<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */
include_once '../../config/config.inc.php';
include_once '../../init.php';
include_once 'htmlbanners11.php';

$hero_slider = new HtmlBanners11();
$slides = [];

if (!Tools::isSubmit('secure_key') || Tools::getValue('secure_key') != $hero_slider->secure_key || !Tools::getValue('action')) {
    exit(1);
}

if (Tools::getValue('action') == 'updateSlidesPosition' && Tools::getValue('slides')) {
    $slides = Tools::getValue('slides');

    foreach ($slides as $position => $id_slide) {
        $res = Db::getInstance()->execute(
            '
			UPDATE `' . _DB_PREFIX_ . 'htmlbanners11_slides` SET `position` = ' . (int) $position . '
			WHERE `id_htmlbanners11_slides` = ' . (int) $id_slide
        );
    }

    $hero_slider->clearCache();
}
