import * as webpack from 'webpack';
import IWebpackChunkModule from './types/IWebpackChunkModule';
declare type Compilation = Partial<webpack.compilation.Compilation & {
    chunkGraph: {
        getChunkModulesIterable: (chunk: Chunk) => IWebpackChunkModule[];
        getChunkEntryModulesIterable: (chunk: Chunk) => IWebpackChunkModule[];
    };
}>;
declare type Chunk = Partial<Pick<webpack.compilation.Chunk & {
    forEachModule?: (callback: (module: IWebpackChunkModule) => void) => void;
    modules?: IWebpackChunkModule[];
}, 'entryModule' | 'forEachModule' | 'modules' | 'modulesIterable'>>;
export default class WebpackChunkModuleIterator {
    iterateModules(compilation: Compilation, chunk: Chunk, callback: (module: IWebpackChunkModule) => void): void;
}
export {};
