"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var WebpackModuleFileIterator = /** @class */ (function () {
    function WebpackModuleFileIterator() {
    }
    WebpackModuleFileIterator.prototype.iterateFiles = function (_a, callback) {
        var resource = _a.resource, rootModule = _a.rootModule, fileDependencies = _a.fileDependencies, dependencies = _a.dependencies;
        if (resource) {
            callback(resource);
        }
        else if (rootModule === null || rootModule === void 0 ? void 0 : rootModule.resource) {
            callback(rootModule.resource);
        }
        if (fileDependencies) {
            fileDependencies.forEach(function (dep) { return callback(dep); });
        }
        if (dependencies) {
            dependencies.forEach(function (_a) {
                var originModule = _a.originModule, _parentModule = _a._parentModule;
                if (originModule === null || originModule === void 0 ? void 0 : originModule.resource) {
                    callback(originModule.resource);
                }
                if (_parentModule === null || _parentModule === void 0 ? void 0 : _parentModule.resource) {
                    callback(_parentModule.resource);
                }
            });
        }
    };
    return WebpackModuleFileIterator;
}());
exports.default = WebpackModuleFileIterator;
//# sourceMappingURL=WebpackModuleFileIterator.js.map