/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./js/cart.js":
/*!********************!*\
  !*** ./js/cart.js ***!
  \********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prestashop */ "prestashop");
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prestashop__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_debounce__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/debounce */ "./js/components/debounce.js");



(prestashop__WEBPACK_IMPORTED_MODULE_1___default().cart) = (prestashop__WEBPACK_IMPORTED_MODULE_1___default().cart) || {};
(prestashop__WEBPACK_IMPORTED_MODULE_1___default().cart.active_inputs) = null;
const spinnerSelector = 'input[name="product-quantity-spin"]';
let hasError = false;
let isUpdateOperation = false;
let errorMsg = "";
const CheckUpdateQuantityOperations = {
  switchErrorStat: () => {
    const $checkoutBtn = jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.checkout.btn));
    if (jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.notifications.dangerAlert)).length || errorMsg !== "" && !hasError) {
      $checkoutBtn.addClass("disabled");
    }
    if (errorMsg !== "") {
      const strError = `
        <article class="alert alert-danger" role="alert" data-alert="danger">
          <ul>
            <li>${errorMsg}</li>
          </ul>
        </article>
      `;
      jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.notifications.container)).html(strError);
      errorMsg = "";
      isUpdateOperation = false;
      if (hasError) {
        $checkoutBtn.removeClass("disabled");
      }
    } else if (!hasError && isUpdateOperation) {
      hasError = false;
      isUpdateOperation = false;
      jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.notifications.container)).html("");
      $checkoutBtn.removeClass("disabled");
    }
  },
  checkUpdateOperation: (resp) => {
    const { hasError: hasErrorOccurred, errors: errorData } = resp;
    hasError = hasErrorOccurred != null ? hasErrorOccurred : false;
    const errors = errorData != null ? errorData : "";
    if (errors instanceof Array) {
      errorMsg = errors.join(" ");
    } else {
      errorMsg = errors;
    }
    isUpdateOperation = true;
  }
};
function createSpin() {
  jquery__WEBPACK_IMPORTED_MODULE_0___default().each(jquery__WEBPACK_IMPORTED_MODULE_0___default()(spinnerSelector), (index, spinner) => {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()(spinner).TouchSpin({
      verticalbuttons: true,
      verticalupclass: "material-icons touchspin-up",
      verticaldownclass: "material-icons touchspin-down",
      buttondown_class: "btn btn-touchspin js-touchspin js-increase-product-quantity",
      buttonup_class: "btn btn-touchspin js-touchspin js-decrease-product-quantity",
      min: parseInt(jquery__WEBPACK_IMPORTED_MODULE_0___default()(spinner).attr("min"), 10),
      max: 1e6
    });
  });
  jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.touchspin)).off("touchstart.touchspin");
  CheckUpdateQuantityOperations.switchErrorStat();
}
const preventCustomModalOpen = (event) => {
  if (window.shouldPreventModal) {
    event.preventDefault();
    return false;
  }
  return true;
};
jquery__WEBPACK_IMPORTED_MODULE_0___default()(document).ready(() => {
  const productLineInCartSelector = (prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.cart.productLineQty);
  const promises = [];
  prestashop__WEBPACK_IMPORTED_MODULE_1___default().on("updateCart", () => {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.cart.quickview)).modal("hide");
  });
  prestashop__WEBPACK_IMPORTED_MODULE_1___default().on("updatedCart", () => {
    window.shouldPreventModal = false;
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.customizationModal)).on("show.bs.modal", (modalEvent) => {
      preventCustomModalOpen(modalEvent);
    });
    createSpin();
  });
  createSpin();
  const $body = jquery__WEBPACK_IMPORTED_MODULE_0___default()("body");
  function isTouchSpin(namespace) {
    return namespace === "on.startupspin" || namespace === "on.startdownspin";
  }
  function shouldIncreaseProductQuantity(namespace) {
    return namespace === "on.startupspin";
  }
  function findCartLineProductQuantityInput($target) {
    const $input = $target.parents((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.cart.touchspin)).find(productLineInCartSelector);
    if ($input.is(":focus")) {
      return null;
    }
    return $input;
  }
  function camelize(subject) {
    const actionTypeParts = subject.split("-");
    let i;
    let part;
    let camelizedSubject = "";
    for (i = 0; i < actionTypeParts.length; i += 1) {
      part = actionTypeParts[i];
      if (i !== 0) {
        part = part.substring(0, 1).toUpperCase() + part.substring(1);
      }
      camelizedSubject += part;
    }
    return camelizedSubject;
  }
  function parseCartAction($target, namespace) {
    if (!isTouchSpin(namespace)) {
      return {
        url: $target.attr("href"),
        type: camelize($target.data("link-action"))
      };
    }
    const $input = findCartLineProductQuantityInput($target);
    if (!$input) {
      return false;
    }
    let cartAction = {};
    if (shouldIncreaseProductQuantity(namespace)) {
      cartAction = {
        url: $input.data("up-url"),
        type: "increaseProductQuantity"
      };
    } else {
      cartAction = {
        url: $input.data("down-url"),
        type: "decreaseProductQuantity"
      };
    }
    return cartAction;
  }
  const abortPreviousRequests = () => {
    let promise;
    while (promises.length > 0) {
      promise = promises.pop();
      promise.abort();
    }
  };
  const getTouchSpinInput = ($button) => jquery__WEBPACK_IMPORTED_MODULE_0___default()($button.parents((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.cart.touchspin)).find("input"));
  jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.customizationModal)).on("show.bs.modal", (modalEvent) => {
    preventCustomModalOpen(modalEvent);
  });
  const handleCartAction = (event) => {
    abortPreviousRequests();
    window.shouldPreventModal = true;
    event.preventDefault();
    const $target = jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.currentTarget);
    const { dataset } = event.currentTarget;
    const cartAction = parseCartAction($target, event.namespace);
    const requestData = {
      ajax: "1",
      action: "update"
    };
    if (!cartAction) {
      return;
    }
    jquery__WEBPACK_IMPORTED_MODULE_0___default().ajax({
      url: cartAction.url,
      method: "POST",
      data: requestData,
      dataType: "json",
      beforeSend(jqXHR) {
        promises.push(jqXHR);
      }
    }).then((resp) => {
      const $quantityInput = getTouchSpinInput($target);
      CheckUpdateQuantityOperations.checkUpdateOperation(resp);
      $quantityInput.val(resp.quantity);
      prestashop__WEBPACK_IMPORTED_MODULE_1___default().emit("updateCart", {
        reason: dataset,
        resp
      });
    }).fail((resp) => {
      prestashop__WEBPACK_IMPORTED_MODULE_1___default().emit("handleError", {
        eventType: "updateProductInCart",
        resp,
        cartAction: cartAction.type
      });
    });
  };
  $body.on("click", (prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.cart.actions), handleCartAction);
  function sendUpdateQuantityInCartRequest(updateQuantityInCartUrl, requestData, $target) {
    abortPreviousRequests();
    window.shouldPreventModal = true;
    return jquery__WEBPACK_IMPORTED_MODULE_0___default().ajax({
      url: updateQuantityInCartUrl,
      method: "POST",
      data: requestData,
      dataType: "json",
      beforeSend(jqXHR) {
        promises.push(jqXHR);
      }
    }).then((resp) => {
      CheckUpdateQuantityOperations.checkUpdateOperation(resp);
      $target.val(resp.quantity);
      const dataset = $target && $target.dataset ? $target.dataset : resp;
      prestashop__WEBPACK_IMPORTED_MODULE_1___default().emit("updateCart", {
        reason: dataset,
        resp
      });
    }).fail((resp) => {
      prestashop__WEBPACK_IMPORTED_MODULE_1___default().emit("handleError", {
        eventType: "updateProductQuantityInCart",
        resp
      });
    });
  }
  function getQuantityChangeType($quantity) {
    return $quantity > 0 ? "up" : "down";
  }
  function getRequestData(quantity) {
    return {
      ajax: "1",
      qty: Math.abs(quantity),
      action: "update",
      op: getQuantityChangeType(quantity)
    };
  }
  function updateProductQuantityInCart(event) {
    const $target = jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.currentTarget);
    const updateQuantityInCartUrl = $target.data("update-url");
    const baseValue = $target.attr("value");
    const targetValue = $target.val();
    if (targetValue != parseInt(targetValue, 10) || targetValue < 0 || isNaN(targetValue)) {
      window.shouldPreventModal = false;
      $target.val(baseValue);
      return;
    }
    const qty = targetValue - baseValue;
    if (qty === 0) {
      return;
    }
    if (targetValue === "0") {
      $target.closest(".product-line-actions").find('[data-link-action="delete-from-cart"]').click();
    } else {
      $target.attr("value", targetValue);
      sendUpdateQuantityInCartRequest(updateQuantityInCartUrl, getRequestData(qty), $target);
    }
  }
  $body.on("touchspin.on.stopspin", spinnerSelector, (0,_components_debounce__WEBPACK_IMPORTED_MODULE_2__["default"])(updateProductQuantityInCart));
  $body.on("focusout keyup", productLineInCartSelector, (event) => {
    if (event.type === "keyup") {
      if (event.keyCode === 13) {
        isUpdateOperation = true;
        updateProductQuantityInCart(event);
      }
      return false;
    }
    if (!isUpdateOperation) {
      updateProductQuantityInCart(event);
    }
    return false;
  });
  $body.on("click", (prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.cart.discountCode), (event) => {
    event.stopPropagation();
    const $code = jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.currentTarget);
    const $discountInput = jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.cart.discountName));
    $discountInput.val($code.text());
    return false;
  });
});


/***/ }),

/***/ "./js/checkout.js":
/*!************************!*\
  !*** ./js/checkout.js ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prestashop */ "prestashop");
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prestashop__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */


function setUpCheckout() {
  jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.checkout.termsLink)).on("click", (event) => {
    event.preventDefault();
    let url = jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).attr("href");
    if (url) {
      url += "?content_only=1";
      jquery__WEBPACK_IMPORTED_MODULE_0___default().get(url, (content) => {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.modal)).find((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.modalContent)).html(jquery__WEBPACK_IMPORTED_MODULE_0___default()(content).find(".page-cms").contents());
      }).fail((resp) => {
        prestashop__WEBPACK_IMPORTED_MODULE_1___default().emit("handleError", { eventType: "clickTerms", resp });
      });
    }
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.modal)).modal("show");
  });
  jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.checkout.giftCheckbox)).on("click", () => {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()("#gift").slideToggle();
  });
}
function toggleImage() {
  jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.checkout.imagesLink)).on("click", function() {
    const icon = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).find("i.material-icons");
    if (icon.text() === "expand_more") {
      icon.text("expand_less");
    } else {
      icon.text("expand_more");
    }
  });
}
jquery__WEBPACK_IMPORTED_MODULE_0___default()(document).ready(() => {
  if (jquery__WEBPACK_IMPORTED_MODULE_0___default()("body#checkout").length === 1) {
    setUpCheckout();
    toggleImage();
  }
  prestashop__WEBPACK_IMPORTED_MODULE_1___default().on("updatedDeliveryForm", (params) => {
    if (typeof params.deliveryOption === "undefined" || params.deliveryOption.length === 0) {
      return;
    }
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.checkout.carrierExtraContent)).hide();
    params.deliveryOption.next((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.checkout.carrierExtraContent)).slideDown();
  });
});


/***/ }),

/***/ "./js/components/block-cart.js":
/*!*************************************!*\
  !*** ./js/components/block-cart.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! prestashop */ "prestashop");
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(prestashop__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */


(prestashop__WEBPACK_IMPORTED_MODULE_0___default().blockcart) = (prestashop__WEBPACK_IMPORTED_MODULE_0___default().blockcart) || {};
(prestashop__WEBPACK_IMPORTED_MODULE_0___default().blockcart.showModal) = (html) => {
  function getBlockCartModal() {
    return jquery__WEBPACK_IMPORTED_MODULE_1___default()("#blockcart-modal");
  }
  let $blockCartModal = getBlockCartModal();
  if ($blockCartModal.length) {
    $blockCartModal.remove();
  }
  jquery__WEBPACK_IMPORTED_MODULE_1___default()("body").append(html);
  $blockCartModal = getBlockCartModal();
  $blockCartModal.modal("show").on("hidden.bs.modal", (event) => {
    prestashop__WEBPACK_IMPORTED_MODULE_0___default().emit("updateProduct", {
      reason: event.currentTarget.dataset,
      event
    });
  });
};


/***/ }),

/***/ "./js/components/debounce.js":
/*!***********************************!*\
  !*** ./js/components/debounce.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ debounce)
/* harmony export */ });
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */
function debounce(func, timeout = 300) {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => {
      func.apply(this, args);
    }, timeout);
  };
}


/***/ }),

/***/ "./js/components/display-view.js":
/*!***************************************!*\
  !*** ./js/components/display-view.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DisplayView)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);

class DisplayView {
  init() {
    this.displayView();
  }
  displayView() {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()(".show_list").click(function() {
      document.cookie = "show_list=true; expires=Thu, 30 Jan 2100 12:00:00 UTC; path=/";
      jquery__WEBPACK_IMPORTED_MODULE_0___default()("#products").removeClass("grid");
      jquery__WEBPACK_IMPORTED_MODULE_0___default()("#products").addClass("list");
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(".show_grid").removeClass("active");
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(".show_list").addClass("active");
    });
    jquery__WEBPACK_IMPORTED_MODULE_0___default()(".show_grid").click(function() {
      document.cookie = "show_list=; expires=Thu, 30 Jan 1970 12:00:00 UTC; path=/";
      jquery__WEBPACK_IMPORTED_MODULE_0___default()("#products").removeClass("list");
      jquery__WEBPACK_IMPORTED_MODULE_0___default()("#products").addClass("grid");
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(".show_list").removeClass("active");
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(".show_grid").addClass("active");
    });
    prestashop.on("updateProductList", function(event) {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(".show_list").click(function() {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()("#products").removeClass("grid");
        jquery__WEBPACK_IMPORTED_MODULE_0___default()("#products").addClass("list");
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(".show_grid").removeClass("active");
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(".show_list").addClass("active");
      });
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(".show_grid").click(function() {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()("#products").removeClass("list");
        jquery__WEBPACK_IMPORTED_MODULE_0___default()("#products").addClass("grid");
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(".show_list").removeClass("active");
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(".show_grid").addClass("active");
      });
    });
  }
}


/***/ }),

/***/ "./js/components/drop-down.js":
/*!************************************!*\
  !*** ./js/components/drop-down.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DropDown)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

class DropDown {
  constructor(el) {
    this.el = el;
  }
  init() {
    this.el.on("show.bs.dropdown", function(e, el) {
      if (el) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(`#${el}`).find(".dropdown-menu").first().stop(true, true).slideDown();
      } else {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(e.target).find(".dropdown-menu").first().stop(true, true).slideDown();
      }
    });
    this.el.on("hide.bs.dropdown", function(e, el) {
      if (el) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(`#${el}`).find(".dropdown-menu").first().stop(true, true).slideUp();
      } else {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(e.target).find(".dropdown-menu").first().stop(true, true).slideUp();
      }
    });
    this.el.find("select.link").each(function(idx, el) {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(el).on("change", function(event) {
        window.location = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).val();
      });
    });
  }
}


/***/ }),

/***/ "./js/components/form.js":
/*!*******************************!*\
  !*** ./js/components/form.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Form)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

class Form {
  init() {
    this.parentFocus();
    this.togglePasswordVisibility();
  }
  parentFocus() {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-child-focus").focus(function() {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).closest(".js-parent-focus").addClass("focus");
    });
    jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-child-focus").focusout(function() {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).closest(".js-parent-focus").removeClass("focus");
    });
  }
  togglePasswordVisibility() {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()('button[data-action="show-password"]').on("click", function() {
      const elm = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).closest(".input-group").children("input.js-visible-password");
      if (elm.attr("type") === "password") {
        elm.attr("type", "text");
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).text(jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).data("textHide"));
      } else {
        elm.attr("type", "password");
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).text(jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).data("textShow"));
      }
    });
  }
}


/***/ }),

/***/ "./js/components/product-miniature.js":
/*!********************************************!*\
  !*** ./js/components/product-miniature.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ProductMinitature)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

class ProductMinitature {
  init() {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-product-miniature").each((index, element) => {
      if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(element).find(".color").length > 5) {
        let count = 0;
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(element).find(".color").each((colorIndex, colorElement) => {
          if (colorIndex > 4) {
            jquery__WEBPACK_IMPORTED_MODULE_0___default()(colorElement).hide();
            count += 1;
          }
        });
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(element).find(".js-count").append(`+${count}`);
      }
    });
  }
}


/***/ }),

/***/ "./js/components/product-select.js":
/*!*****************************************!*\
  !*** ./js/components/product-select.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ProductSelect)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var velocity_animate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! velocity-animate */ "./node_modules/velocity-animate/velocity.js");
/* harmony import */ var velocity_animate__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(velocity_animate__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */


class ProductSelect {
  init() {
    const MAX_THUMBS = 5;
    const $arrows = jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-arrows");
    const $thumbnails = jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-product-images");
    jquery__WEBPACK_IMPORTED_MODULE_0___default()("body").on("click", ".js-modal-thumb", (event) => {
      if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-thumb").hasClass("selected")) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-thumb").removeClass("selected");
      }
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.currentTarget).addClass("selected");
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-product-cover").attr("src", jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).data("image-large-src"));
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-product-cover").attr("title", jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).attr("title"));
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-product-cover").attr("alt", jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).attr("alt"));
    }).on("click", "aside#thumbnails", (event) => {
      if (event.target.id === "thumbnails") {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()("#product-modal").modal("hide");
      }
    });
    if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-product-images li").length <= MAX_THUMBS) {
      $arrows.css("opacity", ".2");
    } else {
      $arrows.on("click", (event) => {
        if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).hasClass("arrow-up") && $thumbnails.position().top < 0) {
          this.move("up");
          jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-arrow-down").css("opacity", "1");
        } else if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).hasClass("arrow-down") && $thumbnails.position().top + $thumbnails.height() > jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-mask").height()) {
          this.move("down");
          jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-arrow-up").css("opacity", "1");
        }
      });
    }
  }
  move(direction) {
    const THUMB_MARGIN = 10;
    const $thumbnails = jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-product-images");
    const thumbHeight = jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-product-images li img").height() + THUMB_MARGIN;
    const currentPosition = $thumbnails.position().top;
    $thumbnails.velocity({
      translateY: direction === "up" ? currentPosition + thumbHeight : currentPosition - thumbHeight
    }, () => {
      if ($thumbnails.position().top >= 0) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-arrow-up").css("opacity", ".2");
      } else if ($thumbnails.position().top + $thumbnails.height() <= jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-mask").height()) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-modal-arrow-down").css("opacity", ".2");
      }
    });
  }
}


/***/ }),

/***/ "./js/components/top-menu.js":
/*!***********************************!*\
  !*** ./js/components/top-menu.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TopMenu)
/* harmony export */ });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prestashop */ "prestashop");
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prestashop__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _drop_down__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./drop-down */ "./js/components/drop-down.js");
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */



class TopMenu extends _drop_down__WEBPACK_IMPORTED_MODULE_2__["default"] {
  init() {
    let elmtClass;
    const self = this;
    this.el.find("li").hover((e) => {
      if (this.el.parent().hasClass("mobile")) {
        return;
      }
    });
    jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-menu-icon").on("click", function() {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).toggleClass("active");
      jquery__WEBPACK_IMPORTED_MODULE_0___default()("body").toggleClass("no-scroll");
      jquery__WEBPACK_IMPORTED_MODULE_0___default()("#page").toggleClass("menu-show");
    });
    jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-top-menu").mouseleave(() => {
      if (this.el.parent().hasClass("mobile")) {
        return;
      }
    });
    this.el.on("click", (e) => {
      if (this.el.parent().hasClass("mobile")) {
        return;
      }
      e.stopPropagation();
    });
    super.init();
  }
}


/***/ }),

/***/ "./js/components/usePasswordPolicy.js":
/*!********************************************!*\
  !*** ./js/components/usePasswordPolicy.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var sprintf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! sprintf-js */ "./node_modules/sprintf-js/src/sprintf.js");
/* harmony import */ var sprintf_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(sprintf_js__WEBPACK_IMPORTED_MODULE_0__);
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

const { passwordPolicy: PasswordPolicyMap } = prestashop.themeSelectors;
const PASSWORD_POLICY_ERROR = "The password policy elements are undefined.";
const getPasswordStrengthFeedback = (strength) => {
  switch (strength) {
    case 0:
      return {
        color: "bg-danger"
      };
    case 1:
      return {
        color: "bg-danger"
      };
    case 2:
      return {
        color: "bg-warning"
      };
    case 3:
      return {
        color: "bg-success"
      };
    case 4:
      return {
        color: "bg-success"
      };
    default:
      throw new Error("Invalid password strength indicator.");
  }
};
const watchPassword = (elementInput, feedbackContainer, hints) => __async(undefined, null, function* () {
  const { prestashop: prestashop2 } = window;
  const passwordValue = elementInput.value;
  const elementIcon = feedbackContainer.querySelector(PasswordPolicyMap.requirementScoreIcon);
  const result = yield prestashop2.checkPasswordScore(passwordValue);
  const feedback = getPasswordStrengthFeedback(result.score);
  const passwordLength = passwordValue.length;
  const popoverContent = [];
  $(elementInput).popover("dispose");
  feedbackContainer.style.display = passwordValue === "" ? "none" : "block";
  if (result.feedback.warning !== "") {
    if (result.feedback.warning in hints) {
      popoverContent.push(hints[result.feedback.warning]);
    }
  }
  result.feedback.suggestions.forEach((suggestion) => {
    if (suggestion in hints) {
      popoverContent.push(hints[suggestion]);
    }
  });
  $(elementInput).popover({
    html: true,
    placement: "top",
    content: popoverContent.join("<br/>")
  }).popover("show");
  const passwordLengthValid = passwordLength >= parseInt(elementInput.dataset.minlength, 10) && passwordLength <= parseInt(elementInput.dataset.maxlength, 10);
  const passwordScoreValid = parseInt(elementInput.dataset.minscore, 10) <= result.score;
  feedbackContainer.querySelector(PasswordPolicyMap.requirementLengthIcon).classList.toggle("text-success", passwordLengthValid);
  elementIcon.classList.toggle("text-success", passwordScoreValid);
  elementInput.classList.remove("border-success", "border-danger");
  elementInput.classList.add(passwordScoreValid && passwordLengthValid ? "border-success" : "border-danger");
  elementInput.classList.add("form-control", "border");
  const percentage = result.score * 20 + 20;
  const progressBar = feedbackContainer.querySelector(PasswordPolicyMap.progressBar);
  if (progressBar) {
    progressBar.style.width = `${percentage}%`;
    progressBar.classList.remove("bg-success", "bg-danger", "bg-warning");
    progressBar.classList.add(feedback.color);
  }
});
const usePasswordPolicy = (selector) => {
  const element = document.querySelector(selector);
  const inputColumn = element == null ? void 0 : element.querySelector(PasswordPolicyMap.inputColumn);
  const elementInput = element == null ? void 0 : element.querySelector("input");
  const templateElement = document.createElement("div");
  const feedbackTemplate = document.querySelector(PasswordPolicyMap.template);
  let feedbackContainer;
  if (feedbackTemplate && element && inputColumn && elementInput) {
    templateElement.innerHTML = feedbackTemplate.innerHTML;
    inputColumn.append(templateElement);
    feedbackContainer = element.querySelector(PasswordPolicyMap.container);
    if (feedbackContainer) {
      const hintElement = document.querySelector(PasswordPolicyMap.hint);
      if (hintElement) {
        const hints = JSON.parse(hintElement.innerHTML);
        const passwordRequirementsLength = feedbackContainer.querySelector(PasswordPolicyMap.requirementLength);
        const passwordRequirementsScore = feedbackContainer.querySelector(PasswordPolicyMap.requirementScore);
        const passwordLengthText = passwordRequirementsLength == null ? void 0 : passwordRequirementsLength.querySelector("span");
        const passwordRequirementsText = passwordRequirementsScore == null ? void 0 : passwordRequirementsScore.querySelector("span");
        if (passwordLengthText && passwordRequirementsLength && passwordRequirementsLength.dataset.translation) {
          passwordLengthText.innerText = (0,sprintf_js__WEBPACK_IMPORTED_MODULE_0__.sprintf)(passwordRequirementsLength.dataset.translation, elementInput.dataset.minlength, elementInput.dataset.maxlength);
        }
        if (passwordRequirementsText && passwordRequirementsScore && passwordRequirementsScore.dataset.translation) {
          passwordRequirementsText.innerText = (0,sprintf_js__WEBPACK_IMPORTED_MODULE_0__.sprintf)(passwordRequirementsScore.dataset.translation, hints[elementInput.dataset.minscore]);
        }
        elementInput.addEventListener("keyup", () => watchPassword(elementInput, feedbackContainer, hints));
        elementInput.addEventListener("blur", () => {
          $(elementInput).popover("dispose");
        });
      }
    }
  }
  if (element) {
    return {
      element
    };
  }
  return {
    error: new Error(PASSWORD_POLICY_ERROR)
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (usePasswordPolicy);


/***/ }),

/***/ "./js/customer.js":
/*!************************!*\
  !*** ./js/customer.js ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prestashop */ "prestashop");
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prestashop__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */


function initRmaItemSelector() {
  jquery__WEBPACK_IMPORTED_MODULE_0___default()(`${(prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.order.returnForm)} table thead input[type=checkbox]`).on("click", function() {
    const checked = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).prop("checked");
    jquery__WEBPACK_IMPORTED_MODULE_0___default()(`${(prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.order.returnForm)} table tbody input[type=checkbox]`).each((_, checkbox) => {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(checkbox).prop("checked", checked);
    });
  });
}
function setupCustomerScripts() {
  if (jquery__WEBPACK_IMPORTED_MODULE_0___default()("body#order-detail")) {
    initRmaItemSelector();
  }
}
jquery__WEBPACK_IMPORTED_MODULE_0___default()(document).ready(setupCustomerScripts);


/***/ }),

/***/ "./js/lib/bootstrap-filestyle.min.js":
/*!*******************************************!*\
  !*** ./js/lib/bootstrap-filestyle.min.js ***!
  \*******************************************/
/***/ (() => {

/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */
(function($) {
  var nextId = 0;
  var Filestyle = function(element, options) {
    this.options = options;
    this.$elementFilestyle = [];
    this.$element = $(element);
  };
  Filestyle.prototype = { clear: function() {
    this.$element.val("");
    this.$elementFilestyle.find(":text").val("");
    this.$elementFilestyle.find(".badge").remove();
  }, destroy: function() {
    this.$element.removeAttr("style").removeData("filestyle");
    this.$elementFilestyle.remove();
  }, disabled: function(value) {
    if (value === true) {
      if (!this.options.disabled) {
        this.$element.attr("disabled", "true");
        this.$elementFilestyle.find("label").attr("disabled", "true");
        this.options.disabled = true;
      }
    } else {
      if (value === false) {
        if (this.options.disabled) {
          this.$element.removeAttr("disabled");
          this.$elementFilestyle.find("label").removeAttr("disabled");
          this.options.disabled = false;
        }
      } else {
        return this.options.disabled;
      }
    }
  }, buttonBefore: function(value) {
    if (value === true) {
      if (!this.options.buttonBefore) {
        this.options.buttonBefore = true;
        if (this.options.input) {
          this.$elementFilestyle.remove();
          this.constructor();
          this.pushNameFiles();
        }
      }
    } else {
      if (value === false) {
        if (this.options.buttonBefore) {
          this.options.buttonBefore = false;
          if (this.options.input) {
            this.$elementFilestyle.remove();
            this.constructor();
            this.pushNameFiles();
          }
        }
      } else {
        return this.options.buttonBefore;
      }
    }
  }, icon: function(value) {
    if (value === true) {
      if (!this.options.icon) {
        this.options.icon = true;
        this.$elementFilestyle.find("label").prepend(this.htmlIcon());
      }
    } else {
      if (value === false) {
        if (this.options.icon) {
          this.options.icon = false;
          this.$elementFilestyle.find(".icon-span-filestyle").remove();
        }
      } else {
        return this.options.icon;
      }
    }
  }, input: function(value) {
    if (value === true) {
      if (!this.options.input) {
        this.options.input = true;
        if (this.options.buttonBefore) {
          this.$elementFilestyle.append(this.htmlInput());
        } else {
          this.$elementFilestyle.prepend(this.htmlInput());
        }
        this.$elementFilestyle.find(".badge").remove();
        this.pushNameFiles();
        this.$elementFilestyle.find(".group-span-filestyle").addClass("input-group-btn");
      }
    } else {
      if (value === false) {
        if (this.options.input) {
          this.options.input = false;
          this.$elementFilestyle.find(":text").remove();
          var files = this.pushNameFiles();
          if (files.length > 0 && this.options.badge) {
            this.$elementFilestyle.find("label").append(' <span class="badge">' + files.length + "</span>");
          }
          this.$elementFilestyle.find(".group-span-filestyle").removeClass("input-group-btn");
        }
      } else {
        return this.options.input;
      }
    }
  }, size: function(value) {
    if (value !== void 0) {
      var btn = this.$elementFilestyle.find("label"), input = this.$elementFilestyle.find("input");
      btn.removeClass("btn-lg btn-sm");
      input.removeClass("input-lg input-sm");
      if (value != "nr") {
        btn.addClass("btn-" + value);
        input.addClass("input-" + value);
      }
    } else {
      return this.options.size;
    }
  }, placeholder: function(value) {
    if (value !== void 0) {
      this.options.placeholder = value;
      this.$elementFilestyle.find("input").attr("placeholder", value);
    } else {
      return this.options.placeholder;
    }
  }, buttonText: function(value) {
    if (value !== void 0) {
      this.options.buttonText = value;
      this.$elementFilestyle.find("label .buttonText").html(this.options.buttonText);
    } else {
      return this.options.buttonText;
    }
  }, buttonName: function(value) {
    if (value !== void 0) {
      this.options.buttonName = value;
      this.$elementFilestyle.find("label").attr({ "class": "btn " + this.options.buttonName });
    } else {
      return this.options.buttonName;
    }
  }, iconName: function(value) {
    if (value !== void 0) {
      this.$elementFilestyle.find(".icon-span-filestyle").attr({ "class": "icon-span-filestyle " + this.options.iconName });
    } else {
      return this.options.iconName;
    }
  }, htmlIcon: function() {
    if (this.options.icon) {
      return '<span class="icon-span-filestyle ' + this.options.iconName + '"></span> ';
    } else {
      return "";
    }
  }, htmlInput: function() {
    if (this.options.input) {
      return '<input type="text" class="form-control ' + (this.options.size == "nr" ? "" : "input-" + this.options.size) + '" placeholder="' + this.options.placeholder + '" disabled> ';
    } else {
      return "";
    }
  }, pushNameFiles: function() {
    var content = "", files = [];
    if (this.$element[0].files === void 0) {
      files[0] = { name: this.$element[0] && this.$element[0].value };
    } else {
      files = this.$element[0].files;
    }
    for (var i = 0; i < files.length; i++) {
      content += files[i].name.split("\\").pop() + ", ";
    }
    if (content !== "") {
      this.$elementFilestyle.find(":text").val(content.replace(/\, $/g, ""));
    } else {
      this.$elementFilestyle.find(":text").val("");
    }
    return files;
  }, constructor: function() {
    var _self = this, html = "", id = _self.$element.attr("id"), files = [], btn = "", $label;
    if (id === "" || !id) {
      id = "filestyle-" + nextId;
      _self.$element.attr({ id });
      nextId++;
    }
    btn = '<span class="group-span-filestyle ' + (_self.options.input ? "input-group-btn" : "") + '"><label for="' + id + '" class="btn ' + _self.options.buttonName + " " + (_self.options.size == "nr" ? "" : "btn-" + _self.options.size) + '" ' + (_self.options.disabled ? 'disabled="true"' : "") + ">" + _self.htmlIcon() + '<span class="buttonText">' + _self.options.buttonText + "</span></label></span>";
    html = _self.options.buttonBefore ? btn + _self.htmlInput() : _self.htmlInput() + btn;
    _self.$elementFilestyle = $('<div class="bootstrap-filestyle input-group">' + html + "</div>");
    _self.$elementFilestyle.find(".group-span-filestyle").attr("tabindex", "0").keypress(function(e) {
      if (e.keyCode === 13 || e.charCode === 32) {
        _self.$elementFilestyle.find("label").click();
        return false;
      }
    });
    _self.$element.css({ position: "absolute", clip: "rect(0px 0px 0px 0px)" }).attr("tabindex", "-1").after(_self.$elementFilestyle);
    if (_self.options.disabled) {
      _self.$element.attr("disabled", "true");
    }
    _self.$element.change(function() {
      var files2 = _self.pushNameFiles();
      if (_self.options.input == false && _self.options.badge) {
        if (_self.$elementFilestyle.find(".badge").length == 0) {
          _self.$elementFilestyle.find("label").append(' <span class="badge">' + files2.length + "</span>");
        } else {
          if (files2.length == 0) {
            _self.$elementFilestyle.find(".badge").remove();
          } else {
            _self.$elementFilestyle.find(".badge").html(files2.length);
          }
        }
      } else {
        _self.$elementFilestyle.find(".badge").remove();
      }
    });
    if (window.navigator.userAgent.search(/firefox/i) > -1) {
      _self.$elementFilestyle.find("label").click(function() {
        _self.$element.click();
        return false;
      });
    }
  } };
  var old = $.fn.filestyle;
  $.fn.filestyle = function(option, value) {
    var get = "", element = this.each(function() {
      if ($(this).attr("type") === "file") {
        var $this = $(this), data = $this.data("filestyle"), options = $.extend({}, $.fn.filestyle.defaults, option, typeof option === "object" && option);
        if (!data) {
          $this.data("filestyle", data = new Filestyle(this, options));
          data.constructor();
        }
        if (typeof option === "string") {
          get = data[option](value);
        }
      }
    });
    if (typeof get !== void 0) {
      return get;
    } else {
      return element;
    }
  };
  $.fn.filestyle.defaults = { buttonText: "Choose file", iconName: "glyphicon glyphicon-folder-open", buttonName: "btn-default", size: "nr", input: true, badge: true, icon: true, buttonBefore: false, disabled: false, placeholder: "" };
  $.fn.filestyle.noConflict = function() {
    $.fn.filestyle = old;
    return this;
  };
  $(function() {
    $(".filestyle").each(function() {
      var $this = $(this), options = { input: $this.attr("data-input") === "false" ? false : true, icon: $this.attr("data-icon") === "false" ? false : true, buttonBefore: $this.attr("data-buttonBefore") === "true" ? true : false, disabled: $this.attr("data-disabled") === "true" ? true : false, size: $this.attr("data-size"), buttonText: $this.attr("data-buttonText"), buttonName: $this.attr("data-buttonName"), iconName: $this.attr("data-iconName"), badge: $this.attr("data-badge") === "false" ? false : true, placeholder: $this.attr("data-placeholder") };
      $this.filestyle(options);
    });
  });
})(window.jQuery);


/***/ }),

/***/ "./js/lib/jquery.scrollbox.min.js":
/*!****************************************!*\
  !*** ./js/lib/jquery.scrollbox.min.js ***!
  \****************************************/
/***/ (() => {

/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */
(function($) {
  $.fn.scrollbox = function(config) {
    var defConfig = { linear: false, startDelay: 2, delay: 3, step: 5, speed: 32, switchItems: 1, direction: "vertical", distance: "auto", autoPlay: true, onMouseOverPause: true, paused: false, queue: null, listElement: "ul", listItemElement: "li", infiniteLoop: true, switchAmount: 0, afterForward: null, afterBackward: null, triggerStackable: false };
    config = $.extend(defConfig, config);
    config.scrollOffset = config.direction === "vertical" ? "scrollTop" : "scrollLeft";
    if (config.queue) {
      config.queue = $("#" + config.queue);
    }
    return this.each(function() {
      var container = $(this), containerUL, scrollingId = null, nextScrollId = null, paused = false, releaseStack, backward, forward, resetClock, scrollForward, scrollBackward, forwardHover, pauseHover, switchCount = 0, stackedTriggerIndex = 0;
      if (config.onMouseOverPause) {
        container.bind("mouseover", function() {
          paused = true;
        });
        container.bind("mouseout", function() {
          paused = false;
        });
      }
      containerUL = container.children(config.listElement + ":first-child");
      if (config.infiniteLoop === false && config.switchAmount === 0) {
        config.switchAmount = containerUL.children().length;
      }
      scrollForward = function() {
        if (paused) {
          return;
        }
        var curLi, i, newScrollOffset, scrollDistance, theStep;
        curLi = containerUL.children(config.listItemElement + ":first-child");
        scrollDistance = config.distance !== "auto" ? config.distance : config.direction === "vertical" ? curLi.outerHeight(true) : curLi.outerWidth(true);
        if (!config.linear) {
          theStep = Math.max(3, parseInt((scrollDistance - container[0][config.scrollOffset]) * 0.3, 10));
          newScrollOffset = Math.min(container[0][config.scrollOffset] + theStep, scrollDistance);
        } else {
          newScrollOffset = Math.min(container[0][config.scrollOffset] + config.step, scrollDistance);
        }
        container[0][config.scrollOffset] = newScrollOffset;
        if (newScrollOffset >= scrollDistance) {
          for (i = 0; i < config.switchItems; i++) {
            if (config.queue && config.queue.find(config.listItemElement).length > 0) {
              containerUL.append(config.queue.find(config.listItemElement)[0]);
              containerUL.children(config.listItemElement + ":first-child").remove();
            } else {
              containerUL.append(containerUL.children(config.listItemElement + ":first-child"));
            }
            ++switchCount;
          }
          container[0][config.scrollOffset] = 0;
          clearInterval(scrollingId);
          scrollingId = null;
          if ($.isFunction(config.afterForward)) {
            config.afterForward.call(container, { switchCount, currentFirstChild: containerUL.children(config.listItemElement + ":first-child") });
          }
          if (config.triggerStackable && stackedTriggerIndex !== 0) {
            releaseStack();
            return;
          }
          if (config.infiniteLoop === false && switchCount >= config.switchAmount) {
            return;
          }
          if (config.autoPlay) {
            nextScrollId = setTimeout(forward, config.delay * 1e3);
          }
        }
      };
      scrollBackward = function() {
        if (paused) {
          return;
        }
        var curLi, i, newScrollOffset, scrollDistance, theStep;
        if (container[0][config.scrollOffset] === 0) {
          for (i = 0; i < config.switchItems; i++) {
            containerUL.children(config.listItemElement + ":last-child").insertBefore(containerUL.children(config.listItemElement + ":first-child"));
          }
          curLi = containerUL.children(config.listItemElement + ":first-child");
          scrollDistance = config.distance !== "auto" ? config.distance : config.direction === "vertical" ? curLi.height() : curLi.width();
          container[0][config.scrollOffset] = scrollDistance;
        }
        if (!config.linear) {
          theStep = Math.max(3, parseInt(container[0][config.scrollOffset] * 0.3, 10));
          newScrollOffset = Math.max(container[0][config.scrollOffset] - theStep, 0);
        } else {
          newScrollOffset = Math.max(container[0][config.scrollOffset] - config.step, 0);
        }
        container[0][config.scrollOffset] = newScrollOffset;
        if (newScrollOffset === 0) {
          --switchCount;
          clearInterval(scrollingId);
          scrollingId = null;
          if ($.isFunction(config.afterBackward)) {
            config.afterBackward.call(container, { switchCount, currentFirstChild: containerUL.children(config.listItemElement + ":first-child") });
          }
          if (config.triggerStackable && stackedTriggerIndex !== 0) {
            releaseStack();
            return;
          }
          if (config.autoPlay) {
            nextScrollId = setTimeout(forward, config.delay * 1e3);
          }
        }
      };
      releaseStack = function() {
        if (stackedTriggerIndex === 0) {
          return;
        }
        if (stackedTriggerIndex > 0) {
          stackedTriggerIndex--;
          nextScrollId = setTimeout(forward, 0);
        } else {
          stackedTriggerIndex++;
          nextScrollId = setTimeout(backward, 0);
        }
      };
      forward = function() {
        clearInterval(scrollingId);
        scrollingId = setInterval(scrollForward, config.speed);
      };
      backward = function() {
        clearInterval(scrollingId);
        scrollingId = setInterval(scrollBackward, config.speed);
      };
      forwardHover = function() {
        config.autoPlay = true;
        paused = false;
        clearInterval(scrollingId);
        scrollingId = setInterval(scrollForward, config.speed);
      };
      pauseHover = function() {
        paused = true;
      };
      resetClock = function(delay) {
        config.delay = delay || config.delay;
        clearTimeout(nextScrollId);
        if (config.autoPlay) {
          nextScrollId = setTimeout(forward, config.delay * 1e3);
        }
      };
      if (config.autoPlay) {
        nextScrollId = setTimeout(forward, config.startDelay * 1e3);
      }
      container.bind("resetClock", function(delay) {
        resetClock(delay);
      });
      container.bind("forward", function() {
        if (config.triggerStackable) {
          if (scrollingId !== null) {
            stackedTriggerIndex++;
          } else {
            forward();
          }
        } else {
          clearTimeout(nextScrollId);
          forward();
        }
      });
      container.bind("backward", function() {
        if (config.triggerStackable) {
          if (scrollingId !== null) {
            stackedTriggerIndex--;
          } else {
            backward();
          }
        } else {
          clearTimeout(nextScrollId);
          backward();
        }
      });
      container.bind("pauseHover", function() {
        pauseHover();
      });
      container.bind("forwardHover", function() {
        forwardHover();
      });
      container.bind("speedUp", function(event, speed) {
        if (speed === "undefined") {
          speed = Math.max(1, parseInt(config.speed / 2, 10));
        }
        config.speed = speed;
      });
      container.bind("speedDown", function(event, speed) {
        if (speed === "undefined") {
          speed = config.speed * 2;
        }
        config.speed = speed;
      });
      container.bind("updateConfig", function(event, options) {
        config = $.extend(config, options);
      });
    });
  };
})(jQuery);


/***/ }),

/***/ "./js/listing.js":
/*!***********************!*\
  !*** ./js/listing.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prestashop */ "prestashop");
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prestashop__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var velocity_animate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! velocity-animate */ "./node_modules/velocity-animate/velocity.js");
/* harmony import */ var velocity_animate__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(velocity_animate__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_product_miniature__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/product-miniature */ "./js/components/product-miniature.js");
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */




jquery__WEBPACK_IMPORTED_MODULE_0___default()(document).ready(() => {
  const move = (direction) => {
    const THUMB_MARGIN = 20;
    const $thumbnails = jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-qv-product-images");
    const thumbHeight = jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-qv-product-images li img").height() + THUMB_MARGIN;
    const currentPosition = $thumbnails.position().top;
    $thumbnails.velocity({
      translateY: direction === "up" ? currentPosition + thumbHeight : currentPosition - thumbHeight
    }, () => {
      if ($thumbnails.position().top >= 0) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(".arrow-up").css("opacity", ".2");
      } else if ($thumbnails.position().top + $thumbnails.height() <= jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-qv-mask").height()) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(".arrow-down").css("opacity", ".2");
      }
    });
  };
  const productConfig = (qv) => {
    const MAX_THUMBS = 4;
    const $arrows = jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.arrows));
    const $thumbnails = qv.find(".js-qv-product-images");
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.thumb)).on("click", (event) => {
      if (jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.thumb)).hasClass("selected")) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.thumb)).removeClass("selected");
      }
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.currentTarget).addClass("selected");
      jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.cover)).attr("src", jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).data("image-large-src"));
    });
    if ($thumbnails.find("li").length <= MAX_THUMBS) {
      $arrows.hide();
    } else {
      $arrows.on("click", (event) => {
        if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).hasClass("arrow-up") && jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-qv-product-images").position().top < 0) {
          move("up");
          jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.arrowDown)).css("opacity", "1");
        } else if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).hasClass("arrow-down") && $thumbnails.position().top + $thumbnails.height() > jquery__WEBPACK_IMPORTED_MODULE_0___default()(".js-qv-mask").height()) {
          move("down");
          jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.arrowUp)).css("opacity", "1");
        }
      });
    }
    qv.find((prestashop__WEBPACK_IMPORTED_MODULE_1___default().selectors.quantityWanted)).TouchSpin({
      verticalbuttons: true,
      verticalupclass: "material-icons touchspin-up",
      verticaldownclass: "material-icons touchspin-down",
      buttondown_class: "btn btn-touchspin js-touchspin",
      buttonup_class: "btn btn-touchspin js-touchspin",
      min: 1,
      max: 1e6
    });
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.touchspin)).off("touchstart.touchspin");
  };
  prestashop__WEBPACK_IMPORTED_MODULE_1___default().on("clickQuickView", (elm) => {
    const data = {
      action: "quickview",
      id_product: elm.dataset.idProduct,
      id_product_attribute: elm.dataset.idProductAttribute
    };
    jquery__WEBPACK_IMPORTED_MODULE_0___default().post((prestashop__WEBPACK_IMPORTED_MODULE_1___default().urls.pages.product), data, null, "json").then((resp) => {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()("body").append(resp.quickview_html);
      const productModal = jquery__WEBPACK_IMPORTED_MODULE_0___default()(`#quickview-modal-${resp.product.id}-${resp.product.id_product_attribute}`);
      productModal.modal("show");
      productConfig(productModal);
      productModal.on("hidden.bs.modal", () => {
        productModal.remove();
      });
    }).fail((resp) => {
      prestashop__WEBPACK_IMPORTED_MODULE_1___default().emit("handleError", {
        eventType: "clickQuickView",
        resp
      });
    });
  });
  jquery__WEBPACK_IMPORTED_MODULE_0___default()("body").on("click", (prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.searchFilterToggler), () => {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.searchFiltersWrapper)).removeClass("hidden-sm-down");
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.contentWrapper)).addClass("hidden-sm-down");
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.footer)).addClass("hidden-sm-down");
  });
  jquery__WEBPACK_IMPORTED_MODULE_0___default()(`${(prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.searchFilterControls)} ${(prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.clear)}`).on("click", () => {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.searchFiltersWrapper)).addClass("hidden-sm-down");
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.contentWrapper)).removeClass("hidden-sm-down");
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.footer)).removeClass("hidden-sm-down");
  });
  jquery__WEBPACK_IMPORTED_MODULE_0___default()(`${(prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.searchFilterControls)} .ok`).on("click", () => {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.searchFiltersWrapper)).addClass("hidden-sm-down");
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.contentWrapper)).removeClass("hidden-sm-down");
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.footer)).removeClass("hidden-sm-down");
  });
  const parseSearchUrl = function(event) {
    if (event.target.dataset.searchUrl !== void 0) {
      return event.target.dataset.searchUrl;
    }
    if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).parent()[0].dataset.searchUrl === void 0) {
      throw new Error("Can not parse search URL");
    }
    return jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).parent()[0].dataset.searchUrl;
  };
  function updateProductListDOM(data) {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.searchFilters)).replaceWith(data.rendered_facets);
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.activeSearchFilters)).replaceWith(data.rendered_active_filters);
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.listTop)).replaceWith(data.rendered_products_top);
    const renderedProducts = jquery__WEBPACK_IMPORTED_MODULE_0___default()(data.rendered_products);
    const productSelectors = jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.product));
    if (productSelectors.length > 0) {
      productSelectors.removeClass().addClass(productSelectors.first().attr("class"));
    } else {
      productSelectors.removeClass().addClass(renderedProducts.first().attr("class"));
    }
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.list)).replaceWith(renderedProducts);
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.listBottom)).replaceWith(data.rendered_products_bottom);
    if (data.rendered_products_header) {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.listHeader)).replaceWith(data.rendered_products_header);
    }
    const productMinitature = new _components_product_miniature__WEBPACK_IMPORTED_MODULE_3__["default"]();
    productMinitature.init();
  }
  jquery__WEBPACK_IMPORTED_MODULE_0___default()("body").on("change", `${(prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.searchFilters)} input[data-search-url]`, (event) => {
    prestashop__WEBPACK_IMPORTED_MODULE_1___default().emit("updateFacets", parseSearchUrl(event));
  });
  jquery__WEBPACK_IMPORTED_MODULE_0___default()("body").on("click", (prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.searchFiltersClearAll), (event) => {
    prestashop__WEBPACK_IMPORTED_MODULE_1___default().emit("updateFacets", parseSearchUrl(event));
  });
  jquery__WEBPACK_IMPORTED_MODULE_0___default()("body").on("click", (prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.searchLink), (event) => {
    event.preventDefault();
    prestashop__WEBPACK_IMPORTED_MODULE_1___default().emit("updateFacets", jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).closest("a").get(0).href);
  });
  window.addEventListener("popstate", (e) => {
    if (e.state && e.state.current_url) {
      window.location.href = e.state.current_url;
    }
  });
  jquery__WEBPACK_IMPORTED_MODULE_0___default()("body").on("change", `${(prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.listing.searchFilters)} select`, (event) => {
    const form = jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).closest("form");
    prestashop__WEBPACK_IMPORTED_MODULE_1___default().emit("updateFacets", `?${form.serialize()}`);
  });
  prestashop__WEBPACK_IMPORTED_MODULE_1___default().on("updateProductList", (data) => {
    updateProductListDOM(data);
    window.scrollTo(0, 0);
  });
});


/***/ }),

/***/ "./js/product.js":
/*!***********************!*\
  !*** ./js/product.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prestashop */ "prestashop");
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prestashop__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_product_select__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/product-select */ "./js/components/product-select.js");
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */



jquery__WEBPACK_IMPORTED_MODULE_0___default()(document).ready(() => {
  function coverImage() {
    const productCover = jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.cover));
    let thumbSelected = jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.selected));
    const swipe = (selectedThumb, thumbParent) => {
      const newSelectedThumb = thumbParent.find((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.thumb));
      jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.modalProductCover)).attr("src", newSelectedThumb.data("image-large-src"));
      selectedThumb.removeClass("selected");
      newSelectedThumb.addClass("selected");
      productCover.prop("src", newSelectedThumb.data("image-large-src"));
    };
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.thumb)).on("click", (event) => {
      thumbSelected = jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.selected));
      swipe(thumbSelected, jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).closest((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.thumbContainer)));
    });
    productCover.swipe({
      swipe: (event, direction) => {
        thumbSelected = jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.selected));
        const parentThumb = thumbSelected.closest((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.thumbContainer));
        if (direction === "right") {
          if (parentThumb.prev().length > 0) {
            swipe(thumbSelected, parentThumb.prev());
          } else if (parentThumb.next().length > 0) {
            swipe(thumbSelected, parentThumb.next());
          }
        } else if (direction === "left") {
          if (parentThumb.next().length > 0) {
            swipe(thumbSelected, parentThumb.next());
          } else if (parentThumb.prev().length > 0) {
            swipe(thumbSelected, parentThumb.prev());
          }
        }
      },
      allowPageScroll: "vertical"
    });
  }
  function imageScrollBox() {
    if (jquery__WEBPACK_IMPORTED_MODULE_0___default()("#main .js-qv-product-images li").length > 4) {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()("#main .js-qv-mask").addClass("scroll");
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(".scroll-box-arrows").addClass("scroll");
      jquery__WEBPACK_IMPORTED_MODULE_0___default()("#main .js-qv-mask").scrollbox({
        direction: "h",
        distance: 113,
        autoPlay: false
      });
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(".scroll-box-arrows .left").click(() => {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()("#main .js-qv-mask").trigger("backward");
      });
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(".scroll-box-arrows .right").click(() => {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()("#main .js-qv-mask").trigger("forward");
      });
    } else {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()("#main .js-qv-mask").removeClass("scroll");
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(".scroll-box-arrows").removeClass("scroll");
    }
  }
  function createInputFile() {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.fileInput)).on("change", (event) => {
      const target = jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.currentTarget)[0];
      const file = target ? target.files[0] : null;
      if (target && file) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(target).prev().text(file.name);
      }
    });
  }
  function createProductSpin() {
    const $quantityInput = jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().selectors.quantityWanted));
    $quantityInput.TouchSpin({
      verticalbuttons: true,
      verticalupclass: "material-icons touchspin-up",
      verticaldownclass: "material-icons touchspin-down",
      buttondown_class: "btn btn-touchspin js-touchspin",
      buttonup_class: "btn btn-touchspin js-touchspin",
      min: parseInt($quantityInput.attr("min"), 10),
      max: 1e6
    });
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.touchspin)).off("touchstart.touchspin");
    $quantityInput.focusout(() => {
      if ($quantityInput.val() === "" || $quantityInput.val() < $quantityInput.attr("min")) {
        $quantityInput.val($quantityInput.attr("min"));
        $quantityInput.trigger("change");
      }
    });
    jquery__WEBPACK_IMPORTED_MODULE_0___default()("body").on("change keyup", (prestashop__WEBPACK_IMPORTED_MODULE_1___default().selectors.quantityWanted), (e) => {
      if ($quantityInput.val() !== "") {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(e.currentTarget).trigger("touchspin.stopspin");
        prestashop__WEBPACK_IMPORTED_MODULE_1___default().emit("updateProduct", {
          eventType: "updatedProductQuantity",
          event: e
        });
      }
    });
  }
  createProductSpin();
  createInputFile();
  coverImage();
  imageScrollBox();
  jquery__WEBPACK_IMPORTED_MODULE_0___default()(".nav-tabs_alternative li:first a, .more-info .tab-pane:first").addClass("active");
  prestashop__WEBPACK_IMPORTED_MODULE_1___default().on("updatedProduct", (event) => {
    createInputFile();
    coverImage();
    if (event && event.product_minimal_quantity) {
      const minimalProductQuantity = parseInt(event.product_minimal_quantity, 10);
      const quantityInputSelector = (prestashop__WEBPACK_IMPORTED_MODULE_1___default().selectors.quantityWanted);
      const quantityInput = jquery__WEBPACK_IMPORTED_MODULE_0___default()(quantityInputSelector);
      quantityInput.trigger("touchspin.updatesettings", {
        min: minimalProductQuantity
      });
    }
    imageScrollBox();
    jquery__WEBPACK_IMPORTED_MODULE_0___default()(jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.activeTabs)).attr("href")).addClass("active").removeClass("fade");
    jquery__WEBPACK_IMPORTED_MODULE_0___default()((prestashop__WEBPACK_IMPORTED_MODULE_1___default().themeSelectors.product.imagesModal)).replaceWith(event.product_images_modal);
    const productSelect = new _components_product_select__WEBPACK_IMPORTED_MODULE_2__["default"]();
    productSelect.init();
    if (typeof thumbnailsGallery == "function") {
      thumbnailsGallery();
    }
  });
});


/***/ }),

/***/ "./js/responsive.js":
/*!**************************!*\
  !*** ./js/responsive.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prestashop */ "prestashop");
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prestashop__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */


var scrollW = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ? 0 : scrollWidth();
(prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive) = (prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive) || {};
(prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive.current_width) = window.innerWidth;
(prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive.min_width) = 992 - scrollW;
(prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive.mobile) = (prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive.current_width) < (prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive.min_width);
function scrollWidth() {
  var div = jquery__WEBPACK_IMPORTED_MODULE_0___default()("<div>").css({
    position: "absolute",
    top: "0px",
    left: "0px",
    width: "100px",
    height: "100px",
    visibility: "hidden",
    overflow: "scroll"
  });
  jquery__WEBPACK_IMPORTED_MODULE_0___default()("body").eq(0).append(div);
  var width = div.get(0).offsetWidth - div.get(0).clientWidth;
  div.remove();
  return width;
}
function swapChildren(obj1, obj2) {
  var temp = obj2.children().detach();
  obj2.empty().append(obj1.children().detach());
  obj1.append(temp);
}
function toggleMobileStyles() {
  if ((prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive.mobile)) {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()("*[id^='_desktop_']").each(function(idx, el) {
      var target = jquery__WEBPACK_IMPORTED_MODULE_0___default()("#" + el.id.replace("_desktop_", "_mobile_"));
      if (target.length) {
        swapChildren(jquery__WEBPACK_IMPORTED_MODULE_0___default()(el), target);
      }
    });
  } else {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()("*[id^='_mobile_']").each(function(idx, el) {
      var target = jquery__WEBPACK_IMPORTED_MODULE_0___default()("#" + el.id.replace("_mobile_", "_desktop_"));
      if (target.length) {
        swapChildren(jquery__WEBPACK_IMPORTED_MODULE_0___default()(el), target);
      }
    });
  }
  prestashop__WEBPACK_IMPORTED_MODULE_1___default().emit("responsive update", {
    mobile: (prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive.mobile)
  });
}
jquery__WEBPACK_IMPORTED_MODULE_0___default()(window).on("resize", function() {
  var _cw = (prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive.current_width);
  var _mw = (prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive.min_width);
  var _w = window.innerWidth;
  var _toggle = _cw >= _mw && _w < _mw || _cw < _mw && _w >= _mw;
  (prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive.current_width) = _w;
  (prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive.mobile) = (prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive.current_width) < (prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive.min_width);
  if (_toggle) {
    toggleMobileStyles();
  }
});
jquery__WEBPACK_IMPORTED_MODULE_0___default()(document).ready(function() {
  if ((prestashop__WEBPACK_IMPORTED_MODULE_1___default().responsive.mobile)) {
    toggleMobileStyles();
  }
});


/***/ }),

/***/ "./js/selectors.js":
/*!*************************!*\
  !*** ./js/selectors.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! prestashop */ "prestashop");
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(prestashop__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */


const passwordPolicy = {
  template: "#password-feedback",
  hint: ".js-hint-password",
  container: ".password-strength-feedback",
  strengthText: ".password-strength-text",
  requirementScore: ".password-requirements-score",
  requirementLength: ".password-requirements-length",
  requirementScoreIcon: ".password-requirements-score i",
  requirementLengthIcon: ".password-requirements-length i",
  progressBar: ".progress-bar",
  inputColumn: ".js-input-column"
};
(prestashop__WEBPACK_IMPORTED_MODULE_0___default().themeSelectors) = {
  product: {
    tabs: ".tabs .nav-link, .more-info .nav-link",
    activeNavClass: "js-product-nav-active",
    activeTabClass: "js-product-tab-active",
    activeTabs: ".tabs .nav-link.active, .js-product-nav-active, .more-info .nav-link.active",
    imagesModal: ".js-product-images-modal",
    thumb: ".js-thumb",
    thumbContainer: ".thumb-container, .js-thumb-container",
    arrows: ".js-arrows",
    selected: ".selected, .js-thumb-selected",
    modalProductCover: ".js-modal-product-cover",
    cover: ".js-qv-product-cover",
    customizationModal: ".js-customization-modal"
  },
  listing: {
    searchFilterToggler: "#search_filter_toggler, .js-search-toggler",
    searchFiltersWrapper: "#search_filters_wrapper",
    searchFilterControls: "#search_filter_controls",
    searchFilters: "#search_filters",
    activeSearchFilters: "#js-active-search-filters",
    listTop: "#js-product-list-top",
    product: ".js-product",
    list: "#js-product-list",
    listBottom: "#js-product-list-bottom",
    listHeader: "#js-product-list-header",
    searchFiltersClearAll: ".js-search-filters-clear-all",
    searchLink: ".js-search-link"
  },
  order: {
    returnForm: "#order-return-form, .js-order-return-form"
  },
  arrowDown: ".arrow-down, .js-arrow-down",
  arrowUp: ".arrow-up, .js-arrow-up",
  clear: ".clear",
  fileInput: ".js-file-input",
  contentWrapper: "#content-wrapper, .js-content-wrapper",
  footer: "#footer, .js-footer",
  modalContent: ".js-modal-content",
  modal: "#modal, .js-checkout-modal",
  touchspin: ".js-touchspin",
  checkout: {
    termsLink: ".js-terms a",
    giftCheckbox: ".js-gift-checkbox",
    imagesLink: ".card-block .cart-summary-products p a, .js-show-details",
    carrierExtraContent: ".carrier-extra-content, .js-carrier-extra-content",
    btn: ".checkout a"
  },
  cart: {
    productLineQty: ".js-cart-line-product-quantity",
    quickview: ".quickview",
    touchspin: ".bootstrap-touchspin",
    promoCode: "#promo-code",
    displayPromo: ".display-promo",
    promoCodeButton: ".promo-code-button",
    discountCode: ".js-discount .code",
    discountName: "[name=discount_name]",
    actions: '[data-link-action="delete-from-cart"], [data-link-action="remove-voucher"]'
  },
  notifications: {
    dangerAlert: "#notifications article.alert-danger",
    container: "#notifications .notifications-container"
  },
  passwordPolicy
};
jquery__WEBPACK_IMPORTED_MODULE_1___default()(document).ready(() => {
  prestashop__WEBPACK_IMPORTED_MODULE_0___default().emit("themeSelectorsInit");
});


/***/ }),

/***/ "./node_modules/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.js ***!
  \*****************************************************************************/
/***/ (() => {

(function($) {
  "use strict";
  var _currentSpinnerId = 0;
  function _scopedEventName(name, id) {
    return name + ".touchspin_" + id;
  }
  function _scopeEventNames(names, id) {
    return $.map(names, function(name) {
      return _scopedEventName(name, id);
    });
  }
  $.fn.TouchSpin = function(options) {
    if (options === "destroy") {
      this.each(function() {
        var originalinput = $(this), originalinput_data = originalinput.data();
        $(document).off(_scopeEventNames([
          "mouseup",
          "touchend",
          "touchcancel",
          "mousemove",
          "touchmove",
          "scroll",
          "scrollstart"
        ], originalinput_data.spinnerid).join(" "));
      });
      return;
    }
    var defaults = {
      min: 0,
      max: 100,
      initval: "",
      replacementval: "",
      step: 1,
      decimals: 0,
      stepinterval: 100,
      forcestepdivisibility: "round",
      stepintervaldelay: 500,
      verticalbuttons: false,
      verticalupclass: "glyphicon glyphicon-chevron-up",
      verticaldownclass: "glyphicon glyphicon-chevron-down",
      prefix: "",
      postfix: "",
      prefix_extraclass: "",
      postfix_extraclass: "",
      booster: true,
      boostat: 10,
      maxboostedstep: false,
      mousewheel: true,
      buttondown_class: "btn btn-default",
      buttonup_class: "btn btn-default",
      buttondown_txt: "-",
      buttonup_txt: "+"
    };
    var attributeMap = {
      min: "min",
      max: "max",
      initval: "init-val",
      replacementval: "replacement-val",
      step: "step",
      decimals: "decimals",
      stepinterval: "step-interval",
      verticalbuttons: "vertical-buttons",
      verticalupclass: "vertical-up-class",
      verticaldownclass: "vertical-down-class",
      forcestepdivisibility: "force-step-divisibility",
      stepintervaldelay: "step-interval-delay",
      prefix: "prefix",
      postfix: "postfix",
      prefix_extraclass: "prefix-extra-class",
      postfix_extraclass: "postfix-extra-class",
      booster: "booster",
      boostat: "boostat",
      maxboostedstep: "max-boosted-step",
      mousewheel: "mouse-wheel",
      buttondown_class: "button-down-class",
      buttonup_class: "button-up-class",
      buttondown_txt: "button-down-txt",
      buttonup_txt: "button-up-txt"
    };
    return this.each(function() {
      var settings, originalinput = $(this), originalinput_data = originalinput.data(), container, elements, value, downSpinTimer, upSpinTimer, downDelayTimeout, upDelayTimeout, spincount = 0, spinning = false;
      init();
      function init() {
        if (originalinput.data("alreadyinitialized")) {
          return;
        }
        originalinput.data("alreadyinitialized", true);
        _currentSpinnerId += 1;
        originalinput.data("spinnerid", _currentSpinnerId);
        if (!originalinput.is("input")) {
          console.log("Must be an input.");
          return;
        }
        _initSettings();
        _setInitval();
        _checkValue();
        _buildHtml();
        _initElements();
        _hideEmptyPrefixPostfix();
        _bindEvents();
        _bindEventsInterface();
        elements.input.css("display", "block");
      }
      function _setInitval() {
        if (settings.initval !== "" && originalinput.val() === "") {
          originalinput.val(settings.initval);
        }
      }
      function changeSettings(newsettings) {
        _updateSettings(newsettings);
        _checkValue();
        var value2 = elements.input.val();
        if (value2 !== "") {
          value2 = Number(elements.input.val());
          elements.input.val(value2.toFixed(settings.decimals));
        }
      }
      function _initSettings() {
        settings = $.extend({}, defaults, originalinput_data, _parseAttributes(), options);
      }
      function _parseAttributes() {
        var data = {};
        $.each(attributeMap, function(key, value2) {
          var attrName = "bts-" + value2 + "";
          if (originalinput.is("[data-" + attrName + "]")) {
            data[key] = originalinput.data(attrName);
          }
        });
        return data;
      }
      function _updateSettings(newsettings) {
        settings = $.extend({}, settings, newsettings);
      }
      function _buildHtml() {
        var initval = originalinput.val(), parentelement = originalinput.parent();
        if (initval !== "") {
          initval = Number(initval).toFixed(settings.decimals);
        }
        originalinput.data("initvalue", initval).val(initval);
        originalinput.addClass("form-control");
        if (parentelement.hasClass("input-group")) {
          _advanceInputGroup(parentelement);
        } else {
          _buildInputGroup();
        }
      }
      function _advanceInputGroup(parentelement) {
        parentelement.addClass("bootstrap-touchspin");
        var prev = originalinput.prev(), next = originalinput.next();
        var downhtml, uphtml, prefixhtml = '<span class="input-group-addon bootstrap-touchspin-prefix">' + settings.prefix + "</span>", postfixhtml = '<span class="input-group-addon bootstrap-touchspin-postfix">' + settings.postfix + "</span>";
        if (prev.hasClass("input-group-btn")) {
          downhtml = '<button class="' + settings.buttondown_class + ' bootstrap-touchspin-down" type="button">' + settings.buttondown_txt + "</button>";
          prev.append(downhtml);
        } else {
          downhtml = '<span class="input-group-btn"><button class="' + settings.buttondown_class + ' bootstrap-touchspin-down" type="button">' + settings.buttondown_txt + "</button></span>";
          $(downhtml).insertBefore(originalinput);
        }
        if (next.hasClass("input-group-btn")) {
          uphtml = '<button class="' + settings.buttonup_class + ' bootstrap-touchspin-up" type="button">' + settings.buttonup_txt + "</button>";
          next.prepend(uphtml);
        } else {
          uphtml = '<span class="input-group-btn"><button class="' + settings.buttonup_class + ' bootstrap-touchspin-up" type="button">' + settings.buttonup_txt + "</button></span>";
          $(uphtml).insertAfter(originalinput);
        }
        $(prefixhtml).insertBefore(originalinput);
        $(postfixhtml).insertAfter(originalinput);
        container = parentelement;
      }
      function _buildInputGroup() {
        var html;
        if (settings.verticalbuttons) {
          html = '<div class="input-group bootstrap-touchspin"><span class="input-group-addon bootstrap-touchspin-prefix">' + settings.prefix + '</span><span class="input-group-addon bootstrap-touchspin-postfix">' + settings.postfix + '</span><span class="input-group-btn-vertical"><button class="' + settings.buttondown_class + ' bootstrap-touchspin-up" type="button"><i class="' + settings.verticalupclass + '"></i></button><button class="' + settings.buttonup_class + ' bootstrap-touchspin-down" type="button"><i class="' + settings.verticaldownclass + '"></i></button></span></div>';
        } else {
          html = '<div class="input-group bootstrap-touchspin"><span class="input-group-btn"><button class="' + settings.buttondown_class + ' bootstrap-touchspin-down" type="button">' + settings.buttondown_txt + '</button></span><span class="input-group-addon bootstrap-touchspin-prefix">' + settings.prefix + '</span><span class="input-group-addon bootstrap-touchspin-postfix">' + settings.postfix + '</span><span class="input-group-btn"><button class="' + settings.buttonup_class + ' bootstrap-touchspin-up" type="button">' + settings.buttonup_txt + "</button></span></div>";
        }
        container = $(html).insertBefore(originalinput);
        $(".bootstrap-touchspin-prefix", container).after(originalinput);
        if (originalinput.hasClass("input-sm")) {
          container.addClass("input-group-sm");
        } else if (originalinput.hasClass("input-lg")) {
          container.addClass("input-group-lg");
        }
      }
      function _initElements() {
        elements = {
          down: $(".bootstrap-touchspin-down", container),
          up: $(".bootstrap-touchspin-up", container),
          input: $("input", container),
          prefix: $(".bootstrap-touchspin-prefix", container).addClass(settings.prefix_extraclass),
          postfix: $(".bootstrap-touchspin-postfix", container).addClass(settings.postfix_extraclass)
        };
      }
      function _hideEmptyPrefixPostfix() {
        if (settings.prefix === "") {
          elements.prefix.hide();
        }
        if (settings.postfix === "") {
          elements.postfix.hide();
        }
      }
      function _bindEvents() {
        originalinput.on("keydown", function(ev) {
          var code = ev.keyCode || ev.which;
          if (code === 38) {
            if (spinning !== "up") {
              upOnce();
              startUpSpin();
            }
            ev.preventDefault();
          } else if (code === 40) {
            if (spinning !== "down") {
              downOnce();
              startDownSpin();
            }
            ev.preventDefault();
          }
        });
        originalinput.on("keyup", function(ev) {
          var code = ev.keyCode || ev.which;
          if (code === 38) {
            stopSpin();
          } else if (code === 40) {
            stopSpin();
          }
        });
        originalinput.on("blur", function() {
          _checkValue();
        });
        elements.down.on("keydown", function(ev) {
          var code = ev.keyCode || ev.which;
          if (code === 32 || code === 13) {
            if (spinning !== "down") {
              downOnce();
              startDownSpin();
            }
            ev.preventDefault();
          }
        });
        elements.down.on("keyup", function(ev) {
          var code = ev.keyCode || ev.which;
          if (code === 32 || code === 13) {
            stopSpin();
          }
        });
        elements.up.on("keydown", function(ev) {
          var code = ev.keyCode || ev.which;
          if (code === 32 || code === 13) {
            if (spinning !== "up") {
              upOnce();
              startUpSpin();
            }
            ev.preventDefault();
          }
        });
        elements.up.on("keyup", function(ev) {
          var code = ev.keyCode || ev.which;
          if (code === 32 || code === 13) {
            stopSpin();
          }
        });
        elements.down.on("mousedown.touchspin", function(ev) {
          elements.down.off("touchstart.touchspin");
          if (originalinput.is(":disabled")) {
            return;
          }
          downOnce();
          startDownSpin();
          ev.preventDefault();
          ev.stopPropagation();
        });
        elements.down.on("touchstart.touchspin", function(ev) {
          elements.down.off("mousedown.touchspin");
          if (originalinput.is(":disabled")) {
            return;
          }
          downOnce();
          startDownSpin();
          ev.preventDefault();
          ev.stopPropagation();
        });
        elements.up.on("mousedown.touchspin", function(ev) {
          elements.up.off("touchstart.touchspin");
          if (originalinput.is(":disabled")) {
            return;
          }
          upOnce();
          startUpSpin();
          ev.preventDefault();
          ev.stopPropagation();
        });
        elements.up.on("touchstart.touchspin", function(ev) {
          elements.up.off("mousedown.touchspin");
          if (originalinput.is(":disabled")) {
            return;
          }
          upOnce();
          startUpSpin();
          ev.preventDefault();
          ev.stopPropagation();
        });
        elements.up.on("mouseout touchleave touchend touchcancel", function(ev) {
          if (!spinning) {
            return;
          }
          ev.stopPropagation();
          stopSpin();
        });
        elements.down.on("mouseout touchleave touchend touchcancel", function(ev) {
          if (!spinning) {
            return;
          }
          ev.stopPropagation();
          stopSpin();
        });
        elements.down.on("mousemove touchmove", function(ev) {
          if (!spinning) {
            return;
          }
          ev.stopPropagation();
          ev.preventDefault();
        });
        elements.up.on("mousemove touchmove", function(ev) {
          if (!spinning) {
            return;
          }
          ev.stopPropagation();
          ev.preventDefault();
        });
        $(document).on(_scopeEventNames(["mouseup", "touchend", "touchcancel"], _currentSpinnerId).join(" "), function(ev) {
          if (!spinning) {
            return;
          }
          ev.preventDefault();
          stopSpin();
        });
        $(document).on(_scopeEventNames(["mousemove", "touchmove", "scroll", "scrollstart"], _currentSpinnerId).join(" "), function(ev) {
          if (!spinning) {
            return;
          }
          ev.preventDefault();
          stopSpin();
        });
        originalinput.on("mousewheel DOMMouseScroll", function(ev) {
          if (!settings.mousewheel || !originalinput.is(":focus")) {
            return;
          }
          var delta = ev.originalEvent.wheelDelta || -ev.originalEvent.deltaY || -ev.originalEvent.detail;
          ev.stopPropagation();
          ev.preventDefault();
          if (delta < 0) {
            downOnce();
          } else {
            upOnce();
          }
        });
      }
      function _bindEventsInterface() {
        originalinput.on("touchspin.uponce", function() {
          stopSpin();
          upOnce();
        });
        originalinput.on("touchspin.downonce", function() {
          stopSpin();
          downOnce();
        });
        originalinput.on("touchspin.startupspin", function() {
          startUpSpin();
        });
        originalinput.on("touchspin.startdownspin", function() {
          startDownSpin();
        });
        originalinput.on("touchspin.stopspin", function() {
          stopSpin();
        });
        originalinput.on("touchspin.updatesettings", function(e, newsettings) {
          changeSettings(newsettings);
        });
      }
      function _forcestepdivisibility(value2) {
        switch (settings.forcestepdivisibility) {
          case "round":
            return (Math.round(value2 / settings.step) * settings.step).toFixed(settings.decimals);
          case "floor":
            return (Math.floor(value2 / settings.step) * settings.step).toFixed(settings.decimals);
          case "ceil":
            return (Math.ceil(value2 / settings.step) * settings.step).toFixed(settings.decimals);
          default:
            return value2;
        }
      }
      function _checkValue() {
        var val, parsedval, returnval;
        val = originalinput.val();
        if (val === "") {
          if (settings.replacementval !== "") {
            originalinput.val(settings.replacementval);
            originalinput.trigger("change");
          }
          return;
        }
        if (settings.decimals > 0 && val === ".") {
          return;
        }
        parsedval = parseFloat(val);
        if (isNaN(parsedval)) {
          if (settings.replacementval !== "") {
            parsedval = settings.replacementval;
          } else {
            parsedval = 0;
          }
        }
        returnval = parsedval;
        if (parsedval.toString() !== val) {
          returnval = parsedval;
        }
        if (parsedval < settings.min) {
          returnval = settings.min;
        }
        if (parsedval > settings.max) {
          returnval = settings.max;
        }
        returnval = _forcestepdivisibility(returnval);
        if (Number(val).toString() !== returnval.toString()) {
          originalinput.val(returnval);
          originalinput.trigger("change");
        }
      }
      function _getBoostedStep() {
        if (!settings.booster) {
          return settings.step;
        } else {
          var boosted = Math.pow(2, Math.floor(spincount / settings.boostat)) * settings.step;
          if (settings.maxboostedstep) {
            if (boosted > settings.maxboostedstep) {
              boosted = settings.maxboostedstep;
              value = Math.round(value / boosted) * boosted;
            }
          }
          return Math.max(settings.step, boosted);
        }
      }
      function upOnce() {
        _checkValue();
        value = parseFloat(elements.input.val());
        if (isNaN(value)) {
          value = 0;
        }
        var initvalue = value, boostedstep = _getBoostedStep();
        value = value + boostedstep;
        if (value > settings.max) {
          value = settings.max;
          originalinput.trigger("touchspin.on.max");
          stopSpin();
        }
        elements.input.val(Number(value).toFixed(settings.decimals));
        if (initvalue !== value) {
          originalinput.trigger("change");
        }
      }
      function downOnce() {
        _checkValue();
        value = parseFloat(elements.input.val());
        if (isNaN(value)) {
          value = 0;
        }
        var initvalue = value, boostedstep = _getBoostedStep();
        value = value - boostedstep;
        if (value < settings.min) {
          value = settings.min;
          originalinput.trigger("touchspin.on.min");
          stopSpin();
        }
        elements.input.val(value.toFixed(settings.decimals));
        if (initvalue !== value) {
          originalinput.trigger("change");
        }
      }
      function startDownSpin() {
        stopSpin();
        spincount = 0;
        spinning = "down";
        originalinput.trigger("touchspin.on.startspin");
        originalinput.trigger("touchspin.on.startdownspin");
        downDelayTimeout = setTimeout(function() {
          downSpinTimer = setInterval(function() {
            spincount++;
            downOnce();
          }, settings.stepinterval);
        }, settings.stepintervaldelay);
      }
      function startUpSpin() {
        stopSpin();
        spincount = 0;
        spinning = "up";
        originalinput.trigger("touchspin.on.startspin");
        originalinput.trigger("touchspin.on.startupspin");
        upDelayTimeout = setTimeout(function() {
          upSpinTimer = setInterval(function() {
            spincount++;
            upOnce();
          }, settings.stepinterval);
        }, settings.stepintervaldelay);
      }
      function stopSpin() {
        clearTimeout(downDelayTimeout);
        clearTimeout(upDelayTimeout);
        clearInterval(downSpinTimer);
        clearInterval(upSpinTimer);
        switch (spinning) {
          case "up":
            originalinput.trigger("touchspin.on.stopupspin");
            originalinput.trigger("touchspin.on.stopspin");
            break;
          case "down":
            originalinput.trigger("touchspin.on.stopdownspin");
            originalinput.trigger("touchspin.on.stopspin");
            break;
        }
        spincount = 0;
        spinning = false;
      }
    });
  };
})(jQuery);


/***/ }),

/***/ "./node_modules/bootstrap/dist/js/bootstrap.min.js":
/*!*********************************************************!*\
  !*** ./node_modules/bootstrap/dist/js/bootstrap.min.js ***!
  \*********************************************************/
/***/ (() => {

/*!
 * Bootstrap v4.0.0-alpha.6 (https://getbootstrap.com)
 * Copyright 2011-2017 The Bootstrap Authors (https://github.com/twbs/bootstrap/graphs/contributors)
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 */
if (typeof jQuery == "undefined")
  throw new Error("Bootstrap's JavaScript requires jQuery. jQuery must be included before Bootstrap's JavaScript.");
+function(t) {
  var e = t.fn.jquery.split(" ")[0].split(".");
  if (e[0] < 2 && e[1] < 9 || e[0] == 1 && e[1] == 9 && e[2] < 1 || e[0] >= 4)
    throw new Error("Bootstrap's JavaScript requires at least jQuery v1.9.1 but less than v4.0.0");
}(jQuery), +function() {
  function t(t2, e2) {
    if (!t2)
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    return !e2 || typeof e2 != "object" && typeof e2 != "function" ? t2 : e2;
  }
  function e(t2, e2) {
    if (typeof e2 != "function" && e2 !== null)
      throw new TypeError("Super expression must either be null or a function, not " + typeof e2);
    t2.prototype = Object.create(e2 && e2.prototype, { constructor: { value: t2, enumerable: false, writable: true, configurable: true } }), e2 && (Object.setPrototypeOf ? Object.setPrototypeOf(t2, e2) : t2.__proto__ = e2);
  }
  function n(t2, e2) {
    if (!(t2 instanceof e2))
      throw new TypeError("Cannot call a class as a function");
  }
  var i = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(t2) {
    return typeof t2;
  } : function(t2) {
    return t2 && typeof Symbol == "function" && t2.constructor === Symbol && t2 !== Symbol.prototype ? "symbol" : typeof t2;
  }, o = function() {
    function t2(t3, e2) {
      for (var n2 = 0; n2 < e2.length; n2++) {
        var i2 = e2[n2];
        i2.enumerable = i2.enumerable || false, i2.configurable = true, "value" in i2 && (i2.writable = true), Object.defineProperty(t3, i2.key, i2);
      }
    }
    return function(e2, n2, i2) {
      return n2 && t2(e2.prototype, n2), i2 && t2(e2, i2), e2;
    };
  }(), r = function(t2) {
    function e2(t3) {
      return {}.toString.call(t3).match(/\s([a-zA-Z]+)/)[1].toLowerCase();
    }
    function n2(t3) {
      return (t3[0] || t3).nodeType;
    }
    function i2() {
      return { bindType: a.end, delegateType: a.end, handle: function(e3) {
        if (t2(e3.target).is(this))
          return e3.handleObj.handler.apply(this, arguments);
      } };
    }
    function o2() {
      if (window.QUnit)
        return false;
      var t3 = document.createElement("bootstrap");
      for (var e3 in h)
        if (t3.style[e3] !== void 0)
          return { end: h[e3] };
      return false;
    }
    function r2(e3) {
      var n3 = this, i3 = false;
      return t2(this).one(c.TRANSITION_END, function() {
        i3 = true;
      }), setTimeout(function() {
        i3 || c.triggerTransitionEnd(n3);
      }, e3), this;
    }
    function s2() {
      a = o2(), t2.fn.emulateTransitionEnd = r2, c.supportsTransitionEnd() && (t2.event.special[c.TRANSITION_END] = i2());
    }
    var a = false, l = 1e6, h = { WebkitTransition: "webkitTransitionEnd", MozTransition: "transitionend", OTransition: "oTransitionEnd otransitionend", transition: "transitionend" }, c = { TRANSITION_END: "bsTransitionEnd", getUID: function(t3) {
      do
        t3 += ~~(Math.random() * l);
      while (document.getElementById(t3));
      return t3;
    }, getSelectorFromElement: function(t3) {
      var e3 = t3.getAttribute("data-target");
      return e3 || (e3 = t3.getAttribute("href") || "", e3 = /^#[a-z]/i.test(e3) ? e3 : null), e3;
    }, reflow: function(t3) {
      return t3.offsetHeight;
    }, triggerTransitionEnd: function(e3) {
      t2(e3).trigger(a.end);
    }, supportsTransitionEnd: function() {
      return Boolean(a);
    }, typeCheckConfig: function(t3, i3, o3) {
      for (var r3 in o3)
        if (o3.hasOwnProperty(r3)) {
          var s3 = o3[r3], a2 = i3[r3], l2 = a2 && n2(a2) ? "element" : e2(a2);
          if (!new RegExp(s3).test(l2))
            throw new Error(t3.toUpperCase() + ": " + ('Option "' + r3 + '" provided type "' + l2 + '" ') + ('but expected type "' + s3 + '".'));
        }
    } };
    return s2(), c;
  }(jQuery), s = (function(t2) {
    var e2 = "alert", i2 = "4.0.0-alpha.6", s2 = "bs.alert", a = "." + s2, l = ".data-api", h = t2.fn[e2], c = 150, u = { DISMISS: '[data-dismiss="alert"]' }, d = { CLOSE: "close" + a, CLOSED: "closed" + a, CLICK_DATA_API: "click" + a + l }, f = { ALERT: "alert", FADE: "fade", SHOW: "show" }, _ = function() {
      function e3(t3) {
        n(this, e3), this._element = t3;
      }
      return e3.prototype.close = function(t3) {
        t3 = t3 || this._element;
        var e4 = this._getRootElement(t3), n2 = this._triggerCloseEvent(e4);
        n2.isDefaultPrevented() || this._removeElement(e4);
      }, e3.prototype.dispose = function() {
        t2.removeData(this._element, s2), this._element = null;
      }, e3.prototype._getRootElement = function(e4) {
        var n2 = r.getSelectorFromElement(e4), i3 = false;
        return n2 && (i3 = t2(n2)[0]), i3 || (i3 = t2(e4).closest("." + f.ALERT)[0]), i3;
      }, e3.prototype._triggerCloseEvent = function(e4) {
        var n2 = t2.Event(d.CLOSE);
        return t2(e4).trigger(n2), n2;
      }, e3.prototype._removeElement = function(e4) {
        var n2 = this;
        return t2(e4).removeClass(f.SHOW), r.supportsTransitionEnd() && t2(e4).hasClass(f.FADE) ? void t2(e4).one(r.TRANSITION_END, function(t3) {
          return n2._destroyElement(e4, t3);
        }).emulateTransitionEnd(c) : void this._destroyElement(e4);
      }, e3.prototype._destroyElement = function(e4) {
        t2(e4).detach().trigger(d.CLOSED).remove();
      }, e3._jQueryInterface = function(n2) {
        return this.each(function() {
          var i3 = t2(this), o2 = i3.data(s2);
          o2 || (o2 = new e3(this), i3.data(s2, o2)), n2 === "close" && o2[n2](this);
        });
      }, e3._handleDismiss = function(t3) {
        return function(e4) {
          e4 && e4.preventDefault(), t3.close(this);
        };
      }, o(e3, null, [{ key: "VERSION", get: function() {
        return i2;
      } }]), e3;
    }();
    return t2(document).on(d.CLICK_DATA_API, u.DISMISS, _._handleDismiss(new _())), t2.fn[e2] = _._jQueryInterface, t2.fn[e2].Constructor = _, t2.fn[e2].noConflict = function() {
      return t2.fn[e2] = h, _._jQueryInterface;
    }, _;
  }(jQuery), function(t2) {
    var e2 = "button", i2 = "4.0.0-alpha.6", r2 = "bs.button", s2 = "." + r2, a = ".data-api", l = t2.fn[e2], h = { ACTIVE: "active", BUTTON: "btn", FOCUS: "focus" }, c = { DATA_TOGGLE_CARROT: '[data-toggle^="button"]', DATA_TOGGLE: '[data-toggle="buttons"]', INPUT: "input", ACTIVE: ".active", BUTTON: ".btn" }, u = { CLICK_DATA_API: "click" + s2 + a, FOCUS_BLUR_DATA_API: "focus" + s2 + a + " " + ("blur" + s2 + a) }, d = function() {
      function e3(t3) {
        n(this, e3), this._element = t3;
      }
      return e3.prototype.toggle = function() {
        var e4 = true, n2 = t2(this._element).closest(c.DATA_TOGGLE)[0];
        if (n2) {
          var i3 = t2(this._element).find(c.INPUT)[0];
          if (i3) {
            if (i3.type === "radio")
              if (i3.checked && t2(this._element).hasClass(h.ACTIVE))
                e4 = false;
              else {
                var o2 = t2(n2).find(c.ACTIVE)[0];
                o2 && t2(o2).removeClass(h.ACTIVE);
              }
            e4 && (i3.checked = !t2(this._element).hasClass(h.ACTIVE), t2(i3).trigger("change")), i3.focus();
          }
        }
        this._element.setAttribute("aria-pressed", !t2(this._element).hasClass(h.ACTIVE)), e4 && t2(this._element).toggleClass(h.ACTIVE);
      }, e3.prototype.dispose = function() {
        t2.removeData(this._element, r2), this._element = null;
      }, e3._jQueryInterface = function(n2) {
        return this.each(function() {
          var i3 = t2(this).data(r2);
          i3 || (i3 = new e3(this), t2(this).data(r2, i3)), n2 === "toggle" && i3[n2]();
        });
      }, o(e3, null, [{ key: "VERSION", get: function() {
        return i2;
      } }]), e3;
    }();
    return t2(document).on(u.CLICK_DATA_API, c.DATA_TOGGLE_CARROT, function(e3) {
      e3.preventDefault();
      var n2 = e3.target;
      t2(n2).hasClass(h.BUTTON) || (n2 = t2(n2).closest(c.BUTTON)), d._jQueryInterface.call(t2(n2), "toggle");
    }).on(u.FOCUS_BLUR_DATA_API, c.DATA_TOGGLE_CARROT, function(e3) {
      var n2 = t2(e3.target).closest(c.BUTTON)[0];
      t2(n2).toggleClass(h.FOCUS, /^focus(in)?$/.test(e3.type));
    }), t2.fn[e2] = d._jQueryInterface, t2.fn[e2].Constructor = d, t2.fn[e2].noConflict = function() {
      return t2.fn[e2] = l, d._jQueryInterface;
    }, d;
  }(jQuery), function(t2) {
    var e2 = "carousel", s2 = "4.0.0-alpha.6", a = "bs.carousel", l = "." + a, h = ".data-api", c = t2.fn[e2], u = 600, d = 37, f = 39, _ = { interval: 5e3, keyboard: true, slide: false, pause: "hover", wrap: true }, g = { interval: "(number|boolean)", keyboard: "boolean", slide: "(boolean|string)", pause: "(string|boolean)", wrap: "boolean" }, p = { NEXT: "next", PREV: "prev", LEFT: "left", RIGHT: "right" }, m = { SLIDE: "slide" + l, SLID: "slid" + l, KEYDOWN: "keydown" + l, MOUSEENTER: "mouseenter" + l, MOUSELEAVE: "mouseleave" + l, LOAD_DATA_API: "load" + l + h, CLICK_DATA_API: "click" + l + h }, E = { CAROUSEL: "carousel", ACTIVE: "active", SLIDE: "slide", RIGHT: "carousel-item-right", LEFT: "carousel-item-left", NEXT: "carousel-item-next", PREV: "carousel-item-prev", ITEM: "carousel-item" }, v = { ACTIVE: ".active", ACTIVE_ITEM: ".active.carousel-item", ITEM: ".carousel-item", NEXT_PREV: ".carousel-item-next, .carousel-item-prev", INDICATORS: ".carousel-indicators", DATA_SLIDE: "[data-slide], [data-slide-to]", DATA_RIDE: '[data-ride="carousel"]' }, T = function() {
      function h2(e3, i2) {
        n(this, h2), this._items = null, this._interval = null, this._activeElement = null, this._isPaused = false, this._isSliding = false, this._config = this._getConfig(i2), this._element = t2(e3)[0], this._indicatorsElement = t2(this._element).find(v.INDICATORS)[0], this._addEventListeners();
      }
      return h2.prototype.next = function() {
        if (this._isSliding)
          throw new Error("Carousel is sliding");
        this._slide(p.NEXT);
      }, h2.prototype.nextWhenVisible = function() {
        document.hidden || this.next();
      }, h2.prototype.prev = function() {
        if (this._isSliding)
          throw new Error("Carousel is sliding");
        this._slide(p.PREVIOUS);
      }, h2.prototype.pause = function(e3) {
        e3 || (this._isPaused = true), t2(this._element).find(v.NEXT_PREV)[0] && r.supportsTransitionEnd() && (r.triggerTransitionEnd(this._element), this.cycle(true)), clearInterval(this._interval), this._interval = null;
      }, h2.prototype.cycle = function(t3) {
        t3 || (this._isPaused = false), this._interval && (clearInterval(this._interval), this._interval = null), this._config.interval && !this._isPaused && (this._interval = setInterval((document.visibilityState ? this.nextWhenVisible : this.next).bind(this), this._config.interval));
      }, h2.prototype.to = function(e3) {
        var n2 = this;
        this._activeElement = t2(this._element).find(v.ACTIVE_ITEM)[0];
        var i2 = this._getItemIndex(this._activeElement);
        if (!(e3 > this._items.length - 1 || e3 < 0)) {
          if (this._isSliding)
            return void t2(this._element).one(m.SLID, function() {
              return n2.to(e3);
            });
          if (i2 === e3)
            return this.pause(), void this.cycle();
          var o2 = e3 > i2 ? p.NEXT : p.PREVIOUS;
          this._slide(o2, this._items[e3]);
        }
      }, h2.prototype.dispose = function() {
        t2(this._element).off(l), t2.removeData(this._element, a), this._items = null, this._config = null, this._element = null, this._interval = null, this._isPaused = null, this._isSliding = null, this._activeElement = null, this._indicatorsElement = null;
      }, h2.prototype._getConfig = function(n2) {
        return n2 = t2.extend({}, _, n2), r.typeCheckConfig(e2, n2, g), n2;
      }, h2.prototype._addEventListeners = function() {
        var e3 = this;
        this._config.keyboard && t2(this._element).on(m.KEYDOWN, function(t3) {
          return e3._keydown(t3);
        }), this._config.pause !== "hover" || "ontouchstart" in document.documentElement || t2(this._element).on(m.MOUSEENTER, function(t3) {
          return e3.pause(t3);
        }).on(m.MOUSELEAVE, function(t3) {
          return e3.cycle(t3);
        });
      }, h2.prototype._keydown = function(t3) {
        if (!/input|textarea/i.test(t3.target.tagName))
          switch (t3.which) {
            case d:
              t3.preventDefault(), this.prev();
              break;
            case f:
              t3.preventDefault(), this.next();
              break;
            default:
              return;
          }
      }, h2.prototype._getItemIndex = function(e3) {
        return this._items = t2.makeArray(t2(e3).parent().find(v.ITEM)), this._items.indexOf(e3);
      }, h2.prototype._getItemByDirection = function(t3, e3) {
        var n2 = t3 === p.NEXT, i2 = t3 === p.PREVIOUS, o2 = this._getItemIndex(e3), r2 = this._items.length - 1, s3 = i2 && o2 === 0 || n2 && o2 === r2;
        if (s3 && !this._config.wrap)
          return e3;
        var a2 = t3 === p.PREVIOUS ? -1 : 1, l2 = (o2 + a2) % this._items.length;
        return l2 === -1 ? this._items[this._items.length - 1] : this._items[l2];
      }, h2.prototype._triggerSlideEvent = function(e3, n2) {
        var i2 = t2.Event(m.SLIDE, { relatedTarget: e3, direction: n2 });
        return t2(this._element).trigger(i2), i2;
      }, h2.prototype._setActiveIndicatorElement = function(e3) {
        if (this._indicatorsElement) {
          t2(this._indicatorsElement).find(v.ACTIVE).removeClass(E.ACTIVE);
          var n2 = this._indicatorsElement.children[this._getItemIndex(e3)];
          n2 && t2(n2).addClass(E.ACTIVE);
        }
      }, h2.prototype._slide = function(e3, n2) {
        var i2 = this, o2 = t2(this._element).find(v.ACTIVE_ITEM)[0], s3 = n2 || o2 && this._getItemByDirection(e3, o2), a2 = Boolean(this._interval), l2 = void 0, h3 = void 0, c2 = void 0;
        if (e3 === p.NEXT ? (l2 = E.LEFT, h3 = E.NEXT, c2 = p.LEFT) : (l2 = E.RIGHT, h3 = E.PREV, c2 = p.RIGHT), s3 && t2(s3).hasClass(E.ACTIVE))
          return void (this._isSliding = false);
        var d2 = this._triggerSlideEvent(s3, c2);
        if (!d2.isDefaultPrevented() && o2 && s3) {
          this._isSliding = true, a2 && this.pause(), this._setActiveIndicatorElement(s3);
          var f2 = t2.Event(m.SLID, { relatedTarget: s3, direction: c2 });
          r.supportsTransitionEnd() && t2(this._element).hasClass(E.SLIDE) ? (t2(s3).addClass(h3), r.reflow(s3), t2(o2).addClass(l2), t2(s3).addClass(l2), t2(o2).one(r.TRANSITION_END, function() {
            t2(s3).removeClass(l2 + " " + h3).addClass(E.ACTIVE), t2(o2).removeClass(E.ACTIVE + " " + h3 + " " + l2), i2._isSliding = false, setTimeout(function() {
              return t2(i2._element).trigger(f2);
            }, 0);
          }).emulateTransitionEnd(u)) : (t2(o2).removeClass(E.ACTIVE), t2(s3).addClass(E.ACTIVE), this._isSliding = false, t2(this._element).trigger(f2)), a2 && this.cycle();
        }
      }, h2._jQueryInterface = function(e3) {
        return this.each(function() {
          var n2 = t2(this).data(a), o2 = t2.extend({}, _, t2(this).data());
          (typeof e3 == "undefined" ? "undefined" : i(e3)) === "object" && t2.extend(o2, e3);
          var r2 = typeof e3 == "string" ? e3 : o2.slide;
          if (n2 || (n2 = new h2(this, o2), t2(this).data(a, n2)), typeof e3 == "number")
            n2.to(e3);
          else if (typeof r2 == "string") {
            if (n2[r2] === void 0)
              throw new Error('No method named "' + r2 + '"');
            n2[r2]();
          } else
            o2.interval && (n2.pause(), n2.cycle());
        });
      }, h2._dataApiClickHandler = function(e3) {
        var n2 = r.getSelectorFromElement(this);
        if (n2) {
          var i2 = t2(n2)[0];
          if (i2 && t2(i2).hasClass(E.CAROUSEL)) {
            var o2 = t2.extend({}, t2(i2).data(), t2(this).data()), s3 = this.getAttribute("data-slide-to");
            s3 && (o2.interval = false), h2._jQueryInterface.call(t2(i2), o2), s3 && t2(i2).data(a).to(s3), e3.preventDefault();
          }
        }
      }, o(h2, null, [{ key: "VERSION", get: function() {
        return s2;
      } }, { key: "Default", get: function() {
        return _;
      } }]), h2;
    }();
    return t2(document).on(m.CLICK_DATA_API, v.DATA_SLIDE, T._dataApiClickHandler), t2(window).on(m.LOAD_DATA_API, function() {
      t2(v.DATA_RIDE).each(function() {
        var e3 = t2(this);
        T._jQueryInterface.call(e3, e3.data());
      });
    }), t2.fn[e2] = T._jQueryInterface, t2.fn[e2].Constructor = T, t2.fn[e2].noConflict = function() {
      return t2.fn[e2] = c, T._jQueryInterface;
    }, T;
  }(jQuery), function(t2) {
    var e2 = "collapse", s2 = "4.0.0-alpha.6", a = "bs.collapse", l = "." + a, h = ".data-api", c = t2.fn[e2], u = 600, d = { toggle: true, parent: "" }, f = { toggle: "boolean", parent: "string" }, _ = { SHOW: "show" + l, SHOWN: "shown" + l, HIDE: "hide" + l, HIDDEN: "hidden" + l, CLICK_DATA_API: "click" + l + h }, g = { SHOW: "show", COLLAPSE: "collapse", COLLAPSING: "collapsing", COLLAPSED: "collapsed" }, p = { WIDTH: "width", HEIGHT: "height" }, m = { ACTIVES: ".card > .show, .card > .collapsing", DATA_TOGGLE: '[data-toggle="collapse"]' }, E = function() {
      function l2(e3, i2) {
        n(this, l2), this._isTransitioning = false, this._element = e3, this._config = this._getConfig(i2), this._triggerArray = t2.makeArray(t2('[data-toggle="collapse"][href="#' + e3.id + '"],' + ('[data-toggle="collapse"][data-target="#' + e3.id + '"]'))), this._parent = this._config.parent ? this._getParent() : null, this._config.parent || this._addAriaAndCollapsedClass(this._element, this._triggerArray), this._config.toggle && this.toggle();
      }
      return l2.prototype.toggle = function() {
        t2(this._element).hasClass(g.SHOW) ? this.hide() : this.show();
      }, l2.prototype.show = function() {
        var e3 = this;
        if (this._isTransitioning)
          throw new Error("Collapse is transitioning");
        if (!t2(this._element).hasClass(g.SHOW)) {
          var n2 = void 0, i2 = void 0;
          if (this._parent && (n2 = t2.makeArray(t2(this._parent).find(m.ACTIVES)), n2.length || (n2 = null)), !(n2 && (i2 = t2(n2).data(a), i2 && i2._isTransitioning))) {
            var o2 = t2.Event(_.SHOW);
            if (t2(this._element).trigger(o2), !o2.isDefaultPrevented()) {
              n2 && (l2._jQueryInterface.call(t2(n2), "hide"), i2 || t2(n2).data(a, null));
              var s3 = this._getDimension();
              t2(this._element).removeClass(g.COLLAPSE).addClass(g.COLLAPSING), this._element.style[s3] = 0, this._element.setAttribute("aria-expanded", true), this._triggerArray.length && t2(this._triggerArray).removeClass(g.COLLAPSED).attr("aria-expanded", true), this.setTransitioning(true);
              var h2 = function() {
                t2(e3._element).removeClass(g.COLLAPSING).addClass(g.COLLAPSE).addClass(g.SHOW), e3._element.style[s3] = "", e3.setTransitioning(false), t2(e3._element).trigger(_.SHOWN);
              };
              if (!r.supportsTransitionEnd())
                return void h2();
              var c2 = s3[0].toUpperCase() + s3.slice(1), d2 = "scroll" + c2;
              t2(this._element).one(r.TRANSITION_END, h2).emulateTransitionEnd(u), this._element.style[s3] = this._element[d2] + "px";
            }
          }
        }
      }, l2.prototype.hide = function() {
        var e3 = this;
        if (this._isTransitioning)
          throw new Error("Collapse is transitioning");
        if (t2(this._element).hasClass(g.SHOW)) {
          var n2 = t2.Event(_.HIDE);
          if (t2(this._element).trigger(n2), !n2.isDefaultPrevented()) {
            var i2 = this._getDimension(), o2 = i2 === p.WIDTH ? "offsetWidth" : "offsetHeight";
            this._element.style[i2] = this._element[o2] + "px", r.reflow(this._element), t2(this._element).addClass(g.COLLAPSING).removeClass(g.COLLAPSE).removeClass(g.SHOW), this._element.setAttribute("aria-expanded", false), this._triggerArray.length && t2(this._triggerArray).addClass(g.COLLAPSED).attr("aria-expanded", false), this.setTransitioning(true);
            var s3 = function() {
              e3.setTransitioning(false), t2(e3._element).removeClass(g.COLLAPSING).addClass(g.COLLAPSE).trigger(_.HIDDEN);
            };
            return this._element.style[i2] = "", r.supportsTransitionEnd() ? void t2(this._element).one(r.TRANSITION_END, s3).emulateTransitionEnd(u) : void s3();
          }
        }
      }, l2.prototype.setTransitioning = function(t3) {
        this._isTransitioning = t3;
      }, l2.prototype.dispose = function() {
        t2.removeData(this._element, a), this._config = null, this._parent = null, this._element = null, this._triggerArray = null, this._isTransitioning = null;
      }, l2.prototype._getConfig = function(n2) {
        return n2 = t2.extend({}, d, n2), n2.toggle = Boolean(n2.toggle), r.typeCheckConfig(e2, n2, f), n2;
      }, l2.prototype._getDimension = function() {
        var e3 = t2(this._element).hasClass(p.WIDTH);
        return e3 ? p.WIDTH : p.HEIGHT;
      }, l2.prototype._getParent = function() {
        var e3 = this, n2 = t2(this._config.parent)[0], i2 = '[data-toggle="collapse"][data-parent="' + this._config.parent + '"]';
        return t2(n2).find(i2).each(function(t3, n3) {
          e3._addAriaAndCollapsedClass(l2._getTargetFromElement(n3), [n3]);
        }), n2;
      }, l2.prototype._addAriaAndCollapsedClass = function(e3, n2) {
        if (e3) {
          var i2 = t2(e3).hasClass(g.SHOW);
          e3.setAttribute("aria-expanded", i2), n2.length && t2(n2).toggleClass(g.COLLAPSED, !i2).attr("aria-expanded", i2);
        }
      }, l2._getTargetFromElement = function(e3) {
        var n2 = r.getSelectorFromElement(e3);
        return n2 ? t2(n2)[0] : null;
      }, l2._jQueryInterface = function(e3) {
        return this.each(function() {
          var n2 = t2(this), o2 = n2.data(a), r2 = t2.extend({}, d, n2.data(), (typeof e3 == "undefined" ? "undefined" : i(e3)) === "object" && e3);
          if (!o2 && r2.toggle && /show|hide/.test(e3) && (r2.toggle = false), o2 || (o2 = new l2(this, r2), n2.data(a, o2)), typeof e3 == "string") {
            if (o2[e3] === void 0)
              throw new Error('No method named "' + e3 + '"');
            o2[e3]();
          }
        });
      }, o(l2, null, [{ key: "VERSION", get: function() {
        return s2;
      } }, { key: "Default", get: function() {
        return d;
      } }]), l2;
    }();
    return t2(document).on(_.CLICK_DATA_API, m.DATA_TOGGLE, function(e3) {
      e3.preventDefault();
      var n2 = E._getTargetFromElement(this), i2 = t2(n2).data(a), o2 = i2 ? "toggle" : t2(this).data();
      E._jQueryInterface.call(t2(n2), o2);
    }), t2.fn[e2] = E._jQueryInterface, t2.fn[e2].Constructor = E, t2.fn[e2].noConflict = function() {
      return t2.fn[e2] = c, E._jQueryInterface;
    }, E;
  }(jQuery), function(t2) {
    var e2 = "dropdown", i2 = "4.0.0-alpha.6", s2 = "bs.dropdown", a = "." + s2, l = ".data-api", h = t2.fn[e2], c = 27, u = 38, d = 40, f = 3, _ = { HIDE: "hide" + a, HIDDEN: "hidden" + a, SHOW: "show" + a, SHOWN: "shown" + a, CLICK: "click" + a, CLICK_DATA_API: "click" + a + l, FOCUSIN_DATA_API: "focusin" + a + l, KEYDOWN_DATA_API: "keydown" + a + l }, g = { BACKDROP: "dropdown-backdrop", DISABLED: "disabled", SHOW: "show" }, p = { BACKDROP: ".dropdown-backdrop", DATA_TOGGLE: '[data-toggle="dropdown"]', FORM_CHILD: ".dropdown form", ROLE_MENU: '[role="menu"]', ROLE_LISTBOX: '[role="listbox"]', NAVBAR_NAV: ".navbar-nav", VISIBLE_ITEMS: '[role="menu"] li:not(.disabled) a, [role="listbox"] li:not(.disabled) a' }, m = function() {
      function e3(t3) {
        n(this, e3), this._element = t3, this._addEventListeners();
      }
      return e3.prototype.toggle = function() {
        if (this.disabled || t2(this).hasClass(g.DISABLED))
          return false;
        var n2 = e3._getParentFromElement(this), i3 = t2(n2).hasClass(g.SHOW);
        if (e3._clearMenus(), i3)
          return false;
        if ("ontouchstart" in document.documentElement && !t2(n2).closest(p.NAVBAR_NAV).length) {
          var o2 = document.createElement("div");
          o2.className = g.BACKDROP, t2(o2).insertBefore(this), t2(o2).on("click", e3._clearMenus);
        }
        var r2 = { relatedTarget: this }, s3 = t2.Event(_.SHOW, r2);
        return t2(n2).trigger(s3), !s3.isDefaultPrevented() && (this.focus(), this.setAttribute("aria-expanded", true), t2(n2).toggleClass(g.SHOW), t2(n2).trigger(t2.Event(_.SHOWN, r2)), false);
      }, e3.prototype.dispose = function() {
        t2.removeData(this._element, s2), t2(this._element).off(a), this._element = null;
      }, e3.prototype._addEventListeners = function() {
        t2(this._element).on(_.CLICK, this.toggle);
      }, e3._jQueryInterface = function(n2) {
        return this.each(function() {
          var i3 = t2(this).data(s2);
          if (i3 || (i3 = new e3(this), t2(this).data(s2, i3)), typeof n2 == "string") {
            if (i3[n2] === void 0)
              throw new Error('No method named "' + n2 + '"');
            i3[n2].call(this);
          }
        });
      }, e3._clearMenus = function(n2) {
        if (!n2 || n2.which !== f) {
          var i3 = t2(p.BACKDROP)[0];
          i3 && i3.parentNode.removeChild(i3);
          for (var o2 = t2.makeArray(t2(p.DATA_TOGGLE)), r2 = 0; r2 < o2.length; r2++) {
            var s3 = e3._getParentFromElement(o2[r2]), a2 = { relatedTarget: o2[r2] };
            if (t2(s3).hasClass(g.SHOW) && !(n2 && (n2.type === "click" && /input|textarea/i.test(n2.target.tagName) || n2.type === "focusin") && t2.contains(s3, n2.target))) {
              var l2 = t2.Event(_.HIDE, a2);
              t2(s3).trigger(l2), l2.isDefaultPrevented() || (o2[r2].setAttribute("aria-expanded", "false"), t2(s3).removeClass(g.SHOW).trigger(t2.Event(_.HIDDEN, a2)));
            }
          }
        }
      }, e3._getParentFromElement = function(e4) {
        var n2 = void 0, i3 = r.getSelectorFromElement(e4);
        return i3 && (n2 = t2(i3)[0]), n2 || e4.parentNode;
      }, e3._dataApiKeydownHandler = function(n2) {
        if (/(38|40|27|32)/.test(n2.which) && !/input|textarea/i.test(n2.target.tagName) && (n2.preventDefault(), n2.stopPropagation(), !this.disabled && !t2(this).hasClass(g.DISABLED))) {
          var i3 = e3._getParentFromElement(this), o2 = t2(i3).hasClass(g.SHOW);
          if (!o2 && n2.which !== c || o2 && n2.which === c) {
            if (n2.which === c) {
              var r2 = t2(i3).find(p.DATA_TOGGLE)[0];
              t2(r2).trigger("focus");
            }
            return void t2(this).trigger("click");
          }
          var s3 = t2(i3).find(p.VISIBLE_ITEMS).get();
          if (s3.length) {
            var a2 = s3.indexOf(n2.target);
            n2.which === u && a2 > 0 && a2--, n2.which === d && a2 < s3.length - 1 && a2++, a2 < 0 && (a2 = 0), s3[a2].focus();
          }
        }
      }, o(e3, null, [{ key: "VERSION", get: function() {
        return i2;
      } }]), e3;
    }();
    return t2(document).on(_.KEYDOWN_DATA_API, p.DATA_TOGGLE, m._dataApiKeydownHandler).on(_.KEYDOWN_DATA_API, p.ROLE_MENU, m._dataApiKeydownHandler).on(_.KEYDOWN_DATA_API, p.ROLE_LISTBOX, m._dataApiKeydownHandler).on(_.CLICK_DATA_API + " " + _.FOCUSIN_DATA_API, m._clearMenus).on(_.CLICK_DATA_API, p.DATA_TOGGLE, m.prototype.toggle).on(_.CLICK_DATA_API, p.FORM_CHILD, function(t3) {
      t3.stopPropagation();
    }), t2.fn[e2] = m._jQueryInterface, t2.fn[e2].Constructor = m, t2.fn[e2].noConflict = function() {
      return t2.fn[e2] = h, m._jQueryInterface;
    }, m;
  }(jQuery), function(t2) {
    var e2 = "modal", s2 = "4.0.0-alpha.6", a = "bs.modal", l = "." + a, h = ".data-api", c = t2.fn[e2], u = 300, d = 150, f = 27, _ = { backdrop: true, keyboard: true, focus: true, show: true }, g = { backdrop: "(boolean|string)", keyboard: "boolean", focus: "boolean", show: "boolean" }, p = { HIDE: "hide" + l, HIDDEN: "hidden" + l, SHOW: "show" + l, SHOWN: "shown" + l, FOCUSIN: "focusin" + l, RESIZE: "resize" + l, CLICK_DISMISS: "click.dismiss" + l, KEYDOWN_DISMISS: "keydown.dismiss" + l, MOUSEUP_DISMISS: "mouseup.dismiss" + l, MOUSEDOWN_DISMISS: "mousedown.dismiss" + l, CLICK_DATA_API: "click" + l + h }, m = { SCROLLBAR_MEASURER: "modal-scrollbar-measure", BACKDROP: "modal-backdrop", OPEN: "modal-open", FADE: "fade", SHOW: "show" }, E = { DIALOG: ".modal-dialog", DATA_TOGGLE: '[data-toggle="modal"]', DATA_DISMISS: '[data-dismiss="modal"]', FIXED_CONTENT: ".fixed-top, .fixed-bottom, .is-fixed, .sticky-top" }, v = function() {
      function h2(e3, i2) {
        n(this, h2), this._config = this._getConfig(i2), this._element = e3, this._dialog = t2(e3).find(E.DIALOG)[0], this._backdrop = null, this._isShown = false, this._isBodyOverflowing = false, this._ignoreBackdropClick = false, this._isTransitioning = false, this._originalBodyPadding = 0, this._scrollbarWidth = 0;
      }
      return h2.prototype.toggle = function(t3) {
        return this._isShown ? this.hide() : this.show(t3);
      }, h2.prototype.show = function(e3) {
        var n2 = this;
        if (this._isTransitioning)
          throw new Error("Modal is transitioning");
        r.supportsTransitionEnd() && t2(this._element).hasClass(m.FADE) && (this._isTransitioning = true);
        var i2 = t2.Event(p.SHOW, { relatedTarget: e3 });
        t2(this._element).trigger(i2), this._isShown || i2.isDefaultPrevented() || (this._isShown = true, this._checkScrollbar(), this._setScrollbar(), t2(document.body).addClass(m.OPEN), this._setEscapeEvent(), this._setResizeEvent(), t2(this._element).on(p.CLICK_DISMISS, E.DATA_DISMISS, function(t3) {
          return n2.hide(t3);
        }), t2(this._dialog).on(p.MOUSEDOWN_DISMISS, function() {
          t2(n2._element).one(p.MOUSEUP_DISMISS, function(e4) {
            t2(e4.target).is(n2._element) && (n2._ignoreBackdropClick = true);
          });
        }), this._showBackdrop(function() {
          return n2._showElement(e3);
        }));
      }, h2.prototype.hide = function(e3) {
        var n2 = this;
        if (e3 && e3.preventDefault(), this._isTransitioning)
          throw new Error("Modal is transitioning");
        var i2 = r.supportsTransitionEnd() && t2(this._element).hasClass(m.FADE);
        i2 && (this._isTransitioning = true);
        var o2 = t2.Event(p.HIDE);
        t2(this._element).trigger(o2), this._isShown && !o2.isDefaultPrevented() && (this._isShown = false, this._setEscapeEvent(), this._setResizeEvent(), t2(document).off(p.FOCUSIN), t2(this._element).removeClass(m.SHOW), t2(this._element).off(p.CLICK_DISMISS), t2(this._dialog).off(p.MOUSEDOWN_DISMISS), i2 ? t2(this._element).one(r.TRANSITION_END, function(t3) {
          return n2._hideModal(t3);
        }).emulateTransitionEnd(u) : this._hideModal());
      }, h2.prototype.dispose = function() {
        t2.removeData(this._element, a), t2(window, document, this._element, this._backdrop).off(l), this._config = null, this._element = null, this._dialog = null, this._backdrop = null, this._isShown = null, this._isBodyOverflowing = null, this._ignoreBackdropClick = null, this._originalBodyPadding = null, this._scrollbarWidth = null;
      }, h2.prototype._getConfig = function(n2) {
        return n2 = t2.extend({}, _, n2), r.typeCheckConfig(e2, n2, g), n2;
      }, h2.prototype._showElement = function(e3) {
        var n2 = this, i2 = r.supportsTransitionEnd() && t2(this._element).hasClass(m.FADE);
        this._element.parentNode && this._element.parentNode.nodeType === Node.ELEMENT_NODE || document.body.appendChild(this._element), this._element.style.display = "block", this._element.removeAttribute("aria-hidden"), this._element.scrollTop = 0, i2 && r.reflow(this._element), t2(this._element).addClass(m.SHOW), this._config.focus && this._enforceFocus();
        var o2 = t2.Event(p.SHOWN, { relatedTarget: e3 }), s3 = function() {
          n2._config.focus && n2._element.focus(), n2._isTransitioning = false, t2(n2._element).trigger(o2);
        };
        i2 ? t2(this._dialog).one(r.TRANSITION_END, s3).emulateTransitionEnd(u) : s3();
      }, h2.prototype._enforceFocus = function() {
        var e3 = this;
        t2(document).off(p.FOCUSIN).on(p.FOCUSIN, function(n2) {
          document === n2.target || e3._element === n2.target || t2(e3._element).has(n2.target).length || e3._element.focus();
        });
      }, h2.prototype._setEscapeEvent = function() {
        var e3 = this;
        this._isShown && this._config.keyboard ? t2(this._element).on(p.KEYDOWN_DISMISS, function(t3) {
          t3.which === f && e3.hide();
        }) : this._isShown || t2(this._element).off(p.KEYDOWN_DISMISS);
      }, h2.prototype._setResizeEvent = function() {
        var e3 = this;
        this._isShown ? t2(window).on(p.RESIZE, function(t3) {
          return e3._handleUpdate(t3);
        }) : t2(window).off(p.RESIZE);
      }, h2.prototype._hideModal = function() {
        var e3 = this;
        this._element.style.display = "none", this._element.setAttribute("aria-hidden", "true"), this._isTransitioning = false, this._showBackdrop(function() {
          t2(document.body).removeClass(m.OPEN), e3._resetAdjustments(), e3._resetScrollbar(), t2(e3._element).trigger(p.HIDDEN);
        });
      }, h2.prototype._removeBackdrop = function() {
        this._backdrop && (t2(this._backdrop).remove(), this._backdrop = null);
      }, h2.prototype._showBackdrop = function(e3) {
        var n2 = this, i2 = t2(this._element).hasClass(m.FADE) ? m.FADE : "";
        if (this._isShown && this._config.backdrop) {
          var o2 = r.supportsTransitionEnd() && i2;
          if (this._backdrop = document.createElement("div"), this._backdrop.className = m.BACKDROP, i2 && t2(this._backdrop).addClass(i2), t2(this._backdrop).appendTo(document.body), t2(this._element).on(p.CLICK_DISMISS, function(t3) {
            return n2._ignoreBackdropClick ? void (n2._ignoreBackdropClick = false) : void (t3.target === t3.currentTarget && (n2._config.backdrop === "static" ? n2._element.focus() : n2.hide()));
          }), o2 && r.reflow(this._backdrop), t2(this._backdrop).addClass(m.SHOW), !e3)
            return;
          if (!o2)
            return void e3();
          t2(this._backdrop).one(r.TRANSITION_END, e3).emulateTransitionEnd(d);
        } else if (!this._isShown && this._backdrop) {
          t2(this._backdrop).removeClass(m.SHOW);
          var s3 = function() {
            n2._removeBackdrop(), e3 && e3();
          };
          r.supportsTransitionEnd() && t2(this._element).hasClass(m.FADE) ? t2(this._backdrop).one(r.TRANSITION_END, s3).emulateTransitionEnd(d) : s3();
        } else
          e3 && e3();
      }, h2.prototype._handleUpdate = function() {
        this._adjustDialog();
      }, h2.prototype._adjustDialog = function() {
        var t3 = this._element.scrollHeight > document.documentElement.clientHeight;
        !this._isBodyOverflowing && t3 && (this._element.style.paddingLeft = this._scrollbarWidth + "px"), this._isBodyOverflowing && !t3 && (this._element.style.paddingRight = this._scrollbarWidth + "px");
      }, h2.prototype._resetAdjustments = function() {
        this._element.style.paddingLeft = "", this._element.style.paddingRight = "";
      }, h2.prototype._checkScrollbar = function() {
        this._isBodyOverflowing = document.body.clientWidth < window.innerWidth, this._scrollbarWidth = this._getScrollbarWidth();
      }, h2.prototype._setScrollbar = function() {
        var e3 = parseInt(t2(E.FIXED_CONTENT).css("padding-right") || 0, 10);
        this._originalBodyPadding = document.body.style.paddingRight || "", this._isBodyOverflowing && (document.body.style.paddingRight = e3 + this._scrollbarWidth + "px");
      }, h2.prototype._resetScrollbar = function() {
        document.body.style.paddingRight = this._originalBodyPadding;
      }, h2.prototype._getScrollbarWidth = function() {
        var t3 = document.createElement("div");
        t3.className = m.SCROLLBAR_MEASURER, document.body.appendChild(t3);
        var e3 = t3.offsetWidth - t3.clientWidth;
        return document.body.removeChild(t3), e3;
      }, h2._jQueryInterface = function(e3, n2) {
        return this.each(function() {
          var o2 = t2(this).data(a), r2 = t2.extend({}, h2.Default, t2(this).data(), (typeof e3 == "undefined" ? "undefined" : i(e3)) === "object" && e3);
          if (o2 || (o2 = new h2(this, r2), t2(this).data(a, o2)), typeof e3 == "string") {
            if (o2[e3] === void 0)
              throw new Error('No method named "' + e3 + '"');
            o2[e3](n2);
          } else
            r2.show && o2.show(n2);
        });
      }, o(h2, null, [{ key: "VERSION", get: function() {
        return s2;
      } }, { key: "Default", get: function() {
        return _;
      } }]), h2;
    }();
    return t2(document).on(p.CLICK_DATA_API, E.DATA_TOGGLE, function(e3) {
      var n2 = this, i2 = void 0, o2 = r.getSelectorFromElement(this);
      o2 && (i2 = t2(o2)[0]);
      var s3 = t2(i2).data(a) ? "toggle" : t2.extend({}, t2(i2).data(), t2(this).data());
      this.tagName !== "A" && this.tagName !== "AREA" || e3.preventDefault();
      var l2 = t2(i2).one(p.SHOW, function(e4) {
        e4.isDefaultPrevented() || l2.one(p.HIDDEN, function() {
          t2(n2).is(":visible") && n2.focus();
        });
      });
      v._jQueryInterface.call(t2(i2), s3, this);
    }), t2.fn[e2] = v._jQueryInterface, t2.fn[e2].Constructor = v, t2.fn[e2].noConflict = function() {
      return t2.fn[e2] = c, v._jQueryInterface;
    }, v;
  }(jQuery), function(t2) {
    var e2 = "scrollspy", s2 = "4.0.0-alpha.6", a = "bs.scrollspy", l = "." + a, h = ".data-api", c = t2.fn[e2], u = { offset: 10, method: "auto", target: "" }, d = { offset: "number", method: "string", target: "(string|element)" }, f = { ACTIVATE: "activate" + l, SCROLL: "scroll" + l, LOAD_DATA_API: "load" + l + h }, _ = { DROPDOWN_ITEM: "dropdown-item", DROPDOWN_MENU: "dropdown-menu", NAV_LINK: "nav-link", NAV: "nav", ACTIVE: "active" }, g = { DATA_SPY: '[data-spy="scroll"]', ACTIVE: ".active", LIST_ITEM: ".list-item", LI: "li", LI_DROPDOWN: "li.dropdown", NAV_LINKS: ".nav-link", DROPDOWN: ".dropdown", DROPDOWN_ITEMS: ".dropdown-item", DROPDOWN_TOGGLE: ".dropdown-toggle" }, p = { OFFSET: "offset", POSITION: "position" }, m = function() {
      function h2(e3, i2) {
        var o2 = this;
        n(this, h2), this._element = e3, this._scrollElement = e3.tagName === "BODY" ? window : e3, this._config = this._getConfig(i2), this._selector = this._config.target + " " + g.NAV_LINKS + "," + (this._config.target + " " + g.DROPDOWN_ITEMS), this._offsets = [], this._targets = [], this._activeTarget = null, this._scrollHeight = 0, t2(this._scrollElement).on(f.SCROLL, function(t3) {
          return o2._process(t3);
        }), this.refresh(), this._process();
      }
      return h2.prototype.refresh = function() {
        var e3 = this, n2 = this._scrollElement !== this._scrollElement.window ? p.POSITION : p.OFFSET, i2 = this._config.method === "auto" ? n2 : this._config.method, o2 = i2 === p.POSITION ? this._getScrollTop() : 0;
        this._offsets = [], this._targets = [], this._scrollHeight = this._getScrollHeight();
        var s3 = t2.makeArray(t2(this._selector));
        s3.map(function(e4) {
          var n3 = void 0, s4 = r.getSelectorFromElement(e4);
          return s4 && (n3 = t2(s4)[0]), n3 && (n3.offsetWidth || n3.offsetHeight) ? [t2(n3)[i2]().top + o2, s4] : null;
        }).filter(function(t3) {
          return t3;
        }).sort(function(t3, e4) {
          return t3[0] - e4[0];
        }).forEach(function(t3) {
          e3._offsets.push(t3[0]), e3._targets.push(t3[1]);
        });
      }, h2.prototype.dispose = function() {
        t2.removeData(this._element, a), t2(this._scrollElement).off(l), this._element = null, this._scrollElement = null, this._config = null, this._selector = null, this._offsets = null, this._targets = null, this._activeTarget = null, this._scrollHeight = null;
      }, h2.prototype._getConfig = function(n2) {
        if (n2 = t2.extend({}, u, n2), typeof n2.target != "string") {
          var i2 = t2(n2.target).attr("id");
          i2 || (i2 = r.getUID(e2), t2(n2.target).attr("id", i2)), n2.target = "#" + i2;
        }
        return r.typeCheckConfig(e2, n2, d), n2;
      }, h2.prototype._getScrollTop = function() {
        return this._scrollElement === window ? this._scrollElement.pageYOffset : this._scrollElement.scrollTop;
      }, h2.prototype._getScrollHeight = function() {
        return this._scrollElement.scrollHeight || Math.max(document.body.scrollHeight, document.documentElement.scrollHeight);
      }, h2.prototype._getOffsetHeight = function() {
        return this._scrollElement === window ? window.innerHeight : this._scrollElement.offsetHeight;
      }, h2.prototype._process = function() {
        var t3 = this._getScrollTop() + this._config.offset, e3 = this._getScrollHeight(), n2 = this._config.offset + e3 - this._getOffsetHeight();
        if (this._scrollHeight !== e3 && this.refresh(), t3 >= n2) {
          var i2 = this._targets[this._targets.length - 1];
          return void (this._activeTarget !== i2 && this._activate(i2));
        }
        if (this._activeTarget && t3 < this._offsets[0] && this._offsets[0] > 0)
          return this._activeTarget = null, void this._clear();
        for (var o2 = this._offsets.length; o2--; ) {
          var r2 = this._activeTarget !== this._targets[o2] && t3 >= this._offsets[o2] && (this._offsets[o2 + 1] === void 0 || t3 < this._offsets[o2 + 1]);
          r2 && this._activate(this._targets[o2]);
        }
      }, h2.prototype._activate = function(e3) {
        this._activeTarget = e3, this._clear();
        var n2 = this._selector.split(",");
        n2 = n2.map(function(t3) {
          return t3 + '[data-target="' + e3 + '"],' + (t3 + '[href="' + e3 + '"]');
        });
        var i2 = t2(n2.join(","));
        i2.hasClass(_.DROPDOWN_ITEM) ? (i2.closest(g.DROPDOWN).find(g.DROPDOWN_TOGGLE).addClass(_.ACTIVE), i2.addClass(_.ACTIVE)) : i2.parents(g.LI).find("> " + g.NAV_LINKS).addClass(_.ACTIVE), t2(this._scrollElement).trigger(f.ACTIVATE, { relatedTarget: e3 });
      }, h2.prototype._clear = function() {
        t2(this._selector).filter(g.ACTIVE).removeClass(_.ACTIVE);
      }, h2._jQueryInterface = function(e3) {
        return this.each(function() {
          var n2 = t2(this).data(a), o2 = (typeof e3 == "undefined" ? "undefined" : i(e3)) === "object" && e3;
          if (n2 || (n2 = new h2(this, o2), t2(this).data(a, n2)), typeof e3 == "string") {
            if (n2[e3] === void 0)
              throw new Error('No method named "' + e3 + '"');
            n2[e3]();
          }
        });
      }, o(h2, null, [{ key: "VERSION", get: function() {
        return s2;
      } }, { key: "Default", get: function() {
        return u;
      } }]), h2;
    }();
    return t2(window).on(f.LOAD_DATA_API, function() {
      for (var e3 = t2.makeArray(t2(g.DATA_SPY)), n2 = e3.length; n2--; ) {
        var i2 = t2(e3[n2]);
        m._jQueryInterface.call(i2, i2.data());
      }
    }), t2.fn[e2] = m._jQueryInterface, t2.fn[e2].Constructor = m, t2.fn[e2].noConflict = function() {
      return t2.fn[e2] = c, m._jQueryInterface;
    }, m;
  }(jQuery), function(t2) {
    var e2 = "tab", i2 = "4.0.0-alpha.6", s2 = "bs.tab", a = "." + s2, l = ".data-api", h = t2.fn[e2], c = 150, u = { HIDE: "hide" + a, HIDDEN: "hidden" + a, SHOW: "show" + a, SHOWN: "shown" + a, CLICK_DATA_API: "click" + a + l }, d = { DROPDOWN_MENU: "dropdown-menu", ACTIVE: "active", DISABLED: "disabled", FADE: "fade", SHOW: "show" }, f = { A: "a", LI: "li", DROPDOWN: ".dropdown", LIST: "ul:not(.dropdown-menu), ol:not(.dropdown-menu), nav:not(.dropdown-menu)", FADE_CHILD: "> .nav-item .fade, > .fade", ACTIVE: ".active", ACTIVE_CHILD: "> .nav-item > .active, > .active", DATA_TOGGLE: '[data-toggle="tab"], [data-toggle="pill"]', DROPDOWN_TOGGLE: ".dropdown-toggle", DROPDOWN_ACTIVE_CHILD: "> .dropdown-menu .active" }, _ = function() {
      function e3(t3) {
        n(this, e3), this._element = t3;
      }
      return e3.prototype.show = function() {
        var e4 = this;
        if (!(this._element.parentNode && this._element.parentNode.nodeType === Node.ELEMENT_NODE && t2(this._element).hasClass(d.ACTIVE) || t2(this._element).hasClass(d.DISABLED))) {
          var n2 = void 0, i3 = void 0, o2 = t2(this._element).closest(f.LIST)[0], s3 = r.getSelectorFromElement(this._element);
          o2 && (i3 = t2.makeArray(t2(o2).find(f.ACTIVE)), i3 = i3[i3.length - 1]);
          var a2 = t2.Event(u.HIDE, { relatedTarget: this._element }), l2 = t2.Event(u.SHOW, { relatedTarget: i3 });
          if (i3 && t2(i3).trigger(a2), t2(this._element).trigger(l2), !l2.isDefaultPrevented() && !a2.isDefaultPrevented()) {
            s3 && (n2 = t2(s3)[0]), this._activate(this._element, o2);
            var h2 = function() {
              var n3 = t2.Event(u.HIDDEN, { relatedTarget: e4._element }), o3 = t2.Event(u.SHOWN, { relatedTarget: i3 });
              t2(i3).trigger(n3), t2(e4._element).trigger(o3);
            };
            n2 ? this._activate(n2, n2.parentNode, h2) : h2();
          }
        }
      }, e3.prototype.dispose = function() {
        t2.removeClass(this._element, s2), this._element = null;
      }, e3.prototype._activate = function(e4, n2, i3) {
        var o2 = this, s3 = t2(n2).find(f.ACTIVE_CHILD)[0], a2 = i3 && r.supportsTransitionEnd() && (s3 && t2(s3).hasClass(d.FADE) || Boolean(t2(n2).find(f.FADE_CHILD)[0])), l2 = function() {
          return o2._transitionComplete(e4, s3, a2, i3);
        };
        s3 && a2 ? t2(s3).one(r.TRANSITION_END, l2).emulateTransitionEnd(c) : l2(), s3 && t2(s3).removeClass(d.SHOW);
      }, e3.prototype._transitionComplete = function(e4, n2, i3, o2) {
        if (n2) {
          t2(n2).removeClass(d.ACTIVE);
          var s3 = t2(n2.parentNode).find(f.DROPDOWN_ACTIVE_CHILD)[0];
          s3 && t2(s3).removeClass(d.ACTIVE), n2.setAttribute("aria-expanded", false);
        }
        if (t2(e4).addClass(d.ACTIVE), e4.setAttribute("aria-expanded", true), i3 ? (r.reflow(e4), t2(e4).addClass(d.SHOW)) : t2(e4).removeClass(d.FADE), e4.parentNode && t2(e4.parentNode).hasClass(d.DROPDOWN_MENU)) {
          var a2 = t2(e4).closest(f.DROPDOWN)[0];
          a2 && t2(a2).find(f.DROPDOWN_TOGGLE).addClass(d.ACTIVE), e4.setAttribute("aria-expanded", true);
        }
        o2 && o2();
      }, e3._jQueryInterface = function(n2) {
        return this.each(function() {
          var i3 = t2(this), o2 = i3.data(s2);
          if (o2 || (o2 = new e3(this), i3.data(s2, o2)), typeof n2 == "string") {
            if (o2[n2] === void 0)
              throw new Error('No method named "' + n2 + '"');
            o2[n2]();
          }
        });
      }, o(e3, null, [{ key: "VERSION", get: function() {
        return i2;
      } }]), e3;
    }();
    return t2(document).on(u.CLICK_DATA_API, f.DATA_TOGGLE, function(e3) {
      e3.preventDefault(), _._jQueryInterface.call(t2(this), "show");
    }), t2.fn[e2] = _._jQueryInterface, t2.fn[e2].Constructor = _, t2.fn[e2].noConflict = function() {
      return t2.fn[e2] = h, _._jQueryInterface;
    }, _;
  }(jQuery), function(t2) {
    if (typeof Tether == "undefined")
      throw new Error("Bootstrap tooltips require Tether (http://tether.io/)");
    var e2 = "tooltip", s2 = "4.0.0-alpha.6", a = "bs.tooltip", l = "." + a, h = t2.fn[e2], c = 150, u = "bs-tether", d = { animation: true, template: '<div class="tooltip" role="tooltip"><div class="tooltip-inner"></div></div>', trigger: "hover focus", title: "", delay: 0, html: false, selector: false, placement: "top", offset: "0 0", constraints: [], container: false }, f = { animation: "boolean", template: "string", title: "(string|element|function)", trigger: "string", delay: "(number|object)", html: "boolean", selector: "(string|boolean)", placement: "(string|function)", offset: "string", constraints: "array", container: "(string|element|boolean)" }, _ = { TOP: "bottom center", RIGHT: "middle left", BOTTOM: "top center", LEFT: "middle right" }, g = { SHOW: "show", OUT: "out" }, p = { HIDE: "hide" + l, HIDDEN: "hidden" + l, SHOW: "show" + l, SHOWN: "shown" + l, INSERTED: "inserted" + l, CLICK: "click" + l, FOCUSIN: "focusin" + l, FOCUSOUT: "focusout" + l, MOUSEENTER: "mouseenter" + l, MOUSELEAVE: "mouseleave" + l }, m = { FADE: "fade", SHOW: "show" }, E = { TOOLTIP: ".tooltip", TOOLTIP_INNER: ".tooltip-inner" }, v = { element: false, enabled: false }, T = { HOVER: "hover", FOCUS: "focus", CLICK: "click", MANUAL: "manual" }, I = function() {
      function h2(t3, e3) {
        n(this, h2), this._isEnabled = true, this._timeout = 0, this._hoverState = "", this._activeTrigger = {}, this._isTransitioning = false, this._tether = null, this.element = t3, this.config = this._getConfig(e3), this.tip = null, this._setListeners();
      }
      return h2.prototype.enable = function() {
        this._isEnabled = true;
      }, h2.prototype.disable = function() {
        this._isEnabled = false;
      }, h2.prototype.toggleEnabled = function() {
        this._isEnabled = !this._isEnabled;
      }, h2.prototype.toggle = function(e3) {
        if (e3) {
          var n2 = this.constructor.DATA_KEY, i2 = t2(e3.currentTarget).data(n2);
          i2 || (i2 = new this.constructor(e3.currentTarget, this._getDelegateConfig()), t2(e3.currentTarget).data(n2, i2)), i2._activeTrigger.click = !i2._activeTrigger.click, i2._isWithActiveTrigger() ? i2._enter(null, i2) : i2._leave(null, i2);
        } else {
          if (t2(this.getTipElement()).hasClass(m.SHOW))
            return void this._leave(null, this);
          this._enter(null, this);
        }
      }, h2.prototype.dispose = function() {
        clearTimeout(this._timeout), this.cleanupTether(), t2.removeData(this.element, this.constructor.DATA_KEY), t2(this.element).off(this.constructor.EVENT_KEY), t2(this.element).closest(".modal").off("hide.bs.modal"), this.tip && t2(this.tip).remove(), this._isEnabled = null, this._timeout = null, this._hoverState = null, this._activeTrigger = null, this._tether = null, this.element = null, this.config = null, this.tip = null;
      }, h2.prototype.show = function() {
        var e3 = this;
        if (t2(this.element).css("display") === "none")
          throw new Error("Please use show on visible elements");
        var n2 = t2.Event(this.constructor.Event.SHOW);
        if (this.isWithContent() && this._isEnabled) {
          if (this._isTransitioning)
            throw new Error("Tooltip is transitioning");
          t2(this.element).trigger(n2);
          var i2 = t2.contains(this.element.ownerDocument.documentElement, this.element);
          if (n2.isDefaultPrevented() || !i2)
            return;
          var o2 = this.getTipElement(), s3 = r.getUID(this.constructor.NAME);
          o2.setAttribute("id", s3), this.element.setAttribute("aria-describedby", s3), this.setContent(), this.config.animation && t2(o2).addClass(m.FADE);
          var a2 = typeof this.config.placement == "function" ? this.config.placement.call(this, o2, this.element) : this.config.placement, l2 = this._getAttachment(a2), c2 = this.config.container === false ? document.body : t2(this.config.container);
          t2(o2).data(this.constructor.DATA_KEY, this).appendTo(c2), t2(this.element).trigger(this.constructor.Event.INSERTED), this._tether = new Tether({ attachment: l2, element: o2, target: this.element, classes: v, classPrefix: u, offset: this.config.offset, constraints: this.config.constraints, addTargetClasses: false }), r.reflow(o2), this._tether.position(), t2(o2).addClass(m.SHOW);
          var d2 = function() {
            var n3 = e3._hoverState;
            e3._hoverState = null, e3._isTransitioning = false, t2(e3.element).trigger(e3.constructor.Event.SHOWN), n3 === g.OUT && e3._leave(null, e3);
          };
          if (r.supportsTransitionEnd() && t2(this.tip).hasClass(m.FADE))
            return this._isTransitioning = true, void t2(this.tip).one(r.TRANSITION_END, d2).emulateTransitionEnd(h2._TRANSITION_DURATION);
          d2();
        }
      }, h2.prototype.hide = function(e3) {
        var n2 = this, i2 = this.getTipElement(), o2 = t2.Event(this.constructor.Event.HIDE);
        if (this._isTransitioning)
          throw new Error("Tooltip is transitioning");
        var s3 = function() {
          n2._hoverState !== g.SHOW && i2.parentNode && i2.parentNode.removeChild(i2), n2.element.removeAttribute("aria-describedby"), t2(n2.element).trigger(n2.constructor.Event.HIDDEN), n2._isTransitioning = false, n2.cleanupTether(), e3 && e3();
        };
        t2(this.element).trigger(o2), o2.isDefaultPrevented() || (t2(i2).removeClass(m.SHOW), this._activeTrigger[T.CLICK] = false, this._activeTrigger[T.FOCUS] = false, this._activeTrigger[T.HOVER] = false, r.supportsTransitionEnd() && t2(this.tip).hasClass(m.FADE) ? (this._isTransitioning = true, t2(i2).one(r.TRANSITION_END, s3).emulateTransitionEnd(c)) : s3(), this._hoverState = "");
      }, h2.prototype.isWithContent = function() {
        return Boolean(this.getTitle());
      }, h2.prototype.getTipElement = function() {
        return this.tip = this.tip || t2(this.config.template)[0];
      }, h2.prototype.setContent = function() {
        var e3 = t2(this.getTipElement());
        this.setElementContent(e3.find(E.TOOLTIP_INNER), this.getTitle()), e3.removeClass(m.FADE + " " + m.SHOW), this.cleanupTether();
      }, h2.prototype.setElementContent = function(e3, n2) {
        var o2 = this.config.html;
        (typeof n2 == "undefined" ? "undefined" : i(n2)) === "object" && (n2.nodeType || n2.jquery) ? o2 ? t2(n2).parent().is(e3) || e3.empty().append(n2) : e3.text(t2(n2).text()) : e3[o2 ? "html" : "text"](n2);
      }, h2.prototype.getTitle = function() {
        var t3 = this.element.getAttribute("data-original-title");
        return t3 || (t3 = typeof this.config.title == "function" ? this.config.title.call(this.element) : this.config.title), t3;
      }, h2.prototype.cleanupTether = function() {
        this._tether && this._tether.destroy();
      }, h2.prototype._getAttachment = function(t3) {
        return _[t3.toUpperCase()];
      }, h2.prototype._setListeners = function() {
        var e3 = this, n2 = this.config.trigger.split(" ");
        n2.forEach(function(n3) {
          if (n3 === "click")
            t2(e3.element).on(e3.constructor.Event.CLICK, e3.config.selector, function(t3) {
              return e3.toggle(t3);
            });
          else if (n3 !== T.MANUAL) {
            var i2 = n3 === T.HOVER ? e3.constructor.Event.MOUSEENTER : e3.constructor.Event.FOCUSIN, o2 = n3 === T.HOVER ? e3.constructor.Event.MOUSELEAVE : e3.constructor.Event.FOCUSOUT;
            t2(e3.element).on(i2, e3.config.selector, function(t3) {
              return e3._enter(t3);
            }).on(o2, e3.config.selector, function(t3) {
              return e3._leave(t3);
            });
          }
          t2(e3.element).closest(".modal").on("hide.bs.modal", function() {
            return e3.hide();
          });
        }), this.config.selector ? this.config = t2.extend({}, this.config, { trigger: "manual", selector: "" }) : this._fixTitle();
      }, h2.prototype._fixTitle = function() {
        var t3 = i(this.element.getAttribute("data-original-title"));
        (this.element.getAttribute("title") || t3 !== "string") && (this.element.setAttribute("data-original-title", this.element.getAttribute("title") || ""), this.element.setAttribute("title", ""));
      }, h2.prototype._enter = function(e3, n2) {
        var i2 = this.constructor.DATA_KEY;
        return n2 = n2 || t2(e3.currentTarget).data(i2), n2 || (n2 = new this.constructor(e3.currentTarget, this._getDelegateConfig()), t2(e3.currentTarget).data(i2, n2)), e3 && (n2._activeTrigger[e3.type === "focusin" ? T.FOCUS : T.HOVER] = true), t2(n2.getTipElement()).hasClass(m.SHOW) || n2._hoverState === g.SHOW ? void (n2._hoverState = g.SHOW) : (clearTimeout(n2._timeout), n2._hoverState = g.SHOW, n2.config.delay && n2.config.delay.show ? void (n2._timeout = setTimeout(function() {
          n2._hoverState === g.SHOW && n2.show();
        }, n2.config.delay.show)) : void n2.show());
      }, h2.prototype._leave = function(e3, n2) {
        var i2 = this.constructor.DATA_KEY;
        if (n2 = n2 || t2(e3.currentTarget).data(i2), n2 || (n2 = new this.constructor(e3.currentTarget, this._getDelegateConfig()), t2(e3.currentTarget).data(i2, n2)), e3 && (n2._activeTrigger[e3.type === "focusout" ? T.FOCUS : T.HOVER] = false), !n2._isWithActiveTrigger())
          return clearTimeout(n2._timeout), n2._hoverState = g.OUT, n2.config.delay && n2.config.delay.hide ? void (n2._timeout = setTimeout(function() {
            n2._hoverState === g.OUT && n2.hide();
          }, n2.config.delay.hide)) : void n2.hide();
      }, h2.prototype._isWithActiveTrigger = function() {
        for (var t3 in this._activeTrigger)
          if (this._activeTrigger[t3])
            return true;
        return false;
      }, h2.prototype._getConfig = function(n2) {
        return n2 = t2.extend({}, this.constructor.Default, t2(this.element).data(), n2), n2.delay && typeof n2.delay == "number" && (n2.delay = { show: n2.delay, hide: n2.delay }), r.typeCheckConfig(e2, n2, this.constructor.DefaultType), n2;
      }, h2.prototype._getDelegateConfig = function() {
        var t3 = {};
        if (this.config)
          for (var e3 in this.config)
            this.constructor.Default[e3] !== this.config[e3] && (t3[e3] = this.config[e3]);
        return t3;
      }, h2._jQueryInterface = function(e3) {
        return this.each(function() {
          var n2 = t2(this).data(a), o2 = (typeof e3 == "undefined" ? "undefined" : i(e3)) === "object" && e3;
          if ((n2 || !/dispose|hide/.test(e3)) && (n2 || (n2 = new h2(this, o2), t2(this).data(a, n2)), typeof e3 == "string")) {
            if (n2[e3] === void 0)
              throw new Error('No method named "' + e3 + '"');
            n2[e3]();
          }
        });
      }, o(h2, null, [{ key: "VERSION", get: function() {
        return s2;
      } }, { key: "Default", get: function() {
        return d;
      } }, { key: "NAME", get: function() {
        return e2;
      } }, { key: "DATA_KEY", get: function() {
        return a;
      } }, { key: "Event", get: function() {
        return p;
      } }, { key: "EVENT_KEY", get: function() {
        return l;
      } }, { key: "DefaultType", get: function() {
        return f;
      } }]), h2;
    }();
    return t2.fn[e2] = I._jQueryInterface, t2.fn[e2].Constructor = I, t2.fn[e2].noConflict = function() {
      return t2.fn[e2] = h, I._jQueryInterface;
    }, I;
  }(jQuery));
  (function(r2) {
    var a = "popover", l = "4.0.0-alpha.6", h = "bs.popover", c = "." + h, u = r2.fn[a], d = r2.extend({}, s.Default, { placement: "right", trigger: "click", content: "", template: '<div class="popover" role="tooltip"><h3 class="popover-title"></h3><div class="popover-content"></div></div>' }), f = r2.extend({}, s.DefaultType, { content: "(string|element|function)" }), _ = { FADE: "fade", SHOW: "show" }, g = { TITLE: ".popover-title", CONTENT: ".popover-content" }, p = { HIDE: "hide" + c, HIDDEN: "hidden" + c, SHOW: "show" + c, SHOWN: "shown" + c, INSERTED: "inserted" + c, CLICK: "click" + c, FOCUSIN: "focusin" + c, FOCUSOUT: "focusout" + c, MOUSEENTER: "mouseenter" + c, MOUSELEAVE: "mouseleave" + c }, m = function(s2) {
      function u2() {
        return n(this, u2), t(this, s2.apply(this, arguments));
      }
      return e(u2, s2), u2.prototype.isWithContent = function() {
        return this.getTitle() || this._getContent();
      }, u2.prototype.getTipElement = function() {
        return this.tip = this.tip || r2(this.config.template)[0];
      }, u2.prototype.setContent = function() {
        var t2 = r2(this.getTipElement());
        this.setElementContent(t2.find(g.TITLE), this.getTitle()), this.setElementContent(t2.find(g.CONTENT), this._getContent()), t2.removeClass(_.FADE + " " + _.SHOW), this.cleanupTether();
      }, u2.prototype._getContent = function() {
        return this.element.getAttribute("data-content") || (typeof this.config.content == "function" ? this.config.content.call(this.element) : this.config.content);
      }, u2._jQueryInterface = function(t2) {
        return this.each(function() {
          var e2 = r2(this).data(h), n2 = (typeof t2 == "undefined" ? "undefined" : i(t2)) === "object" ? t2 : null;
          if ((e2 || !/destroy|hide/.test(t2)) && (e2 || (e2 = new u2(this, n2), r2(this).data(h, e2)), typeof t2 == "string")) {
            if (e2[t2] === void 0)
              throw new Error('No method named "' + t2 + '"');
            e2[t2]();
          }
        });
      }, o(u2, null, [{ key: "VERSION", get: function() {
        return l;
      } }, { key: "Default", get: function() {
        return d;
      } }, { key: "NAME", get: function() {
        return a;
      } }, { key: "DATA_KEY", get: function() {
        return h;
      } }, { key: "Event", get: function() {
        return p;
      } }, { key: "EVENT_KEY", get: function() {
        return c;
      } }, { key: "DefaultType", get: function() {
        return f;
      } }]), u2;
    }(s);
    return r2.fn[a] = m._jQueryInterface, r2.fn[a].Constructor = m, r2.fn[a].noConflict = function() {
      return r2.fn[a] = u, m._jQueryInterface;
    }, m;
  })(jQuery);
}();


/***/ }),

/***/ "./node_modules/events/events.js":
/*!***************************************!*\
  !*** ./node_modules/events/events.js ***!
  \***************************************/
/***/ ((module) => {

function EventEmitter() {
  this._events = this._events || {};
  this._maxListeners = this._maxListeners || void 0;
}
module.exports = EventEmitter;
EventEmitter.EventEmitter = EventEmitter;
EventEmitter.prototype._events = void 0;
EventEmitter.prototype._maxListeners = void 0;
EventEmitter.defaultMaxListeners = 10;
EventEmitter.prototype.setMaxListeners = function(n) {
  if (!isNumber(n) || n < 0 || isNaN(n))
    throw TypeError("n must be a positive number");
  this._maxListeners = n;
  return this;
};
EventEmitter.prototype.emit = function(type) {
  var er, handler, len, args, i, listeners;
  if (!this._events)
    this._events = {};
  if (type === "error") {
    if (!this._events.error || isObject(this._events.error) && !this._events.error.length) {
      er = arguments[1];
      if (er instanceof Error) {
        throw er;
      } else {
        var err = new Error('Uncaught, unspecified "error" event. (' + er + ")");
        err.context = er;
        throw err;
      }
    }
  }
  handler = this._events[type];
  if (isUndefined(handler))
    return false;
  if (isFunction(handler)) {
    switch (arguments.length) {
      case 1:
        handler.call(this);
        break;
      case 2:
        handler.call(this, arguments[1]);
        break;
      case 3:
        handler.call(this, arguments[1], arguments[2]);
        break;
      default:
        args = Array.prototype.slice.call(arguments, 1);
        handler.apply(this, args);
    }
  } else if (isObject(handler)) {
    args = Array.prototype.slice.call(arguments, 1);
    listeners = handler.slice();
    len = listeners.length;
    for (i = 0; i < len; i++)
      listeners[i].apply(this, args);
  }
  return true;
};
EventEmitter.prototype.addListener = function(type, listener) {
  var m;
  if (!isFunction(listener))
    throw TypeError("listener must be a function");
  if (!this._events)
    this._events = {};
  if (this._events.newListener)
    this.emit("newListener", type, isFunction(listener.listener) ? listener.listener : listener);
  if (!this._events[type])
    this._events[type] = listener;
  else if (isObject(this._events[type]))
    this._events[type].push(listener);
  else
    this._events[type] = [this._events[type], listener];
  if (isObject(this._events[type]) && !this._events[type].warned) {
    if (!isUndefined(this._maxListeners)) {
      m = this._maxListeners;
    } else {
      m = EventEmitter.defaultMaxListeners;
    }
    if (m && m > 0 && this._events[type].length > m) {
      this._events[type].warned = true;
      console.error("(node) warning: possible EventEmitter memory leak detected. %d listeners added. Use emitter.setMaxListeners() to increase limit.", this._events[type].length);
      if (typeof console.trace === "function") {
        console.trace();
      }
    }
  }
  return this;
};
EventEmitter.prototype.on = EventEmitter.prototype.addListener;
EventEmitter.prototype.once = function(type, listener) {
  if (!isFunction(listener))
    throw TypeError("listener must be a function");
  var fired = false;
  function g() {
    this.removeListener(type, g);
    if (!fired) {
      fired = true;
      listener.apply(this, arguments);
    }
  }
  g.listener = listener;
  this.on(type, g);
  return this;
};
EventEmitter.prototype.removeListener = function(type, listener) {
  var list, position, length, i;
  if (!isFunction(listener))
    throw TypeError("listener must be a function");
  if (!this._events || !this._events[type])
    return this;
  list = this._events[type];
  length = list.length;
  position = -1;
  if (list === listener || isFunction(list.listener) && list.listener === listener) {
    delete this._events[type];
    if (this._events.removeListener)
      this.emit("removeListener", type, listener);
  } else if (isObject(list)) {
    for (i = length; i-- > 0; ) {
      if (list[i] === listener || list[i].listener && list[i].listener === listener) {
        position = i;
        break;
      }
    }
    if (position < 0)
      return this;
    if (list.length === 1) {
      list.length = 0;
      delete this._events[type];
    } else {
      list.splice(position, 1);
    }
    if (this._events.removeListener)
      this.emit("removeListener", type, listener);
  }
  return this;
};
EventEmitter.prototype.removeAllListeners = function(type) {
  var key, listeners;
  if (!this._events)
    return this;
  if (!this._events.removeListener) {
    if (arguments.length === 0)
      this._events = {};
    else if (this._events[type])
      delete this._events[type];
    return this;
  }
  if (arguments.length === 0) {
    for (key in this._events) {
      if (key === "removeListener")
        continue;
      this.removeAllListeners(key);
    }
    this.removeAllListeners("removeListener");
    this._events = {};
    return this;
  }
  listeners = this._events[type];
  if (isFunction(listeners)) {
    this.removeListener(type, listeners);
  } else if (listeners) {
    while (listeners.length)
      this.removeListener(type, listeners[listeners.length - 1]);
  }
  delete this._events[type];
  return this;
};
EventEmitter.prototype.listeners = function(type) {
  var ret;
  if (!this._events || !this._events[type])
    ret = [];
  else if (isFunction(this._events[type]))
    ret = [this._events[type]];
  else
    ret = this._events[type].slice();
  return ret;
};
EventEmitter.prototype.listenerCount = function(type) {
  if (this._events) {
    var evlistener = this._events[type];
    if (isFunction(evlistener))
      return 1;
    else if (evlistener)
      return evlistener.length;
  }
  return 0;
};
EventEmitter.listenerCount = function(emitter, type) {
  return emitter.listenerCount(type);
};
function isFunction(arg) {
  return typeof arg === "function";
}
function isNumber(arg) {
  return typeof arg === "number";
}
function isObject(arg) {
  return typeof arg === "object" && arg !== null;
}
function isUndefined(arg) {
  return arg === void 0;
}


/***/ }),

/***/ "./node_modules/expose-loader/dist/runtime/getGlobalThis.js":
/*!******************************************************************!*\
  !*** ./node_modules/expose-loader/dist/runtime/getGlobalThis.js ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

module.exports = function() {
  if (typeof globalThis === "object") {
    return globalThis;
  }
  var g;
  try {
    g = this || new Function("return this")();
  } catch (e) {
    if (typeof window === "object") {
      return window;
    }
    if (typeof self === "object") {
      return self;
    }
    if (typeof __webpack_require__.g !== "undefined") {
      return __webpack_require__.g;
    }
  }
  return g;
}();


/***/ }),

/***/ "./node_modules/flexibility/flexibility.js":
/*!*************************************************!*\
  !*** ./node_modules/flexibility/flexibility.js ***!
  \*************************************************/
/***/ ((module) => {

!function(e) {
  if (true)
    module.exports = e();
  else { var t; }
}(function() {
  return function e(t, r, l) {
    function n(o2, i) {
      if (!r[o2]) {
        if (!t[o2]) {
          var s = undefined;
          if (!i && s)
            return require(o2, true);
          if (f)
            return f(o2, true);
          var a = new Error("Cannot find module '" + o2 + "'");
          throw a.code = "MODULE_NOT_FOUND", a;
        }
        var c = r[o2] = { exports: {} };
        t[o2][0].call(c.exports, function(e2) {
          var r2 = t[o2][1][e2];
          return n(r2 ? r2 : e2);
        }, c, c.exports, e, t, r, l);
      }
      return r[o2].exports;
    }
    for (var f = undefined, o = 0; o < l.length; o++)
      n(l[o]);
    return n;
  }({ 1: [function(e, t, r) {
    t.exports = function(e2) {
      var t2, r2, l, n = -1;
      if (e2.lines.length > 1 && e2.style.alignContent === "flex-start")
        for (t2 = 0; l = e2.lines[++n]; )
          l.crossStart = t2, t2 += l.cross;
      else if (e2.lines.length > 1 && e2.style.alignContent === "flex-end")
        for (t2 = e2.flexStyle.crossSpace; l = e2.lines[++n]; )
          l.crossStart = t2, t2 += l.cross;
      else if (e2.lines.length > 1 && e2.style.alignContent === "center")
        for (t2 = e2.flexStyle.crossSpace / 2; l = e2.lines[++n]; )
          l.crossStart = t2, t2 += l.cross;
      else if (e2.lines.length > 1 && e2.style.alignContent === "space-between")
        for (r2 = e2.flexStyle.crossSpace / (e2.lines.length - 1), t2 = 0; l = e2.lines[++n]; )
          l.crossStart = t2, t2 += l.cross + r2;
      else if (e2.lines.length > 1 && e2.style.alignContent === "space-around")
        for (r2 = 2 * e2.flexStyle.crossSpace / (2 * e2.lines.length), t2 = r2 / 2; l = e2.lines[++n]; )
          l.crossStart = t2, t2 += l.cross + r2;
      else
        for (r2 = e2.flexStyle.crossSpace / e2.lines.length, t2 = e2.flexStyle.crossInnerBefore; l = e2.lines[++n]; )
          l.crossStart = t2, l.cross += r2, t2 += l.cross;
    };
  }, {}], 2: [function(e, t, r) {
    t.exports = function(e2) {
      for (var t2, r2 = -1; line = e2.lines[++r2]; )
        for (t2 = -1; child = line.children[++t2]; ) {
          var l = child.style.alignSelf;
          l === "auto" && (l = e2.style.alignItems), l === "flex-start" ? child.flexStyle.crossStart = line.crossStart : l === "flex-end" ? child.flexStyle.crossStart = line.crossStart + line.cross - child.flexStyle.crossOuter : l === "center" ? child.flexStyle.crossStart = line.crossStart + (line.cross - child.flexStyle.crossOuter) / 2 : (child.flexStyle.crossStart = line.crossStart, child.flexStyle.crossOuter = line.cross, child.flexStyle.cross = child.flexStyle.crossOuter - child.flexStyle.crossBefore - child.flexStyle.crossAfter);
        }
    };
  }, {}], 3: [function(e, t, r) {
    t.exports = function l(e2, l) {
      var t2 = l === "row" || l === "row-reverse", r2 = e2.mainAxis;
      if (r2) {
        var n = t2 && r2 === "inline" || !t2 && r2 === "block";
        n || (e2.flexStyle = { main: e2.flexStyle.cross, cross: e2.flexStyle.main, mainOffset: e2.flexStyle.crossOffset, crossOffset: e2.flexStyle.mainOffset, mainBefore: e2.flexStyle.crossBefore, mainAfter: e2.flexStyle.crossAfter, crossBefore: e2.flexStyle.mainBefore, crossAfter: e2.flexStyle.mainAfter, mainInnerBefore: e2.flexStyle.crossInnerBefore, mainInnerAfter: e2.flexStyle.crossInnerAfter, crossInnerBefore: e2.flexStyle.mainInnerBefore, crossInnerAfter: e2.flexStyle.mainInnerAfter, mainBorderBefore: e2.flexStyle.crossBorderBefore, mainBorderAfter: e2.flexStyle.crossBorderAfter, crossBorderBefore: e2.flexStyle.mainBorderBefore, crossBorderAfter: e2.flexStyle.mainBorderAfter });
      } else
        t2 ? e2.flexStyle = { main: e2.style.width, cross: e2.style.height, mainOffset: e2.style.offsetWidth, crossOffset: e2.style.offsetHeight, mainBefore: e2.style.marginLeft, mainAfter: e2.style.marginRight, crossBefore: e2.style.marginTop, crossAfter: e2.style.marginBottom, mainInnerBefore: e2.style.paddingLeft, mainInnerAfter: e2.style.paddingRight, crossInnerBefore: e2.style.paddingTop, crossInnerAfter: e2.style.paddingBottom, mainBorderBefore: e2.style.borderLeftWidth, mainBorderAfter: e2.style.borderRightWidth, crossBorderBefore: e2.style.borderTopWidth, crossBorderAfter: e2.style.borderBottomWidth } : e2.flexStyle = { main: e2.style.height, cross: e2.style.width, mainOffset: e2.style.offsetHeight, crossOffset: e2.style.offsetWidth, mainBefore: e2.style.marginTop, mainAfter: e2.style.marginBottom, crossBefore: e2.style.marginLeft, crossAfter: e2.style.marginRight, mainInnerBefore: e2.style.paddingTop, mainInnerAfter: e2.style.paddingBottom, crossInnerBefore: e2.style.paddingLeft, crossInnerAfter: e2.style.paddingRight, mainBorderBefore: e2.style.borderTopWidth, mainBorderAfter: e2.style.borderBottomWidth, crossBorderBefore: e2.style.borderLeftWidth, crossBorderAfter: e2.style.borderRightWidth }, e2.style.boxSizing === "content-box" && (typeof e2.flexStyle.main == "number" && (e2.flexStyle.main += e2.flexStyle.mainInnerBefore + e2.flexStyle.mainInnerAfter + e2.flexStyle.mainBorderBefore + e2.flexStyle.mainBorderAfter), typeof e2.flexStyle.cross == "number" && (e2.flexStyle.cross += e2.flexStyle.crossInnerBefore + e2.flexStyle.crossInnerAfter + e2.flexStyle.crossBorderBefore + e2.flexStyle.crossBorderAfter));
      e2.mainAxis = t2 ? "inline" : "block", e2.crossAxis = t2 ? "block" : "inline", typeof e2.style.flexBasis == "number" && (e2.flexStyle.main = e2.style.flexBasis + e2.flexStyle.mainInnerBefore + e2.flexStyle.mainInnerAfter + e2.flexStyle.mainBorderBefore + e2.flexStyle.mainBorderAfter), e2.flexStyle.mainOuter = e2.flexStyle.main, e2.flexStyle.crossOuter = e2.flexStyle.cross, e2.flexStyle.mainOuter === "auto" && (e2.flexStyle.mainOuter = e2.flexStyle.mainOffset), e2.flexStyle.crossOuter === "auto" && (e2.flexStyle.crossOuter = e2.flexStyle.crossOffset), typeof e2.flexStyle.mainBefore == "number" && (e2.flexStyle.mainOuter += e2.flexStyle.mainBefore), typeof e2.flexStyle.mainAfter == "number" && (e2.flexStyle.mainOuter += e2.flexStyle.mainAfter), typeof e2.flexStyle.crossBefore == "number" && (e2.flexStyle.crossOuter += e2.flexStyle.crossBefore), typeof e2.flexStyle.crossAfter == "number" && (e2.flexStyle.crossOuter += e2.flexStyle.crossAfter);
    };
  }, {}], 4: [function(e, t, r) {
    var l = e("../reduce");
    t.exports = function(e2) {
      if (e2.mainSpace > 0) {
        var t2 = l(e2.children, function(e3, t3) {
          return e3 + parseFloat(t3.style.flexGrow);
        }, 0);
        t2 > 0 && (e2.main = l(e2.children, function(r2, l2) {
          return l2.flexStyle.main === "auto" ? l2.flexStyle.main = l2.flexStyle.mainOffset + parseFloat(l2.style.flexGrow) / t2 * e2.mainSpace : l2.flexStyle.main += parseFloat(l2.style.flexGrow) / t2 * e2.mainSpace, l2.flexStyle.mainOuter = l2.flexStyle.main + l2.flexStyle.mainBefore + l2.flexStyle.mainAfter, r2 + l2.flexStyle.mainOuter;
        }, 0), e2.mainSpace = 0);
      }
    };
  }, { "../reduce": 12 }], 5: [function(e, t, r) {
    var l = e("../reduce");
    t.exports = function(e2) {
      if (e2.mainSpace < 0) {
        var t2 = l(e2.children, function(e3, t3) {
          return e3 + parseFloat(t3.style.flexShrink);
        }, 0);
        t2 > 0 && (e2.main = l(e2.children, function(r2, l2) {
          return l2.flexStyle.main += parseFloat(l2.style.flexShrink) / t2 * e2.mainSpace, l2.flexStyle.mainOuter = l2.flexStyle.main + l2.flexStyle.mainBefore + l2.flexStyle.mainAfter, r2 + l2.flexStyle.mainOuter;
        }, 0), e2.mainSpace = 0);
      }
    };
  }, { "../reduce": 12 }], 6: [function(e, t, r) {
    var l = e("../reduce");
    t.exports = function(e2) {
      var t2;
      e2.lines = [t2 = { main: 0, cross: 0, children: [] }];
      for (var r2, n = -1; r2 = e2.children[++n]; )
        e2.style.flexWrap === "nowrap" || t2.children.length === 0 || e2.flexStyle.main === "auto" || e2.flexStyle.main - e2.flexStyle.mainInnerBefore - e2.flexStyle.mainInnerAfter - e2.flexStyle.mainBorderBefore - e2.flexStyle.mainBorderAfter >= t2.main + r2.flexStyle.mainOuter ? (t2.main += r2.flexStyle.mainOuter, t2.cross = Math.max(t2.cross, r2.flexStyle.crossOuter)) : e2.lines.push(t2 = { main: r2.flexStyle.mainOuter, cross: r2.flexStyle.crossOuter, children: [] }), t2.children.push(r2);
      e2.flexStyle.mainLines = l(e2.lines, function(e3, t3) {
        return Math.max(e3, t3.main);
      }, 0), e2.flexStyle.crossLines = l(e2.lines, function(e3, t3) {
        return e3 + t3.cross;
      }, 0), e2.flexStyle.main === "auto" && (e2.flexStyle.main = Math.max(e2.flexStyle.mainOffset, e2.flexStyle.mainLines + e2.flexStyle.mainInnerBefore + e2.flexStyle.mainInnerAfter + e2.flexStyle.mainBorderBefore + e2.flexStyle.mainBorderAfter)), e2.flexStyle.cross === "auto" && (e2.flexStyle.cross = Math.max(e2.flexStyle.crossOffset, e2.flexStyle.crossLines + e2.flexStyle.crossInnerBefore + e2.flexStyle.crossInnerAfter + e2.flexStyle.crossBorderBefore + e2.flexStyle.crossBorderAfter)), e2.flexStyle.crossSpace = e2.flexStyle.cross - e2.flexStyle.crossInnerBefore - e2.flexStyle.crossInnerAfter - e2.flexStyle.crossBorderBefore - e2.flexStyle.crossBorderAfter - e2.flexStyle.crossLines, e2.flexStyle.mainOuter = e2.flexStyle.main + e2.flexStyle.mainBefore + e2.flexStyle.mainAfter, e2.flexStyle.crossOuter = e2.flexStyle.cross + e2.flexStyle.crossBefore + e2.flexStyle.crossAfter;
    };
  }, { "../reduce": 12 }], 7: [function(e, t, r) {
    function l(t2) {
      for (var r2, l2 = -1; r2 = t2.children[++l2]; )
        e("./flex-direction")(r2, t2.style.flexDirection);
      e("./flex-direction")(t2, t2.style.flexDirection), e("./order")(t2), e("./flexbox-lines")(t2), e("./align-content")(t2), l2 = -1;
      for (var n; n = t2.lines[++l2]; )
        n.mainSpace = t2.flexStyle.main - t2.flexStyle.mainInnerBefore - t2.flexStyle.mainInnerAfter - t2.flexStyle.mainBorderBefore - t2.flexStyle.mainBorderAfter - n.main, e("./flex-grow")(n), e("./flex-shrink")(n), e("./margin-main")(n), e("./margin-cross")(n), e("./justify-content")(n, t2.style.justifyContent, t2);
      e("./align-items")(t2);
    }
    t.exports = l;
  }, { "./align-content": 1, "./align-items": 2, "./flex-direction": 3, "./flex-grow": 4, "./flex-shrink": 5, "./flexbox-lines": 6, "./justify-content": 8, "./margin-cross": 9, "./margin-main": 10, "./order": 11 }], 8: [function(e, t, r) {
    t.exports = function(e2, t2, r2) {
      var l, n, f, o = r2.flexStyle.mainInnerBefore, i = -1;
      if (t2 === "flex-end")
        for (l = e2.mainSpace, l += o; f = e2.children[++i]; )
          f.flexStyle.mainStart = l, l += f.flexStyle.mainOuter;
      else if (t2 === "center")
        for (l = e2.mainSpace / 2, l += o; f = e2.children[++i]; )
          f.flexStyle.mainStart = l, l += f.flexStyle.mainOuter;
      else if (t2 === "space-between")
        for (n = e2.mainSpace / (e2.children.length - 1), l = 0, l += o; f = e2.children[++i]; )
          f.flexStyle.mainStart = l, l += f.flexStyle.mainOuter + n;
      else if (t2 === "space-around")
        for (n = 2 * e2.mainSpace / (2 * e2.children.length), l = n / 2, l += o; f = e2.children[++i]; )
          f.flexStyle.mainStart = l, l += f.flexStyle.mainOuter + n;
      else
        for (l = 0, l += o; f = e2.children[++i]; )
          f.flexStyle.mainStart = l, l += f.flexStyle.mainOuter;
    };
  }, {}], 9: [function(e, t, r) {
    t.exports = function(e2) {
      for (var t2, r2 = -1; t2 = e2.children[++r2]; ) {
        var l = 0;
        t2.flexStyle.crossBefore === "auto" && ++l, t2.flexStyle.crossAfter === "auto" && ++l;
        var n = e2.cross - t2.flexStyle.crossOuter;
        t2.flexStyle.crossBefore === "auto" && (t2.flexStyle.crossBefore = n / l), t2.flexStyle.crossAfter === "auto" && (t2.flexStyle.crossAfter = n / l), t2.flexStyle.cross === "auto" ? t2.flexStyle.crossOuter = t2.flexStyle.crossOffset + t2.flexStyle.crossBefore + t2.flexStyle.crossAfter : t2.flexStyle.crossOuter = t2.flexStyle.cross + t2.flexStyle.crossBefore + t2.flexStyle.crossAfter;
      }
    };
  }, {}], 10: [function(e, t, r) {
    t.exports = function(e2) {
      for (var t2, r2 = 0, l = -1; t2 = e2.children[++l]; )
        t2.flexStyle.mainBefore === "auto" && ++r2, t2.flexStyle.mainAfter === "auto" && ++r2;
      if (r2 > 0) {
        for (l = -1; t2 = e2.children[++l]; )
          t2.flexStyle.mainBefore === "auto" && (t2.flexStyle.mainBefore = e2.mainSpace / r2), t2.flexStyle.mainAfter === "auto" && (t2.flexStyle.mainAfter = e2.mainSpace / r2), t2.flexStyle.main === "auto" ? t2.flexStyle.mainOuter = t2.flexStyle.mainOffset + t2.flexStyle.mainBefore + t2.flexStyle.mainAfter : t2.flexStyle.mainOuter = t2.flexStyle.main + t2.flexStyle.mainBefore + t2.flexStyle.mainAfter;
        e2.mainSpace = 0;
      }
    };
  }, {}], 11: [function(e, t, r) {
    var l = /^(column|row)-reverse$/;
    t.exports = function(e2) {
      e2.children.sort(function(e3, t2) {
        return e3.style.order - t2.style.order || e3.index - t2.index;
      }), l.test(e2.style.flexDirection) && e2.children.reverse();
    };
  }, {}], 12: [function(e, t, r) {
    function l(e2, t2, r2) {
      for (var l2 = e2.length, n = -1; ++n < l2; )
        n in e2 && (r2 = t2(r2, e2[n], n));
      return r2;
    }
    t.exports = l;
  }, {}], 13: [function(e, t, r) {
    function l(e2) {
      i(o(e2));
    }
    var n = e("./read"), f = e("./write"), o = e("./readAll"), i = e("./writeAll");
    t.exports = l, t.exports.read = n, t.exports.write = f, t.exports.readAll = o, t.exports.writeAll = i;
  }, { "./read": 15, "./readAll": 16, "./write": 17, "./writeAll": 18 }], 14: [function(e, t, r) {
    function l(e2, t2) {
      var r2 = String(e2).match(f);
      if (!r2)
        return e2;
      var l2 = r2[1], o2 = r2[2];
      return o2 === "px" ? 1 * l2 : o2 === "cm" ? 0.3937 * l2 * 96 : o2 === "in" ? 96 * l2 : o2 === "mm" ? 0.3937 * l2 * 96 / 10 : o2 === "pc" ? 12 * l2 * 96 / 72 : o2 === "pt" ? 96 * l2 / 72 : o2 === "rem" ? 16 * l2 : n(e2, t2);
    }
    function n(e2, t2) {
      o.style.cssText = "border:none!important;clip:rect(0 0 0 0)!important;display:block!important;font-size:1em!important;height:0!important;margin:0!important;padding:0!important;position:relative!important;width:" + e2 + "!important", t2.parentNode.insertBefore(o, t2.nextSibling);
      var r2 = o.offsetWidth;
      return t2.parentNode.removeChild(o), r2;
    }
    t.exports = l;
    var f = /^([-+]?\d*\.?\d+)(%|[a-z]+)$/, o = document.createElement("div");
  }, {}], 15: [function(e, t, r) {
    function l(e2) {
      var t2 = { alignContent: "stretch", alignItems: "stretch", alignSelf: "auto", borderBottomWidth: 0, borderLeftWidth: 0, borderRightWidth: 0, borderTopWidth: 0, boxSizing: "content-box", display: "inline", flexBasis: "auto", flexDirection: "row", flexGrow: 0, flexShrink: 1, flexWrap: "nowrap", justifyContent: "flex-start", height: "auto", marginTop: 0, marginRight: 0, marginLeft: 0, marginBottom: 0, paddingTop: 0, paddingRight: 0, paddingLeft: 0, paddingBottom: 0, maxHeight: "none", maxWidth: "none", minHeight: 0, minWidth: 0, order: 0, position: "static", width: "auto" }, r2 = e2 instanceof Element;
      if (r2) {
        var l2 = e2.hasAttribute("data-style"), i2 = l2 ? e2.getAttribute("data-style") : e2.getAttribute("style") || "";
        l2 || e2.setAttribute("data-style", i2);
        var a = window.getComputedStyle && getComputedStyle(e2) || {};
        o(t2, a);
        var c = e2.currentStyle || {};
        n(t2, c), f(t2, i2);
        for (var y in t2)
          t2[y] = s(t2[y], e2);
        var x = e2.getBoundingClientRect();
        t2.offsetHeight = x.height || e2.offsetHeight, t2.offsetWidth = x.width || e2.offsetWidth;
      }
      var S = { element: e2, style: t2 };
      return S;
    }
    function n(e2, t2) {
      for (var r2 in e2) {
        var l2 = r2 in t2;
        if (l2)
          e2[r2] = t2[r2];
        else {
          var n2 = r2.replace(/[A-Z]/g, "-$&").toLowerCase(), f2 = n2 in t2;
          f2 && (e2[r2] = t2[n2]);
        }
      }
      var o2 = "-js-display" in t2;
      o2 && (e2.display = t2["-js-display"]);
    }
    function f(e2, t2) {
      for (var r2; r2 = i.exec(t2); ) {
        var l2 = r2[1].toLowerCase().replace(/-[a-z]/g, function(e3) {
          return e3.slice(1).toUpperCase();
        });
        e2[l2] = r2[2];
      }
    }
    function o(e2, t2) {
      for (var r2 in e2) {
        var l2 = r2 in t2;
        l2 && !/^(alignSelf|height|width)$/.test(r2) && (e2[r2] = t2[r2]);
      }
    }
    t.exports = l;
    var i = /([^\s:;]+)\s*:\s*([^;]+?)\s*(;|$)/g, s = e("./getComputedLength");
  }, { "./getComputedLength": 14 }], 16: [function(e, t, r) {
    function l(e2) {
      var t2 = [];
      return n(e2, t2), t2;
    }
    function n(e2, t2) {
      for (var r2, l2 = f(e2), i2 = [], s2 = -1; r2 = e2.childNodes[++s2]; ) {
        var a = r2.nodeType === 3 && !/^\s*$/.test(r2.nodeValue);
        if (l2 && a) {
          var c = r2;
          r2 = e2.insertBefore(document.createElement("flex-item"), c), r2.appendChild(c);
        }
        var y = r2 instanceof Element;
        if (y) {
          var x = n(r2, t2);
          if (l2) {
            var S = r2.style;
            S.display = "inline-block", S.position = "absolute", x.style = o(r2).style, i2.push(x);
          }
        }
      }
      var m = { element: e2, children: i2 };
      return l2 && (m.style = o(e2).style, t2.push(m)), m;
    }
    function f(e2) {
      var t2 = e2 instanceof Element, r2 = t2 && e2.getAttribute("data-style"), l2 = t2 && e2.currentStyle && e2.currentStyle["-js-display"], n2 = i.test(r2) || s.test(l2);
      return n2;
    }
    t.exports = l;
    var o = e("../read"), i = /(^|;)\s*display\s*:\s*(inline-)?flex\s*(;|$)/i, s = /^(inline-)?flex$/i;
  }, { "../read": 15 }], 17: [function(e, t, r) {
    function l(e2) {
      f(e2);
      var t2 = e2.element.style, r2 = e2.mainAxis === "inline" ? ["main", "cross"] : ["cross", "main"];
      t2.boxSizing = "content-box", t2.display = "block", t2.position = "relative", t2.width = n(e2.flexStyle[r2[0]] - e2.flexStyle[r2[0] + "InnerBefore"] - e2.flexStyle[r2[0] + "InnerAfter"] - e2.flexStyle[r2[0] + "BorderBefore"] - e2.flexStyle[r2[0] + "BorderAfter"]), t2.height = n(e2.flexStyle[r2[1]] - e2.flexStyle[r2[1] + "InnerBefore"] - e2.flexStyle[r2[1] + "InnerAfter"] - e2.flexStyle[r2[1] + "BorderBefore"] - e2.flexStyle[r2[1] + "BorderAfter"]);
      for (var l2, o = -1; l2 = e2.children[++o]; ) {
        var i = l2.element.style, s = l2.mainAxis === "inline" ? ["main", "cross"] : ["cross", "main"];
        i.boxSizing = "content-box", i.display = "block", i.position = "absolute", l2.flexStyle[s[0]] !== "auto" && (i.width = n(l2.flexStyle[s[0]] - l2.flexStyle[s[0] + "InnerBefore"] - l2.flexStyle[s[0] + "InnerAfter"] - l2.flexStyle[s[0] + "BorderBefore"] - l2.flexStyle[s[0] + "BorderAfter"])), l2.flexStyle[s[1]] !== "auto" && (i.height = n(l2.flexStyle[s[1]] - l2.flexStyle[s[1] + "InnerBefore"] - l2.flexStyle[s[1] + "InnerAfter"] - l2.flexStyle[s[1] + "BorderBefore"] - l2.flexStyle[s[1] + "BorderAfter"])), i.top = n(l2.flexStyle[s[1] + "Start"]), i.left = n(l2.flexStyle[s[0] + "Start"]), i.marginTop = n(l2.flexStyle[s[1] + "Before"]), i.marginRight = n(l2.flexStyle[s[0] + "After"]), i.marginBottom = n(l2.flexStyle[s[1] + "After"]), i.marginLeft = n(l2.flexStyle[s[0] + "Before"]);
      }
    }
    function n(e2) {
      return typeof e2 == "string" ? e2 : Math.max(e2, 0) + "px";
    }
    t.exports = l;
    var f = e("../flexbox");
  }, { "../flexbox": 7 }], 18: [function(e, t, r) {
    function l(e2) {
      for (var t2, r2 = -1; t2 = e2[++r2]; )
        n(t2);
    }
    t.exports = l;
    var n = e("../write");
  }, { "../write": 17 }] }, {}, [13])(13);
});


/***/ }),

/***/ "./node_modules/jquery-touchswipe/jquery.touchSwipe.min.js":
/*!*****************************************************************!*\
  !*** ./node_modules/jquery-touchswipe/jquery.touchSwipe.min.js ***!
  \*****************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * @fileOverview TouchSwipe - jQuery Plugin
 * @version 1.6.18
 *
 * @author Matt Bryson http://www.github.com/mattbryson
 * @see https://github.com/mattbryson/TouchSwipe-Jquery-Plugin
 * @see http://labs.rampinteractive.co.uk/touchSwipe/
 * @see http://plugins.jquery.com/project/touchSwipe
 * @license
 * Copyright (c) 2010-2015 Matt Bryson
 * Dual licensed under the MIT or GPL Version 2 licenses.
 *
 */
!function(factory) {
   true && __webpack_require__.amdO.jQuery ? !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "jquery")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : factory( true && module.exports ? __webpack_require__(/*! jquery */ "jquery") : jQuery);
}(function($) {
  "use strict";
  function init(options) {
    return !options || options.allowPageScroll !== void 0 || options.swipe === void 0 && options.swipeStatus === void 0 || (options.allowPageScroll = NONE), options.click !== void 0 && options.tap === void 0 && (options.tap = options.click), options || (options = {}), options = $.extend({}, $.fn.swipe.defaults, options), this.each(function() {
      var $this = $(this), plugin = $this.data(PLUGIN_NS);
      plugin || (plugin = new TouchSwipe(this, options), $this.data(PLUGIN_NS, plugin));
    });
  }
  function TouchSwipe(element, options) {
    function touchStart(jqEvent) {
      if (!(getTouchInProgress() || $(jqEvent.target).closest(options.excludedElements, $element).length > 0)) {
        var event = jqEvent.originalEvent ? jqEvent.originalEvent : jqEvent;
        if (!event.pointerType || event.pointerType != "mouse" || options.fallbackToMouseEvents != 0) {
          var ret, touches = event.touches, evt = touches ? touches[0] : event;
          return phase = PHASE_START, touches ? fingerCount = touches.length : options.preventDefaultEvents !== false && jqEvent.preventDefault(), distance = 0, direction = null, currentDirection = null, pinchDirection = null, duration = 0, startTouchesDistance = 0, endTouchesDistance = 0, pinchZoom = 1, pinchDistance = 0, maximumsMap = createMaximumsData(), cancelMultiFingerRelease(), createFingerData(0, evt), !touches || fingerCount === options.fingers || options.fingers === ALL_FINGERS || hasPinches() ? (startTime = getTimeStamp(), fingerCount == 2 && (createFingerData(1, touches[1]), startTouchesDistance = endTouchesDistance = calculateTouchesDistance(fingerData[0].start, fingerData[1].start)), (options.swipeStatus || options.pinchStatus) && (ret = triggerHandler(event, phase))) : ret = false, ret === false ? (phase = PHASE_CANCEL, triggerHandler(event, phase), ret) : (options.hold && (holdTimeout = setTimeout($.proxy(function() {
            $element.trigger("hold", [event.target]), options.hold && (ret = options.hold.call($element, event, event.target));
          }, this), options.longTapThreshold)), setTouchInProgress(true), null);
        }
      }
    }
    function touchMove(jqEvent) {
      var event = jqEvent.originalEvent ? jqEvent.originalEvent : jqEvent;
      if (phase !== PHASE_END && phase !== PHASE_CANCEL && !inMultiFingerRelease()) {
        var ret, touches = event.touches, evt = touches ? touches[0] : event, currentFinger = updateFingerData(evt);
        if (endTime = getTimeStamp(), touches && (fingerCount = touches.length), options.hold && clearTimeout(holdTimeout), phase = PHASE_MOVE, fingerCount == 2 && (startTouchesDistance == 0 ? (createFingerData(1, touches[1]), startTouchesDistance = endTouchesDistance = calculateTouchesDistance(fingerData[0].start, fingerData[1].start)) : (updateFingerData(touches[1]), endTouchesDistance = calculateTouchesDistance(fingerData[0].end, fingerData[1].end), pinchDirection = calculatePinchDirection(fingerData[0].end, fingerData[1].end)), pinchZoom = calculatePinchZoom(startTouchesDistance, endTouchesDistance), pinchDistance = Math.abs(startTouchesDistance - endTouchesDistance)), fingerCount === options.fingers || options.fingers === ALL_FINGERS || !touches || hasPinches()) {
          if (direction = calculateDirection(currentFinger.start, currentFinger.end), currentDirection = calculateDirection(currentFinger.last, currentFinger.end), validateDefaultEvent(jqEvent, currentDirection), distance = calculateDistance(currentFinger.start, currentFinger.end), duration = calculateDuration(), setMaxDistance(direction, distance), ret = triggerHandler(event, phase), !options.triggerOnTouchEnd || options.triggerOnTouchLeave) {
            var inBounds = true;
            if (options.triggerOnTouchLeave) {
              var bounds = getbounds(this);
              inBounds = isInBounds(currentFinger.end, bounds);
            }
            !options.triggerOnTouchEnd && inBounds ? phase = getNextPhase(PHASE_MOVE) : options.triggerOnTouchLeave && !inBounds && (phase = getNextPhase(PHASE_END)), phase != PHASE_CANCEL && phase != PHASE_END || triggerHandler(event, phase);
          }
        } else
          phase = PHASE_CANCEL, triggerHandler(event, phase);
        ret === false && (phase = PHASE_CANCEL, triggerHandler(event, phase));
      }
    }
    function touchEnd(jqEvent) {
      var event = jqEvent.originalEvent ? jqEvent.originalEvent : jqEvent, touches = event.touches;
      if (touches) {
        if (touches.length && !inMultiFingerRelease())
          return startMultiFingerRelease(event), true;
        if (touches.length && inMultiFingerRelease())
          return true;
      }
      return inMultiFingerRelease() && (fingerCount = fingerCountAtRelease), endTime = getTimeStamp(), duration = calculateDuration(), didSwipeBackToCancel() || !validateSwipeDistance() ? (phase = PHASE_CANCEL, triggerHandler(event, phase)) : options.triggerOnTouchEnd || options.triggerOnTouchEnd === false && phase === PHASE_MOVE ? (options.preventDefaultEvents !== false && jqEvent.cancelable !== false && jqEvent.preventDefault(), phase = PHASE_END, triggerHandler(event, phase)) : !options.triggerOnTouchEnd && hasTap() ? (phase = PHASE_END, triggerHandlerForGesture(event, phase, TAP)) : phase === PHASE_MOVE && (phase = PHASE_CANCEL, triggerHandler(event, phase)), setTouchInProgress(false), null;
    }
    function touchCancel() {
      fingerCount = 0, endTime = 0, startTime = 0, startTouchesDistance = 0, endTouchesDistance = 0, pinchZoom = 1, cancelMultiFingerRelease(), setTouchInProgress(false);
    }
    function touchLeave(jqEvent) {
      var event = jqEvent.originalEvent ? jqEvent.originalEvent : jqEvent;
      options.triggerOnTouchLeave && (phase = getNextPhase(PHASE_END), triggerHandler(event, phase));
    }
    function removeListeners() {
      $element.off(START_EV, touchStart), $element.off(CANCEL_EV, touchCancel), $element.off(MOVE_EV, touchMove), $element.off(END_EV, touchEnd), LEAVE_EV && $element.off(LEAVE_EV, touchLeave), setTouchInProgress(false);
    }
    function getNextPhase(currentPhase) {
      var nextPhase = currentPhase, validTime = validateSwipeTime(), validDistance = validateSwipeDistance(), didCancel = didSwipeBackToCancel();
      return !validTime || didCancel ? nextPhase = PHASE_CANCEL : !validDistance || currentPhase != PHASE_MOVE || options.triggerOnTouchEnd && !options.triggerOnTouchLeave ? !validDistance && currentPhase == PHASE_END && options.triggerOnTouchLeave && (nextPhase = PHASE_CANCEL) : nextPhase = PHASE_END, nextPhase;
    }
    function triggerHandler(event, phase2) {
      var ret, touches = event.touches;
      return (didSwipe() || hasSwipes()) && (ret = triggerHandlerForGesture(event, phase2, SWIPE)), (didPinch() || hasPinches()) && ret !== false && (ret = triggerHandlerForGesture(event, phase2, PINCH)), didDoubleTap() && ret !== false ? ret = triggerHandlerForGesture(event, phase2, DOUBLE_TAP) : didLongTap() && ret !== false ? ret = triggerHandlerForGesture(event, phase2, LONG_TAP) : didTap() && ret !== false && (ret = triggerHandlerForGesture(event, phase2, TAP)), phase2 === PHASE_CANCEL && touchCancel(event), phase2 === PHASE_END && (touches ? touches.length || touchCancel(event) : touchCancel(event)), ret;
    }
    function triggerHandlerForGesture(event, phase2, gesture) {
      var ret;
      if (gesture == SWIPE) {
        if ($element.trigger("swipeStatus", [phase2, direction || null, distance || 0, duration || 0, fingerCount, fingerData, currentDirection]), options.swipeStatus && (ret = options.swipeStatus.call($element, event, phase2, direction || null, distance || 0, duration || 0, fingerCount, fingerData, currentDirection), ret === false))
          return false;
        if (phase2 == PHASE_END && validateSwipe()) {
          if (clearTimeout(singleTapTimeout), clearTimeout(holdTimeout), $element.trigger("swipe", [direction, distance, duration, fingerCount, fingerData, currentDirection]), options.swipe && (ret = options.swipe.call($element, event, direction, distance, duration, fingerCount, fingerData, currentDirection), ret === false))
            return false;
          switch (direction) {
            case LEFT:
              $element.trigger("swipeLeft", [direction, distance, duration, fingerCount, fingerData, currentDirection]), options.swipeLeft && (ret = options.swipeLeft.call($element, event, direction, distance, duration, fingerCount, fingerData, currentDirection));
              break;
            case RIGHT:
              $element.trigger("swipeRight", [direction, distance, duration, fingerCount, fingerData, currentDirection]), options.swipeRight && (ret = options.swipeRight.call($element, event, direction, distance, duration, fingerCount, fingerData, currentDirection));
              break;
            case UP:
              $element.trigger("swipeUp", [direction, distance, duration, fingerCount, fingerData, currentDirection]), options.swipeUp && (ret = options.swipeUp.call($element, event, direction, distance, duration, fingerCount, fingerData, currentDirection));
              break;
            case DOWN:
              $element.trigger("swipeDown", [direction, distance, duration, fingerCount, fingerData, currentDirection]), options.swipeDown && (ret = options.swipeDown.call($element, event, direction, distance, duration, fingerCount, fingerData, currentDirection));
          }
        }
      }
      if (gesture == PINCH) {
        if ($element.trigger("pinchStatus", [phase2, pinchDirection || null, pinchDistance || 0, duration || 0, fingerCount, pinchZoom, fingerData]), options.pinchStatus && (ret = options.pinchStatus.call($element, event, phase2, pinchDirection || null, pinchDistance || 0, duration || 0, fingerCount, pinchZoom, fingerData), ret === false))
          return false;
        if (phase2 == PHASE_END && validatePinch())
          switch (pinchDirection) {
            case IN:
              $element.trigger("pinchIn", [pinchDirection || null, pinchDistance || 0, duration || 0, fingerCount, pinchZoom, fingerData]), options.pinchIn && (ret = options.pinchIn.call($element, event, pinchDirection || null, pinchDistance || 0, duration || 0, fingerCount, pinchZoom, fingerData));
              break;
            case OUT:
              $element.trigger("pinchOut", [pinchDirection || null, pinchDistance || 0, duration || 0, fingerCount, pinchZoom, fingerData]), options.pinchOut && (ret = options.pinchOut.call($element, event, pinchDirection || null, pinchDistance || 0, duration || 0, fingerCount, pinchZoom, fingerData));
          }
      }
      return gesture == TAP ? phase2 !== PHASE_CANCEL && phase2 !== PHASE_END || (clearTimeout(singleTapTimeout), clearTimeout(holdTimeout), hasDoubleTap() && !inDoubleTap() ? (doubleTapStartTime = getTimeStamp(), singleTapTimeout = setTimeout($.proxy(function() {
        doubleTapStartTime = null, $element.trigger("tap", [event.target]), options.tap && (ret = options.tap.call($element, event, event.target));
      }, this), options.doubleTapThreshold)) : (doubleTapStartTime = null, $element.trigger("tap", [event.target]), options.tap && (ret = options.tap.call($element, event, event.target)))) : gesture == DOUBLE_TAP ? phase2 !== PHASE_CANCEL && phase2 !== PHASE_END || (clearTimeout(singleTapTimeout), clearTimeout(holdTimeout), doubleTapStartTime = null, $element.trigger("doubletap", [event.target]), options.doubleTap && (ret = options.doubleTap.call($element, event, event.target))) : gesture == LONG_TAP && (phase2 !== PHASE_CANCEL && phase2 !== PHASE_END || (clearTimeout(singleTapTimeout), doubleTapStartTime = null, $element.trigger("longtap", [event.target]), options.longTap && (ret = options.longTap.call($element, event, event.target)))), ret;
    }
    function validateSwipeDistance() {
      var valid = true;
      return options.threshold !== null && (valid = distance >= options.threshold), valid;
    }
    function didSwipeBackToCancel() {
      var cancelled = false;
      return options.cancelThreshold !== null && direction !== null && (cancelled = getMaxDistance(direction) - distance >= options.cancelThreshold), cancelled;
    }
    function validatePinchDistance() {
      return options.pinchThreshold !== null ? pinchDistance >= options.pinchThreshold : true;
    }
    function validateSwipeTime() {
      var result;
      return result = options.maxTimeThreshold ? !(duration >= options.maxTimeThreshold) : true;
    }
    function validateDefaultEvent(jqEvent, direction2) {
      if (options.preventDefaultEvents !== false)
        if (options.allowPageScroll === NONE)
          jqEvent.preventDefault();
        else {
          var auto = options.allowPageScroll === AUTO;
          switch (direction2) {
            case LEFT:
              (options.swipeLeft && auto || !auto && options.allowPageScroll != HORIZONTAL) && jqEvent.preventDefault();
              break;
            case RIGHT:
              (options.swipeRight && auto || !auto && options.allowPageScroll != HORIZONTAL) && jqEvent.preventDefault();
              break;
            case UP:
              (options.swipeUp && auto || !auto && options.allowPageScroll != VERTICAL) && jqEvent.preventDefault();
              break;
            case DOWN:
              (options.swipeDown && auto || !auto && options.allowPageScroll != VERTICAL) && jqEvent.preventDefault();
              break;
            case NONE:
          }
        }
    }
    function validatePinch() {
      var hasCorrectFingerCount = validateFingers(), hasEndPoint = validateEndPoint(), hasCorrectDistance = validatePinchDistance();
      return hasCorrectFingerCount && hasEndPoint && hasCorrectDistance;
    }
    function hasPinches() {
      return !!(options.pinchStatus || options.pinchIn || options.pinchOut);
    }
    function didPinch() {
      return !(!validatePinch() || !hasPinches());
    }
    function validateSwipe() {
      var hasValidTime = validateSwipeTime(), hasValidDistance = validateSwipeDistance(), hasCorrectFingerCount = validateFingers(), hasEndPoint = validateEndPoint(), didCancel = didSwipeBackToCancel(), valid = !didCancel && hasEndPoint && hasCorrectFingerCount && hasValidDistance && hasValidTime;
      return valid;
    }
    function hasSwipes() {
      return !!(options.swipe || options.swipeStatus || options.swipeLeft || options.swipeRight || options.swipeUp || options.swipeDown);
    }
    function didSwipe() {
      return !(!validateSwipe() || !hasSwipes());
    }
    function validateFingers() {
      return fingerCount === options.fingers || options.fingers === ALL_FINGERS || !SUPPORTS_TOUCH;
    }
    function validateEndPoint() {
      return fingerData[0].end.x !== 0;
    }
    function hasTap() {
      return !!options.tap;
    }
    function hasDoubleTap() {
      return !!options.doubleTap;
    }
    function hasLongTap() {
      return !!options.longTap;
    }
    function validateDoubleTap() {
      if (doubleTapStartTime == null)
        return false;
      var now = getTimeStamp();
      return hasDoubleTap() && now - doubleTapStartTime <= options.doubleTapThreshold;
    }
    function inDoubleTap() {
      return validateDoubleTap();
    }
    function validateTap() {
      return (fingerCount === 1 || !SUPPORTS_TOUCH) && (isNaN(distance) || distance < options.threshold);
    }
    function validateLongTap() {
      return duration > options.longTapThreshold && DOUBLE_TAP_THRESHOLD > distance;
    }
    function didTap() {
      return !(!validateTap() || !hasTap());
    }
    function didDoubleTap() {
      return !(!validateDoubleTap() || !hasDoubleTap());
    }
    function didLongTap() {
      return !(!validateLongTap() || !hasLongTap());
    }
    function startMultiFingerRelease(event) {
      previousTouchEndTime = getTimeStamp(), fingerCountAtRelease = event.touches.length + 1;
    }
    function cancelMultiFingerRelease() {
      previousTouchEndTime = 0, fingerCountAtRelease = 0;
    }
    function inMultiFingerRelease() {
      var withinThreshold = false;
      if (previousTouchEndTime) {
        var diff = getTimeStamp() - previousTouchEndTime;
        diff <= options.fingerReleaseThreshold && (withinThreshold = true);
      }
      return withinThreshold;
    }
    function getTouchInProgress() {
      return !($element.data(PLUGIN_NS + "_intouch") !== true);
    }
    function setTouchInProgress(val) {
      $element && (val === true ? ($element.on(MOVE_EV, touchMove), $element.on(END_EV, touchEnd), LEAVE_EV && $element.on(LEAVE_EV, touchLeave)) : ($element.off(MOVE_EV, touchMove, false), $element.off(END_EV, touchEnd, false), LEAVE_EV && $element.off(LEAVE_EV, touchLeave, false)), $element.data(PLUGIN_NS + "_intouch", val === true));
    }
    function createFingerData(id, evt) {
      var f = { start: { x: 0, y: 0 }, last: { x: 0, y: 0 }, end: { x: 0, y: 0 } };
      return f.start.x = f.last.x = f.end.x = evt.pageX || evt.clientX, f.start.y = f.last.y = f.end.y = evt.pageY || evt.clientY, fingerData[id] = f, f;
    }
    function updateFingerData(evt) {
      var id = evt.identifier !== void 0 ? evt.identifier : 0, f = getFingerData(id);
      return f === null && (f = createFingerData(id, evt)), f.last.x = f.end.x, f.last.y = f.end.y, f.end.x = evt.pageX || evt.clientX, f.end.y = evt.pageY || evt.clientY, f;
    }
    function getFingerData(id) {
      return fingerData[id] || null;
    }
    function setMaxDistance(direction2, distance2) {
      direction2 != NONE && (distance2 = Math.max(distance2, getMaxDistance(direction2)), maximumsMap[direction2].distance = distance2);
    }
    function getMaxDistance(direction2) {
      return maximumsMap[direction2] ? maximumsMap[direction2].distance : void 0;
    }
    function createMaximumsData() {
      var maxData = {};
      return maxData[LEFT] = createMaximumVO(LEFT), maxData[RIGHT] = createMaximumVO(RIGHT), maxData[UP] = createMaximumVO(UP), maxData[DOWN] = createMaximumVO(DOWN), maxData;
    }
    function createMaximumVO(dir) {
      return { direction: dir, distance: 0 };
    }
    function calculateDuration() {
      return endTime - startTime;
    }
    function calculateTouchesDistance(startPoint, endPoint) {
      var diffX = Math.abs(startPoint.x - endPoint.x), diffY = Math.abs(startPoint.y - endPoint.y);
      return Math.round(Math.sqrt(diffX * diffX + diffY * diffY));
    }
    function calculatePinchZoom(startDistance, endDistance) {
      var percent = endDistance / startDistance * 1;
      return percent.toFixed(2);
    }
    function calculatePinchDirection() {
      return 1 > pinchZoom ? OUT : IN;
    }
    function calculateDistance(startPoint, endPoint) {
      return Math.round(Math.sqrt(Math.pow(endPoint.x - startPoint.x, 2) + Math.pow(endPoint.y - startPoint.y, 2)));
    }
    function calculateAngle(startPoint, endPoint) {
      var x = startPoint.x - endPoint.x, y = endPoint.y - startPoint.y, r = Math.atan2(y, x), angle = Math.round(180 * r / Math.PI);
      return 0 > angle && (angle = 360 - Math.abs(angle)), angle;
    }
    function calculateDirection(startPoint, endPoint) {
      if (comparePoints(startPoint, endPoint))
        return NONE;
      var angle = calculateAngle(startPoint, endPoint);
      return 45 >= angle && angle >= 0 ? LEFT : 360 >= angle && angle >= 315 ? LEFT : angle >= 135 && 225 >= angle ? RIGHT : angle > 45 && 135 > angle ? DOWN : UP;
    }
    function getTimeStamp() {
      var now = new Date();
      return now.getTime();
    }
    function getbounds(el) {
      el = $(el);
      var offset = el.offset(), bounds = { left: offset.left, right: offset.left + el.outerWidth(), top: offset.top, bottom: offset.top + el.outerHeight() };
      return bounds;
    }
    function isInBounds(point, bounds) {
      return point.x > bounds.left && point.x < bounds.right && point.y > bounds.top && point.y < bounds.bottom;
    }
    function comparePoints(pointA, pointB) {
      return pointA.x == pointB.x && pointA.y == pointB.y;
    }
    var options = $.extend({}, options), useTouchEvents = SUPPORTS_TOUCH || SUPPORTS_POINTER || !options.fallbackToMouseEvents, START_EV = useTouchEvents ? SUPPORTS_POINTER ? SUPPORTS_POINTER_IE10 ? "MSPointerDown" : "pointerdown" : "touchstart" : "mousedown", MOVE_EV = useTouchEvents ? SUPPORTS_POINTER ? SUPPORTS_POINTER_IE10 ? "MSPointerMove" : "pointermove" : "touchmove" : "mousemove", END_EV = useTouchEvents ? SUPPORTS_POINTER ? SUPPORTS_POINTER_IE10 ? "MSPointerUp" : "pointerup" : "touchend" : "mouseup", LEAVE_EV = useTouchEvents ? SUPPORTS_POINTER ? "mouseleave" : null : "mouseleave", CANCEL_EV = SUPPORTS_POINTER ? SUPPORTS_POINTER_IE10 ? "MSPointerCancel" : "pointercancel" : "touchcancel", distance = 0, direction = null, currentDirection = null, duration = 0, startTouchesDistance = 0, endTouchesDistance = 0, pinchZoom = 1, pinchDistance = 0, pinchDirection = 0, maximumsMap = null, $element = $(element), phase = "start", fingerCount = 0, fingerData = {}, startTime = 0, endTime = 0, previousTouchEndTime = 0, fingerCountAtRelease = 0, doubleTapStartTime = 0, singleTapTimeout = null, holdTimeout = null;
    try {
      $element.on(START_EV, touchStart), $element.on(CANCEL_EV, touchCancel);
    } catch (e) {
      $.error("events not supported " + START_EV + "," + CANCEL_EV + " on jQuery.swipe");
    }
    this.enable = function() {
      return this.disable(), $element.on(START_EV, touchStart), $element.on(CANCEL_EV, touchCancel), $element;
    }, this.disable = function() {
      return removeListeners(), $element;
    }, this.destroy = function() {
      removeListeners(), $element.data(PLUGIN_NS, null), $element = null;
    }, this.option = function(property, value) {
      if (typeof property == "object")
        options = $.extend(options, property);
      else if (options[property] !== void 0) {
        if (value === void 0)
          return options[property];
        options[property] = value;
      } else {
        if (!property)
          return options;
        $.error("Option " + property + " does not exist on jQuery.swipe.options");
      }
      return null;
    };
  }
  var VERSION = "1.6.18", LEFT = "left", RIGHT = "right", UP = "up", DOWN = "down", IN = "in", OUT = "out", NONE = "none", AUTO = "auto", SWIPE = "swipe", PINCH = "pinch", TAP = "tap", DOUBLE_TAP = "doubletap", LONG_TAP = "longtap", HORIZONTAL = "horizontal", VERTICAL = "vertical", ALL_FINGERS = "all", DOUBLE_TAP_THRESHOLD = 10, PHASE_START = "start", PHASE_MOVE = "move", PHASE_END = "end", PHASE_CANCEL = "cancel", SUPPORTS_TOUCH = "ontouchstart" in window, SUPPORTS_POINTER_IE10 = window.navigator.msPointerEnabled && !window.PointerEvent && !SUPPORTS_TOUCH, SUPPORTS_POINTER = (window.PointerEvent || window.navigator.msPointerEnabled) && !SUPPORTS_TOUCH, PLUGIN_NS = "TouchSwipe", defaults = { fingers: 1, threshold: 75, cancelThreshold: null, pinchThreshold: 20, maxTimeThreshold: null, fingerReleaseThreshold: 250, longTapThreshold: 500, doubleTapThreshold: 200, swipe: null, swipeLeft: null, swipeRight: null, swipeUp: null, swipeDown: null, swipeStatus: null, pinchIn: null, pinchOut: null, pinchStatus: null, click: null, tap: null, doubleTap: null, longTap: null, hold: null, triggerOnTouchEnd: true, triggerOnTouchLeave: false, allowPageScroll: "auto", fallbackToMouseEvents: true, excludedElements: ".noSwipe", preventDefaultEvents: true };
  $.fn.swipe = function(method) {
    var $this = $(this), plugin = $this.data(PLUGIN_NS);
    if (plugin && typeof method == "string") {
      if (plugin[method])
        return plugin[method].apply(plugin, Array.prototype.slice.call(arguments, 1));
      $.error("Method " + method + " does not exist on jQuery.swipe");
    } else if (plugin && typeof method == "object")
      plugin.option.apply(plugin, arguments);
    else if (!(plugin || typeof method != "object" && method))
      return init.apply(this, arguments);
    return $this;
  }, $.fn.swipe.version = VERSION, $.fn.swipe.defaults = defaults, $.fn.swipe.phases = { PHASE_START, PHASE_MOVE, PHASE_END, PHASE_CANCEL }, $.fn.swipe.directions = { LEFT, RIGHT, UP, DOWN, IN, OUT }, $.fn.swipe.pageScroll = { NONE, HORIZONTAL, VERTICAL, AUTO }, $.fn.swipe.fingers = { ONE: 1, TWO: 2, THREE: 3, FOUR: 4, FIVE: 5, ALL: ALL_FINGERS };
});


/***/ }),

/***/ "./node_modules/sprintf-js/src/sprintf.js":
/*!************************************************!*\
  !*** ./node_modules/sprintf-js/src/sprintf.js ***!
  \************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_RESULT__;!function() {
  "use strict";
  var re = {
    not_string: /[^s]/,
    not_bool: /[^t]/,
    not_type: /[^T]/,
    not_primitive: /[^v]/,
    number: /[diefg]/,
    numeric_arg: /[bcdiefguxX]/,
    json: /[j]/,
    not_json: /[^j]/,
    text: /^[^\x25]+/,
    modulo: /^\x25{2}/,
    placeholder: /^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,
    key: /^([a-z_][a-z_\d]*)/i,
    key_access: /^\.([a-z_][a-z_\d]*)/i,
    index_access: /^\[(\d+)\]/,
    sign: /^[+-]/
  };
  function sprintf(key) {
    return sprintf_format(sprintf_parse(key), arguments);
  }
  function vsprintf(fmt, argv) {
    return sprintf.apply(null, [fmt].concat(argv || []));
  }
  function sprintf_format(parse_tree, argv) {
    var cursor = 1, tree_length = parse_tree.length, arg, output = "", i, k, ph, pad, pad_character, pad_length, is_positive, sign;
    for (i = 0; i < tree_length; i++) {
      if (typeof parse_tree[i] === "string") {
        output += parse_tree[i];
      } else if (typeof parse_tree[i] === "object") {
        ph = parse_tree[i];
        if (ph.keys) {
          arg = argv[cursor];
          for (k = 0; k < ph.keys.length; k++) {
            if (arg == void 0) {
              throw new Error(sprintf('[sprintf] Cannot access property "%s" of undefined value "%s"', ph.keys[k], ph.keys[k - 1]));
            }
            arg = arg[ph.keys[k]];
          }
        } else if (ph.param_no) {
          arg = argv[ph.param_no];
        } else {
          arg = argv[cursor++];
        }
        if (re.not_type.test(ph.type) && re.not_primitive.test(ph.type) && arg instanceof Function) {
          arg = arg();
        }
        if (re.numeric_arg.test(ph.type) && (typeof arg !== "number" && isNaN(arg))) {
          throw new TypeError(sprintf("[sprintf] expecting number but found %T", arg));
        }
        if (re.number.test(ph.type)) {
          is_positive = arg >= 0;
        }
        switch (ph.type) {
          case "b":
            arg = parseInt(arg, 10).toString(2);
            break;
          case "c":
            arg = String.fromCharCode(parseInt(arg, 10));
            break;
          case "d":
          case "i":
            arg = parseInt(arg, 10);
            break;
          case "j":
            arg = JSON.stringify(arg, null, ph.width ? parseInt(ph.width) : 0);
            break;
          case "e":
            arg = ph.precision ? parseFloat(arg).toExponential(ph.precision) : parseFloat(arg).toExponential();
            break;
          case "f":
            arg = ph.precision ? parseFloat(arg).toFixed(ph.precision) : parseFloat(arg);
            break;
          case "g":
            arg = ph.precision ? String(Number(arg.toPrecision(ph.precision))) : parseFloat(arg);
            break;
          case "o":
            arg = (parseInt(arg, 10) >>> 0).toString(8);
            break;
          case "s":
            arg = String(arg);
            arg = ph.precision ? arg.substring(0, ph.precision) : arg;
            break;
          case "t":
            arg = String(!!arg);
            arg = ph.precision ? arg.substring(0, ph.precision) : arg;
            break;
          case "T":
            arg = Object.prototype.toString.call(arg).slice(8, -1).toLowerCase();
            arg = ph.precision ? arg.substring(0, ph.precision) : arg;
            break;
          case "u":
            arg = parseInt(arg, 10) >>> 0;
            break;
          case "v":
            arg = arg.valueOf();
            arg = ph.precision ? arg.substring(0, ph.precision) : arg;
            break;
          case "x":
            arg = (parseInt(arg, 10) >>> 0).toString(16);
            break;
          case "X":
            arg = (parseInt(arg, 10) >>> 0).toString(16).toUpperCase();
            break;
        }
        if (re.json.test(ph.type)) {
          output += arg;
        } else {
          if (re.number.test(ph.type) && (!is_positive || ph.sign)) {
            sign = is_positive ? "+" : "-";
            arg = arg.toString().replace(re.sign, "");
          } else {
            sign = "";
          }
          pad_character = ph.pad_char ? ph.pad_char === "0" ? "0" : ph.pad_char.charAt(1) : " ";
          pad_length = ph.width - (sign + arg).length;
          pad = ph.width ? pad_length > 0 ? pad_character.repeat(pad_length) : "" : "";
          output += ph.align ? sign + arg + pad : pad_character === "0" ? sign + pad + arg : pad + sign + arg;
        }
      }
    }
    return output;
  }
  var sprintf_cache = Object.create(null);
  function sprintf_parse(fmt) {
    if (sprintf_cache[fmt]) {
      return sprintf_cache[fmt];
    }
    var _fmt = fmt, match, parse_tree = [], arg_names = 0;
    while (_fmt) {
      if ((match = re.text.exec(_fmt)) !== null) {
        parse_tree.push(match[0]);
      } else if ((match = re.modulo.exec(_fmt)) !== null) {
        parse_tree.push("%");
      } else if ((match = re.placeholder.exec(_fmt)) !== null) {
        if (match[2]) {
          arg_names |= 1;
          var field_list = [], replacement_field = match[2], field_match = [];
          if ((field_match = re.key.exec(replacement_field)) !== null) {
            field_list.push(field_match[1]);
            while ((replacement_field = replacement_field.substring(field_match[0].length)) !== "") {
              if ((field_match = re.key_access.exec(replacement_field)) !== null) {
                field_list.push(field_match[1]);
              } else if ((field_match = re.index_access.exec(replacement_field)) !== null) {
                field_list.push(field_match[1]);
              } else {
                throw new SyntaxError("[sprintf] failed to parse named argument key");
              }
            }
          } else {
            throw new SyntaxError("[sprintf] failed to parse named argument key");
          }
          match[2] = field_list;
        } else {
          arg_names |= 2;
        }
        if (arg_names === 3) {
          throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");
        }
        parse_tree.push({
          placeholder: match[0],
          param_no: match[1],
          keys: match[2],
          sign: match[3],
          pad_char: match[4],
          align: match[5],
          width: match[6],
          precision: match[7],
          type: match[8]
        });
      } else {
        throw new SyntaxError("[sprintf] unexpected placeholder");
      }
      _fmt = _fmt.substring(match[0].length);
    }
    return sprintf_cache[fmt] = parse_tree;
  }
  if (true) {
    exports.sprintf = sprintf;
    exports.vsprintf = vsprintf;
  }
  if (typeof window !== "undefined") {
    window["sprintf"] = sprintf;
    window["vsprintf"] = vsprintf;
    if (true) {
      !(__WEBPACK_AMD_DEFINE_RESULT__ = (function() {
        return {
          "sprintf": sprintf,
          "vsprintf": vsprintf
        };
      }).call(exports, __webpack_require__, exports, module),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    }
  }
}();


/***/ }),

/***/ "./node_modules/esbuild-loader/dist/index.js!./node_modules/tether/dist/js/tether.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/esbuild-loader/dist/index.js!./node_modules/tether/dist/js/tether.js ***!
  \*******************************************************************************************/
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! tether 1.4.7 */
(function(root, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}
})(this, function() {
  "use strict";
  var _createClass = function() {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor)
          descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    return function(Constructor, protoProps, staticProps) {
      if (protoProps)
        defineProperties(Constructor.prototype, protoProps);
      if (staticProps)
        defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();
  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }
  var TetherBase = void 0;
  if (typeof TetherBase === "undefined") {
    TetherBase = { modules: [] };
  }
  var zeroElement = null;
  function getActualBoundingClientRect(node) {
    var boundingRect = node.getBoundingClientRect();
    var rect = {};
    for (var k in boundingRect) {
      rect[k] = boundingRect[k];
    }
    try {
      if (node.ownerDocument !== document) {
        var _frameElement = node.ownerDocument.defaultView.frameElement;
        if (_frameElement) {
          var frameRect = getActualBoundingClientRect(_frameElement);
          rect.top += frameRect.top;
          rect.bottom += frameRect.top;
          rect.left += frameRect.left;
          rect.right += frameRect.left;
        }
      }
    } catch (err) {
    }
    return rect;
  }
  function getScrollParents(el) {
    var computedStyle = getComputedStyle(el) || {};
    var position2 = computedStyle.position;
    var parents = [];
    if (position2 === "fixed") {
      return [el];
    }
    var parent = el;
    while ((parent = parent.parentNode) && parent && parent.nodeType === 1) {
      var style = void 0;
      try {
        style = getComputedStyle(parent);
      } catch (err) {
      }
      if (typeof style === "undefined" || style === null) {
        parents.push(parent);
        return parents;
      }
      var _style = style;
      var overflow = _style.overflow;
      var overflowX = _style.overflowX;
      var overflowY = _style.overflowY;
      if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
        if (position2 !== "absolute" || ["relative", "absolute", "fixed"].indexOf(style.position) >= 0) {
          parents.push(parent);
        }
      }
    }
    parents.push(el.ownerDocument.body);
    if (el.ownerDocument !== document) {
      parents.push(el.ownerDocument.defaultView);
    }
    return parents;
  }
  var uniqueId = function() {
    var id = 0;
    return function() {
      return ++id;
    };
  }();
  var zeroPosCache = {};
  var getOrigin = function getOrigin2() {
    var node = zeroElement;
    if (!node || !document.body.contains(node)) {
      node = document.createElement("div");
      node.setAttribute("data-tether-id", uniqueId());
      extend(node.style, {
        top: 0,
        left: 0,
        position: "absolute"
      });
      document.body.appendChild(node);
      zeroElement = node;
    }
    var id = node.getAttribute("data-tether-id");
    if (typeof zeroPosCache[id] === "undefined") {
      zeroPosCache[id] = getActualBoundingClientRect(node);
      defer(function() {
        delete zeroPosCache[id];
      });
    }
    return zeroPosCache[id];
  };
  function removeUtilElements() {
    if (zeroElement) {
      document.body.removeChild(zeroElement);
    }
    zeroElement = null;
  }
  ;
  function getBounds(el) {
    var doc = void 0;
    if (el === document) {
      doc = document;
      el = document.documentElement;
    } else {
      doc = el.ownerDocument;
    }
    var docEl = doc.documentElement;
    var box = getActualBoundingClientRect(el);
    var origin = getOrigin();
    box.top -= origin.top;
    box.left -= origin.left;
    if (typeof box.width === "undefined") {
      box.width = document.body.scrollWidth - box.left - box.right;
    }
    if (typeof box.height === "undefined") {
      box.height = document.body.scrollHeight - box.top - box.bottom;
    }
    box.top = box.top - docEl.clientTop;
    box.left = box.left - docEl.clientLeft;
    box.right = doc.body.clientWidth - box.width - box.left;
    box.bottom = doc.body.clientHeight - box.height - box.top;
    return box;
  }
  function getOffsetParent(el) {
    return el.offsetParent || document.documentElement;
  }
  var _scrollBarSize = null;
  function getScrollBarSize() {
    if (_scrollBarSize) {
      return _scrollBarSize;
    }
    var inner = document.createElement("div");
    inner.style.width = "100%";
    inner.style.height = "200px";
    var outer = document.createElement("div");
    extend(outer.style, {
      position: "absolute",
      top: 0,
      left: 0,
      pointerEvents: "none",
      visibility: "hidden",
      width: "200px",
      height: "150px",
      overflow: "hidden"
    });
    outer.appendChild(inner);
    document.body.appendChild(outer);
    var widthContained = inner.offsetWidth;
    outer.style.overflow = "scroll";
    var widthScroll = inner.offsetWidth;
    if (widthContained === widthScroll) {
      widthScroll = outer.clientWidth;
    }
    document.body.removeChild(outer);
    var width = widthContained - widthScroll;
    _scrollBarSize = { width, height: width };
    return _scrollBarSize;
  }
  function extend() {
    var out = arguments.length <= 0 || arguments[0] === void 0 ? {} : arguments[0];
    var args = [];
    Array.prototype.push.apply(args, arguments);
    args.slice(1).forEach(function(obj) {
      if (obj) {
        for (var key in obj) {
          if ({}.hasOwnProperty.call(obj, key)) {
            out[key] = obj[key];
          }
        }
      }
    });
    return out;
  }
  function removeClass(el, name) {
    if (typeof el.classList !== "undefined") {
      name.split(" ").forEach(function(cls) {
        if (cls.trim()) {
          el.classList.remove(cls);
        }
      });
    } else {
      var regex = new RegExp("(^| )" + name.split(" ").join("|") + "( |$)", "gi");
      var className = getClassName(el).replace(regex, " ");
      setClassName(el, className);
    }
  }
  function addClass(el, name) {
    if (typeof el.classList !== "undefined") {
      name.split(" ").forEach(function(cls2) {
        if (cls2.trim()) {
          el.classList.add(cls2);
        }
      });
    } else {
      removeClass(el, name);
      var cls = getClassName(el) + (" " + name);
      setClassName(el, cls);
    }
  }
  function hasClass(el, name) {
    if (typeof el.classList !== "undefined") {
      return el.classList.contains(name);
    }
    var className = getClassName(el);
    return new RegExp("(^| )" + name + "( |$)", "gi").test(className);
  }
  function getClassName(el) {
    if (el.className instanceof el.ownerDocument.defaultView.SVGAnimatedString) {
      return el.className.baseVal;
    }
    return el.className;
  }
  function setClassName(el, className) {
    el.setAttribute("class", className);
  }
  function updateClasses(el, add, all) {
    all.forEach(function(cls) {
      if (add.indexOf(cls) === -1 && hasClass(el, cls)) {
        removeClass(el, cls);
      }
    });
    add.forEach(function(cls) {
      if (!hasClass(el, cls)) {
        addClass(el, cls);
      }
    });
  }
  var deferred = [];
  var defer = function defer2(fn) {
    deferred.push(fn);
  };
  var flush = function flush2() {
    var fn = void 0;
    while (fn = deferred.pop()) {
      fn();
    }
  };
  var Evented = function() {
    function Evented2() {
      _classCallCheck(this, Evented2);
    }
    _createClass(Evented2, [{
      key: "on",
      value: function on(event, handler, ctx) {
        var once = arguments.length <= 3 || arguments[3] === void 0 ? false : arguments[3];
        if (typeof this.bindings === "undefined") {
          this.bindings = {};
        }
        if (typeof this.bindings[event] === "undefined") {
          this.bindings[event] = [];
        }
        this.bindings[event].push({ handler, ctx, once });
      }
    }, {
      key: "once",
      value: function once(event, handler, ctx) {
        this.on(event, handler, ctx, true);
      }
    }, {
      key: "off",
      value: function off(event, handler) {
        if (typeof this.bindings === "undefined" || typeof this.bindings[event] === "undefined") {
          return;
        }
        if (typeof handler === "undefined") {
          delete this.bindings[event];
        } else {
          var i = 0;
          while (i < this.bindings[event].length) {
            if (this.bindings[event][i].handler === handler) {
              this.bindings[event].splice(i, 1);
            } else {
              ++i;
            }
          }
        }
      }
    }, {
      key: "trigger",
      value: function trigger(event) {
        if (typeof this.bindings !== "undefined" && this.bindings[event]) {
          var i = 0;
          for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
          }
          while (i < this.bindings[event].length) {
            var _bindings$event$i = this.bindings[event][i];
            var handler = _bindings$event$i.handler;
            var ctx = _bindings$event$i.ctx;
            var once = _bindings$event$i.once;
            var context = ctx;
            if (typeof context === "undefined") {
              context = this;
            }
            handler.apply(context, args);
            if (once) {
              this.bindings[event].splice(i, 1);
            } else {
              ++i;
            }
          }
        }
      }
    }]);
    return Evented2;
  }();
  TetherBase.Utils = {
    getActualBoundingClientRect,
    getScrollParents,
    getBounds,
    getOffsetParent,
    extend,
    addClass,
    removeClass,
    hasClass,
    updateClasses,
    defer,
    flush,
    uniqueId,
    Evented,
    getScrollBarSize,
    removeUtilElements
  };
  "use strict";
  var _slicedToArray = function() {
    function sliceIterator(arr, i) {
      var _arr = [];
      var _n = true;
      var _d = false;
      var _e = void 0;
      try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);
          if (i && _arr.length === i)
            break;
        }
      } catch (err) {
        _d = true;
        _e = err;
      } finally {
        try {
          if (!_n && _i["return"])
            _i["return"]();
        } finally {
          if (_d)
            throw _e;
        }
      }
      return _arr;
    }
    return function(arr, i) {
      if (Array.isArray(arr)) {
        return arr;
      } else if (Symbol.iterator in Object(arr)) {
        return sliceIterator(arr, i);
      } else {
        throw new TypeError("Invalid attempt to destructure non-iterable instance");
      }
    };
  }();
  var _createClass = function() {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor)
          descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    return function(Constructor, protoProps, staticProps) {
      if (protoProps)
        defineProperties(Constructor.prototype, protoProps);
      if (staticProps)
        defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();
  var _get = function get(_x6, _x7, _x8) {
    var _again = true;
    _function:
      while (_again) {
        var object = _x6, property = _x7, receiver = _x8;
        _again = false;
        if (object === null)
          object = Function.prototype;
        var desc = Object.getOwnPropertyDescriptor(object, property);
        if (desc === void 0) {
          var parent = Object.getPrototypeOf(object);
          if (parent === null) {
            return void 0;
          } else {
            _x6 = parent;
            _x7 = property;
            _x8 = receiver;
            _again = true;
            desc = parent = void 0;
            continue _function;
          }
        } else if ("value" in desc) {
          return desc.value;
        } else {
          var getter = desc.get;
          if (getter === void 0) {
            return void 0;
          }
          return getter.call(receiver);
        }
      }
  };
  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }
  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });
    if (superClass)
      Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }
  if (typeof TetherBase === "undefined") {
    throw new Error("You must include the utils.js file before tether.js");
  }
  var _TetherBase$Utils = TetherBase.Utils;
  var getScrollParents = _TetherBase$Utils.getScrollParents;
  var getBounds = _TetherBase$Utils.getBounds;
  var getOffsetParent = _TetherBase$Utils.getOffsetParent;
  var extend = _TetherBase$Utils.extend;
  var addClass = _TetherBase$Utils.addClass;
  var removeClass = _TetherBase$Utils.removeClass;
  var updateClasses = _TetherBase$Utils.updateClasses;
  var defer = _TetherBase$Utils.defer;
  var flush = _TetherBase$Utils.flush;
  var getScrollBarSize = _TetherBase$Utils.getScrollBarSize;
  var removeUtilElements = _TetherBase$Utils.removeUtilElements;
  function within(a, b) {
    var diff = arguments.length <= 2 || arguments[2] === void 0 ? 1 : arguments[2];
    return a + diff >= b && b >= a - diff;
  }
  var transformKey = function() {
    if (typeof document === "undefined") {
      return "";
    }
    var el = document.createElement("div");
    var transforms = ["transform", "WebkitTransform", "OTransform", "MozTransform", "msTransform"];
    for (var i = 0; i < transforms.length; ++i) {
      var key = transforms[i];
      if (el.style[key] !== void 0) {
        return key;
      }
    }
  }();
  var tethers = [];
  var position = function position2() {
    tethers.forEach(function(tether) {
      tether.position(false);
    });
    flush();
  };
  function now() {
    if (typeof performance === "object" && typeof performance.now === "function") {
      return performance.now();
    }
    return +new Date();
  }
  (function() {
    var lastCall = null;
    var lastDuration = null;
    var pendingTimeout = null;
    var tick = function tick2() {
      if (typeof lastDuration !== "undefined" && lastDuration > 16) {
        lastDuration = Math.min(lastDuration - 16, 250);
        pendingTimeout = setTimeout(tick2, 250);
        return;
      }
      if (typeof lastCall !== "undefined" && now() - lastCall < 10) {
        return;
      }
      if (pendingTimeout != null) {
        clearTimeout(pendingTimeout);
        pendingTimeout = null;
      }
      lastCall = now();
      position();
      lastDuration = now() - lastCall;
    };
    if (typeof window !== "undefined" && typeof window.addEventListener !== "undefined") {
      ["resize", "scroll", "touchmove"].forEach(function(event) {
        window.addEventListener(event, tick);
      });
    }
  })();
  var MIRROR_LR = {
    center: "center",
    left: "right",
    right: "left"
  };
  var MIRROR_TB = {
    middle: "middle",
    top: "bottom",
    bottom: "top"
  };
  var OFFSET_MAP = {
    top: 0,
    left: 0,
    middle: "50%",
    center: "50%",
    bottom: "100%",
    right: "100%"
  };
  var autoToFixedAttachment = function autoToFixedAttachment2(attachment, relativeToAttachment) {
    var left = attachment.left;
    var top = attachment.top;
    if (left === "auto") {
      left = MIRROR_LR[relativeToAttachment.left];
    }
    if (top === "auto") {
      top = MIRROR_TB[relativeToAttachment.top];
    }
    return { left, top };
  };
  var attachmentToOffset = function attachmentToOffset2(attachment) {
    var left = attachment.left;
    var top = attachment.top;
    if (typeof OFFSET_MAP[attachment.left] !== "undefined") {
      left = OFFSET_MAP[attachment.left];
    }
    if (typeof OFFSET_MAP[attachment.top] !== "undefined") {
      top = OFFSET_MAP[attachment.top];
    }
    return { left, top };
  };
  function addOffset() {
    var out = { top: 0, left: 0 };
    for (var _len = arguments.length, offsets = Array(_len), _key = 0; _key < _len; _key++) {
      offsets[_key] = arguments[_key];
    }
    offsets.forEach(function(_ref) {
      var top = _ref.top;
      var left = _ref.left;
      if (typeof top === "string") {
        top = parseFloat(top, 10);
      }
      if (typeof left === "string") {
        left = parseFloat(left, 10);
      }
      out.top += top;
      out.left += left;
    });
    return out;
  }
  function offsetToPx(offset, size) {
    if (typeof offset.left === "string" && offset.left.indexOf("%") !== -1) {
      offset.left = parseFloat(offset.left, 10) / 100 * size.width;
    }
    if (typeof offset.top === "string" && offset.top.indexOf("%") !== -1) {
      offset.top = parseFloat(offset.top, 10) / 100 * size.height;
    }
    return offset;
  }
  var parseOffset = function parseOffset2(value) {
    var _value$split = value.split(" ");
    var _value$split2 = _slicedToArray(_value$split, 2);
    var top = _value$split2[0];
    var left = _value$split2[1];
    return { top, left };
  };
  var parseAttachment = parseOffset;
  var TetherClass = function(_Evented) {
    _inherits(TetherClass2, _Evented);
    function TetherClass2(options) {
      var _this = this;
      _classCallCheck(this, TetherClass2);
      _get(Object.getPrototypeOf(TetherClass2.prototype), "constructor", this).call(this);
      this.position = this.position.bind(this);
      tethers.push(this);
      this.history = [];
      this.setOptions(options, false);
      TetherBase.modules.forEach(function(module2) {
        if (typeof module2.initialize !== "undefined") {
          module2.initialize.call(_this);
        }
      });
      this.position();
    }
    _createClass(TetherClass2, [{
      key: "getClass",
      value: function getClass() {
        var key = arguments.length <= 0 || arguments[0] === void 0 ? "" : arguments[0];
        var classes = this.options.classes;
        if (typeof classes !== "undefined" && classes[key]) {
          return this.options.classes[key];
        } else if (this.options.classPrefix) {
          return this.options.classPrefix + "-" + key;
        } else {
          return key;
        }
      }
    }, {
      key: "setOptions",
      value: function setOptions(options) {
        var _this2 = this;
        var pos = arguments.length <= 1 || arguments[1] === void 0 ? true : arguments[1];
        var defaults = {
          offset: "0 0",
          targetOffset: "0 0",
          targetAttachment: "auto auto",
          classPrefix: "tether"
        };
        this.options = extend(defaults, options);
        var _options = this.options;
        var element = _options.element;
        var target = _options.target;
        var targetModifier = _options.targetModifier;
        this.element = element;
        this.target = target;
        this.targetModifier = targetModifier;
        if (this.target === "viewport") {
          this.target = document.body;
          this.targetModifier = "visible";
        } else if (this.target === "scroll-handle") {
          this.target = document.body;
          this.targetModifier = "scroll-handle";
        }
        ["element", "target"].forEach(function(key) {
          if (typeof _this2[key] === "undefined") {
            throw new Error("Tether Error: Both element and target must be defined");
          }
          if (typeof _this2[key].jquery !== "undefined") {
            _this2[key] = _this2[key][0];
          } else if (typeof _this2[key] === "string") {
            _this2[key] = document.querySelector(_this2[key]);
          }
        });
        addClass(this.element, this.getClass("element"));
        if (!(this.options.addTargetClasses === false)) {
          addClass(this.target, this.getClass("target"));
        }
        if (!this.options.attachment) {
          throw new Error("Tether Error: You must provide an attachment");
        }
        this.targetAttachment = parseAttachment(this.options.targetAttachment);
        this.attachment = parseAttachment(this.options.attachment);
        this.offset = parseOffset(this.options.offset);
        this.targetOffset = parseOffset(this.options.targetOffset);
        if (typeof this.scrollParents !== "undefined") {
          this.disable();
        }
        if (this.targetModifier === "scroll-handle") {
          this.scrollParents = [this.target];
        } else {
          this.scrollParents = getScrollParents(this.target);
        }
        if (!(this.options.enabled === false)) {
          this.enable(pos);
        }
      }
    }, {
      key: "getTargetBounds",
      value: function getTargetBounds() {
        if (typeof this.targetModifier !== "undefined") {
          if (this.targetModifier === "visible") {
            if (this.target === document.body) {
              return { top: pageYOffset, left: pageXOffset, height: innerHeight, width: innerWidth };
            } else {
              var bounds = getBounds(this.target);
              var out = {
                height: bounds.height,
                width: bounds.width,
                top: bounds.top,
                left: bounds.left
              };
              out.height = Math.min(out.height, bounds.height - (pageYOffset - bounds.top));
              out.height = Math.min(out.height, bounds.height - (bounds.top + bounds.height - (pageYOffset + innerHeight)));
              out.height = Math.min(innerHeight, out.height);
              out.height -= 2;
              out.width = Math.min(out.width, bounds.width - (pageXOffset - bounds.left));
              out.width = Math.min(out.width, bounds.width - (bounds.left + bounds.width - (pageXOffset + innerWidth)));
              out.width = Math.min(innerWidth, out.width);
              out.width -= 2;
              if (out.top < pageYOffset) {
                out.top = pageYOffset;
              }
              if (out.left < pageXOffset) {
                out.left = pageXOffset;
              }
              return out;
            }
          } else if (this.targetModifier === "scroll-handle") {
            var bounds = void 0;
            var target = this.target;
            if (target === document.body) {
              target = document.documentElement;
              bounds = {
                left: pageXOffset,
                top: pageYOffset,
                height: innerHeight,
                width: innerWidth
              };
            } else {
              bounds = getBounds(target);
            }
            var style = getComputedStyle(target);
            var hasBottomScroll = target.scrollWidth > target.clientWidth || [style.overflow, style.overflowX].indexOf("scroll") >= 0 || this.target !== document.body;
            var scrollBottom = 0;
            if (hasBottomScroll) {
              scrollBottom = 15;
            }
            var height = bounds.height - parseFloat(style.borderTopWidth) - parseFloat(style.borderBottomWidth) - scrollBottom;
            var out = {
              width: 15,
              height: height * 0.975 * (height / target.scrollHeight),
              left: bounds.left + bounds.width - parseFloat(style.borderLeftWidth) - 15
            };
            var fitAdj = 0;
            if (height < 408 && this.target === document.body) {
              fitAdj = -11e-5 * Math.pow(height, 2) - 727e-5 * height + 22.58;
            }
            if (this.target !== document.body) {
              out.height = Math.max(out.height, 24);
            }
            var scrollPercentage = this.target.scrollTop / (target.scrollHeight - height);
            out.top = scrollPercentage * (height - out.height - fitAdj) + bounds.top + parseFloat(style.borderTopWidth);
            if (this.target === document.body) {
              out.height = Math.max(out.height, 24);
            }
            return out;
          }
        } else {
          return getBounds(this.target);
        }
      }
    }, {
      key: "clearCache",
      value: function clearCache() {
        this._cache = {};
      }
    }, {
      key: "cache",
      value: function cache(k, getter) {
        if (typeof this._cache === "undefined") {
          this._cache = {};
        }
        if (typeof this._cache[k] === "undefined") {
          this._cache[k] = getter.call(this);
        }
        return this._cache[k];
      }
    }, {
      key: "enable",
      value: function enable() {
        var _this3 = this;
        var pos = arguments.length <= 0 || arguments[0] === void 0 ? true : arguments[0];
        if (!(this.options.addTargetClasses === false)) {
          addClass(this.target, this.getClass("enabled"));
        }
        addClass(this.element, this.getClass("enabled"));
        this.enabled = true;
        this.scrollParents.forEach(function(parent) {
          if (parent !== _this3.target.ownerDocument) {
            parent.addEventListener("scroll", _this3.position);
          }
        });
        if (pos) {
          this.position();
        }
      }
    }, {
      key: "disable",
      value: function disable() {
        var _this4 = this;
        removeClass(this.target, this.getClass("enabled"));
        removeClass(this.element, this.getClass("enabled"));
        this.enabled = false;
        if (typeof this.scrollParents !== "undefined") {
          this.scrollParents.forEach(function(parent) {
            parent.removeEventListener("scroll", _this4.position);
          });
        }
      }
    }, {
      key: "destroy",
      value: function destroy() {
        var _this5 = this;
        this.disable();
        tethers.forEach(function(tether, i) {
          if (tether === _this5) {
            tethers.splice(i, 1);
          }
        });
        if (tethers.length === 0) {
          removeUtilElements();
        }
      }
    }, {
      key: "updateAttachClasses",
      value: function updateAttachClasses(elementAttach, targetAttach) {
        var _this6 = this;
        elementAttach = elementAttach || this.attachment;
        targetAttach = targetAttach || this.targetAttachment;
        var sides = ["left", "top", "bottom", "right", "middle", "center"];
        if (typeof this._addAttachClasses !== "undefined" && this._addAttachClasses.length) {
          this._addAttachClasses.splice(0, this._addAttachClasses.length);
        }
        if (typeof this._addAttachClasses === "undefined") {
          this._addAttachClasses = [];
        }
        var add = this._addAttachClasses;
        if (elementAttach.top) {
          add.push(this.getClass("element-attached") + "-" + elementAttach.top);
        }
        if (elementAttach.left) {
          add.push(this.getClass("element-attached") + "-" + elementAttach.left);
        }
        if (targetAttach.top) {
          add.push(this.getClass("target-attached") + "-" + targetAttach.top);
        }
        if (targetAttach.left) {
          add.push(this.getClass("target-attached") + "-" + targetAttach.left);
        }
        var all = [];
        sides.forEach(function(side) {
          all.push(_this6.getClass("element-attached") + "-" + side);
          all.push(_this6.getClass("target-attached") + "-" + side);
        });
        defer(function() {
          if (!(typeof _this6._addAttachClasses !== "undefined")) {
            return;
          }
          updateClasses(_this6.element, _this6._addAttachClasses, all);
          if (!(_this6.options.addTargetClasses === false)) {
            updateClasses(_this6.target, _this6._addAttachClasses, all);
          }
          delete _this6._addAttachClasses;
        });
      }
    }, {
      key: "position",
      value: function position2() {
        var _this7 = this;
        var flushChanges = arguments.length <= 0 || arguments[0] === void 0 ? true : arguments[0];
        if (!this.enabled) {
          return;
        }
        this.clearCache();
        var targetAttachment = autoToFixedAttachment(this.targetAttachment, this.attachment);
        this.updateAttachClasses(this.attachment, targetAttachment);
        var elementPos = this.cache("element-bounds", function() {
          return getBounds(_this7.element);
        });
        var width = elementPos.width;
        var height = elementPos.height;
        if (width === 0 && height === 0 && typeof this.lastSize !== "undefined") {
          var _lastSize = this.lastSize;
          width = _lastSize.width;
          height = _lastSize.height;
        } else {
          this.lastSize = { width, height };
        }
        var targetPos = this.cache("target-bounds", function() {
          return _this7.getTargetBounds();
        });
        var targetSize = targetPos;
        var offset = offsetToPx(attachmentToOffset(this.attachment), { width, height });
        var targetOffset = offsetToPx(attachmentToOffset(targetAttachment), targetSize);
        var manualOffset = offsetToPx(this.offset, { width, height });
        var manualTargetOffset = offsetToPx(this.targetOffset, targetSize);
        offset = addOffset(offset, manualOffset);
        targetOffset = addOffset(targetOffset, manualTargetOffset);
        var left = targetPos.left + targetOffset.left - offset.left;
        var top = targetPos.top + targetOffset.top - offset.top;
        for (var i = 0; i < TetherBase.modules.length; ++i) {
          var _module2 = TetherBase.modules[i];
          var ret = _module2.position.call(this, {
            left,
            top,
            targetAttachment,
            targetPos,
            elementPos,
            offset,
            targetOffset,
            manualOffset,
            manualTargetOffset,
            scrollbarSize,
            attachment: this.attachment
          });
          if (ret === false) {
            return false;
          } else if (typeof ret === "undefined" || typeof ret !== "object") {
            continue;
          } else {
            top = ret.top;
            left = ret.left;
          }
        }
        var next = {
          page: {
            top,
            left
          },
          viewport: {
            top: top - pageYOffset,
            bottom: pageYOffset - top - height + innerHeight,
            left: left - pageXOffset,
            right: pageXOffset - left - width + innerWidth
          }
        };
        var doc = this.target.ownerDocument;
        var win = doc.defaultView;
        var scrollbarSize = void 0;
        if (win.innerHeight > doc.documentElement.clientHeight) {
          scrollbarSize = this.cache("scrollbar-size", getScrollBarSize);
          next.viewport.bottom -= scrollbarSize.height;
        }
        if (win.innerWidth > doc.documentElement.clientWidth) {
          scrollbarSize = this.cache("scrollbar-size", getScrollBarSize);
          next.viewport.right -= scrollbarSize.width;
        }
        if (["", "static"].indexOf(doc.body.style.position) === -1 || ["", "static"].indexOf(doc.body.parentElement.style.position) === -1) {
          next.page.bottom = doc.body.scrollHeight - top - height;
          next.page.right = doc.body.scrollWidth - left - width;
        }
        if (typeof this.options.optimizations !== "undefined" && this.options.optimizations.moveElement !== false && !(typeof this.targetModifier !== "undefined")) {
          (function() {
            var offsetParent = _this7.cache("target-offsetparent", function() {
              return getOffsetParent(_this7.target);
            });
            var offsetPosition = _this7.cache("target-offsetparent-bounds", function() {
              return getBounds(offsetParent);
            });
            var offsetParentStyle = getComputedStyle(offsetParent);
            var offsetParentSize = offsetPosition;
            var offsetBorder = {};
            ["Top", "Left", "Bottom", "Right"].forEach(function(side) {
              offsetBorder[side.toLowerCase()] = parseFloat(offsetParentStyle["border" + side + "Width"]);
            });
            offsetPosition.right = doc.body.scrollWidth - offsetPosition.left - offsetParentSize.width + offsetBorder.right;
            offsetPosition.bottom = doc.body.scrollHeight - offsetPosition.top - offsetParentSize.height + offsetBorder.bottom;
            if (next.page.top >= offsetPosition.top + offsetBorder.top && next.page.bottom >= offsetPosition.bottom) {
              if (next.page.left >= offsetPosition.left + offsetBorder.left && next.page.right >= offsetPosition.right) {
                var scrollTop = offsetParent.scrollTop;
                var scrollLeft = offsetParent.scrollLeft;
                next.offset = {
                  top: next.page.top - offsetPosition.top + scrollTop - offsetBorder.top,
                  left: next.page.left - offsetPosition.left + scrollLeft - offsetBorder.left
                };
              }
            }
          })();
        }
        this.move(next);
        this.history.unshift(next);
        if (this.history.length > 3) {
          this.history.pop();
        }
        if (flushChanges) {
          flush();
        }
        return true;
      }
    }, {
      key: "move",
      value: function move(pos) {
        var _this8 = this;
        if (!(typeof this.element.parentNode !== "undefined")) {
          return;
        }
        var same = {};
        for (var type in pos) {
          same[type] = {};
          for (var key in pos[type]) {
            var found = false;
            for (var i = 0; i < this.history.length; ++i) {
              var point = this.history[i];
              if (typeof point[type] !== "undefined" && !within(point[type][key], pos[type][key])) {
                found = true;
                break;
              }
            }
            if (!found) {
              same[type][key] = true;
            }
          }
        }
        var css = { top: "", left: "", right: "", bottom: "" };
        var transcribe = function transcribe2(_same, _pos) {
          var hasOptimizations = typeof _this8.options.optimizations !== "undefined";
          var gpu = hasOptimizations ? _this8.options.optimizations.gpu : null;
          if (gpu !== false) {
            var yPos = void 0, xPos = void 0;
            if (_same.top) {
              css.top = 0;
              yPos = _pos.top;
            } else {
              css.bottom = 0;
              yPos = -_pos.bottom;
            }
            if (_same.left) {
              css.left = 0;
              xPos = _pos.left;
            } else {
              css.right = 0;
              xPos = -_pos.right;
            }
            if (typeof window.devicePixelRatio === "number" && devicePixelRatio % 1 === 0) {
              xPos = Math.round(xPos * devicePixelRatio) / devicePixelRatio;
              yPos = Math.round(yPos * devicePixelRatio) / devicePixelRatio;
            }
            css[transformKey] = "translateX(" + xPos + "px) translateY(" + yPos + "px)";
            if (transformKey !== "msTransform") {
              css[transformKey] += " translateZ(0)";
            }
          } else {
            if (_same.top) {
              css.top = _pos.top + "px";
            } else {
              css.bottom = _pos.bottom + "px";
            }
            if (_same.left) {
              css.left = _pos.left + "px";
            } else {
              css.right = _pos.right + "px";
            }
          }
        };
        var moved = false;
        if ((same.page.top || same.page.bottom) && (same.page.left || same.page.right)) {
          css.position = "absolute";
          transcribe(same.page, pos.page);
        } else if ((same.viewport.top || same.viewport.bottom) && (same.viewport.left || same.viewport.right)) {
          css.position = "fixed";
          transcribe(same.viewport, pos.viewport);
        } else if (typeof same.offset !== "undefined" && same.offset.top && same.offset.left) {
          (function() {
            css.position = "absolute";
            var offsetParent = _this8.cache("target-offsetparent", function() {
              return getOffsetParent(_this8.target);
            });
            if (getOffsetParent(_this8.element) !== offsetParent) {
              defer(function() {
                _this8.element.parentNode.removeChild(_this8.element);
                offsetParent.appendChild(_this8.element);
              });
            }
            transcribe(same.offset, pos.offset);
            moved = true;
          })();
        } else {
          css.position = "absolute";
          transcribe({ top: true, left: true }, pos.page);
        }
        if (!moved) {
          if (this.options.bodyElement) {
            if (this.element.parentNode !== this.options.bodyElement) {
              this.options.bodyElement.appendChild(this.element);
            }
          } else {
            var isFullscreenElement = function isFullscreenElement2(e) {
              var d = e.ownerDocument;
              var fe = d.fullscreenElement || d.webkitFullscreenElement || d.mozFullScreenElement || d.msFullscreenElement;
              return fe === e;
            };
            var offsetParentIsBody = true;
            var currentNode = this.element.parentNode;
            while (currentNode && currentNode.nodeType === 1 && currentNode.tagName !== "BODY" && !isFullscreenElement(currentNode)) {
              if (getComputedStyle(currentNode).position !== "static") {
                offsetParentIsBody = false;
                break;
              }
              currentNode = currentNode.parentNode;
            }
            if (!offsetParentIsBody) {
              this.element.parentNode.removeChild(this.element);
              this.element.ownerDocument.body.appendChild(this.element);
            }
          }
        }
        var writeCSS = {};
        var write = false;
        for (var key in css) {
          var val = css[key];
          var elVal = this.element.style[key];
          if (elVal !== val) {
            write = true;
            writeCSS[key] = val;
          }
        }
        if (write) {
          defer(function() {
            extend(_this8.element.style, writeCSS);
            _this8.trigger("repositioned");
          });
        }
      }
    }]);
    return TetherClass2;
  }(Evented);
  TetherClass.modules = [];
  TetherBase.position = position;
  var Tether = extend(TetherClass, TetherBase);
  "use strict";
  var _slicedToArray = function() {
    function sliceIterator(arr, i) {
      var _arr = [];
      var _n = true;
      var _d = false;
      var _e = void 0;
      try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);
          if (i && _arr.length === i)
            break;
        }
      } catch (err) {
        _d = true;
        _e = err;
      } finally {
        try {
          if (!_n && _i["return"])
            _i["return"]();
        } finally {
          if (_d)
            throw _e;
        }
      }
      return _arr;
    }
    return function(arr, i) {
      if (Array.isArray(arr)) {
        return arr;
      } else if (Symbol.iterator in Object(arr)) {
        return sliceIterator(arr, i);
      } else {
        throw new TypeError("Invalid attempt to destructure non-iterable instance");
      }
    };
  }();
  var _TetherBase$Utils = TetherBase.Utils;
  var getBounds = _TetherBase$Utils.getBounds;
  var extend = _TetherBase$Utils.extend;
  var updateClasses = _TetherBase$Utils.updateClasses;
  var defer = _TetherBase$Utils.defer;
  var BOUNDS_FORMAT = ["left", "top", "right", "bottom"];
  function getBoundingRect(tether, to) {
    if (to === "scrollParent") {
      to = tether.scrollParents[0];
    } else if (to === "window") {
      to = [pageXOffset, pageYOffset, innerWidth + pageXOffset, innerHeight + pageYOffset];
    }
    if (to === document) {
      to = to.documentElement;
    }
    if (typeof to.nodeType !== "undefined") {
      (function() {
        var node = to;
        var size = getBounds(to);
        var pos = size;
        var style = getComputedStyle(to);
        to = [pos.left, pos.top, size.width + pos.left, size.height + pos.top];
        if (node.ownerDocument !== document) {
          var win = node.ownerDocument.defaultView;
          to[0] += win.pageXOffset;
          to[1] += win.pageYOffset;
          to[2] += win.pageXOffset;
          to[3] += win.pageYOffset;
        }
        BOUNDS_FORMAT.forEach(function(side, i) {
          side = side[0].toUpperCase() + side.substr(1);
          if (side === "Top" || side === "Left") {
            to[i] += parseFloat(style["border" + side + "Width"]);
          } else {
            to[i] -= parseFloat(style["border" + side + "Width"]);
          }
        });
      })();
    }
    return to;
  }
  TetherBase.modules.push({
    position: function position2(_ref) {
      var _this = this;
      var top = _ref.top;
      var left = _ref.left;
      var targetAttachment = _ref.targetAttachment;
      if (!this.options.constraints) {
        return true;
      }
      var _cache = this.cache("element-bounds", function() {
        return getBounds(_this.element);
      });
      var height = _cache.height;
      var width = _cache.width;
      if (width === 0 && height === 0 && typeof this.lastSize !== "undefined") {
        var _lastSize = this.lastSize;
        width = _lastSize.width;
        height = _lastSize.height;
      }
      var targetSize = this.cache("target-bounds", function() {
        return _this.getTargetBounds();
      });
      var targetHeight = targetSize.height;
      var targetWidth = targetSize.width;
      var allClasses = [this.getClass("pinned"), this.getClass("out-of-bounds")];
      this.options.constraints.forEach(function(constraint) {
        var outOfBoundsClass = constraint.outOfBoundsClass;
        var pinnedClass = constraint.pinnedClass;
        if (outOfBoundsClass) {
          allClasses.push(outOfBoundsClass);
        }
        if (pinnedClass) {
          allClasses.push(pinnedClass);
        }
      });
      allClasses.forEach(function(cls) {
        ["left", "top", "right", "bottom"].forEach(function(side) {
          allClasses.push(cls + "-" + side);
        });
      });
      var addClasses = [];
      var tAttachment = extend({}, targetAttachment);
      var eAttachment = extend({}, this.attachment);
      this.options.constraints.forEach(function(constraint) {
        var to = constraint.to;
        var attachment = constraint.attachment;
        var pin = constraint.pin;
        if (typeof attachment === "undefined") {
          attachment = "";
        }
        var changeAttachX = void 0, changeAttachY = void 0;
        if (attachment.indexOf(" ") >= 0) {
          var _attachment$split = attachment.split(" ");
          var _attachment$split2 = _slicedToArray(_attachment$split, 2);
          changeAttachY = _attachment$split2[0];
          changeAttachX = _attachment$split2[1];
        } else {
          changeAttachX = changeAttachY = attachment;
        }
        var bounds = getBoundingRect(_this, to);
        if (changeAttachY === "target" || changeAttachY === "both") {
          if (top < bounds[1] && tAttachment.top === "top") {
            top += targetHeight;
            tAttachment.top = "bottom";
          }
          if (top + height > bounds[3] && tAttachment.top === "bottom") {
            top -= targetHeight;
            tAttachment.top = "top";
          }
        }
        if (changeAttachY === "together") {
          if (tAttachment.top === "top") {
            if (eAttachment.top === "bottom" && top < bounds[1]) {
              top += targetHeight;
              tAttachment.top = "bottom";
              top += height;
              eAttachment.top = "top";
            } else if (eAttachment.top === "top" && top + height > bounds[3] && top - (height - targetHeight) >= bounds[1]) {
              top -= height - targetHeight;
              tAttachment.top = "bottom";
              eAttachment.top = "bottom";
            }
          }
          if (tAttachment.top === "bottom") {
            if (eAttachment.top === "top" && top + height > bounds[3]) {
              top -= targetHeight;
              tAttachment.top = "top";
              top -= height;
              eAttachment.top = "bottom";
            } else if (eAttachment.top === "bottom" && top < bounds[1] && top + (height * 2 - targetHeight) <= bounds[3]) {
              top += height - targetHeight;
              tAttachment.top = "top";
              eAttachment.top = "top";
            }
          }
          if (tAttachment.top === "middle") {
            if (top + height > bounds[3] && eAttachment.top === "top") {
              top -= height;
              eAttachment.top = "bottom";
            } else if (top < bounds[1] && eAttachment.top === "bottom") {
              top += height;
              eAttachment.top = "top";
            }
          }
        }
        if (changeAttachX === "target" || changeAttachX === "both") {
          if (left < bounds[0] && tAttachment.left === "left") {
            left += targetWidth;
            tAttachment.left = "right";
          }
          if (left + width > bounds[2] && tAttachment.left === "right") {
            left -= targetWidth;
            tAttachment.left = "left";
          }
        }
        if (changeAttachX === "together") {
          if (left < bounds[0] && tAttachment.left === "left") {
            if (eAttachment.left === "right") {
              left += targetWidth;
              tAttachment.left = "right";
              left += width;
              eAttachment.left = "left";
            } else if (eAttachment.left === "left") {
              left += targetWidth;
              tAttachment.left = "right";
              left -= width;
              eAttachment.left = "right";
            }
          } else if (left + width > bounds[2] && tAttachment.left === "right") {
            if (eAttachment.left === "left") {
              left -= targetWidth;
              tAttachment.left = "left";
              left -= width;
              eAttachment.left = "right";
            } else if (eAttachment.left === "right") {
              left -= targetWidth;
              tAttachment.left = "left";
              left += width;
              eAttachment.left = "left";
            }
          } else if (tAttachment.left === "center") {
            if (left + width > bounds[2] && eAttachment.left === "left") {
              left -= width;
              eAttachment.left = "right";
            } else if (left < bounds[0] && eAttachment.left === "right") {
              left += width;
              eAttachment.left = "left";
            }
          }
        }
        if (changeAttachY === "element" || changeAttachY === "both") {
          if (top < bounds[1] && eAttachment.top === "bottom") {
            top += height;
            eAttachment.top = "top";
          }
          if (top + height > bounds[3] && eAttachment.top === "top") {
            top -= height;
            eAttachment.top = "bottom";
          }
        }
        if (changeAttachX === "element" || changeAttachX === "both") {
          if (left < bounds[0]) {
            if (eAttachment.left === "right") {
              left += width;
              eAttachment.left = "left";
            } else if (eAttachment.left === "center") {
              left += width / 2;
              eAttachment.left = "left";
            }
          }
          if (left + width > bounds[2]) {
            if (eAttachment.left === "left") {
              left -= width;
              eAttachment.left = "right";
            } else if (eAttachment.left === "center") {
              left -= width / 2;
              eAttachment.left = "right";
            }
          }
        }
        if (typeof pin === "string") {
          pin = pin.split(",").map(function(p) {
            return p.trim();
          });
        } else if (pin === true) {
          pin = ["top", "left", "right", "bottom"];
        }
        pin = pin || [];
        var pinned = [];
        var oob = [];
        if (top < bounds[1]) {
          if (pin.indexOf("top") >= 0) {
            top = bounds[1];
            pinned.push("top");
          } else {
            oob.push("top");
          }
        }
        if (top + height > bounds[3]) {
          if (pin.indexOf("bottom") >= 0) {
            top = bounds[3] - height;
            pinned.push("bottom");
          } else {
            oob.push("bottom");
          }
        }
        if (left < bounds[0]) {
          if (pin.indexOf("left") >= 0) {
            left = bounds[0];
            pinned.push("left");
          } else {
            oob.push("left");
          }
        }
        if (left + width > bounds[2]) {
          if (pin.indexOf("right") >= 0) {
            left = bounds[2] - width;
            pinned.push("right");
          } else {
            oob.push("right");
          }
        }
        if (pinned.length) {
          (function() {
            var pinnedClass = void 0;
            if (typeof _this.options.pinnedClass !== "undefined") {
              pinnedClass = _this.options.pinnedClass;
            } else {
              pinnedClass = _this.getClass("pinned");
            }
            addClasses.push(pinnedClass);
            pinned.forEach(function(side) {
              addClasses.push(pinnedClass + "-" + side);
            });
          })();
        }
        if (oob.length) {
          (function() {
            var oobClass = void 0;
            if (typeof _this.options.outOfBoundsClass !== "undefined") {
              oobClass = _this.options.outOfBoundsClass;
            } else {
              oobClass = _this.getClass("out-of-bounds");
            }
            addClasses.push(oobClass);
            oob.forEach(function(side) {
              addClasses.push(oobClass + "-" + side);
            });
          })();
        }
        if (pinned.indexOf("left") >= 0 || pinned.indexOf("right") >= 0) {
          eAttachment.left = tAttachment.left = false;
        }
        if (pinned.indexOf("top") >= 0 || pinned.indexOf("bottom") >= 0) {
          eAttachment.top = tAttachment.top = false;
        }
        if (tAttachment.top !== targetAttachment.top || tAttachment.left !== targetAttachment.left || eAttachment.top !== _this.attachment.top || eAttachment.left !== _this.attachment.left) {
          _this.updateAttachClasses(eAttachment, tAttachment);
          _this.trigger("update", {
            attachment: eAttachment,
            targetAttachment: tAttachment
          });
        }
      });
      defer(function() {
        if (!(_this.options.addTargetClasses === false)) {
          updateClasses(_this.target, addClasses, allClasses);
        }
        updateClasses(_this.element, addClasses, allClasses);
      });
      return { top, left };
    }
  });
  "use strict";
  var _TetherBase$Utils = TetherBase.Utils;
  var getBounds = _TetherBase$Utils.getBounds;
  var updateClasses = _TetherBase$Utils.updateClasses;
  var defer = _TetherBase$Utils.defer;
  TetherBase.modules.push({
    position: function position2(_ref) {
      var _this = this;
      var top = _ref.top;
      var left = _ref.left;
      var _cache = this.cache("element-bounds", function() {
        return getBounds(_this.element);
      });
      var height = _cache.height;
      var width = _cache.width;
      var targetPos = this.getTargetBounds();
      var bottom = top + height;
      var right = left + width;
      var abutted = [];
      if (top <= targetPos.bottom && bottom >= targetPos.top) {
        ["left", "right"].forEach(function(side) {
          var targetPosSide = targetPos[side];
          if (targetPosSide === left || targetPosSide === right) {
            abutted.push(side);
          }
        });
      }
      if (left <= targetPos.right && right >= targetPos.left) {
        ["top", "bottom"].forEach(function(side) {
          var targetPosSide = targetPos[side];
          if (targetPosSide === top || targetPosSide === bottom) {
            abutted.push(side);
          }
        });
      }
      var allClasses = [];
      var addClasses = [];
      var sides = ["left", "top", "right", "bottom"];
      allClasses.push(this.getClass("abutted"));
      sides.forEach(function(side) {
        allClasses.push(_this.getClass("abutted") + "-" + side);
      });
      if (abutted.length) {
        addClasses.push(this.getClass("abutted"));
      }
      abutted.forEach(function(side) {
        addClasses.push(_this.getClass("abutted") + "-" + side);
      });
      defer(function() {
        if (!(_this.options.addTargetClasses === false)) {
          updateClasses(_this.target, addClasses, allClasses);
        }
        updateClasses(_this.element, addClasses, allClasses);
      });
      return true;
    }
  });
  "use strict";
  var _slicedToArray = function() {
    function sliceIterator(arr, i) {
      var _arr = [];
      var _n = true;
      var _d = false;
      var _e = void 0;
      try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);
          if (i && _arr.length === i)
            break;
        }
      } catch (err) {
        _d = true;
        _e = err;
      } finally {
        try {
          if (!_n && _i["return"])
            _i["return"]();
        } finally {
          if (_d)
            throw _e;
        }
      }
      return _arr;
    }
    return function(arr, i) {
      if (Array.isArray(arr)) {
        return arr;
      } else if (Symbol.iterator in Object(arr)) {
        return sliceIterator(arr, i);
      } else {
        throw new TypeError("Invalid attempt to destructure non-iterable instance");
      }
    };
  }();
  TetherBase.modules.push({
    position: function position2(_ref) {
      var top = _ref.top;
      var left = _ref.left;
      if (!this.options.shift) {
        return;
      }
      var shift = this.options.shift;
      if (typeof this.options.shift === "function") {
        shift = this.options.shift.call(this, { top, left });
      }
      var shiftTop = void 0, shiftLeft = void 0;
      if (typeof shift === "string") {
        shift = shift.split(" ");
        shift[1] = shift[1] || shift[0];
        var _shift = shift;
        var _shift2 = _slicedToArray(_shift, 2);
        shiftTop = _shift2[0];
        shiftLeft = _shift2[1];
        shiftTop = parseFloat(shiftTop, 10);
        shiftLeft = parseFloat(shiftLeft, 10);
      } else {
        shiftTop = shift.top;
        shiftLeft = shift.left;
      }
      top += shiftTop;
      left += shiftLeft;
      return { top, left };
    }
  });
  return Tether;
});


/***/ }),

/***/ "./node_modules/velocity-animate/velocity.js":
/*!***************************************************!*\
  !*** ./node_modules/velocity-animate/velocity.js ***!
  \***************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! VelocityJS.org (1.5.0). (C) 2014 Julian Shapiro. MIT @license: en.wikipedia.org/wiki/MIT_License */
/*! VelocityJS.org jQuery Shim (1.0.1). (C) 2014 The jQuery Foundation. MIT @license: en.wikipedia.org/wiki/MIT_License. */
(function(window2) {
  "use strict";
  if (window2.jQuery) {
    return;
  }
  var $ = function(selector, context) {
    return new $.fn.init(selector, context);
  };
  $.isWindow = function(obj) {
    return obj && obj === obj.window;
  };
  $.type = function(obj) {
    if (!obj) {
      return obj + "";
    }
    return typeof obj === "object" || typeof obj === "function" ? class2type[toString.call(obj)] || "object" : typeof obj;
  };
  $.isArray = Array.isArray || function(obj) {
    return $.type(obj) === "array";
  };
  function isArraylike(obj) {
    var length = obj.length, type = $.type(obj);
    if (type === "function" || $.isWindow(obj)) {
      return false;
    }
    if (obj.nodeType === 1 && length) {
      return true;
    }
    return type === "array" || length === 0 || typeof length === "number" && length > 0 && length - 1 in obj;
  }
  $.isPlainObject = function(obj) {
    var key;
    if (!obj || $.type(obj) !== "object" || obj.nodeType || $.isWindow(obj)) {
      return false;
    }
    try {
      if (obj.constructor && !hasOwn.call(obj, "constructor") && !hasOwn.call(obj.constructor.prototype, "isPrototypeOf")) {
        return false;
      }
    } catch (e) {
      return false;
    }
    for (key in obj) {
    }
    return key === void 0 || hasOwn.call(obj, key);
  };
  $.each = function(obj, callback, args) {
    var value, i2 = 0, length = obj.length, isArray = isArraylike(obj);
    if (args) {
      if (isArray) {
        for (; i2 < length; i2++) {
          value = callback.apply(obj[i2], args);
          if (value === false) {
            break;
          }
        }
      } else {
        for (i2 in obj) {
          if (!obj.hasOwnProperty(i2)) {
            continue;
          }
          value = callback.apply(obj[i2], args);
          if (value === false) {
            break;
          }
        }
      }
    } else {
      if (isArray) {
        for (; i2 < length; i2++) {
          value = callback.call(obj[i2], i2, obj[i2]);
          if (value === false) {
            break;
          }
        }
      } else {
        for (i2 in obj) {
          if (!obj.hasOwnProperty(i2)) {
            continue;
          }
          value = callback.call(obj[i2], i2, obj[i2]);
          if (value === false) {
            break;
          }
        }
      }
    }
    return obj;
  };
  $.data = function(node, key, value) {
    if (value === void 0) {
      var getId = node[$.expando], store = getId && cache[getId];
      if (key === void 0) {
        return store;
      } else if (store) {
        if (key in store) {
          return store[key];
        }
      }
    } else if (key !== void 0) {
      var setId = node[$.expando] || (node[$.expando] = ++$.uuid);
      cache[setId] = cache[setId] || {};
      cache[setId][key] = value;
      return value;
    }
  };
  $.removeData = function(node, keys) {
    var id = node[$.expando], store = id && cache[id];
    if (store) {
      if (!keys) {
        delete cache[id];
      } else {
        $.each(keys, function(_, key) {
          delete store[key];
        });
      }
    }
  };
  $.extend = function() {
    var src, copyIsArray, copy, name, options, clone, target = arguments[0] || {}, i2 = 1, length = arguments.length, deep = false;
    if (typeof target === "boolean") {
      deep = target;
      target = arguments[i2] || {};
      i2++;
    }
    if (typeof target !== "object" && $.type(target) !== "function") {
      target = {};
    }
    if (i2 === length) {
      target = this;
      i2--;
    }
    for (; i2 < length; i2++) {
      if (options = arguments[i2]) {
        for (name in options) {
          if (!options.hasOwnProperty(name)) {
            continue;
          }
          src = target[name];
          copy = options[name];
          if (target === copy) {
            continue;
          }
          if (deep && copy && ($.isPlainObject(copy) || (copyIsArray = $.isArray(copy)))) {
            if (copyIsArray) {
              copyIsArray = false;
              clone = src && $.isArray(src) ? src : [];
            } else {
              clone = src && $.isPlainObject(src) ? src : {};
            }
            target[name] = $.extend(deep, clone, copy);
          } else if (copy !== void 0) {
            target[name] = copy;
          }
        }
      }
    }
    return target;
  };
  $.queue = function(elem, type, data) {
    function $makeArray(arr, results) {
      var ret = results || [];
      if (arr) {
        if (isArraylike(Object(arr))) {
          (function(first, second) {
            var len = +second.length, j = 0, i2 = first.length;
            while (j < len) {
              first[i2++] = second[j++];
            }
            if (len !== len) {
              while (second[j] !== void 0) {
                first[i2++] = second[j++];
              }
            }
            first.length = i2;
            return first;
          })(ret, typeof arr === "string" ? [arr] : arr);
        } else {
          [].push.call(ret, arr);
        }
      }
      return ret;
    }
    if (!elem) {
      return;
    }
    type = (type || "fx") + "queue";
    var q = $.data(elem, type);
    if (!data) {
      return q || [];
    }
    if (!q || $.isArray(data)) {
      q = $.data(elem, type, $makeArray(data));
    } else {
      q.push(data);
    }
    return q;
  };
  $.dequeue = function(elems, type) {
    $.each(elems.nodeType ? [elems] : elems, function(i2, elem) {
      type = type || "fx";
      var queue = $.queue(elem, type), fn = queue.shift();
      if (fn === "inprogress") {
        fn = queue.shift();
      }
      if (fn) {
        if (type === "fx") {
          queue.unshift("inprogress");
        }
        fn.call(elem, function() {
          $.dequeue(elem, type);
        });
      }
    });
  };
  $.fn = $.prototype = {
    init: function(selector) {
      if (selector.nodeType) {
        this[0] = selector;
        return this;
      } else {
        throw new Error("Not a DOM node.");
      }
    },
    offset: function() {
      var box = this[0].getBoundingClientRect ? this[0].getBoundingClientRect() : { top: 0, left: 0 };
      return {
        top: box.top + (window2.pageYOffset || document.scrollTop || 0) - (document.clientTop || 0),
        left: box.left + (window2.pageXOffset || document.scrollLeft || 0) - (document.clientLeft || 0)
      };
    },
    position: function() {
      function offsetParentFn(elem2) {
        var offsetParent2 = elem2.offsetParent;
        while (offsetParent2 && offsetParent2.nodeName.toLowerCase() !== "html" && offsetParent2.style && offsetParent2.style.position === "static") {
          offsetParent2 = offsetParent2.offsetParent;
        }
        return offsetParent2 || document;
      }
      var elem = this[0], offsetParent = offsetParentFn(elem), offset = this.offset(), parentOffset = /^(?:body|html)$/i.test(offsetParent.nodeName) ? { top: 0, left: 0 } : $(offsetParent).offset();
      offset.top -= parseFloat(elem.style.marginTop) || 0;
      offset.left -= parseFloat(elem.style.marginLeft) || 0;
      if (offsetParent.style) {
        parentOffset.top += parseFloat(offsetParent.style.borderTopWidth) || 0;
        parentOffset.left += parseFloat(offsetParent.style.borderLeftWidth) || 0;
      }
      return {
        top: offset.top - parentOffset.top,
        left: offset.left - parentOffset.left
      };
    }
  };
  var cache = {};
  $.expando = "velocity" + new Date().getTime();
  $.uuid = 0;
  var class2type = {}, hasOwn = class2type.hasOwnProperty, toString = class2type.toString;
  var types = "Boolean Number String Function Array Date RegExp Object Error".split(" ");
  for (var i = 0; i < types.length; i++) {
    class2type["[object " + types[i] + "]"] = types[i].toLowerCase();
  }
  $.fn.init.prototype = $.fn;
  window2.Velocity = { Utilities: $ };
})(window);
(function(factory) {
  "use strict";
  if ( true && typeof module.exports === "object") {
    module.exports = factory();
  } else if (true) {
    !(__WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :
		__WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}
})(function() {
  "use strict";
  return function(global, window2, document2, undefined2) {
    var IE = function() {
      if (document2.documentMode) {
        return document2.documentMode;
      } else {
        for (var i = 7; i > 4; i--) {
          var div = document2.createElement("div");
          div.innerHTML = "<!--[if IE " + i + "]><span></span><![endif]-->";
          if (div.getElementsByTagName("span").length) {
            div = null;
            return i;
          }
        }
      }
      return undefined2;
    }();
    var rAFShim = function() {
      var timeLast = 0;
      return window2.webkitRequestAnimationFrame || window2.mozRequestAnimationFrame || function(callback) {
        var timeCurrent = new Date().getTime(), timeDelta;
        timeDelta = Math.max(0, 16 - (timeCurrent - timeLast));
        timeLast = timeCurrent + timeDelta;
        return setTimeout(function() {
          callback(timeCurrent + timeDelta);
        }, timeDelta);
      };
    }();
    var performance = function() {
      var perf = window2.performance || {};
      if (typeof perf.now !== "function") {
        var nowOffset = perf.timing && perf.timing.navigationStart ? perf.timing.navigationStart : new Date().getTime();
        perf.now = function() {
          return new Date().getTime() - nowOffset;
        };
      }
      return perf;
    }();
    function compactSparseArray(array) {
      var index = -1, length = array ? array.length : 0, result = [];
      while (++index < length) {
        var value = array[index];
        if (value) {
          result.push(value);
        }
      }
      return result;
    }
    var _slice = function() {
      var slice = Array.prototype.slice;
      try {
        slice.call(document2.documentElement);
        return slice;
      } catch (e) {
        return function(begin, end) {
          var len = this.length;
          if (typeof begin !== "number") {
            begin = 0;
          }
          if (typeof end !== "number") {
            end = len;
          }
          if (this.slice) {
            return slice.call(this, begin, end);
          }
          var i, cloned = [], start = begin >= 0 ? begin : Math.max(0, len + begin), upTo = end < 0 ? len + end : Math.min(end, len), size = upTo - start;
          if (size > 0) {
            cloned = new Array(size);
            if (this.charAt) {
              for (i = 0; i < size; i++) {
                cloned[i] = this.charAt(start + i);
              }
            } else {
              for (i = 0; i < size; i++) {
                cloned[i] = this[start + i];
              }
            }
          }
          return cloned;
        };
      }
    }();
    var _inArray = function() {
      if (Array.prototype.includes) {
        return function(arr, val) {
          return arr.includes(val);
        };
      }
      if (Array.prototype.indexOf) {
        return function(arr, val) {
          return arr.indexOf(val) >= 0;
        };
      }
      return function(arr, val) {
        for (var i = 0; i < arr.length; i++) {
          if (arr[i] === val) {
            return true;
          }
        }
        return false;
      };
    };
    function sanitizeElements(elements) {
      if (Type.isWrapped(elements)) {
        elements = _slice.call(elements);
      } else if (Type.isNode(elements)) {
        elements = [elements];
      }
      return elements;
    }
    var Type = {
      isNumber: function(variable) {
        return typeof variable === "number";
      },
      isString: function(variable) {
        return typeof variable === "string";
      },
      isArray: Array.isArray || function(variable) {
        return Object.prototype.toString.call(variable) === "[object Array]";
      },
      isFunction: function(variable) {
        return Object.prototype.toString.call(variable) === "[object Function]";
      },
      isNode: function(variable) {
        return variable && variable.nodeType;
      },
      isWrapped: function(variable) {
        return variable && variable !== window2 && Type.isNumber(variable.length) && !Type.isString(variable) && !Type.isFunction(variable) && !Type.isNode(variable) && (variable.length === 0 || Type.isNode(variable[0]));
      },
      isSVG: function(variable) {
        return window2.SVGElement && variable instanceof window2.SVGElement;
      },
      isEmptyObject: function(variable) {
        for (var name in variable) {
          if (variable.hasOwnProperty(name)) {
            return false;
          }
        }
        return true;
      }
    };
    var $, isJQuery = false;
    if (global.fn && global.fn.jquery) {
      $ = global;
      isJQuery = true;
    } else {
      $ = window2.Velocity.Utilities;
    }
    if (IE <= 8 && !isJQuery) {
      throw new Error("Velocity: IE8 and below require jQuery to be loaded before Velocity.");
    } else if (IE <= 7) {
      jQuery.fn.velocity = jQuery.fn.animate;
      return;
    }
    var DURATION_DEFAULT = 400, EASING_DEFAULT = "swing";
    var Velocity = {
      State: {
        isMobile: /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent),
        isAndroid: /Android/i.test(navigator.userAgent),
        isGingerbread: /Android 2\.3\.[3-7]/i.test(navigator.userAgent),
        isChrome: window2.chrome,
        isFirefox: /Firefox/i.test(navigator.userAgent),
        prefixElement: document2.createElement("div"),
        prefixMatches: {},
        scrollAnchor: null,
        scrollPropertyLeft: null,
        scrollPropertyTop: null,
        isTicking: false,
        calls: [],
        delayedElements: {
          count: 0
        }
      },
      CSS: {},
      Utilities: $,
      Redirects: {},
      Easings: {},
      Promise: window2.Promise,
      defaults: {
        queue: "",
        duration: DURATION_DEFAULT,
        easing: EASING_DEFAULT,
        begin: undefined2,
        complete: undefined2,
        progress: undefined2,
        display: undefined2,
        visibility: undefined2,
        loop: false,
        delay: false,
        mobileHA: true,
        _cacheValues: true,
        promiseRejectEmpty: true
      },
      init: function(element) {
        $.data(element, "velocity", {
          isSVG: Type.isSVG(element),
          isAnimating: false,
          computedStyle: null,
          tweensContainer: null,
          rootPropertyValueCache: {},
          transformCache: {}
        });
      },
      hook: null,
      mock: false,
      version: { major: 1, minor: 5, patch: 0 },
      debug: false,
      timestamp: true,
      pauseAll: function(queueName) {
        var currentTime = new Date().getTime();
        $.each(Velocity.State.calls, function(i, activeCall) {
          if (activeCall) {
            if (queueName !== undefined2 && (activeCall[2].queue !== queueName || activeCall[2].queue === false)) {
              return true;
            }
            activeCall[5] = {
              resume: false
            };
          }
        });
        $.each(Velocity.State.delayedElements, function(k, element) {
          if (!element) {
            return;
          }
          pauseDelayOnElement(element, currentTime);
        });
      },
      resumeAll: function(queueName) {
        var currentTime = new Date().getTime();
        $.each(Velocity.State.calls, function(i, activeCall) {
          if (activeCall) {
            if (queueName !== undefined2 && (activeCall[2].queue !== queueName || activeCall[2].queue === false)) {
              return true;
            }
            if (activeCall[5]) {
              activeCall[5].resume = true;
            }
          }
        });
        $.each(Velocity.State.delayedElements, function(k, element) {
          if (!element) {
            return;
          }
          resumeDelayOnElement(element, currentTime);
        });
      }
    };
    if (window2.pageYOffset !== undefined2) {
      Velocity.State.scrollAnchor = window2;
      Velocity.State.scrollPropertyLeft = "pageXOffset";
      Velocity.State.scrollPropertyTop = "pageYOffset";
    } else {
      Velocity.State.scrollAnchor = document2.documentElement || document2.body.parentNode || document2.body;
      Velocity.State.scrollPropertyLeft = "scrollLeft";
      Velocity.State.scrollPropertyTop = "scrollTop";
    }
    function Data(element) {
      var response = $.data(element, "velocity");
      return response === null ? undefined2 : response;
    }
    function pauseDelayOnElement(element, currentTime) {
      var data = Data(element);
      if (data && data.delayTimer && !data.delayPaused) {
        data.delayRemaining = data.delay - currentTime + data.delayBegin;
        data.delayPaused = true;
        clearTimeout(data.delayTimer.setTimeout);
      }
    }
    function resumeDelayOnElement(element, currentTime) {
      var data = Data(element);
      if (data && data.delayTimer && data.delayPaused) {
        data.delayPaused = false;
        data.delayTimer.setTimeout = setTimeout(data.delayTimer.next, data.delayRemaining);
      }
    }
    function generateStep(steps) {
      return function(p) {
        return Math.round(p * steps) * (1 / steps);
      };
    }
    function generateBezier(mX1, mY1, mX2, mY2) {
      var NEWTON_ITERATIONS = 4, NEWTON_MIN_SLOPE = 1e-3, SUBDIVISION_PRECISION = 1e-7, SUBDIVISION_MAX_ITERATIONS = 10, kSplineTableSize = 11, kSampleStepSize = 1 / (kSplineTableSize - 1), float32ArraySupported = "Float32Array" in window2;
      if (arguments.length !== 4) {
        return false;
      }
      for (var i = 0; i < 4; ++i) {
        if (typeof arguments[i] !== "number" || isNaN(arguments[i]) || !isFinite(arguments[i])) {
          return false;
        }
      }
      mX1 = Math.min(mX1, 1);
      mX2 = Math.min(mX2, 1);
      mX1 = Math.max(mX1, 0);
      mX2 = Math.max(mX2, 0);
      var mSampleValues = float32ArraySupported ? new Float32Array(kSplineTableSize) : new Array(kSplineTableSize);
      function A(aA1, aA2) {
        return 1 - 3 * aA2 + 3 * aA1;
      }
      function B(aA1, aA2) {
        return 3 * aA2 - 6 * aA1;
      }
      function C(aA1) {
        return 3 * aA1;
      }
      function calcBezier(aT, aA1, aA2) {
        return ((A(aA1, aA2) * aT + B(aA1, aA2)) * aT + C(aA1)) * aT;
      }
      function getSlope(aT, aA1, aA2) {
        return 3 * A(aA1, aA2) * aT * aT + 2 * B(aA1, aA2) * aT + C(aA1);
      }
      function newtonRaphsonIterate(aX, aGuessT) {
        for (var i2 = 0; i2 < NEWTON_ITERATIONS; ++i2) {
          var currentSlope = getSlope(aGuessT, mX1, mX2);
          if (currentSlope === 0) {
            return aGuessT;
          }
          var currentX = calcBezier(aGuessT, mX1, mX2) - aX;
          aGuessT -= currentX / currentSlope;
        }
        return aGuessT;
      }
      function calcSampleValues() {
        for (var i2 = 0; i2 < kSplineTableSize; ++i2) {
          mSampleValues[i2] = calcBezier(i2 * kSampleStepSize, mX1, mX2);
        }
      }
      function binarySubdivide(aX, aA, aB) {
        var currentX, currentT, i2 = 0;
        do {
          currentT = aA + (aB - aA) / 2;
          currentX = calcBezier(currentT, mX1, mX2) - aX;
          if (currentX > 0) {
            aB = currentT;
          } else {
            aA = currentT;
          }
        } while (Math.abs(currentX) > SUBDIVISION_PRECISION && ++i2 < SUBDIVISION_MAX_ITERATIONS);
        return currentT;
      }
      function getTForX(aX) {
        var intervalStart = 0, currentSample = 1, lastSample = kSplineTableSize - 1;
        for (; currentSample !== lastSample && mSampleValues[currentSample] <= aX; ++currentSample) {
          intervalStart += kSampleStepSize;
        }
        --currentSample;
        var dist = (aX - mSampleValues[currentSample]) / (mSampleValues[currentSample + 1] - mSampleValues[currentSample]), guessForT = intervalStart + dist * kSampleStepSize, initialSlope = getSlope(guessForT, mX1, mX2);
        if (initialSlope >= NEWTON_MIN_SLOPE) {
          return newtonRaphsonIterate(aX, guessForT);
        } else if (initialSlope === 0) {
          return guessForT;
        } else {
          return binarySubdivide(aX, intervalStart, intervalStart + kSampleStepSize);
        }
      }
      var _precomputed = false;
      function precompute() {
        _precomputed = true;
        if (mX1 !== mY1 || mX2 !== mY2) {
          calcSampleValues();
        }
      }
      var f = function(aX) {
        if (!_precomputed) {
          precompute();
        }
        if (mX1 === mY1 && mX2 === mY2) {
          return aX;
        }
        if (aX === 0) {
          return 0;
        }
        if (aX === 1) {
          return 1;
        }
        return calcBezier(getTForX(aX), mY1, mY2);
      };
      f.getControlPoints = function() {
        return [{ x: mX1, y: mY1 }, { x: mX2, y: mY2 }];
      };
      var str = "generateBezier(" + [mX1, mY1, mX2, mY2] + ")";
      f.toString = function() {
        return str;
      };
      return f;
    }
    var generateSpringRK4 = function() {
      function springAccelerationForState(state) {
        return -state.tension * state.x - state.friction * state.v;
      }
      function springEvaluateStateWithDerivative(initialState, dt, derivative) {
        var state = {
          x: initialState.x + derivative.dx * dt,
          v: initialState.v + derivative.dv * dt,
          tension: initialState.tension,
          friction: initialState.friction
        };
        return { dx: state.v, dv: springAccelerationForState(state) };
      }
      function springIntegrateState(state, dt) {
        var a = {
          dx: state.v,
          dv: springAccelerationForState(state)
        }, b = springEvaluateStateWithDerivative(state, dt * 0.5, a), c = springEvaluateStateWithDerivative(state, dt * 0.5, b), d = springEvaluateStateWithDerivative(state, dt, c), dxdt = 1 / 6 * (a.dx + 2 * (b.dx + c.dx) + d.dx), dvdt = 1 / 6 * (a.dv + 2 * (b.dv + c.dv) + d.dv);
        state.x = state.x + dxdt * dt;
        state.v = state.v + dvdt * dt;
        return state;
      }
      return function springRK4Factory(tension, friction, duration) {
        var initState = {
          x: -1,
          v: 0,
          tension: null,
          friction: null
        }, path = [0], time_lapsed = 0, tolerance = 1 / 1e4, DT = 16 / 1e3, have_duration, dt, last_state;
        tension = parseFloat(tension) || 500;
        friction = parseFloat(friction) || 20;
        duration = duration || null;
        initState.tension = tension;
        initState.friction = friction;
        have_duration = duration !== null;
        if (have_duration) {
          time_lapsed = springRK4Factory(tension, friction);
          dt = time_lapsed / duration * DT;
        } else {
          dt = DT;
        }
        while (true) {
          last_state = springIntegrateState(last_state || initState, dt);
          path.push(1 + last_state.x);
          time_lapsed += 16;
          if (!(Math.abs(last_state.x) > tolerance && Math.abs(last_state.v) > tolerance)) {
            break;
          }
        }
        return !have_duration ? time_lapsed : function(percentComplete) {
          return path[percentComplete * (path.length - 1) | 0];
        };
      };
    }();
    Velocity.Easings = {
      linear: function(p) {
        return p;
      },
      swing: function(p) {
        return 0.5 - Math.cos(p * Math.PI) / 2;
      },
      spring: function(p) {
        return 1 - Math.cos(p * 4.5 * Math.PI) * Math.exp(-p * 6);
      }
    };
    $.each([
      ["ease", [0.25, 0.1, 0.25, 1]],
      ["ease-in", [0.42, 0, 1, 1]],
      ["ease-out", [0, 0, 0.58, 1]],
      ["ease-in-out", [0.42, 0, 0.58, 1]],
      ["easeInSine", [0.47, 0, 0.745, 0.715]],
      ["easeOutSine", [0.39, 0.575, 0.565, 1]],
      ["easeInOutSine", [0.445, 0.05, 0.55, 0.95]],
      ["easeInQuad", [0.55, 0.085, 0.68, 0.53]],
      ["easeOutQuad", [0.25, 0.46, 0.45, 0.94]],
      ["easeInOutQuad", [0.455, 0.03, 0.515, 0.955]],
      ["easeInCubic", [0.55, 0.055, 0.675, 0.19]],
      ["easeOutCubic", [0.215, 0.61, 0.355, 1]],
      ["easeInOutCubic", [0.645, 0.045, 0.355, 1]],
      ["easeInQuart", [0.895, 0.03, 0.685, 0.22]],
      ["easeOutQuart", [0.165, 0.84, 0.44, 1]],
      ["easeInOutQuart", [0.77, 0, 0.175, 1]],
      ["easeInQuint", [0.755, 0.05, 0.855, 0.06]],
      ["easeOutQuint", [0.23, 1, 0.32, 1]],
      ["easeInOutQuint", [0.86, 0, 0.07, 1]],
      ["easeInExpo", [0.95, 0.05, 0.795, 0.035]],
      ["easeOutExpo", [0.19, 1, 0.22, 1]],
      ["easeInOutExpo", [1, 0, 0, 1]],
      ["easeInCirc", [0.6, 0.04, 0.98, 0.335]],
      ["easeOutCirc", [0.075, 0.82, 0.165, 1]],
      ["easeInOutCirc", [0.785, 0.135, 0.15, 0.86]]
    ], function(i, easingArray) {
      Velocity.Easings[easingArray[0]] = generateBezier.apply(null, easingArray[1]);
    });
    function getEasing(value, duration) {
      var easing = value;
      if (Type.isString(value)) {
        if (!Velocity.Easings[value]) {
          easing = false;
        }
      } else if (Type.isArray(value) && value.length === 1) {
        easing = generateStep.apply(null, value);
      } else if (Type.isArray(value) && value.length === 2) {
        easing = generateSpringRK4.apply(null, value.concat([duration]));
      } else if (Type.isArray(value) && value.length === 4) {
        easing = generateBezier.apply(null, value);
      } else {
        easing = false;
      }
      if (easing === false) {
        if (Velocity.Easings[Velocity.defaults.easing]) {
          easing = Velocity.defaults.easing;
        } else {
          easing = EASING_DEFAULT;
        }
      }
      return easing;
    }
    var CSS = Velocity.CSS = {
      RegEx: {
        isHex: /^#([A-f\d]{3}){1,2}$/i,
        valueUnwrap: /^[A-z]+\((.*)\)$/i,
        wrappedValueAlreadyExtracted: /[0-9.]+ [0-9.]+ [0-9.]+( [0-9.]+)?/,
        valueSplit: /([A-z]+\(.+\))|(([A-z0-9#-.]+?)(?=\s|$))/ig
      },
      Lists: {
        colors: ["fill", "stroke", "stopColor", "color", "backgroundColor", "borderColor", "borderTopColor", "borderRightColor", "borderBottomColor", "borderLeftColor", "outlineColor"],
        transformsBase: ["translateX", "translateY", "scale", "scaleX", "scaleY", "skewX", "skewY", "rotateZ"],
        transforms3D: ["transformPerspective", "translateZ", "scaleZ", "rotateX", "rotateY"],
        units: [
          "%",
          "em",
          "ex",
          "ch",
          "rem",
          "vw",
          "vh",
          "vmin",
          "vmax",
          "cm",
          "mm",
          "Q",
          "in",
          "pc",
          "pt",
          "px",
          "deg",
          "grad",
          "rad",
          "turn",
          "s",
          "ms"
        ],
        colorNames: {
          "aliceblue": "240,248,255",
          "antiquewhite": "250,235,215",
          "aquamarine": "127,255,212",
          "aqua": "0,255,255",
          "azure": "240,255,255",
          "beige": "245,245,220",
          "bisque": "255,228,196",
          "black": "0,0,0",
          "blanchedalmond": "255,235,205",
          "blueviolet": "138,43,226",
          "blue": "0,0,255",
          "brown": "165,42,42",
          "burlywood": "222,184,135",
          "cadetblue": "95,158,160",
          "chartreuse": "127,255,0",
          "chocolate": "210,105,30",
          "coral": "255,127,80",
          "cornflowerblue": "100,149,237",
          "cornsilk": "255,248,220",
          "crimson": "220,20,60",
          "cyan": "0,255,255",
          "darkblue": "0,0,139",
          "darkcyan": "0,139,139",
          "darkgoldenrod": "184,134,11",
          "darkgray": "169,169,169",
          "darkgrey": "169,169,169",
          "darkgreen": "0,100,0",
          "darkkhaki": "189,183,107",
          "darkmagenta": "139,0,139",
          "darkolivegreen": "85,107,47",
          "darkorange": "255,140,0",
          "darkorchid": "153,50,204",
          "darkred": "139,0,0",
          "darksalmon": "233,150,122",
          "darkseagreen": "143,188,143",
          "darkslateblue": "72,61,139",
          "darkslategray": "47,79,79",
          "darkturquoise": "0,206,209",
          "darkviolet": "148,0,211",
          "deeppink": "255,20,147",
          "deepskyblue": "0,191,255",
          "dimgray": "105,105,105",
          "dimgrey": "105,105,105",
          "dodgerblue": "30,144,255",
          "firebrick": "178,34,34",
          "floralwhite": "255,250,240",
          "forestgreen": "34,139,34",
          "fuchsia": "255,0,255",
          "gainsboro": "220,220,220",
          "ghostwhite": "248,248,255",
          "gold": "255,215,0",
          "goldenrod": "218,165,32",
          "gray": "128,128,128",
          "grey": "128,128,128",
          "greenyellow": "173,255,47",
          "green": "0,128,0",
          "honeydew": "240,255,240",
          "hotpink": "255,105,180",
          "indianred": "205,92,92",
          "indigo": "75,0,130",
          "ivory": "255,255,240",
          "khaki": "240,230,140",
          "lavenderblush": "255,240,245",
          "lavender": "230,230,250",
          "lawngreen": "124,252,0",
          "lemonchiffon": "255,250,205",
          "lightblue": "173,216,230",
          "lightcoral": "240,128,128",
          "lightcyan": "224,255,255",
          "lightgoldenrodyellow": "250,250,210",
          "lightgray": "211,211,211",
          "lightgrey": "211,211,211",
          "lightgreen": "144,238,144",
          "lightpink": "255,182,193",
          "lightsalmon": "255,160,122",
          "lightseagreen": "32,178,170",
          "lightskyblue": "135,206,250",
          "lightslategray": "119,136,153",
          "lightsteelblue": "176,196,222",
          "lightyellow": "255,255,224",
          "limegreen": "50,205,50",
          "lime": "0,255,0",
          "linen": "250,240,230",
          "magenta": "255,0,255",
          "maroon": "128,0,0",
          "mediumaquamarine": "102,205,170",
          "mediumblue": "0,0,205",
          "mediumorchid": "186,85,211",
          "mediumpurple": "147,112,219",
          "mediumseagreen": "60,179,113",
          "mediumslateblue": "123,104,238",
          "mediumspringgreen": "0,250,154",
          "mediumturquoise": "72,209,204",
          "mediumvioletred": "199,21,133",
          "midnightblue": "25,25,112",
          "mintcream": "245,255,250",
          "mistyrose": "255,228,225",
          "moccasin": "255,228,181",
          "navajowhite": "255,222,173",
          "navy": "0,0,128",
          "oldlace": "253,245,230",
          "olivedrab": "107,142,35",
          "olive": "128,128,0",
          "orangered": "255,69,0",
          "orange": "255,165,0",
          "orchid": "218,112,214",
          "palegoldenrod": "238,232,170",
          "palegreen": "152,251,152",
          "paleturquoise": "175,238,238",
          "palevioletred": "219,112,147",
          "papayawhip": "255,239,213",
          "peachpuff": "255,218,185",
          "peru": "205,133,63",
          "pink": "255,192,203",
          "plum": "221,160,221",
          "powderblue": "176,224,230",
          "purple": "128,0,128",
          "red": "255,0,0",
          "rosybrown": "188,143,143",
          "royalblue": "65,105,225",
          "saddlebrown": "139,69,19",
          "salmon": "250,128,114",
          "sandybrown": "244,164,96",
          "seagreen": "46,139,87",
          "seashell": "255,245,238",
          "sienna": "160,82,45",
          "silver": "192,192,192",
          "skyblue": "135,206,235",
          "slateblue": "106,90,205",
          "slategray": "112,128,144",
          "snow": "255,250,250",
          "springgreen": "0,255,127",
          "steelblue": "70,130,180",
          "tan": "210,180,140",
          "teal": "0,128,128",
          "thistle": "216,191,216",
          "tomato": "255,99,71",
          "turquoise": "64,224,208",
          "violet": "238,130,238",
          "wheat": "245,222,179",
          "whitesmoke": "245,245,245",
          "white": "255,255,255",
          "yellowgreen": "154,205,50",
          "yellow": "255,255,0"
        }
      },
      Hooks: {
        templates: {
          "textShadow": ["Color X Y Blur", "black 0px 0px 0px"],
          "boxShadow": ["Color X Y Blur Spread", "black 0px 0px 0px 0px"],
          "clip": ["Top Right Bottom Left", "0px 0px 0px 0px"],
          "backgroundPosition": ["X Y", "0% 0%"],
          "transformOrigin": ["X Y Z", "50% 50% 0px"],
          "perspectiveOrigin": ["X Y", "50% 50%"]
        },
        registered: {},
        register: function() {
          for (var i = 0; i < CSS.Lists.colors.length; i++) {
            var rgbComponents = CSS.Lists.colors[i] === "color" ? "0 0 0 1" : "255 255 255 1";
            CSS.Hooks.templates[CSS.Lists.colors[i]] = ["Red Green Blue Alpha", rgbComponents];
          }
          var rootProperty, hookTemplate, hookNames;
          if (IE) {
            for (rootProperty in CSS.Hooks.templates) {
              if (!CSS.Hooks.templates.hasOwnProperty(rootProperty)) {
                continue;
              }
              hookTemplate = CSS.Hooks.templates[rootProperty];
              hookNames = hookTemplate[0].split(" ");
              var defaultValues = hookTemplate[1].match(CSS.RegEx.valueSplit);
              if (hookNames[0] === "Color") {
                hookNames.push(hookNames.shift());
                defaultValues.push(defaultValues.shift());
                CSS.Hooks.templates[rootProperty] = [hookNames.join(" "), defaultValues.join(" ")];
              }
            }
          }
          for (rootProperty in CSS.Hooks.templates) {
            if (!CSS.Hooks.templates.hasOwnProperty(rootProperty)) {
              continue;
            }
            hookTemplate = CSS.Hooks.templates[rootProperty];
            hookNames = hookTemplate[0].split(" ");
            for (var j in hookNames) {
              if (!hookNames.hasOwnProperty(j)) {
                continue;
              }
              var fullHookName = rootProperty + hookNames[j], hookPosition = j;
              CSS.Hooks.registered[fullHookName] = [rootProperty, hookPosition];
            }
          }
        },
        getRoot: function(property) {
          var hookData = CSS.Hooks.registered[property];
          if (hookData) {
            return hookData[0];
          } else {
            return property;
          }
        },
        getUnit: function(str, start) {
          var unit = (str.substr(start || 0, 5).match(/^[a-z%]+/) || [])[0] || "";
          if (unit && _inArray(CSS.Lists.units, unit)) {
            return unit;
          }
          return "";
        },
        fixColors: function(str) {
          return str.replace(/(rgba?\(\s*)?(\b[a-z]+\b)/g, function($0, $1, $2) {
            if (CSS.Lists.colorNames.hasOwnProperty($2)) {
              return ($1 ? $1 : "rgba(") + CSS.Lists.colorNames[$2] + ($1 ? "" : ",1)");
            }
            return $1 + $2;
          });
        },
        cleanRootPropertyValue: function(rootProperty, rootPropertyValue) {
          if (CSS.RegEx.valueUnwrap.test(rootPropertyValue)) {
            rootPropertyValue = rootPropertyValue.match(CSS.RegEx.valueUnwrap)[1];
          }
          if (CSS.Values.isCSSNullValue(rootPropertyValue)) {
            rootPropertyValue = CSS.Hooks.templates[rootProperty][1];
          }
          return rootPropertyValue;
        },
        extractValue: function(fullHookName, rootPropertyValue) {
          var hookData = CSS.Hooks.registered[fullHookName];
          if (hookData) {
            var hookRoot = hookData[0], hookPosition = hookData[1];
            rootPropertyValue = CSS.Hooks.cleanRootPropertyValue(hookRoot, rootPropertyValue);
            return rootPropertyValue.toString().match(CSS.RegEx.valueSplit)[hookPosition];
          } else {
            return rootPropertyValue;
          }
        },
        injectValue: function(fullHookName, hookValue, rootPropertyValue) {
          var hookData = CSS.Hooks.registered[fullHookName];
          if (hookData) {
            var hookRoot = hookData[0], hookPosition = hookData[1], rootPropertyValueParts, rootPropertyValueUpdated;
            rootPropertyValue = CSS.Hooks.cleanRootPropertyValue(hookRoot, rootPropertyValue);
            rootPropertyValueParts = rootPropertyValue.toString().match(CSS.RegEx.valueSplit);
            rootPropertyValueParts[hookPosition] = hookValue;
            rootPropertyValueUpdated = rootPropertyValueParts.join(" ");
            return rootPropertyValueUpdated;
          } else {
            return rootPropertyValue;
          }
        }
      },
      Normalizations: {
        registered: {
          clip: function(type, element, propertyValue) {
            switch (type) {
              case "name":
                return "clip";
              case "extract":
                var extracted;
                if (CSS.RegEx.wrappedValueAlreadyExtracted.test(propertyValue)) {
                  extracted = propertyValue;
                } else {
                  extracted = propertyValue.toString().match(CSS.RegEx.valueUnwrap);
                  extracted = extracted ? extracted[1].replace(/,(\s+)?/g, " ") : propertyValue;
                }
                return extracted;
              case "inject":
                return "rect(" + propertyValue + ")";
            }
          },
          blur: function(type, element, propertyValue) {
            switch (type) {
              case "name":
                return Velocity.State.isFirefox ? "filter" : "-webkit-filter";
              case "extract":
                var extracted = parseFloat(propertyValue);
                if (!(extracted || extracted === 0)) {
                  var blurComponent = propertyValue.toString().match(/blur\(([0-9]+[A-z]+)\)/i);
                  if (blurComponent) {
                    extracted = blurComponent[1];
                  } else {
                    extracted = 0;
                  }
                }
                return extracted;
              case "inject":
                if (!parseFloat(propertyValue)) {
                  return "none";
                } else {
                  return "blur(" + propertyValue + ")";
                }
            }
          },
          opacity: function(type, element, propertyValue) {
            if (IE <= 8) {
              switch (type) {
                case "name":
                  return "filter";
                case "extract":
                  var extracted = propertyValue.toString().match(/alpha\(opacity=(.*)\)/i);
                  if (extracted) {
                    propertyValue = extracted[1] / 100;
                  } else {
                    propertyValue = 1;
                  }
                  return propertyValue;
                case "inject":
                  element.style.zoom = 1;
                  if (parseFloat(propertyValue) >= 1) {
                    return "";
                  } else {
                    return "alpha(opacity=" + parseInt(parseFloat(propertyValue) * 100, 10) + ")";
                  }
              }
            } else {
              switch (type) {
                case "name":
                  return "opacity";
                case "extract":
                  return propertyValue;
                case "inject":
                  return propertyValue;
              }
            }
          }
        },
        register: function() {
          if ((!IE || IE > 9) && !Velocity.State.isGingerbread) {
            CSS.Lists.transformsBase = CSS.Lists.transformsBase.concat(CSS.Lists.transforms3D);
          }
          for (var i = 0; i < CSS.Lists.transformsBase.length; i++) {
            (function() {
              var transformName = CSS.Lists.transformsBase[i];
              CSS.Normalizations.registered[transformName] = function(type, element, propertyValue) {
                switch (type) {
                  case "name":
                    return "transform";
                  case "extract":
                    if (Data(element) === undefined2 || Data(element).transformCache[transformName] === undefined2) {
                      return /^scale/i.test(transformName) ? 1 : 0;
                    }
                    return Data(element).transformCache[transformName].replace(/[()]/g, "");
                  case "inject":
                    var invalid = false;
                    switch (transformName.substr(0, transformName.length - 1)) {
                      case "translate":
                        invalid = !/(%|px|em|rem|vw|vh|\d)$/i.test(propertyValue);
                        break;
                      case "scal":
                      case "scale":
                        if (Velocity.State.isAndroid && Data(element).transformCache[transformName] === undefined2 && propertyValue < 1) {
                          propertyValue = 1;
                        }
                        invalid = !/(\d)$/i.test(propertyValue);
                        break;
                      case "skew":
                        invalid = !/(deg|\d)$/i.test(propertyValue);
                        break;
                      case "rotate":
                        invalid = !/(deg|\d)$/i.test(propertyValue);
                        break;
                    }
                    if (!invalid) {
                      Data(element).transformCache[transformName] = "(" + propertyValue + ")";
                    }
                    return Data(element).transformCache[transformName];
                }
              };
            })();
          }
          for (var j = 0; j < CSS.Lists.colors.length; j++) {
            (function() {
              var colorName = CSS.Lists.colors[j];
              CSS.Normalizations.registered[colorName] = function(type, element, propertyValue) {
                switch (type) {
                  case "name":
                    return colorName;
                  case "extract":
                    var extracted;
                    if (CSS.RegEx.wrappedValueAlreadyExtracted.test(propertyValue)) {
                      extracted = propertyValue;
                    } else {
                      var converted, colorNames = {
                        black: "rgb(0, 0, 0)",
                        blue: "rgb(0, 0, 255)",
                        gray: "rgb(128, 128, 128)",
                        green: "rgb(0, 128, 0)",
                        red: "rgb(255, 0, 0)",
                        white: "rgb(255, 255, 255)"
                      };
                      if (/^[A-z]+$/i.test(propertyValue)) {
                        if (colorNames[propertyValue] !== undefined2) {
                          converted = colorNames[propertyValue];
                        } else {
                          converted = colorNames.black;
                        }
                      } else if (CSS.RegEx.isHex.test(propertyValue)) {
                        converted = "rgb(" + CSS.Values.hexToRgb(propertyValue).join(" ") + ")";
                      } else if (!/^rgba?\(/i.test(propertyValue)) {
                        converted = colorNames.black;
                      }
                      extracted = (converted || propertyValue).toString().match(CSS.RegEx.valueUnwrap)[1].replace(/,(\s+)?/g, " ");
                    }
                    if ((!IE || IE > 8) && extracted.split(" ").length === 3) {
                      extracted += " 1";
                    }
                    return extracted;
                  case "inject":
                    if (/^rgb/.test(propertyValue)) {
                      return propertyValue;
                    }
                    if (IE <= 8) {
                      if (propertyValue.split(" ").length === 4) {
                        propertyValue = propertyValue.split(/\s+/).slice(0, 3).join(" ");
                      }
                    } else if (propertyValue.split(" ").length === 3) {
                      propertyValue += " 1";
                    }
                    return (IE <= 8 ? "rgb" : "rgba") + "(" + propertyValue.replace(/\s+/g, ",").replace(/\.(\d)+(?=,)/g, "") + ")";
                }
              };
            })();
          }
          function augmentDimension(name, element, wantInner) {
            var isBorderBox = CSS.getPropertyValue(element, "boxSizing").toString().toLowerCase() === "border-box";
            if (isBorderBox === (wantInner || false)) {
              var i2, value, augment = 0, sides = name === "width" ? ["Left", "Right"] : ["Top", "Bottom"], fields = ["padding" + sides[0], "padding" + sides[1], "border" + sides[0] + "Width", "border" + sides[1] + "Width"];
              for (i2 = 0; i2 < fields.length; i2++) {
                value = parseFloat(CSS.getPropertyValue(element, fields[i2]));
                if (!isNaN(value)) {
                  augment += value;
                }
              }
              return wantInner ? -augment : augment;
            }
            return 0;
          }
          function getDimension(name, wantInner) {
            return function(type, element, propertyValue) {
              switch (type) {
                case "name":
                  return name;
                case "extract":
                  return parseFloat(propertyValue) + augmentDimension(name, element, wantInner);
                case "inject":
                  return parseFloat(propertyValue) - augmentDimension(name, element, wantInner) + "px";
              }
            };
          }
          CSS.Normalizations.registered.innerWidth = getDimension("width", true);
          CSS.Normalizations.registered.innerHeight = getDimension("height", true);
          CSS.Normalizations.registered.outerWidth = getDimension("width");
          CSS.Normalizations.registered.outerHeight = getDimension("height");
        }
      },
      Names: {
        camelCase: function(property) {
          return property.replace(/-(\w)/g, function(match, subMatch) {
            return subMatch.toUpperCase();
          });
        },
        SVGAttribute: function(property) {
          var SVGAttributes = "width|height|x|y|cx|cy|r|rx|ry|x1|x2|y1|y2";
          if (IE || Velocity.State.isAndroid && !Velocity.State.isChrome) {
            SVGAttributes += "|transform";
          }
          return new RegExp("^(" + SVGAttributes + ")$", "i").test(property);
        },
        prefixCheck: function(property) {
          if (Velocity.State.prefixMatches[property]) {
            return [Velocity.State.prefixMatches[property], true];
          } else {
            var vendors = ["", "Webkit", "Moz", "ms", "O"];
            for (var i = 0, vendorsLength = vendors.length; i < vendorsLength; i++) {
              var propertyPrefixed;
              if (i === 0) {
                propertyPrefixed = property;
              } else {
                propertyPrefixed = vendors[i] + property.replace(/^\w/, function(match) {
                  return match.toUpperCase();
                });
              }
              if (Type.isString(Velocity.State.prefixElement.style[propertyPrefixed])) {
                Velocity.State.prefixMatches[property] = propertyPrefixed;
                return [propertyPrefixed, true];
              }
            }
            return [property, false];
          }
        }
      },
      Values: {
        hexToRgb: function(hex) {
          var shortformRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i, longformRegex = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i, rgbParts;
          hex = hex.replace(shortformRegex, function(m, r, g, b) {
            return r + r + g + g + b + b;
          });
          rgbParts = longformRegex.exec(hex);
          return rgbParts ? [parseInt(rgbParts[1], 16), parseInt(rgbParts[2], 16), parseInt(rgbParts[3], 16)] : [0, 0, 0];
        },
        isCSSNullValue: function(value) {
          return !value || /^(none|auto|transparent|(rgba\(0, ?0, ?0, ?0\)))$/i.test(value);
        },
        getUnitType: function(property) {
          if (/^(rotate|skew)/i.test(property)) {
            return "deg";
          } else if (/(^(scale|scaleX|scaleY|scaleZ|alpha|flexGrow|flexHeight|zIndex|fontWeight)$)|((opacity|red|green|blue|alpha)$)/i.test(property)) {
            return "";
          } else {
            return "px";
          }
        },
        getDisplayType: function(element) {
          var tagName = element && element.tagName.toString().toLowerCase();
          if (/^(b|big|i|small|tt|abbr|acronym|cite|code|dfn|em|kbd|strong|samp|var|a|bdo|br|img|map|object|q|script|span|sub|sup|button|input|label|select|textarea)$/i.test(tagName)) {
            return "inline";
          } else if (/^(li)$/i.test(tagName)) {
            return "list-item";
          } else if (/^(tr)$/i.test(tagName)) {
            return "table-row";
          } else if (/^(table)$/i.test(tagName)) {
            return "table";
          } else if (/^(tbody)$/i.test(tagName)) {
            return "table-row-group";
          } else {
            return "block";
          }
        },
        addClass: function(element, className) {
          if (element) {
            if (element.classList) {
              element.classList.add(className);
            } else if (Type.isString(element.className)) {
              element.className += (element.className.length ? " " : "") + className;
            } else {
              var currentClass = element.getAttribute(IE <= 7 ? "className" : "class") || "";
              element.setAttribute("class", currentClass + (currentClass ? " " : "") + className);
            }
          }
        },
        removeClass: function(element, className) {
          if (element) {
            if (element.classList) {
              element.classList.remove(className);
            } else if (Type.isString(element.className)) {
              element.className = element.className.toString().replace(new RegExp("(^|\\s)" + className.split(" ").join("|") + "(\\s|$)", "gi"), " ");
            } else {
              var currentClass = element.getAttribute(IE <= 7 ? "className" : "class") || "";
              element.setAttribute("class", currentClass.replace(new RegExp("(^|s)" + className.split(" ").join("|") + "(s|$)", "gi"), " "));
            }
          }
        }
      },
      getPropertyValue: function(element, property, rootPropertyValue, forceStyleLookup) {
        function computePropertyValue(element2, property2) {
          var computedValue = 0;
          if (IE <= 8) {
            computedValue = $.css(element2, property2);
          } else {
            var toggleDisplay = false;
            if (/^(width|height)$/.test(property2) && CSS.getPropertyValue(element2, "display") === 0) {
              toggleDisplay = true;
              CSS.setPropertyValue(element2, "display", CSS.Values.getDisplayType(element2));
            }
            var revertDisplay = function() {
              if (toggleDisplay) {
                CSS.setPropertyValue(element2, "display", "none");
              }
            };
            if (!forceStyleLookup) {
              if (property2 === "height" && CSS.getPropertyValue(element2, "boxSizing").toString().toLowerCase() !== "border-box") {
                var contentBoxHeight = element2.offsetHeight - (parseFloat(CSS.getPropertyValue(element2, "borderTopWidth")) || 0) - (parseFloat(CSS.getPropertyValue(element2, "borderBottomWidth")) || 0) - (parseFloat(CSS.getPropertyValue(element2, "paddingTop")) || 0) - (parseFloat(CSS.getPropertyValue(element2, "paddingBottom")) || 0);
                revertDisplay();
                return contentBoxHeight;
              } else if (property2 === "width" && CSS.getPropertyValue(element2, "boxSizing").toString().toLowerCase() !== "border-box") {
                var contentBoxWidth = element2.offsetWidth - (parseFloat(CSS.getPropertyValue(element2, "borderLeftWidth")) || 0) - (parseFloat(CSS.getPropertyValue(element2, "borderRightWidth")) || 0) - (parseFloat(CSS.getPropertyValue(element2, "paddingLeft")) || 0) - (parseFloat(CSS.getPropertyValue(element2, "paddingRight")) || 0);
                revertDisplay();
                return contentBoxWidth;
              }
            }
            var computedStyle;
            if (Data(element2) === undefined2) {
              computedStyle = window2.getComputedStyle(element2, null);
            } else if (!Data(element2).computedStyle) {
              computedStyle = Data(element2).computedStyle = window2.getComputedStyle(element2, null);
            } else {
              computedStyle = Data(element2).computedStyle;
            }
            if (property2 === "borderColor") {
              property2 = "borderTopColor";
            }
            if (IE === 9 && property2 === "filter") {
              computedValue = computedStyle.getPropertyValue(property2);
            } else {
              computedValue = computedStyle[property2];
            }
            if (computedValue === "" || computedValue === null) {
              computedValue = element2.style[property2];
            }
            revertDisplay();
          }
          if (computedValue === "auto" && /^(top|right|bottom|left)$/i.test(property2)) {
            var position = computePropertyValue(element2, "position");
            if (position === "fixed" || position === "absolute" && /top|left/i.test(property2)) {
              computedValue = $(element2).position()[property2] + "px";
            }
          }
          return computedValue;
        }
        var propertyValue;
        if (CSS.Hooks.registered[property]) {
          var hook = property, hookRoot = CSS.Hooks.getRoot(hook);
          if (rootPropertyValue === undefined2) {
            rootPropertyValue = CSS.getPropertyValue(element, CSS.Names.prefixCheck(hookRoot)[0]);
          }
          if (CSS.Normalizations.registered[hookRoot]) {
            rootPropertyValue = CSS.Normalizations.registered[hookRoot]("extract", element, rootPropertyValue);
          }
          propertyValue = CSS.Hooks.extractValue(hook, rootPropertyValue);
        } else if (CSS.Normalizations.registered[property]) {
          var normalizedPropertyName, normalizedPropertyValue;
          normalizedPropertyName = CSS.Normalizations.registered[property]("name", element);
          if (normalizedPropertyName !== "transform") {
            normalizedPropertyValue = computePropertyValue(element, CSS.Names.prefixCheck(normalizedPropertyName)[0]);
            if (CSS.Values.isCSSNullValue(normalizedPropertyValue) && CSS.Hooks.templates[property]) {
              normalizedPropertyValue = CSS.Hooks.templates[property][1];
            }
          }
          propertyValue = CSS.Normalizations.registered[property]("extract", element, normalizedPropertyValue);
        }
        if (!/^[\d-]/.test(propertyValue)) {
          var data = Data(element);
          if (data && data.isSVG && CSS.Names.SVGAttribute(property)) {
            if (/^(height|width)$/i.test(property)) {
              try {
                propertyValue = element.getBBox()[property];
              } catch (error) {
                propertyValue = 0;
              }
            } else {
              propertyValue = element.getAttribute(property);
            }
          } else {
            propertyValue = computePropertyValue(element, CSS.Names.prefixCheck(property)[0]);
          }
        }
        if (CSS.Values.isCSSNullValue(propertyValue)) {
          propertyValue = 0;
        }
        if (Velocity.debug >= 2) {
          console.log("Get " + property + ": " + propertyValue);
        }
        return propertyValue;
      },
      setPropertyValue: function(element, property, propertyValue, rootPropertyValue, scrollData) {
        var propertyName = property;
        if (property === "scroll") {
          if (scrollData.container) {
            scrollData.container["scroll" + scrollData.direction] = propertyValue;
          } else {
            if (scrollData.direction === "Left") {
              window2.scrollTo(propertyValue, scrollData.alternateValue);
            } else {
              window2.scrollTo(scrollData.alternateValue, propertyValue);
            }
          }
        } else {
          if (CSS.Normalizations.registered[property] && CSS.Normalizations.registered[property]("name", element) === "transform") {
            CSS.Normalizations.registered[property]("inject", element, propertyValue);
            propertyName = "transform";
            propertyValue = Data(element).transformCache[property];
          } else {
            if (CSS.Hooks.registered[property]) {
              var hookName = property, hookRoot = CSS.Hooks.getRoot(property);
              rootPropertyValue = rootPropertyValue || CSS.getPropertyValue(element, hookRoot);
              propertyValue = CSS.Hooks.injectValue(hookName, propertyValue, rootPropertyValue);
              property = hookRoot;
            }
            if (CSS.Normalizations.registered[property]) {
              propertyValue = CSS.Normalizations.registered[property]("inject", element, propertyValue);
              property = CSS.Normalizations.registered[property]("name", element);
            }
            propertyName = CSS.Names.prefixCheck(property)[0];
            if (IE <= 8) {
              try {
                element.style[propertyName] = propertyValue;
              } catch (error) {
                if (Velocity.debug) {
                  console.log("Browser does not support [" + propertyValue + "] for [" + propertyName + "]");
                }
              }
            } else {
              var data = Data(element);
              if (data && data.isSVG && CSS.Names.SVGAttribute(property)) {
                element.setAttribute(property, propertyValue);
              } else {
                element.style[propertyName] = propertyValue;
              }
            }
            if (Velocity.debug >= 2) {
              console.log("Set " + property + " (" + propertyName + "): " + propertyValue);
            }
          }
        }
        return [propertyName, propertyValue];
      },
      flushTransformCache: function(element) {
        var transformString = "", data = Data(element);
        if ((IE || Velocity.State.isAndroid && !Velocity.State.isChrome) && data && data.isSVG) {
          var getTransformFloat = function(transformProperty) {
            return parseFloat(CSS.getPropertyValue(element, transformProperty));
          };
          var SVGTransforms = {
            translate: [getTransformFloat("translateX"), getTransformFloat("translateY")],
            skewX: [getTransformFloat("skewX")],
            skewY: [getTransformFloat("skewY")],
            scale: getTransformFloat("scale") !== 1 ? [getTransformFloat("scale"), getTransformFloat("scale")] : [getTransformFloat("scaleX"), getTransformFloat("scaleY")],
            rotate: [getTransformFloat("rotateZ"), 0, 0]
          };
          $.each(Data(element).transformCache, function(transformName) {
            if (/^translate/i.test(transformName)) {
              transformName = "translate";
            } else if (/^scale/i.test(transformName)) {
              transformName = "scale";
            } else if (/^rotate/i.test(transformName)) {
              transformName = "rotate";
            }
            if (SVGTransforms[transformName]) {
              transformString += transformName + "(" + SVGTransforms[transformName].join(" ") + ") ";
              delete SVGTransforms[transformName];
            }
          });
        } else {
          var transformValue, perspective;
          $.each(Data(element).transformCache, function(transformName) {
            transformValue = Data(element).transformCache[transformName];
            if (transformName === "transformPerspective") {
              perspective = transformValue;
              return true;
            }
            if (IE === 9 && transformName === "rotateZ") {
              transformName = "rotate";
            }
            transformString += transformName + transformValue + " ";
          });
          if (perspective) {
            transformString = "perspective" + perspective + " " + transformString;
          }
        }
        CSS.setPropertyValue(element, "transform", transformString);
      }
    };
    CSS.Hooks.register();
    CSS.Normalizations.register();
    Velocity.hook = function(elements, arg2, arg3) {
      var value;
      elements = sanitizeElements(elements);
      $.each(elements, function(i, element) {
        if (Data(element) === undefined2) {
          Velocity.init(element);
        }
        if (arg3 === undefined2) {
          if (value === undefined2) {
            value = CSS.getPropertyValue(element, arg2);
          }
        } else {
          var adjustedSet = CSS.setPropertyValue(element, arg2, arg3);
          if (adjustedSet[0] === "transform") {
            Velocity.CSS.flushTransformCache(element);
          }
          value = adjustedSet;
        }
      });
      return value;
    };
    var animate = function() {
      var opts;
      function getChain() {
        if (isUtility) {
          return promiseData.promise || null;
        } else {
          return elementsWrapped;
        }
      }
      var syntacticSugar = arguments[0] && (arguments[0].p || ($.isPlainObject(arguments[0].properties) && !arguments[0].properties.names || Type.isString(arguments[0].properties))), isUtility, elementsWrapped, argumentIndex;
      var elements, propertiesMap, options;
      if (Type.isWrapped(this)) {
        isUtility = false;
        argumentIndex = 0;
        elements = this;
        elementsWrapped = this;
      } else {
        isUtility = true;
        argumentIndex = 1;
        elements = syntacticSugar ? arguments[0].elements || arguments[0].e : arguments[0];
      }
      var promiseData = {
        promise: null,
        resolver: null,
        rejecter: null
      };
      if (isUtility && Velocity.Promise) {
        promiseData.promise = new Velocity.Promise(function(resolve, reject) {
          promiseData.resolver = resolve;
          promiseData.rejecter = reject;
        });
      }
      if (syntacticSugar) {
        propertiesMap = arguments[0].properties || arguments[0].p;
        options = arguments[0].options || arguments[0].o;
      } else {
        propertiesMap = arguments[argumentIndex];
        options = arguments[argumentIndex + 1];
      }
      elements = sanitizeElements(elements);
      if (!elements) {
        if (promiseData.promise) {
          if (!propertiesMap || !options || options.promiseRejectEmpty !== false) {
            promiseData.rejecter();
          } else {
            promiseData.resolver();
          }
        }
        return;
      }
      var elementsLength = elements.length, elementsIndex = 0;
      if (!/^(stop|finish|finishAll|pause|resume)$/i.test(propertiesMap) && !$.isPlainObject(options)) {
        var startingArgumentPosition = argumentIndex + 1;
        options = {};
        for (var i = startingArgumentPosition; i < arguments.length; i++) {
          if (!Type.isArray(arguments[i]) && (/^(fast|normal|slow)$/i.test(arguments[i]) || /^\d/.test(arguments[i]))) {
            options.duration = arguments[i];
          } else if (Type.isString(arguments[i]) || Type.isArray(arguments[i])) {
            options.easing = arguments[i];
          } else if (Type.isFunction(arguments[i])) {
            options.complete = arguments[i];
          }
        }
      }
      var action;
      switch (propertiesMap) {
        case "scroll":
          action = "scroll";
          break;
        case "reverse":
          action = "reverse";
          break;
        case "pause":
          var currentTime = new Date().getTime();
          $.each(elements, function(i2, element) {
            pauseDelayOnElement(element, currentTime);
          });
          $.each(Velocity.State.calls, function(i2, activeCall) {
            var found = false;
            if (activeCall) {
              $.each(activeCall[1], function(k, activeElement) {
                var queueName = options === undefined2 ? "" : options;
                if (queueName !== true && activeCall[2].queue !== queueName && !(options === undefined2 && activeCall[2].queue === false)) {
                  return true;
                }
                $.each(elements, function(l, element) {
                  if (element === activeElement) {
                    activeCall[5] = {
                      resume: false
                    };
                    found = true;
                    return false;
                  }
                });
                if (found) {
                  return false;
                }
              });
            }
          });
          return getChain();
        case "resume":
          $.each(elements, function(i2, element) {
            resumeDelayOnElement(element, currentTime);
          });
          $.each(Velocity.State.calls, function(i2, activeCall) {
            var found = false;
            if (activeCall) {
              $.each(activeCall[1], function(k, activeElement) {
                var queueName = options === undefined2 ? "" : options;
                if (queueName !== true && activeCall[2].queue !== queueName && !(options === undefined2 && activeCall[2].queue === false)) {
                  return true;
                }
                if (!activeCall[5]) {
                  return true;
                }
                $.each(elements, function(l, element) {
                  if (element === activeElement) {
                    activeCall[5].resume = true;
                    found = true;
                    return false;
                  }
                });
                if (found) {
                  return false;
                }
              });
            }
          });
          return getChain();
        case "finish":
        case "finishAll":
        case "stop":
          $.each(elements, function(i2, element) {
            if (Data(element) && Data(element).delayTimer) {
              clearTimeout(Data(element).delayTimer.setTimeout);
              if (Data(element).delayTimer.next) {
                Data(element).delayTimer.next();
              }
              delete Data(element).delayTimer;
            }
            if (propertiesMap === "finishAll" && (options === true || Type.isString(options))) {
              $.each($.queue(element, Type.isString(options) ? options : ""), function(_, item) {
                if (Type.isFunction(item)) {
                  item();
                }
              });
              $.queue(element, Type.isString(options) ? options : "", []);
            }
          });
          var callsToStop = [];
          $.each(Velocity.State.calls, function(i2, activeCall) {
            if (activeCall) {
              $.each(activeCall[1], function(k, activeElement) {
                var queueName = options === undefined2 ? "" : options;
                if (queueName !== true && activeCall[2].queue !== queueName && !(options === undefined2 && activeCall[2].queue === false)) {
                  return true;
                }
                $.each(elements, function(l, element) {
                  if (element === activeElement) {
                    if (options === true || Type.isString(options)) {
                      $.each($.queue(element, Type.isString(options) ? options : ""), function(_, item) {
                        if (Type.isFunction(item)) {
                          item(null, true);
                        }
                      });
                      $.queue(element, Type.isString(options) ? options : "", []);
                    }
                    if (propertiesMap === "stop") {
                      var data = Data(element);
                      if (data && data.tweensContainer && queueName !== false) {
                        $.each(data.tweensContainer, function(m, activeTween) {
                          activeTween.endValue = activeTween.currentValue;
                        });
                      }
                      callsToStop.push(i2);
                    } else if (propertiesMap === "finish" || propertiesMap === "finishAll") {
                      activeCall[2].duration = 1;
                    }
                  }
                });
              });
            }
          });
          if (propertiesMap === "stop") {
            $.each(callsToStop, function(i2, j) {
              completeCall(j, true);
            });
            if (promiseData.promise) {
              promiseData.resolver(elements);
            }
          }
          return getChain();
        default:
          if ($.isPlainObject(propertiesMap) && !Type.isEmptyObject(propertiesMap)) {
            action = "start";
          } else if (Type.isString(propertiesMap) && Velocity.Redirects[propertiesMap]) {
            opts = $.extend({}, options);
            var durationOriginal = opts.duration, delayOriginal = opts.delay || 0;
            if (opts.backwards === true) {
              elements = $.extend(true, [], elements).reverse();
            }
            $.each(elements, function(elementIndex, element) {
              if (parseFloat(opts.stagger)) {
                opts.delay = delayOriginal + parseFloat(opts.stagger) * elementIndex;
              } else if (Type.isFunction(opts.stagger)) {
                opts.delay = delayOriginal + opts.stagger.call(element, elementIndex, elementsLength);
              }
              if (opts.drag) {
                opts.duration = parseFloat(durationOriginal) || (/^(callout|transition)/.test(propertiesMap) ? 1e3 : DURATION_DEFAULT);
                opts.duration = Math.max(opts.duration * (opts.backwards ? 1 - elementIndex / elementsLength : (elementIndex + 1) / elementsLength), opts.duration * 0.75, 200);
              }
              Velocity.Redirects[propertiesMap].call(element, element, opts || {}, elementIndex, elementsLength, elements, promiseData.promise ? promiseData : undefined2);
            });
            return getChain();
          } else {
            var abortError = "Velocity: First argument (" + propertiesMap + ") was not a property map, a known action, or a registered redirect. Aborting.";
            if (promiseData.promise) {
              promiseData.rejecter(new Error(abortError));
            } else if (window2.console) {
              console.log(abortError);
            }
            return getChain();
          }
      }
      var callUnitConversionData = {
        lastParent: null,
        lastPosition: null,
        lastFontSize: null,
        lastPercentToPxWidth: null,
        lastPercentToPxHeight: null,
        lastEmToPx: null,
        remToPx: null,
        vwToPx: null,
        vhToPx: null
      };
      var call = [];
      function processElement(element, elementArrayIndex) {
        var opts2 = $.extend({}, Velocity.defaults, options), tweensContainer = {}, elementUnitConversionData;
        if (Data(element) === undefined2) {
          Velocity.init(element);
        }
        if (parseFloat(opts2.delay) && opts2.queue !== false) {
          $.queue(element, opts2.queue, function(next) {
            Velocity.velocityQueueEntryFlag = true;
            var callIndex2 = Velocity.State.delayedElements.count++;
            Velocity.State.delayedElements[callIndex2] = element;
            var delayComplete2 = function(index) {
              return function() {
                Velocity.State.delayedElements[index] = false;
                next();
              };
            }(callIndex2);
            Data(element).delayBegin = new Date().getTime();
            Data(element).delay = parseFloat(opts2.delay);
            Data(element).delayTimer = {
              setTimeout: setTimeout(next, parseFloat(opts2.delay)),
              next: delayComplete2
            };
          });
        }
        switch (opts2.duration.toString().toLowerCase()) {
          case "fast":
            opts2.duration = 200;
            break;
          case "normal":
            opts2.duration = DURATION_DEFAULT;
            break;
          case "slow":
            opts2.duration = 600;
            break;
          default:
            opts2.duration = parseFloat(opts2.duration) || 1;
        }
        if (Velocity.mock !== false) {
          if (Velocity.mock === true) {
            opts2.duration = opts2.delay = 1;
          } else {
            opts2.duration *= parseFloat(Velocity.mock) || 1;
            opts2.delay *= parseFloat(Velocity.mock) || 1;
          }
        }
        opts2.easing = getEasing(opts2.easing, opts2.duration);
        if (opts2.begin && !Type.isFunction(opts2.begin)) {
          opts2.begin = null;
        }
        if (opts2.progress && !Type.isFunction(opts2.progress)) {
          opts2.progress = null;
        }
        if (opts2.complete && !Type.isFunction(opts2.complete)) {
          opts2.complete = null;
        }
        if (opts2.display !== undefined2 && opts2.display !== null) {
          opts2.display = opts2.display.toString().toLowerCase();
          if (opts2.display === "auto") {
            opts2.display = Velocity.CSS.Values.getDisplayType(element);
          }
        }
        if (opts2.visibility !== undefined2 && opts2.visibility !== null) {
          opts2.visibility = opts2.visibility.toString().toLowerCase();
        }
        opts2.mobileHA = opts2.mobileHA && Velocity.State.isMobile && !Velocity.State.isGingerbread;
        function buildQueue(next) {
          var data, lastTweensContainer;
          if (opts2.begin && elementsIndex === 0) {
            try {
              opts2.begin.call(elements, elements);
            } catch (error) {
              setTimeout(function() {
                throw error;
              }, 1);
            }
          }
          if (action === "scroll") {
            var scrollDirection = /^x$/i.test(opts2.axis) ? "Left" : "Top", scrollOffset = parseFloat(opts2.offset) || 0, scrollPositionCurrent, scrollPositionCurrentAlternate, scrollPositionEnd;
            if (opts2.container) {
              if (Type.isWrapped(opts2.container) || Type.isNode(opts2.container)) {
                opts2.container = opts2.container[0] || opts2.container;
                scrollPositionCurrent = opts2.container["scroll" + scrollDirection];
                scrollPositionEnd = scrollPositionCurrent + $(element).position()[scrollDirection.toLowerCase()] + scrollOffset;
              } else {
                opts2.container = null;
              }
            } else {
              scrollPositionCurrent = Velocity.State.scrollAnchor[Velocity.State["scrollProperty" + scrollDirection]];
              scrollPositionCurrentAlternate = Velocity.State.scrollAnchor[Velocity.State["scrollProperty" + (scrollDirection === "Left" ? "Top" : "Left")]];
              scrollPositionEnd = $(element).offset()[scrollDirection.toLowerCase()] + scrollOffset;
            }
            tweensContainer = {
              scroll: {
                rootPropertyValue: false,
                startValue: scrollPositionCurrent,
                currentValue: scrollPositionCurrent,
                endValue: scrollPositionEnd,
                unitType: "",
                easing: opts2.easing,
                scrollData: {
                  container: opts2.container,
                  direction: scrollDirection,
                  alternateValue: scrollPositionCurrentAlternate
                }
              },
              element
            };
            if (Velocity.debug) {
              console.log("tweensContainer (scroll): ", tweensContainer.scroll, element);
            }
          } else if (action === "reverse") {
            data = Data(element);
            if (!data) {
              return;
            }
            if (!data.tweensContainer) {
              $.dequeue(element, opts2.queue);
              return;
            } else {
              if (data.opts.display === "none") {
                data.opts.display = "auto";
              }
              if (data.opts.visibility === "hidden") {
                data.opts.visibility = "visible";
              }
              data.opts.loop = false;
              data.opts.begin = null;
              data.opts.complete = null;
              if (!options.easing) {
                delete opts2.easing;
              }
              if (!options.duration) {
                delete opts2.duration;
              }
              opts2 = $.extend({}, data.opts, opts2);
              lastTweensContainer = $.extend(true, {}, data ? data.tweensContainer : null);
              for (var lastTween in lastTweensContainer) {
                if (lastTweensContainer.hasOwnProperty(lastTween) && lastTween !== "element") {
                  var lastStartValue = lastTweensContainer[lastTween].startValue;
                  lastTweensContainer[lastTween].startValue = lastTweensContainer[lastTween].currentValue = lastTweensContainer[lastTween].endValue;
                  lastTweensContainer[lastTween].endValue = lastStartValue;
                  if (!Type.isEmptyObject(options)) {
                    lastTweensContainer[lastTween].easing = opts2.easing;
                  }
                  if (Velocity.debug) {
                    console.log("reverse tweensContainer (" + lastTween + "): " + JSON.stringify(lastTweensContainer[lastTween]), element);
                  }
                }
              }
              tweensContainer = lastTweensContainer;
            }
          } else if (action === "start") {
            data = Data(element);
            if (data && data.tweensContainer && data.isAnimating === true) {
              lastTweensContainer = data.tweensContainer;
            }
            var parsePropertyValue = function(valueData2, skipResolvingEasing) {
              var endValue2, easing2, startValue2;
              if (Type.isFunction(valueData2)) {
                valueData2 = valueData2.call(element, elementArrayIndex, elementsLength);
              }
              if (Type.isArray(valueData2)) {
                endValue2 = valueData2[0];
                if (!Type.isArray(valueData2[1]) && /^[\d-]/.test(valueData2[1]) || Type.isFunction(valueData2[1]) || CSS.RegEx.isHex.test(valueData2[1])) {
                  startValue2 = valueData2[1];
                } else if (Type.isString(valueData2[1]) && !CSS.RegEx.isHex.test(valueData2[1]) && Velocity.Easings[valueData2[1]] || Type.isArray(valueData2[1])) {
                  easing2 = skipResolvingEasing ? valueData2[1] : getEasing(valueData2[1], opts2.duration);
                  startValue2 = valueData2[2];
                } else {
                  startValue2 = valueData2[1] || valueData2[2];
                }
              } else {
                endValue2 = valueData2;
              }
              if (!skipResolvingEasing) {
                easing2 = easing2 || opts2.easing;
              }
              if (Type.isFunction(endValue2)) {
                endValue2 = endValue2.call(element, elementArrayIndex, elementsLength);
              }
              if (Type.isFunction(startValue2)) {
                startValue2 = startValue2.call(element, elementArrayIndex, elementsLength);
              }
              return [endValue2 || 0, easing2, startValue2];
            };
            var fixPropertyValue = function(property2, valueData2) {
              var rootProperty = CSS.Hooks.getRoot(property2), rootPropertyValue = false, endValue2 = valueData2[0], easing2 = valueData2[1], startValue2 = valueData2[2], pattern;
              if ((!data || !data.isSVG) && rootProperty !== "tween" && CSS.Names.prefixCheck(rootProperty)[1] === false && CSS.Normalizations.registered[rootProperty] === undefined2) {
                if (Velocity.debug) {
                  console.log("Skipping [" + rootProperty + "] due to a lack of browser support.");
                }
                return;
              }
              if ((opts2.display !== undefined2 && opts2.display !== null && opts2.display !== "none" || opts2.visibility !== undefined2 && opts2.visibility !== "hidden") && /opacity|filter/.test(property2) && !startValue2 && endValue2 !== 0) {
                startValue2 = 0;
              }
              if (opts2._cacheValues && lastTweensContainer && lastTweensContainer[property2]) {
                if (startValue2 === undefined2) {
                  startValue2 = lastTweensContainer[property2].endValue + lastTweensContainer[property2].unitType;
                }
                rootPropertyValue = data.rootPropertyValueCache[rootProperty];
              } else {
                if (CSS.Hooks.registered[property2]) {
                  if (startValue2 === undefined2) {
                    rootPropertyValue = CSS.getPropertyValue(element, rootProperty);
                    startValue2 = CSS.getPropertyValue(element, property2, rootPropertyValue);
                  } else {
                    rootPropertyValue = CSS.Hooks.templates[rootProperty][1];
                  }
                } else if (startValue2 === undefined2) {
                  startValue2 = CSS.getPropertyValue(element, property2);
                }
              }
              var separatedValue, endValueUnitType, startValueUnitType, operator = false;
              var separateValue = function(property3, value) {
                var unitType, numericValue;
                numericValue = (value || "0").toString().toLowerCase().replace(/[%A-z]+$/, function(match) {
                  unitType = match;
                  return "";
                });
                if (!unitType) {
                  unitType = CSS.Values.getUnitType(property3);
                }
                return [numericValue, unitType];
              };
              if (startValue2 !== endValue2 && Type.isString(startValue2) && Type.isString(endValue2)) {
                pattern = "";
                var iStart = 0, iEnd = 0, aStart = [], aEnd = [], inCalc = 0, inRGB = 0, inRGBA = 0;
                startValue2 = CSS.Hooks.fixColors(startValue2);
                endValue2 = CSS.Hooks.fixColors(endValue2);
                while (iStart < startValue2.length && iEnd < endValue2.length) {
                  var cStart = startValue2[iStart], cEnd = endValue2[iEnd];
                  if (/[\d\.-]/.test(cStart) && /[\d\.-]/.test(cEnd)) {
                    var tStart = cStart, tEnd = cEnd, dotStart = ".", dotEnd = ".";
                    while (++iStart < startValue2.length) {
                      cStart = startValue2[iStart];
                      if (cStart === dotStart) {
                        dotStart = "..";
                      } else if (!/\d/.test(cStart)) {
                        break;
                      }
                      tStart += cStart;
                    }
                    while (++iEnd < endValue2.length) {
                      cEnd = endValue2[iEnd];
                      if (cEnd === dotEnd) {
                        dotEnd = "..";
                      } else if (!/\d/.test(cEnd)) {
                        break;
                      }
                      tEnd += cEnd;
                    }
                    var uStart = CSS.Hooks.getUnit(startValue2, iStart), uEnd = CSS.Hooks.getUnit(endValue2, iEnd);
                    iStart += uStart.length;
                    iEnd += uEnd.length;
                    if (uStart === uEnd) {
                      if (tStart === tEnd) {
                        pattern += tStart + uStart;
                      } else {
                        pattern += "{" + aStart.length + (inRGB ? "!" : "") + "}" + uStart;
                        aStart.push(parseFloat(tStart));
                        aEnd.push(parseFloat(tEnd));
                      }
                    } else {
                      var nStart = parseFloat(tStart), nEnd = parseFloat(tEnd);
                      pattern += (inCalc < 5 ? "calc" : "") + "(" + (nStart ? "{" + aStart.length + (inRGB ? "!" : "") + "}" : "0") + uStart + " + " + (nEnd ? "{" + (aStart.length + (nStart ? 1 : 0)) + (inRGB ? "!" : "") + "}" : "0") + uEnd + ")";
                      if (nStart) {
                        aStart.push(nStart);
                        aEnd.push(0);
                      }
                      if (nEnd) {
                        aStart.push(0);
                        aEnd.push(nEnd);
                      }
                    }
                  } else if (cStart === cEnd) {
                    pattern += cStart;
                    iStart++;
                    iEnd++;
                    if (inCalc === 0 && cStart === "c" || inCalc === 1 && cStart === "a" || inCalc === 2 && cStart === "l" || inCalc === 3 && cStart === "c" || inCalc >= 4 && cStart === "(") {
                      inCalc++;
                    } else if (inCalc && inCalc < 5 || inCalc >= 4 && cStart === ")" && --inCalc < 5) {
                      inCalc = 0;
                    }
                    if (inRGB === 0 && cStart === "r" || inRGB === 1 && cStart === "g" || inRGB === 2 && cStart === "b" || inRGB === 3 && cStart === "a" || inRGB >= 3 && cStart === "(") {
                      if (inRGB === 3 && cStart === "a") {
                        inRGBA = 1;
                      }
                      inRGB++;
                    } else if (inRGBA && cStart === ",") {
                      if (++inRGBA > 3) {
                        inRGB = inRGBA = 0;
                      }
                    } else if (inRGBA && inRGB < (inRGBA ? 5 : 4) || inRGB >= (inRGBA ? 4 : 3) && cStart === ")" && --inRGB < (inRGBA ? 5 : 4)) {
                      inRGB = inRGBA = 0;
                    }
                  } else {
                    inCalc = 0;
                    break;
                  }
                }
                if (iStart !== startValue2.length || iEnd !== endValue2.length) {
                  if (Velocity.debug) {
                    console.error('Trying to pattern match mis-matched strings ["' + endValue2 + '", "' + startValue2 + '"]');
                  }
                  pattern = undefined2;
                }
                if (pattern) {
                  if (aStart.length) {
                    if (Velocity.debug) {
                      console.log('Pattern found "' + pattern + '" -> ', aStart, aEnd, "[" + startValue2 + "," + endValue2 + "]");
                    }
                    startValue2 = aStart;
                    endValue2 = aEnd;
                    endValueUnitType = startValueUnitType = "";
                  } else {
                    pattern = undefined2;
                  }
                }
              }
              if (!pattern) {
                separatedValue = separateValue(property2, startValue2);
                startValue2 = separatedValue[0];
                startValueUnitType = separatedValue[1];
                separatedValue = separateValue(property2, endValue2);
                endValue2 = separatedValue[0].replace(/^([+-\/*])=/, function(match, subMatch) {
                  operator = subMatch;
                  return "";
                });
                endValueUnitType = separatedValue[1];
                startValue2 = parseFloat(startValue2) || 0;
                endValue2 = parseFloat(endValue2) || 0;
                if (endValueUnitType === "%") {
                  if (/^(fontSize|lineHeight)$/.test(property2)) {
                    endValue2 = endValue2 / 100;
                    endValueUnitType = "em";
                  } else if (/^scale/.test(property2)) {
                    endValue2 = endValue2 / 100;
                    endValueUnitType = "";
                  } else if (/(Red|Green|Blue)$/i.test(property2)) {
                    endValue2 = endValue2 / 100 * 255;
                    endValueUnitType = "";
                  }
                }
              }
              var calculateUnitRatios = function() {
                var sameRatioIndicators = {
                  myParent: element.parentNode || document2.body,
                  position: CSS.getPropertyValue(element, "position"),
                  fontSize: CSS.getPropertyValue(element, "fontSize")
                }, samePercentRatio = sameRatioIndicators.position === callUnitConversionData.lastPosition && sameRatioIndicators.myParent === callUnitConversionData.lastParent, sameEmRatio = sameRatioIndicators.fontSize === callUnitConversionData.lastFontSize;
                callUnitConversionData.lastParent = sameRatioIndicators.myParent;
                callUnitConversionData.lastPosition = sameRatioIndicators.position;
                callUnitConversionData.lastFontSize = sameRatioIndicators.fontSize;
                var measurement = 100, unitRatios = {};
                if (!sameEmRatio || !samePercentRatio) {
                  var dummy = data && data.isSVG ? document2.createElementNS("http://www.w3.org/2000/svg", "rect") : document2.createElement("div");
                  Velocity.init(dummy);
                  sameRatioIndicators.myParent.appendChild(dummy);
                  $.each(["overflow", "overflowX", "overflowY"], function(i3, property3) {
                    Velocity.CSS.setPropertyValue(dummy, property3, "hidden");
                  });
                  Velocity.CSS.setPropertyValue(dummy, "position", sameRatioIndicators.position);
                  Velocity.CSS.setPropertyValue(dummy, "fontSize", sameRatioIndicators.fontSize);
                  Velocity.CSS.setPropertyValue(dummy, "boxSizing", "content-box");
                  $.each(["minWidth", "maxWidth", "width", "minHeight", "maxHeight", "height"], function(i3, property3) {
                    Velocity.CSS.setPropertyValue(dummy, property3, measurement + "%");
                  });
                  Velocity.CSS.setPropertyValue(dummy, "paddingLeft", measurement + "em");
                  unitRatios.percentToPxWidth = callUnitConversionData.lastPercentToPxWidth = (parseFloat(CSS.getPropertyValue(dummy, "width", null, true)) || 1) / measurement;
                  unitRatios.percentToPxHeight = callUnitConversionData.lastPercentToPxHeight = (parseFloat(CSS.getPropertyValue(dummy, "height", null, true)) || 1) / measurement;
                  unitRatios.emToPx = callUnitConversionData.lastEmToPx = (parseFloat(CSS.getPropertyValue(dummy, "paddingLeft")) || 1) / measurement;
                  sameRatioIndicators.myParent.removeChild(dummy);
                } else {
                  unitRatios.emToPx = callUnitConversionData.lastEmToPx;
                  unitRatios.percentToPxWidth = callUnitConversionData.lastPercentToPxWidth;
                  unitRatios.percentToPxHeight = callUnitConversionData.lastPercentToPxHeight;
                }
                if (callUnitConversionData.remToPx === null) {
                  callUnitConversionData.remToPx = parseFloat(CSS.getPropertyValue(document2.body, "fontSize")) || 16;
                }
                if (callUnitConversionData.vwToPx === null) {
                  callUnitConversionData.vwToPx = parseFloat(window2.innerWidth) / 100;
                  callUnitConversionData.vhToPx = parseFloat(window2.innerHeight) / 100;
                }
                unitRatios.remToPx = callUnitConversionData.remToPx;
                unitRatios.vwToPx = callUnitConversionData.vwToPx;
                unitRatios.vhToPx = callUnitConversionData.vhToPx;
                if (Velocity.debug >= 1) {
                  console.log("Unit ratios: " + JSON.stringify(unitRatios), element);
                }
                return unitRatios;
              };
              if (/[\/*]/.test(operator)) {
                endValueUnitType = startValueUnitType;
              } else if (startValueUnitType !== endValueUnitType && startValue2 !== 0) {
                if (endValue2 === 0) {
                  endValueUnitType = startValueUnitType;
                } else {
                  elementUnitConversionData = elementUnitConversionData || calculateUnitRatios();
                  var axis = /margin|padding|left|right|width|text|word|letter/i.test(property2) || /X$/.test(property2) || property2 === "x" ? "x" : "y";
                  switch (startValueUnitType) {
                    case "%":
                      startValue2 *= axis === "x" ? elementUnitConversionData.percentToPxWidth : elementUnitConversionData.percentToPxHeight;
                      break;
                    case "px":
                      break;
                    default:
                      startValue2 *= elementUnitConversionData[startValueUnitType + "ToPx"];
                  }
                  switch (endValueUnitType) {
                    case "%":
                      startValue2 *= 1 / (axis === "x" ? elementUnitConversionData.percentToPxWidth : elementUnitConversionData.percentToPxHeight);
                      break;
                    case "px":
                      break;
                    default:
                      startValue2 *= 1 / elementUnitConversionData[endValueUnitType + "ToPx"];
                  }
                }
              }
              switch (operator) {
                case "+":
                  endValue2 = startValue2 + endValue2;
                  break;
                case "-":
                  endValue2 = startValue2 - endValue2;
                  break;
                case "*":
                  endValue2 = startValue2 * endValue2;
                  break;
                case "/":
                  endValue2 = startValue2 / endValue2;
                  break;
              }
              tweensContainer[property2] = {
                rootPropertyValue,
                startValue: startValue2,
                currentValue: startValue2,
                endValue: endValue2,
                unitType: endValueUnitType,
                easing: easing2
              };
              if (pattern) {
                tweensContainer[property2].pattern = pattern;
              }
              if (Velocity.debug) {
                console.log("tweensContainer (" + property2 + "): " + JSON.stringify(tweensContainer[property2]), element);
              }
            };
            for (var property in propertiesMap) {
              if (!propertiesMap.hasOwnProperty(property)) {
                continue;
              }
              var propertyName = CSS.Names.camelCase(property), valueData = parsePropertyValue(propertiesMap[property]);
              if (_inArray(CSS.Lists.colors, propertyName)) {
                var endValue = valueData[0], easing = valueData[1], startValue = valueData[2];
                if (CSS.RegEx.isHex.test(endValue)) {
                  var colorComponents = ["Red", "Green", "Blue"], endValueRGB = CSS.Values.hexToRgb(endValue), startValueRGB = startValue ? CSS.Values.hexToRgb(startValue) : undefined2;
                  for (var i2 = 0; i2 < colorComponents.length; i2++) {
                    var dataArray = [endValueRGB[i2]];
                    if (easing) {
                      dataArray.push(easing);
                    }
                    if (startValueRGB !== undefined2) {
                      dataArray.push(startValueRGB[i2]);
                    }
                    fixPropertyValue(propertyName + colorComponents[i2], dataArray);
                  }
                  continue;
                }
              }
              fixPropertyValue(propertyName, valueData);
            }
            tweensContainer.element = element;
          }
          if (tweensContainer.element) {
            CSS.Values.addClass(element, "velocity-animating");
            call.push(tweensContainer);
            data = Data(element);
            if (data) {
              if (opts2.queue === "") {
                data.tweensContainer = tweensContainer;
                data.opts = opts2;
              }
              data.isAnimating = true;
            }
            if (elementsIndex === elementsLength - 1) {
              Velocity.State.calls.push([call, elements, opts2, null, promiseData.resolver, null, 0]);
              if (Velocity.State.isTicking === false) {
                Velocity.State.isTicking = true;
                tick();
              }
            } else {
              elementsIndex++;
            }
          }
        }
        if (opts2.queue === false) {
          if (opts2.delay) {
            var callIndex = Velocity.State.delayedElements.count++;
            Velocity.State.delayedElements[callIndex] = element;
            var delayComplete = function(index) {
              return function() {
                Velocity.State.delayedElements[index] = false;
                buildQueue();
              };
            }(callIndex);
            Data(element).delayBegin = new Date().getTime();
            Data(element).delay = parseFloat(opts2.delay);
            Data(element).delayTimer = {
              setTimeout: setTimeout(buildQueue, parseFloat(opts2.delay)),
              next: delayComplete
            };
          } else {
            buildQueue();
          }
        } else {
          $.queue(element, opts2.queue, function(next, clearQueue) {
            if (clearQueue === true) {
              if (promiseData.promise) {
                promiseData.resolver(elements);
              }
              return true;
            }
            Velocity.velocityQueueEntryFlag = true;
            buildQueue(next);
          });
        }
        if ((opts2.queue === "" || opts2.queue === "fx") && $.queue(element)[0] !== "inprogress") {
          $.dequeue(element);
        }
      }
      $.each(elements, function(i2, element) {
        if (Type.isNode(element)) {
          processElement(element, i2);
        }
      });
      opts = $.extend({}, Velocity.defaults, options);
      opts.loop = parseInt(opts.loop, 10);
      var reverseCallsCount = opts.loop * 2 - 1;
      if (opts.loop) {
        for (var x = 0; x < reverseCallsCount; x++) {
          var reverseOptions = {
            delay: opts.delay,
            progress: opts.progress
          };
          if (x === reverseCallsCount - 1) {
            reverseOptions.display = opts.display;
            reverseOptions.visibility = opts.visibility;
            reverseOptions.complete = opts.complete;
          }
          animate(elements, "reverse", reverseOptions);
        }
      }
      return getChain();
    };
    Velocity = $.extend(animate, Velocity);
    Velocity.animate = animate;
    var ticker = window2.requestAnimationFrame || rAFShim;
    if (!Velocity.State.isMobile && document2.hidden !== undefined2) {
      var updateTicker = function() {
        if (document2.hidden) {
          ticker = function(callback) {
            return setTimeout(function() {
              callback(true);
            }, 16);
          };
          tick();
        } else {
          ticker = window2.requestAnimationFrame || rAFShim;
        }
      };
      updateTicker();
      document2.addEventListener("visibilitychange", updateTicker);
    }
    function tick(timestamp) {
      if (timestamp) {
        var timeCurrent = Velocity.timestamp && timestamp !== true ? timestamp : performance.now();
        var callsLength = Velocity.State.calls.length;
        if (callsLength > 1e4) {
          Velocity.State.calls = compactSparseArray(Velocity.State.calls);
          callsLength = Velocity.State.calls.length;
        }
        for (var i = 0; i < callsLength; i++) {
          if (!Velocity.State.calls[i]) {
            continue;
          }
          var callContainer = Velocity.State.calls[i], call = callContainer[0], opts = callContainer[2], timeStart = callContainer[3], firstTick = !!timeStart, tweenDummyValue = null, pauseObject = callContainer[5], millisecondsEllapsed = callContainer[6];
          if (!timeStart) {
            timeStart = Velocity.State.calls[i][3] = timeCurrent - 16;
          }
          if (pauseObject) {
            if (pauseObject.resume === true) {
              timeStart = callContainer[3] = Math.round(timeCurrent - millisecondsEllapsed - 16);
              callContainer[5] = null;
            } else {
              continue;
            }
          }
          millisecondsEllapsed = callContainer[6] = timeCurrent - timeStart;
          var percentComplete = Math.min(millisecondsEllapsed / opts.duration, 1);
          for (var j = 0, callLength = call.length; j < callLength; j++) {
            var tweensContainer = call[j], element = tweensContainer.element;
            if (!Data(element)) {
              continue;
            }
            var transformPropertyExists = false;
            if (opts.display !== undefined2 && opts.display !== null && opts.display !== "none") {
              if (opts.display === "flex") {
                var flexValues = ["-webkit-box", "-moz-box", "-ms-flexbox", "-webkit-flex"];
                $.each(flexValues, function(i2, flexValue) {
                  CSS.setPropertyValue(element, "display", flexValue);
                });
              }
              CSS.setPropertyValue(element, "display", opts.display);
            }
            if (opts.visibility !== undefined2 && opts.visibility !== "hidden") {
              CSS.setPropertyValue(element, "visibility", opts.visibility);
            }
            for (var property in tweensContainer) {
              if (tweensContainer.hasOwnProperty(property) && property !== "element") {
                var tween = tweensContainer[property], currentValue, easing = Type.isString(tween.easing) ? Velocity.Easings[tween.easing] : tween.easing;
                if (Type.isString(tween.pattern)) {
                  var patternReplace = percentComplete === 1 ? function($0, index, round) {
                    var result = tween.endValue[index];
                    return round ? Math.round(result) : result;
                  } : function($0, index, round) {
                    var startValue = tween.startValue[index], tweenDelta2 = tween.endValue[index] - startValue, result = startValue + tweenDelta2 * easing(percentComplete, opts, tweenDelta2);
                    return round ? Math.round(result) : result;
                  };
                  currentValue = tween.pattern.replace(/{(\d+)(!)?}/g, patternReplace);
                } else if (percentComplete === 1) {
                  currentValue = tween.endValue;
                } else {
                  var tweenDelta = tween.endValue - tween.startValue;
                  currentValue = tween.startValue + tweenDelta * easing(percentComplete, opts, tweenDelta);
                }
                if (!firstTick && currentValue === tween.currentValue) {
                  continue;
                }
                tween.currentValue = currentValue;
                if (property === "tween") {
                  tweenDummyValue = currentValue;
                } else {
                  var hookRoot;
                  if (CSS.Hooks.registered[property]) {
                    hookRoot = CSS.Hooks.getRoot(property);
                    var rootPropertyValueCache = Data(element).rootPropertyValueCache[hookRoot];
                    if (rootPropertyValueCache) {
                      tween.rootPropertyValue = rootPropertyValueCache;
                    }
                  }
                  var adjustedSetData = CSS.setPropertyValue(element, property, tween.currentValue + (IE < 9 && parseFloat(currentValue) === 0 ? "" : tween.unitType), tween.rootPropertyValue, tween.scrollData);
                  if (CSS.Hooks.registered[property]) {
                    if (CSS.Normalizations.registered[hookRoot]) {
                      Data(element).rootPropertyValueCache[hookRoot] = CSS.Normalizations.registered[hookRoot]("extract", null, adjustedSetData[1]);
                    } else {
                      Data(element).rootPropertyValueCache[hookRoot] = adjustedSetData[1];
                    }
                  }
                  if (adjustedSetData[0] === "transform") {
                    transformPropertyExists = true;
                  }
                }
              }
            }
            if (opts.mobileHA) {
              if (Data(element).transformCache.translate3d === undefined2) {
                Data(element).transformCache.translate3d = "(0px, 0px, 0px)";
                transformPropertyExists = true;
              }
            }
            if (transformPropertyExists) {
              CSS.flushTransformCache(element);
            }
          }
          if (opts.display !== undefined2 && opts.display !== "none") {
            Velocity.State.calls[i][2].display = false;
          }
          if (opts.visibility !== undefined2 && opts.visibility !== "hidden") {
            Velocity.State.calls[i][2].visibility = false;
          }
          if (opts.progress) {
            opts.progress.call(callContainer[1], callContainer[1], percentComplete, Math.max(0, timeStart + opts.duration - timeCurrent), timeStart, tweenDummyValue);
          }
          if (percentComplete === 1) {
            completeCall(i);
          }
        }
      }
      if (Velocity.State.isTicking) {
        ticker(tick);
      }
    }
    function completeCall(callIndex, isStopped) {
      if (!Velocity.State.calls[callIndex]) {
        return false;
      }
      var call = Velocity.State.calls[callIndex][0], elements = Velocity.State.calls[callIndex][1], opts = Velocity.State.calls[callIndex][2], resolver = Velocity.State.calls[callIndex][4];
      var remainingCallsExist = false;
      for (var i = 0, callLength = call.length; i < callLength; i++) {
        var element = call[i].element;
        if (!isStopped && !opts.loop) {
          if (opts.display === "none") {
            CSS.setPropertyValue(element, "display", opts.display);
          }
          if (opts.visibility === "hidden") {
            CSS.setPropertyValue(element, "visibility", opts.visibility);
          }
        }
        var data = Data(element);
        if (opts.loop !== true && ($.queue(element)[1] === undefined2 || !/\.velocityQueueEntryFlag/i.test($.queue(element)[1]))) {
          if (data) {
            data.isAnimating = false;
            data.rootPropertyValueCache = {};
            var transformHAPropertyExists = false;
            $.each(CSS.Lists.transforms3D, function(i2, transformName) {
              var defaultValue = /^scale/.test(transformName) ? 1 : 0, currentValue = data.transformCache[transformName];
              if (data.transformCache[transformName] !== undefined2 && new RegExp("^\\(" + defaultValue + "[^.]").test(currentValue)) {
                transformHAPropertyExists = true;
                delete data.transformCache[transformName];
              }
            });
            if (opts.mobileHA) {
              transformHAPropertyExists = true;
              delete data.transformCache.translate3d;
            }
            if (transformHAPropertyExists) {
              CSS.flushTransformCache(element);
            }
            CSS.Values.removeClass(element, "velocity-animating");
          }
        }
        if (!isStopped && opts.complete && !opts.loop && i === callLength - 1) {
          try {
            opts.complete.call(elements, elements);
          } catch (error) {
            setTimeout(function() {
              throw error;
            }, 1);
          }
        }
        if (resolver && opts.loop !== true) {
          resolver(elements);
        }
        if (data && opts.loop === true && !isStopped) {
          $.each(data.tweensContainer, function(propertyName, tweenContainer) {
            if (/^rotate/.test(propertyName) && (parseFloat(tweenContainer.startValue) - parseFloat(tweenContainer.endValue)) % 360 === 0) {
              var oldStartValue = tweenContainer.startValue;
              tweenContainer.startValue = tweenContainer.endValue;
              tweenContainer.endValue = oldStartValue;
            }
            if (/^backgroundPosition/.test(propertyName) && parseFloat(tweenContainer.endValue) === 100 && tweenContainer.unitType === "%") {
              tweenContainer.endValue = 0;
              tweenContainer.startValue = 100;
            }
          });
          Velocity(element, "reverse", { loop: true, delay: opts.delay });
        }
        if (opts.queue !== false) {
          $.dequeue(element, opts.queue);
        }
      }
      Velocity.State.calls[callIndex] = false;
      for (var j = 0, callsLength = Velocity.State.calls.length; j < callsLength; j++) {
        if (Velocity.State.calls[j] !== false) {
          remainingCallsExist = true;
          break;
        }
      }
      if (remainingCallsExist === false) {
        Velocity.State.isTicking = false;
        delete Velocity.State.calls;
        Velocity.State.calls = [];
      }
    }
    global.Velocity = Velocity;
    if (global !== window2) {
      global.fn.velocity = animate;
      global.fn.velocity.defaults = Velocity.defaults;
    }
    $.each(["Down", "Up"], function(i, direction) {
      Velocity.Redirects["slide" + direction] = function(element, options, elementsIndex, elementsSize, elements, promiseData) {
        var opts = $.extend({}, options), begin = opts.begin, complete = opts.complete, inlineValues = {}, computedValues = { height: "", marginTop: "", marginBottom: "", paddingTop: "", paddingBottom: "" };
        if (opts.display === undefined2) {
          opts.display = direction === "Down" ? Velocity.CSS.Values.getDisplayType(element) === "inline" ? "inline-block" : "block" : "none";
        }
        opts.begin = function() {
          if (elementsIndex === 0 && begin) {
            begin.call(elements, elements);
          }
          for (var property in computedValues) {
            if (!computedValues.hasOwnProperty(property)) {
              continue;
            }
            inlineValues[property] = element.style[property];
            var propertyValue = CSS.getPropertyValue(element, property);
            computedValues[property] = direction === "Down" ? [propertyValue, 0] : [0, propertyValue];
          }
          inlineValues.overflow = element.style.overflow;
          element.style.overflow = "hidden";
        };
        opts.complete = function() {
          for (var property in inlineValues) {
            if (inlineValues.hasOwnProperty(property)) {
              element.style[property] = inlineValues[property];
            }
          }
          if (elementsIndex === elementsSize - 1) {
            if (complete) {
              complete.call(elements, elements);
            }
            if (promiseData) {
              promiseData.resolver(elements);
            }
          }
        };
        Velocity(element, computedValues, opts);
      };
    });
    $.each(["In", "Out"], function(i, direction) {
      Velocity.Redirects["fade" + direction] = function(element, options, elementsIndex, elementsSize, elements, promiseData) {
        var opts = $.extend({}, options), complete = opts.complete, propertiesMap = { opacity: direction === "In" ? 1 : 0 };
        if (elementsIndex !== 0) {
          opts.begin = null;
        }
        if (elementsIndex !== elementsSize - 1) {
          opts.complete = null;
        } else {
          opts.complete = function() {
            if (complete) {
              complete.call(elements, elements);
            }
            if (promiseData) {
              promiseData.resolver(elements);
            }
          };
        }
        if (opts.display === undefined2) {
          opts.display = direction === "In" ? "auto" : "none";
        }
        Velocity(this, propertiesMap, opts);
      };
    });
    return Velocity;
  }(window.jQuery || window.Zepto || window, window, window ? window.document : void 0);
});


/***/ }),

/***/ "./node_modules/expose-loader/dist/cjs.js?exposes=Tether!./node_modules/tether/dist/js/tether-exposed.js":
/*!***************************************************************************************************************!*\
  !*** ./node_modules/expose-loader/dist/cjs.js?exposes=Tether!./node_modules/tether/dist/js/tether-exposed.js ***!
  \***************************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var ___EXPOSE_LOADER_IMPORT___ = __webpack_require__(/*! -!../../../esbuild-loader/dist/index.js!./tether.js */ "./node_modules/esbuild-loader/dist/index.js!./node_modules/tether/dist/js/tether.js");
var ___EXPOSE_LOADER_GET_GLOBAL_THIS___ = __webpack_require__(/*! ../../../expose-loader/dist/runtime/getGlobalThis.js */ "./node_modules/expose-loader/dist/runtime/getGlobalThis.js");
var ___EXPOSE_LOADER_GLOBAL_THIS___ = ___EXPOSE_LOADER_GET_GLOBAL_THIS___;
if (typeof ___EXPOSE_LOADER_GLOBAL_THIS___["Tether"] === 'undefined') ___EXPOSE_LOADER_GLOBAL_THIS___["Tether"] = ___EXPOSE_LOADER_IMPORT___;
else throw new Error('[exposes-loader] The "Tether" value exists in the global scope, it may not be safe to overwrite it, use the "override" option')
module.exports = ___EXPOSE_LOADER_IMPORT___;


/***/ }),

/***/ "jquery":
/*!*************************!*\
  !*** external "jQuery" ***!
  \*************************/
/***/ ((module) => {

"use strict";
module.exports = jQuery;

/***/ }),

/***/ "prestashop":
/*!*****************************!*\
  !*** external "prestashop" ***!
  \*****************************/
/***/ ((module) => {

"use strict";
module.exports = prestashop;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/amd options */
/******/ 	(() => {
/******/ 		__webpack_require__.amdO = {};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
(() => {
"use strict";
var __webpack_exports__ = {};
/*!*********************!*\
  !*** ./js/theme.js ***!
  \*********************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var expose_loader_exposes_Tether_tether__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! expose-loader?exposes=Tether!tether */ "./node_modules/expose-loader/dist/cjs.js?exposes=Tether!./node_modules/tether/dist/js/tether-exposed.js");
/* harmony import */ var expose_loader_exposes_Tether_tether__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(expose_loader_exposes_Tether_tether__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var bootstrap_dist_js_bootstrap_min__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! bootstrap/dist/js/bootstrap.min */ "./node_modules/bootstrap/dist/js/bootstrap.min.js");
/* harmony import */ var bootstrap_dist_js_bootstrap_min__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(bootstrap_dist_js_bootstrap_min__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var flexibility__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! flexibility */ "./node_modules/flexibility/flexibility.js");
/* harmony import */ var flexibility__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(flexibility__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var bootstrap_touchspin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! bootstrap-touchspin */ "./node_modules/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.js");
/* harmony import */ var bootstrap_touchspin__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(bootstrap_touchspin__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var jquery_touchswipe__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! jquery-touchswipe */ "./node_modules/jquery-touchswipe/jquery.touchSwipe.min.js");
/* harmony import */ var jquery_touchswipe__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(jquery_touchswipe__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _selectors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./selectors */ "./js/selectors.js");
/* harmony import */ var _responsive__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./responsive */ "./js/responsive.js");
/* harmony import */ var _checkout__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./checkout */ "./js/checkout.js");
/* harmony import */ var _customer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./customer */ "./js/customer.js");
/* harmony import */ var _listing__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./listing */ "./js/listing.js");
/* harmony import */ var _product__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./product */ "./js/product.js");
/* harmony import */ var _cart__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./cart */ "./js/cart.js");
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prestashop */ "prestashop");
/* harmony import */ var prestashop__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prestashop__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var events__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! events */ "./node_modules/events/events.js");
/* harmony import */ var events__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(events__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _components_drop_down__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./components/drop-down */ "./js/components/drop-down.js");
/* harmony import */ var _components_form__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./components/form */ "./js/components/form.js");
/* harmony import */ var _components_usePasswordPolicy__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./components/usePasswordPolicy */ "./js/components/usePasswordPolicy.js");
/* harmony import */ var _components_product_miniature__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./components/product-miniature */ "./js/components/product-miniature.js");
/* harmony import */ var _components_product_select__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./components/product-select */ "./js/components/product-select.js");
/* harmony import */ var _components_top_menu__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./components/top-menu */ "./js/components/top-menu.js");
/* harmony import */ var _components_display_view__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./components/display-view */ "./js/components/display-view.js");
/* harmony import */ var _lib_bootstrap_filestyle_min__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./lib/bootstrap-filestyle.min */ "./js/lib/bootstrap-filestyle.min.js");
/* harmony import */ var _lib_bootstrap_filestyle_min__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(_lib_bootstrap_filestyle_min__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var _lib_jquery_scrollbox_min__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./lib/jquery.scrollbox.min */ "./js/lib/jquery.scrollbox.min.js");
/* harmony import */ var _lib_jquery_scrollbox_min__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(_lib_jquery_scrollbox_min__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var _components_block_cart__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./components/block-cart */ "./js/components/block-cart.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! jquery */ "jquery");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_24__);
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

























for (const i in (events__WEBPACK_IMPORTED_MODULE_13___default().prototype)) {
  (prestashop__WEBPACK_IMPORTED_MODULE_12___default())[i] = (events__WEBPACK_IMPORTED_MODULE_13___default().prototype)[i];
}
jquery__WEBPACK_IMPORTED_MODULE_24___default()(document).ready(() => {
  const dropDownEl = jquery__WEBPACK_IMPORTED_MODULE_24___default()(".js-dropdown");
  const form = new _components_form__WEBPACK_IMPORTED_MODULE_15__["default"]();
  const topMenuEl = jquery__WEBPACK_IMPORTED_MODULE_24___default()('.js-top-menu ul[data-depth="0"]');
  const dropDown = new _components_drop_down__WEBPACK_IMPORTED_MODULE_14__["default"](dropDownEl);
  const topMenu = new _components_top_menu__WEBPACK_IMPORTED_MODULE_19__["default"](topMenuEl);
  const productMinitature = new _components_product_miniature__WEBPACK_IMPORTED_MODULE_17__["default"]();
  const productSelect = new _components_product_select__WEBPACK_IMPORTED_MODULE_18__["default"]();
  const displayView = new _components_display_view__WEBPACK_IMPORTED_MODULE_20__["default"]();
  dropDown.init();
  form.init();
  topMenu.init();
  productMinitature.init();
  productSelect.init();
  displayView.init();
  (0,_components_usePasswordPolicy__WEBPACK_IMPORTED_MODULE_16__["default"])(".field-password-policy");
});

})();

// This entry need to be wrapped in an IIFE because it need to be in strict mode.
(() => {
"use strict";
/*!************************!*\
  !*** ./css/theme.scss ***!
  \************************/
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin

})();

/******/ })()
;
//# sourceMappingURL=theme.js.map