/*
 * 2007-2019 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author PrestaShop SA <contact@prestashop.com>
 *  @copyright  2007-2019 PrestaShop SA
 *  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

/* global $ */
$(document).ready(function () {
    if ($('.js-custom-search').length != 0) {
        var $searchWidget = $('#search_widget');
        var $searchBox = $searchWidget.find('input[type=text]');
        var searchURL = $searchWidget.attr('data-search-controller-url');

        var templateItem = $searchWidget.attr('data-list-item-template');
        var template = templateItem;
        var templateCompiled = Hogan.compile(template);


        $searchBox.devbridgeAutocomplete({
            serviceUrl: searchURL,
            paramName: 's',
            params: { resultsPerPage: 10 },
            maxHeight: 750,
            preventBadQueries: false,
            ajaxSettings: {
                contentType: "application/json; charset=utf-8",
                dataType: "json"
            },
            formatResult: function (suggestion, currentValue) {
                return "<div class='item'>"+templateCompiled.render({ imageUrl: suggestion.product.cover.small.url, name: suggestion.product.name, price: suggestion.product.price })+"</div>"
            },
            transformResult: function (response) {
                return {
                    suggestions: $.map(response.products, function (product) {
                        return { value: product.name, data: product.name, product: product };
                    })
                };
            },
            beforeRender: function (container, suggestions) {
                var $container = container.addClass('eager');
            },
            onSelect: function (suggestion) {
                
                var url = suggestion.product.url;
                window.location.href = url;
            },
        });
        //custom code
        $('.js-search-btn-toggle').click(function(e){
            $(this).addClass('search-active');
            $('body').addClass('search-fixed');
            setTimeout(function() {
                $('.search-block .input-text').focus();
            }, 500);
            e.preventDefault();
        });
        $('.js-search-close').click(function(){
            $('.js-search-btn-toggle').removeClass('search-active');
            $('body').removeClass('search-fixed');
        });
    }
});
