{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}
<div class="images-container">
  {block name='product_cover'}
    <div class="product-cover">
      {if isset($product.default_image)}
        {if $product.default_image}
        <img class="js-qv-product-cover" src="{$product.default_image.bySize.large_default.url}" alt="{if $product.default_image.legend}{$product.default_image.legend}{else}{$product.name}{/if}" title="{if $product.default_image.legend}{$product.default_image.legend}{else}{$product.name}{/if}" style="width:100%;" loading="lazy">
        <div class="layer" data-toggle="modal" data-target="#product-modal">
          <i class="material-icons zoom-in">&#xE8B6;</i>
        </div>
        {else}
          <img src="{$urls.no_picture_image.bySize.large_default.url}" style="width:100%;">
        {/if}
      {else}
        {if $product.cover}
          <img class="js-qv-product-cover" src="{$product.cover.bySize.large_default.url}" alt="{if $product.cover.legend}{$product.cover.legend}{else}{$product.name}{/if}" title="{if $product.cover.legend}{$product.cover.legend}{else}{$product.name}{/if}" style="width:100%;" loading="lazy">
          <div class="layer" data-toggle="modal" data-target="#product-modal">
            <i class="material-icons zoom-in">&#xE8B6;</i>
          </div>
        {else}
          <img src="{$urls.no_picture_image.bySize.large_default.url}" style="width:100%;">
        {/if}
      {/if}
      {block name='product_flags'}
        <ul class="product-flags js-product-flags">
          {foreach from=$product.flags item=flag}
            <li class="product-flag {$flag.type}"><span>{$flag.label}</span></li>
          {/foreach}
        </ul>
      {/block}
    </div>
  {/block}
  {block name='product_images'}
    <div class="wrapper-thumbnails">
        <div class="scroll-box-arrows">
            <i class="material-icons left">&#xE314;</i>
            <i class="material-icons right">&#xE315;</i>
        </div>
          <div class="arrows js-arrows">
            <i class="material-icons arrow-up js-arrow-up">&#xE316;</i>
            <i class="material-icons arrow-down js-arrow-down">&#xE313;</i>
          </div>
      <div class="js-qv-mask mask">
        <ul class="product-images js-qv-product-images">
          {foreach from=$product.images item=image}
            <li class="thumb-container">
              <img
                class="thumb js-thumb{if isset($product.default_image)}{if $image.id_image == $product.default_image.id_image} selected js-thumb-selected{/if}{else}{if $image.id_image == $product.cover.id_image} selected js-thumb-selected{/if}{/if}"
                data-image-medium-src="{$image.bySize.medium_default.url}"
                data-image-large-src="{$image.bySize.large_default.url}"
                src="{$image.bySize.home_default.url}"
                alt="{if $image.legend}{$image.legend}{else}{$product.name}{/if}"
                title="{if $image.legend}{$image.legend}{else}{$product.name}{/if}"
                width="100"
              >
            </li>
          {/foreach}
        </ul>
      </div>
    </div>
  {/block}
</div>
{hook h='displayAfterProductThumbs'}
