<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class BlockFacebook extends Module
{
    public function __construct()
    {
        $this->name = 'blockfacebook';
        $this->tab = 'front_office_features';
        $this->version = '1.0.1';
        $this->author = 'Prestahero';

        $this->bootstrap = true;
        parent::__construct();
        $this->displayName = $this->l('Facebook Like Box block');
        $this->description = $this->l('Displays a block in footer for subscribing to your Facebook Page.');
    }

    public function install()
    {
        return parent::install() &&
            Configuration::updateValue('blockfacebook_url', 'https://www.facebook.com/prestashop') &&
            $this->registerHook('displayFooter') &&
            $this->registerHook('displayHeader');
    }

    public function uninstall()
    {
        // Delete configuration
        return Configuration::deleteByName('blockfacebook_url') && parent::uninstall();
    }

    public function getContent()
    {
        $html = '';
        // If we try to update the settings
        if (Tools::isSubmit('submitModule')) {
            Configuration::updateValue('blockfacebook_url', Tools::getValue('blockfacebook_url'));
            $html .= $this->displayConfirmation($this->l('Configuration updated'));
            $this->_clearCache('views/templates/hook/blockfacebook.tpl');
            Tools::redirectAdmin('index.php?tab=AdminModules&configure=' . $this->name . '&token=' . Tools::getAdminTokenLite('AdminModules'));
        }

        $html .= $this->renderForm();
        $facebookurl = Configuration::get('blockfacebook_url');
        if (!strstr($facebookurl, 'facebook.com')) {
            $facebookurl = 'https://www.facebook.com/' . $facebookurl;
        }
        $this->context->smarty->assign('facebookurl', $facebookurl);
        $this->context->smarty->assign('facebook_js_url', $this->_path . 'blockfacebook.js');
        $this->context->smarty->assign('facebook_css_url', $this->_path . 'css/blockfacebook.css');
        $html .= $this->context->smarty->fetch($this->local_path . 'views/templates/admin/_configure/preview.tpl');

        return $html;
    }

    public function hookDisplayFooter()
    {
        $facebookurl = Configuration::get('blockfacebook_url');
        if (!strstr($facebookurl, 'facebook.com')) {
            $facebookurl = 'https://www.facebook.com/' . $facebookurl;
        }
        $this->context->smarty->assign('facebookurl', $facebookurl);

        return $this->display(__FILE__, 'views/templates/hook/blockfacebook.tpl', $this->getCacheId());
    }

    public function hookDisplayLeftColumn()
    {
        $this->_assignMedia();

        return $this->hookDisplayFooter();
    }

    public function hookDisplayRightColumn()
    {
        $this->_assignMedia();

        return $this->hookDisplayFooter();
    }

    public function hookHeader()
    {
        $this->_assignMedia();
    }

    protected function _assignMedia()
    {
        $this->context->controller->addJS($this->_path . '/views/js/blockfacebook.js');
    }

    public function renderForm()
    {
        $fields_form = [
            'form' => [
                'legend' => [
                    'title' => $this->l('Settings'),
                    'icon' => 'icon-cogs',
                ],
                'input' => [
                    [
                        'type' => 'text',
                        'label' => $this->l('Facebook link (full URL is required)'),
                        'name' => 'blockfacebook_url',
                    ],
                ],
                'submit' => [
                    'title' => $this->l('Save'),
                ],
            ],
        ];

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $lang = new Language((int) Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitModule';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = [
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        ];

        return $helper->generateForm([$fields_form]);
    }

    public function getConfigFieldsValues()
    {
        return [
            'blockfacebook_url' => Tools::getValue('blockfacebook_url', Configuration::get('blockfacebook_url')),
        ];
    }
}
