<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Core\Module\WidgetInterface;

class EagerSearchbar extends Module implements WidgetInterface
{
    public $template;
    public $javascript;

    public function __construct()
    {
        $this->name = 'eagersearchbar';
        $this->tab = 'front_office_features';
        $this->author = 'eagercloud';
        $this->version = '1.0.1';
        $this->need_instance = 0;
        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('Eager: Search bar');
        $this->description = $this->l('Adds a template-based quick search field to your website.');

        $this->ps_versions_compliancy = ['min' => '1.7.1.0', 'max' => _PS_VERSION_];
        $this->template = Configuration::get('EAGERSEARCHBAR_TEMPLATE');
    }

    public function install()
    {
        $installed = parent::install()
            && $this->registerHook('displayNav2')
            && $this->registerHook('displaySearch')
            && $this->registerHook('header')
        ;
        if ($installed) {
            Configuration::updateValue('EAGERSEARCHBAR_TEMPLATE', 'eagersearchbar.tpl');
        }

        return $installed;
    }

    public function uninstall()
    {
        Configuration::deleteByName('EAGERSEARCHBAR_TEMPLATE');

        return parent::uninstall();
    }

    private function osPath($path)
    {
        return str_replace('/', DIRECTORY_SEPARATOR, $path);
    }

    public function getWidgetVariables($hookName, array $configuration = [])
    {
        $templateContent = '<div class="results_item"><div class="item_img"><img class="item_thumbnail" src="{{imageUrl}}" alt="{{name}}"></div><div class="item_des"><span class="item_name">{{name}}</span><span class="item_price">{{price}}</span></div></div>';
        $widgetVariables = [
            'search_controller_url' => $this->context->link->getPageLink('search', null, null, null, false, null, true),
            'list_item_template' => $templateContent,
        ];

        if (!array_key_exists('search_string', $this->context->smarty->getTemplateVars())) {
            $widgetVariables['search_string'] = '';
        }

        return $widgetVariables;
    }

    public function renderWidget($hookName, array $configuration = [])
    {
        $this->smarty->assign($this->getWidgetVariables($hookName, $configuration));

        return $this->fetch('module:eagersearchbar/views/templates/hook/eagersearchbar.tpl');
    }

    public function hookHeader()
    {
        $this->context->controller->registerJavascript('eager-searchbar-jquery.autocomplete', 'modules/' . $this->name . '/views/js/jquery.autocomplete.min.js', ['position' => 'bottom', 'priority' => 150]);
        $this->context->controller->registerJavascript('eager-searchbar', 'modules/' . $this->name . '/views/js/eagersearchbar.js', ['position' => 'bottom', 'priority' => 150]);
        $this->context->controller->registerJavascript('eager-searchbar-hogan', 'modules/' . $this->name . '/views/js/hogan-3.0.1.js', ['position' => 'bottom', 'priority' => 150]);
    }
}
