/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */

/* global $ */
$(document).ready(function () {
    var $searchWidget = $('#search_widget');
    var $searchBox = $searchWidget.find('input[type=text]');
    var searchURL = $searchWidget.attr('data-search-controller-url');

    var templateItem = $searchWidget.attr('data-list-item-template');
    var template = templateItem;
    var templateCompiled = Hogan.compile(template);


    $searchBox.devbridgeAutocomplete({
        serviceUrl: searchURL,
        paramName: 's',
        params: { resultsPerPage: 10 },
        maxHeight: 750,
        preventBadQueries: false,
        ajaxSettings: {
            contentType: "application/json; charset=utf-8",
            dataType: "json"
        },
        formatResult: function (suggestion, currentValue) {
            return "<div class='item'>"+templateCompiled.render({ imageUrl: suggestion.product.cover.small.url, name: suggestion.product.name, price: suggestion.product.price })+"</div>"
        },
        transformResult: function (response) {
            return {
                suggestions: $.map(response.products, function (product) {
                    return { value: product.name, data: product.name, product: product };
                })
            };
        },
        beforeRender: function (container, suggestions) {
            var $container = container.addClass('eager');
        },
        onSelect: function (suggestion) {
            
            var url = suggestion.product.url;
            window.location.href = url;
        },
    });
});
