<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */
class FancyboxThumb extends Module
{
    public function __construct()
    {
        $this->name = 'fancyboxthumb';
        $this->tab = 'front_office_features';
        $this->version = '1.0.0';
        $this->author = 'Prestahero';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Fancybox Thumbnails');
        $this->description = $this->l('Fancybox thumbnails on product page');
    }

    public function install()
    {
        return parent::install() && $this->registerHook('header') && $this->registerHook('displayBackOfficeHeader');
    }

    public function uninstall()
    {
        parent::uninstall();

        return true;
    }

    public function hookHeader()
    {
        if ($this->context->controller instanceof ProductControllerCore) {
            $this->context->controller->addjqueryPlugin('fancybox');
            $this->context->controller->addJS($this->_path . 'views/js/front.js');
        }
    }

    public function hookDisplayBackOfficeHeader()
    {
        $this->context->controller->addCSS($this->_path . 'views/css/admin.css', 'all');
    }
}
