/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */

jQuery(document).ready(function() {
    var owlVideobanners = $(".htmlbanners3-carousel");
    if (owlVideobanners.data('carousel')){
        owlVideobanners.owlCarousel({
            items: owlVideobanners.data('items'),
            nav: (owlVideobanners.children().length > 1) ? owlVideobanners.data('navigation') : false,
            dots: (owlVideobanners.children().length > owlVideobanners.data('items')) ? owlVideobanners.data('pagination') : false,
            autoplay: owlVideobanners.data('autoplay'),
            autoplayTimeout: owlVideobanners.data('timeout'),
            autoplayHoverPause: owlVideobanners.data('pause'),
            loop: (owlVideobanners.children().length > 1) ? owlVideobanners.data('loop') : false,
            responsiveClass: true,
            responsive:{
                0:{
                    items: owlVideobanners.data('items_480')
                },
                480:{
                    items: owlVideobanners.data('items_768')
                },
                768:{
                    items: owlVideobanners.data('items_991')
                },
                991:{
                    items: owlVideobanners.data('items_1199')
                },
                1199:{
                    items: owlVideobanners.data('items')
                }
            },
            navText: ['<i class="font-left">','<i class="font-right">']
        });
    }
});