"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var LicenseFileWriter_1 = require("./LicenseFileWriter");
var LicenseMetaAggregator_1 = require("./LicenseMetaAggregator");
var ModuleDirectoryLocator_1 = require("./ModuleDirectoryLocator");
var OptionsProvider_1 = require("./OptionsProvider");
var PackageJsonReader_1 = require("./PackageJsonReader");
var WebpackAlertAggregator_1 = require("./WebpackAlertAggregator");
var WebpackAssetManager_1 = require("./WebpackAssetManager");
var WebpackChunkIterator_1 = require("./WebpackChunkIterator");
var WebpackFileSystem_1 = require("./WebpackFileSystem");
var pluginName = 'WebpackLicensePlugin';
/**
 * @todo "emit" vs "compilation" & "optimizeChunkAssets" hooks
 * @todo add banner to chunks? boolean option + banner formatter?
 * @todo override license text or license filename
 * @todo override for version ranges or *
 * @todo select output fields
 * @todo error on missing license text?
 * @todo preferred license types on ambiguity (licenses array or spdx expression)
 */
var WebpackLicensePlugin = /** @class */ (function () {
    function WebpackLicensePlugin(pluginOptions) {
        if (pluginOptions === void 0) { pluginOptions = {}; }
        this.pluginOptions = pluginOptions;
        this.filenames = new Set();
        this.createdFiles = false;
        this.observedCompilers = [];
    }
    WebpackLicensePlugin.prototype.apply = function (compiler) {
        if (typeof compiler.hooks !== 'undefined') {
            compiler.hooks.compilation.tap('webpack-license-plugin', this.handleCompilation.bind(this, compiler));
            compiler.hooks.watchRun.tapAsync('webpack-license-plugin', this.handleWatchRun.bind(this));
            // @ts-ignore
        }
        else if (typeof compiler.plugin !== 'undefined') {
            // @ts-ignore
            compiler.plugin('compilation', this.handleCompilation.bind(this, compiler));
            // @ts-ignore
            compiler.plugin('watchRun', this.handleWatchRun.bind(this));
        }
    };
    WebpackLicensePlugin.prototype.handleWatchRun = function (_, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.createdFiles = false;
                this.observedCompilers = [];
                callback();
                return [2 /*return*/];
            });
        });
    };
    WebpackLicensePlugin.prototype.handleCompilation = function (compiler, compilation) {
        if (typeof compilation.hooks !== 'undefined') {
            compilation.hooks.optimizeChunkAssets.tapAsync('webpack-license-plugin', this.handleChunkAssetOptimization.bind(this, compiler, compilation));
            // @ts-ignore
        }
        else if (typeof compilation.plugin !== 'undefined') {
            // @ts-ignore
            compilation.plugin('optimize-chunk-assets', this.handleChunkAssetOptimization.bind(this, compiler, compilation));
        }
    };
    WebpackLicensePlugin.prototype.handleChunkAssetOptimization = function (compiler, compilation, chunks, callback) {
        return __awaiter(this, void 0, void 0, function () {
            var observedCompilersMessage, errorMessage, alertAggregator, optionsProvider, options, chunkIterator, _a, _b, filename, fileSystem, packageJsonReader, licenseFileWriter;
            var e_1, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        this.observedCompilers.push({
                            name: compilation.compiler.name,
                            isChild: compilation.compiler.isChild(),
                        });
                        if (this.createdFiles) {
                            observedCompilersMessage = this.observedCompilers
                                .map(function (_a) {
                                var name = _a.name, isChild = _a.isChild;
                                return "compiler: " + name + ", isChild: " + isChild;
                            })
                                .join('\n');
                            errorMessage = pluginName + ": Found licenses after license files were already created.\nIf you see this message, you ran into an edge case we thought would not happen. Please open an isssue at https://github.com/codepunkt/webpack-license-plugin/issues with details of your webpack configuration so we can invastigate it further.\n" + observedCompilersMessage;
                            compilation.errors.push(errorMessage);
                            callback();
                            return [2 /*return*/];
                        }
                        if (!compilation.compiler.isChild()) {
                            this.createdFiles = true;
                        }
                        alertAggregator = new WebpackAlertAggregator_1.default(compilation);
                        optionsProvider = new OptionsProvider_1.default(alertAggregator);
                        options = optionsProvider.getOptions(this.pluginOptions);
                        alertAggregator.flushAlerts(pluginName);
                        chunkIterator = new WebpackChunkIterator_1.default();
                        try {
                            for (_a = __values(chunkIterator.iterateChunks(compilation, chunks)), _b = _a.next(); !_b.done; _b = _a.next()) {
                                filename = _b.value;
                                this.filenames.add(filename);
                            }
                        }
                        catch (e_1_1) { e_1 = { error: e_1_1 }; }
                        finally {
                            try {
                                if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                            }
                            finally { if (e_1) throw e_1.error; }
                        }
                        if (compilation.compiler.isChild()) {
                            callback();
                            return [2 /*return*/];
                        }
                        fileSystem = new WebpackFileSystem_1.default(compiler.inputFileSystem);
                        packageJsonReader = new PackageJsonReader_1.default(fileSystem);
                        licenseFileWriter = new LicenseFileWriter_1.default(new WebpackAssetManager_1.default(compilation), new ModuleDirectoryLocator_1.default(fileSystem, compiler.options.context, packageJsonReader), new LicenseMetaAggregator_1.default(fileSystem, alertAggregator, options, packageJsonReader));
                        return [4 /*yield*/, licenseFileWriter.writeLicenseFiles(__spread(this.filenames), options)];
                    case 1:
                        _d.sent();
                        alertAggregator.flushAlerts(pluginName);
                        callback();
                        return [2 /*return*/];
                }
            });
        });
    };
    return WebpackLicensePlugin;
}());
exports.default = WebpackLicensePlugin;
//# sourceMappingURL=WebpackLicensePlugin.js.map