{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}

<div class="blockreassurance_product">
    {foreach from=$blocks item=$block key=$key}
        <div class="reass-item">
            {if $block['type_link'] !== $LINK_TYPE_NONE && !empty($block['link'])}
            <a class="item-link" href="{$block['link']}" title="{$block['link']}">
            {else}
            <div class="item-link">
            {/if}
            <div class="block-icon">
                {if $block['icon'] != 'undefined'}
                    {if $block['icon']}
                    <img class="svg invisible" src="{$block['icon']}">
                    {elseif $block['custom_icon']}
                    <img src="{$block['custom_icon']}">
                    {/if}
                {/if}
            </div>
            <div class="item-descr">
                {if empty($block['description'])}
                  <p class="block-title" style="color:{$textColor};">{$block['title']}</p>
                {else}
                  <p class="block-title" style="color:{$textColor};">{$block['title']}</p>
                  <p style="color:{$textColor};">{$block['description'] nofilter}</p>
                {/if}
            </div>
            {if $block['type_link'] !== $LINK_TYPE_NONE && !empty($block['link'])}
            </a>
            {else}
            </div>
            {/if}
        </div>
    {/foreach}
</div>
