{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}
{extends file='page.tpl'}

{block name='page_content'}
    <div id="mywishlist">
    	{*capture name=path}
    		<a href="{$link->getPageLink('my-account', true)|escape:'html':'UTF-8'}">
    			{l s='My account' d='Modules.Blockwishlist.Shop'}
    		</a>
    		<span class="navigation-pipe">
    			{if isset($navigationPipe)}{$navigationPipe}{/if}
    		</span>
    		<span class="navigation_page">
    			{l s='My wishlists' d='Modules.Blockwishlist.Shop'}
    		</span>
    	{/capture*}
    
    	{*<h1 class="page-heading">{l s='My wishlists' d='Modules.Blockwishlist.Shop'}</h1>*}
    
    	{if isset($errors) && $errors}
        	<div class="alert alert-danger">
                <p>{if $errors|@count > 1}{l s='There are errors' d='Modules.Blockwishlist.Shop'}{else}{l s='There is error' d='Modules.Blockwishlist.Shop'}{/if}</p>
        		<ol>
        		{foreach from=$errors key=k item=error}
        			<li>{$error}</li>
        		{/foreach}
        		</ol>
        		{if isset($smarty.server.HTTP_REFERER) && !strstr($request_uri, 'authentication') && preg_replace('#^https?://[^/]+/#', '/', $smarty.server.HTTP_REFERER) != $request_uri}
        			<p class="lnk"><a class="alert-link" href="#" title="{l s='Back'}">&laquo; {l s='Back'}</a></p>
        		{/if}
        	</div>
        {/if}
    
    	{if $id_customer|intval neq 0}
    		<form method="post" class="std box" id="form_wishlist">
    			<fieldset>
    				<h3 class="page-subheading">{l s='New wishlist' d='Modules.Blockwishlist.Shop'}</h3>
    				<div class="form-group">
    					<input type="hidden" name="token" value="{$token|escape:'html':'UTF-8'}" />
    					<label class="align_right" for="name">
    						{l s='Name' d='Modules.Blockwishlist.Shop'}
    					</label>
    					<input type="text" id="name" name="name" class="inputTxt form-control" value="{if isset($smarty.post.name) and $errors|@count > 0}{$smarty.post.name|escape:'html':'UTF-8'}{/if}" />
    				</div>
    				<p class="submit">
                        <button id="submitWishlist" class="btn btn-default button button-medium" type="submit" name="submitWishlist">
                        	<span>{l s='Save' d='Modules.Blockwishlist.Shop'}</span>
                        </button>
    				</p>
    			</fieldset>
    		</form>
    		{if $wishlists}
    			<div id="block-history" class="block-center">
    				<table class="table table-bordered">
    					<thead>
    						<tr>
    							<th class="first_item">{l s='Name' d='Modules.Blockwishlist.Shop'}</th>
    							<th class="item mywishlist_first">{l s='Qty' d='Modules.Blockwishlist.Shop'}</th>
    							<th class="item mywishlist_first">{l s='Viewed' d='Modules.Blockwishlist.Shop'}</th>
    							<th class="item mywishlist_second">{l s='Created' d='Modules.Blockwishlist.Shop'}</th>
    							<th class="item mywishlist_second">{l s='Direct Link' d='Modules.Blockwishlist.Shop'}</th>
    							<th class="item mywishlist_second">{l s='Default' d='Modules.Blockwishlist.Shop'}</th>
    							<th class="last_item mywishlist_first">{l s='Delete' d='Modules.Blockwishlist.Shop'}</th>
    						</tr>
    					</thead>
    					<tbody>
    						{section name=i loop=$wishlists}
    							<tr id="wishlist_{$wishlists[i].id_wishlist|intval}">
    								<td style="width:200px;">
    									<a href="#" onclick="javascript:event.preventDefault();WishlistManage('block-order-detail', '{$wishlists[i].id_wishlist|intval}');">
    										{$wishlists[i].name|truncate:30:'...'|escape:'htmlall':'UTF-8'}
    									</a>
    								</td>
    								<td class="bold align_center">
    									{assign var=n value=0}
    									{foreach from=$nbProducts item=nb name=i}
    										{if $nb.id_wishlist eq $wishlists[i].id_wishlist}
    											{assign var=n value=$nb.nbProducts|intval}
    										{/if}
    									{/foreach}
    									{if $n}
    										{$n|intval}
    									{else}
    										0
    									{/if}
    								</td>
    								<td>{$wishlists[i].counter|intval}</td>
    								<td>{$wishlists[i].date_add|date_format:"%Y-%m-%d"}</td>
    								<td>
    									<a href="#" onclick="javascript:event.preventDefault();WishlistManage('block-order-detail', '{$wishlists[i].id_wishlist|intval}');">
    										{l s='View' d='Modules.Blockwishlist.Shop'}
    									</a>
    								</td>
    								<td class="wishlist_default">
    									{if isset($wishlists[i].default) && $wishlists[i].default == 1}
    										<p class="is_wish_list_default">
    											<i class="material-icons">&#xE5CA;</i>
    										</p>
    									{else}
    										<a href="#" onclick="javascript:event.preventDefault();(WishlistDefault('wishlist_{$wishlists[i].id_wishlist|intval}', '{$wishlists[i].id_wishlist|intval}'));">
    											<i class="material-icons">&#xE3C6;</i>
    										</a>
    									{/if}
    								</td>
    								<td class="wishlist_delete">
    									<a class="icon" href="#" onclick="javascript:event.preventDefault();return (WishlistDelete('wishlist_{$wishlists[i].id_wishlist|intval}', '{$wishlists[i].id_wishlist|intval}', '{l s='Do you really want to delete this wishlist ?' d='Modules.Blockwishlist.Shop' js=1}'));">
    										<i class="material-icons">&#xE5CD;</i>
    									</a>
    								</td>
    							</tr>
    						{/section}
    					</tbody>
    				</table>
    			</div>
    			<div id="block-order-detail">&nbsp;</div>
    		{/if}
    	{/if}
    	<div class="footer_links wishlist_footer clearfix">
    		
    			<a class="btn btn-default button button-small" href="{$link->getPageLink('my-account', true)|escape:'html':'UTF-8'}">
    				<span>
    					{l s='Back to Your Account' d='Modules.Blockwishlist.Shop'}
    				</span>
    			</a>
    			<a class="btn btn-default button button-small pull-right" href="#">
    				<span>
    					{l s='Home' d='Modules.Blockwishlist.Shop'}
    				</span>
    			</a>
    	</div>
    </div>
{/block}
