{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}


{function name="categories" nodes=[] depth=0}
  {strip}
    {if $nodes|count}
      <ul class="category-sub-menu">
        {foreach from=$nodes item=node}
          <li data-depth="{$depth}">
            {if $depth===0}
              <a href="{$node.link}">{$node.name}</a>
              {if $node.children}
                <div class="navbar-toggler collapse-icons" data-toggle="collapse" data-target="#exCollapsingNavbar{$node.id}">
                  <i class="font-down-open-big add"></i>
                  <i class="font-up-open-big remove"></i>
                </div>
                <div class="collapse" id="exCollapsingNavbar{$node.id}">
                  {categories nodes=$node.children depth=$depth+1}
                </div>
              {/if}
            {else}
              <a class="category-sub-link" href="{$node.link}">{$node.name}</a>
              {if $node.children}
                <span class="arrows" data-toggle="collapse" data-target="#exCollapsingNavbar{$node.id}">
                  <i class="font-up-open-big arrow-up"></i>
                  <i class="font-down-open-big arrow-down"></i>
                </span>
                <div class="collapse" id="exCollapsingNavbar{$node.id}">
                  {categories nodes=$node.children depth=$depth+1}
                </div>
              {/if}
            {/if}
          </li>
        {/foreach}
      </ul>
    {/if}
  {/strip}
{/function}


{function name="new_categories" nodes=[] depth=0}
  {strip}
    {if $nodes|count}
      <ul class="category-sub-menu fl-categories">
        {foreach from=$nodes item=node}
          <li data-depth="{$depth}" {if $node.children}class="fl-li"{/if}>
            {if $depth===0}
              <a {if $node.children} class="fl-parent d-flex justify-content-between align-items-center cursor-pointer {if $node.id == $category.id} fl-current {/if}" {else}href="{$node.link}" {if $node.id == $category.id} class="fl-current justify-content-between align-items-center cursor-pointer" {/if} {/if}>{$node.name}{if $node.children}{/if}</a>
              {if $node.children}
                <div class="collapse fl-submenu" id="exCollapsingNavbar{$node.id}">
                  {new_categories nodes=$node.children depth=$depth+1}
                </div>
              {/if}
            {else}
              <a class="category-sub-link {if $node.id == $category.id} fl-current {/if} {if $node.children} fl-parent d-flex justify-content-between align-items-center cursor-pointer{/if}" {if $node.children}{else}href="{$node.link}"{/if}>{$node.name}{if $node.children}{/if}</a>
              {if $node.children}
                <div class="collapse fl-submenu" id="exCollapsingNavbar{$node.id}">
                  {new_categories nodes=$node.children depth=$depth+1}
                </div>
              {/if}
            {/if}
          </li>
        {/foreach}
      </ul>
    {/if}
  {/strip}
{/function}

  <div class="block-categories">
    <ul class="category-top-menu">
      <li><h2 class="h6">Categorii</h2></li>
      <li>{new_categories nodes=$categories.children}</li>
      <li><a class="h6 fl-parent d-flex justify-content-between align-items-center cursor-pointer my-4" href="/outlet">Outlet</a></li>  
    </ul>
  </div>
