{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}

<div class="block-contact links wrapper">
  <p class="h3 text-uppercase block-contact-title hidden-md-down">{l s='Store information' d='Shop.Theme.Global'}</p>
  <div class="title clearfix hidden-lg-up" data-target="#footer_contact" data-toggle="collapse">
    <span class="h3">{l s='Store information' d='Shop.Theme.Global'}</span>
    <span class="pull-xs-right">
      <span class="navbar-toggler collapse-icons">
        <i class="material-icons add">&#xE313;</i>
        <i class="material-icons remove">&#xE316;</i>
      </span>
    </span>
  </div>
  <ul id="footer_contact" class="collapse">
    <li class="item-address">{$contact_infos.address.formatted nofilter}</li>
    {if isset($display_email)}
        {if $contact_infos.email && $display_email}
          <li class="e-mail">
            <a href="mailto:{$contact_infos.email}" target="_blank" title="{l s='Contact us' d='Shop.Theme.Global'}">
               {l s='Email us:' d='Shop.Theme.Global'} {$contact_infos.email}
            </a>
          </li>
        {/if}
    {else}
        {if $contact_infos.email}
          <li class="e-mail">
            <a href="mailto:{$contact_infos.email}" target="_blank" title="{l s='Contact us' d='Shop.Theme.Global'}">
               {l s='Email us:' d='Shop.Theme.Global'} {$contact_infos.email}
            </a>
          </li>
        {/if}
    {/if}
    {if $contact_infos.phone}
    <li class="phone">
        <a href="tel:{$contact_infos.phone}" title="{l s='Contact us' d='Shop.Theme.Global'}">
            {l s='Call us:' d='Shop.Theme.Global'}
            {$contact_infos.phone}
        </a>
    </li>
    {/if}
    {if $contact_infos.fax}
    <li class="fax">
      {l s='Fax:' d='Shop.Theme.Global'}
      {$contact_infos.fax}
    </li>
    {/if}
  </ul>
</div>
