{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}
<div id="blockcart-modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                {*<span aria-hidden="true">&times;</span>*}
            </button>
            <div class="modal-body">
                <div class="row">
                    <div class="col-lg-6 divide-right">
                        {*<h4><i class="material-icons">&#xE876;</i>{l s='Product successfully added to your shopping cart' d='Shop.Theme.Checkout'}</h4>*}
                        {*<img class="product-image" src="{$product.cover.large.url}" alt="{$product.cover.legend}" title="{$product.cover.legend}">*}
                        <div class="product-image" style="background-image: url({if $product.default_image}{$product.default_image.large.url}{else}{$urls.no_picture_image.bySize.large_default.url}{/if});"></div>
                    </div>
                    <div class="col-lg-6 cart-content">
                        <p class="h6 product-name">{$product.name}</p>
                        <p><strong>{l s='Price' d='Shop.Theme.Catalog'}</strong><span>{$product.price}</span></p>
                        <p><strong>{l s='Quantity' d='Shop.Theme.Checkout'}</strong><span>{$product.cart_quantity}</span></p>
                        {hook h='displayProductPriceBlock' product=$product type="unit_price"}
                        {foreach from=$product.attributes item="property_value" key="property"}
                        <p><strong>{$property}</strong> <span>{$property_value}</span></p>
                        {/foreach}
                          {if $cart.products_count > 1}
                            <p class="cart-products-count">{l s='There are %products_count% items in your cart.' sprintf=['%products_count%' => $cart.products_count] d='Shop.Theme.Checkout'}</p>
                          {else}
                            <p class="cart-products-count">{l s='There is %products_count% item in your cart.' sprintf=['%products_count%' =>$cart.products_count] d='Shop.Theme.Checkout'}</p>
                          {/if}
                          <p><strong class="label">{l s='Subtotal:' d='Shop.Theme.Checkout'}</strong><span class="subtotal value">{$cart.subtotals.products.value}</span></p>
                          {if $cart.subtotals.shipping.value}
                            <p><strong>{l s='Shipping:' d='Shop.Theme.Checkout'}</strong><span class="shipping value">{$cart.subtotals.shipping.value} {hook h='displayCheckoutSubtotalDetails' subtotal=$cart.subtotals.shipping}</span></p>
                          {/if}

                          {if !$configuration.display_prices_tax_incl && $configuration.taxes_enabled}
                            <p><strong>{$cart.totals.total.label}{if $configuration.display_taxes_label}&nbsp;{$cart.labels.tax_short}{/if}</strong>&nbsp;<span>{$cart.totals.total.value}</span></p>
                            <p class="product-total"><strong class="label">{$cart.totals.total_including_tax.label}</strong>&nbsp;<span class="value">{$cart.totals.total_including_tax.value}</span></p>
                          {else}
                            <p class="product-total"><strong class="label">{$cart.totals.total.label}&nbsp;{if $configuration.taxes_enabled && $configuration.display_taxes_label}{$cart.labels.tax_short}{/if}</strong>&nbsp;<span class="value">{$cart.totals.total.value}</span></p>
                          {/if}

                          {if $cart.subtotals.tax}
                            <p class="product-tax"><strong>{l s='%label%:' sprintf=['%label%' => $cart.subtotals.tax.label] d='Shop.Theme.Global'}</strong>&nbsp;<span class="value">{$cart.subtotals.tax.value}</span></p>
                          {/if}
                          {hook h='displayCartModalContent' product=$product}
                        <div class="cart-content-btn">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{l s='Continue shopping' d='Shop.Theme.Actions'}</button>
                            <a href="{$cart_url}" class="btn btn-primary">{*<i class="material-icons">&#xE876;</i>*}{l s='Proceed to checkout' d='Shop.Theme.Actions'}</a>
                        </div>
                    </div>
                </div>
            </div>
            {hook h='displayCartModalFooter' product=$product}
        </div>
    </div>
</div>