{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}
{block name='header_banner'}
  <div class="header-banner">
    {hook h='displayBanner'}
  </div>
{/block}

{block name='header_nav'}
  <nav class="header-nav">
    <div class="container">
        <div class="row inner-wrapper">
          <div id="_desktop_logo" class="col-md-2 hidden-md-down">
              {if $page.page_name == 'index'}
                  <a href="{$urls.base_url}">
                    <img class="logo img-responsive" src="{$shop.logo}" alt="{$shop.name}">
                    {* <span>{$shop.name}</span> *}
                  </a>
              {else}
                  <a href="{$urls.base_url}">
                    <img class="logo img-responsive" src="{$shop.logo}" alt="{$shop.name}">
                  </a>
              {/if}
          </div>
          {hook h='displayNav1'} 
          <div class="right-nav">
              {* {hook h='displayNav2'}  *}
              
              <!-- Block shop module TOP -->
              <div id="_desktop_cart"> {* {if $cart.products_count > 0}{$refresh_url =true}{/if}  *}
                <input type="checkbox" id="toggle-cart" class="no-style">
                <div class="blockcart cart-preview {if $cart.products_count > 0}active{else}inactive{/if}" data-refresh-url="{$refresh_url}">
                  <label class="cart-header" for="toggle-cart">
                      <div class="inner-wrapper">
                      <i class="font-cart hidden-lg-up"></i>
                      {* <span class="cart-title hidden-lg-down">{l s='My cart' d='Shop.Theme.Checkout'}</span> *}
                      <span class="cart-products-count">
                        <i class="font-cart d-none d-lg-block"></i>
                        <span class="badge badge-pill badge-info" style="background-color: #2E3E55 !important;"> 
                          <span class="text-white">{$cart.products_count}</span>
                        </span>
                        
                      </span>
                      </div>
                  </label>
                  <div class="body cart-hover-content">
                      <div class="container">
                          <ul class="cart-list">
                          {foreach from=$cart.products item=product}
                              <li class="cart-wishlist-item">
                              {include 'module:ps_shoppingcart/ps_shoppingcart-product-line.tpl' product=$product}
                              </li>
                          {/foreach}
                          </ul>
                          <div class="cart-footer">
                              <div class="cart-subtotals">
                                  {foreach from=$cart.subtotals item="subtotal"}
                                      {if $subtotal && $subtotal.value|count_characters > 0}
                                      <div class="{$subtotal.type}">
                                          <span class="value">{if 'discount' == $subtotal.type}-&nbsp;{/if}{$subtotal.value}</span>
                                          <span class="label">
                                                {$subtotal.label}
                                          </span>
                                      </div>
                                      {/if}
                                  {/foreach}
                                  <div class="cart-total">
                                      <span class="value">{$cart.totals.total.value}</span>
                                      <span class="label">{$cart.totals.total.label}</span>
                                  </div>
                              </div>
                              <div class="cart-wishlist-action">
                                  {*<a class="cart-wishlist-viewcart" href="{$cart_url}">view cart</a>*}
                                  {* <a class="btn cart-wishlist-checkout" href="{if $cart_url != null}{$cart_url}{else}cos?action=show{\if}"href="{$urls.pages.order}">{l s='Checkout' d='Shop.Theme.Actions'}</a> *}
                                  <a class="btn cart-wishlist-checkout" href="/cos?action=show"{*href="{$urls.pages.order}"*}>{l s='Checkout' d='Shop.Theme.Actions'}</a>
                              </div>
                          </div>
                      </div>
                  </div>
                </div>
              </div>
              <!-- Block user module TOP -->
              <div id="_desktop_user_info">
                <div class="header_user_info dropdown-mobile">
                  <span class="js-toggle btn-toggle-mobile font-user hidden-lg-up"></span>
                    <div class="js-toggle-list header_user_info__list dropdown-toggle-mobile">
                      {if $logged}
                        <a
                          class="logout "
                          href="{$logout_url}"
                          title="{l s='Sign out' d='Shop.Theme.Actions'}"
                          rel="nofollow"
                        >
                          <span class="material-symbols-outlined">
                            account_circle
                          </span>
                          {* {l s='Sign out' d='Shop.Theme.Actions'} *}
                        </a>
                        <a
                          class="account" 
                          href="{if $my_account_url != null}{$my_account_url}{else}/autentificare{/if}"
                          title="{l s='View my customer account' d='Shop.Theme.Customeraccount'}"
                          rel="nofollow"
                        >
                          <span class="material-symbols-outlined">
                            account_circle
                          </span>
                          {* <span>{$customerName}</span> *}
                        </a>
                      {else}
                        <a
                          href="{if $my_account_url != null}{$my_account_url}{else}/autentificare{/if}"
                          title="{l s='Log in to your customer account' d='Shop.Theme.Customeraccount'}"
                          rel="nofollow"
                        >
                          <i class="fa-solid fa-circle-user"></i>
                          {* <span>{l s='Sign in' d='Shop.Theme.Actions'}</span> *}
                          {* <span class="material-symbols-outlined">
                            account_circle
                          </span> *}
                        </a>
                        {*<a
                          href="{$urls.pages.register}"
                          title="{l s='Log in to your customer account' d='Shop.Theme.Customeraccount'}"
                          rel="nofollow"
                        >
                          <span>{l s='Register' d='Shop.Theme.Actions'}</span>
                        </a>*}
                      {/if}
                    </div>
                </div>
              </div>
              <!-- Block search module TOP -->
              <div id="_desktop_search_bar">
                <div id="search_widget" data-search-controller-url="{$search_controller_url}">
                  <div class="search-bar hidden-lg-up">
                    <form class="search-bar__wrap" method="get" action="{$search_controller_url}">
                      <input type="hidden" name="controller" value="search">
                      <input class="search-bar__text" type="text" name="s" value="{$search_string}" placeholder="{l s='Search our catalog...' d='Shop.Theme.Catalog'}" aria-label="{l s='Search' d='Shop.Theme.Catalog'}">
                      {if $search_string == ''}<a href="/cautare" type="submit">{/if}
                        <button class="search-bar__btn font-search" type="submit">
                        </button>
                      {if $search_string == ''}</a>{/if}
                    </form>
                  </div>
                  <div class="search-block hidden-md-down">
                    <a href="{$urls.base_url}cautare" class="js-search-btn-toggle search-btn-toggle font-search" title="{l s='Search...' d='Shop.Theme.Catalog'}">
                    <form class="search-form" method="get" action="{if $search_controller_url}{$search_controller_url}{else}{$urls.base_url}cautare{/if}">
                      <span class="search-close js-search-close"></span>
                      <div class="search-field container -responsive">
                        <input type="hidden" name="controller" value="search">
                        <input class="input-text" type="text" name="s" value="{$search_string}" placeholder="{l s='Search...' d='Shop.Theme.Catalog'}" aria-label="{l s='Search' d='Shop.Theme.Catalog'}">
                        <button class="search-btn font-search" type="submit">
                        </button>
                      </div>
                    </form></a>
                  </div>
                </div>
              </div>
              <!-- /Block search module TOP -->

              <div id="_desktop_menu-icon" class="hidden-md-down">
                <div class="js-menu-icon menu-icon" title="{l s='Menu' d='Shop.Theme.Actions'}">
                    <span class="sw-topper"></span>
                    <span class="sw-bottom"></span>
                    <span class="sw-footer"></span>
                </div>
              </div>
          </div>
          <div class="hidden-lg-up mobile">
            <div id="_mobile_menu-icon"></div>
            <div class="top-logo" id="_mobile_logo"></div>
            {if Module::isInstalled(ps_contactinfo) && Module::isEnabled(ps_contactinfo)}
            <div id="_mobile_contact_link"></div>
            {/if}
            {if Module::isInstalled(ps_customersignin) && Module::isEnabled(ps_customersignin)}
            {* <div id="_mobile_user_info"></div> *}
            <a href="{if $my_account_url != null}{$my_account_url}{else}/autentificare{/if}">
              <i class="fa-solid fa-circle-user"></i>
            </a>
            {/if}
            {if Module::isInstalled(ps_shoppingcart) && Module::isEnabled(ps_shoppingcart)}
            <div id="_mobile_cart"></div>
            {/if}
          </div>
        </div>
    </div>
  </nav>
{/block}

{block name='header_top'}
  <div class="header-top">
    <div class="container">
       <div class="row inner-wrapper">
        {hook h='displayTop'}
      </div>
      <div id="mobile_top_menu_wrapper" class="row hidden-lg-up">
        <div class="wrapper-nav">
            {if Module::isInstalled(ps_currencyselector) && Module::isEnabled(ps_currencyselector)}
            <div id="_mobile_currency_selector"></div>
            {/if}
            {if Module::isInstalled(ps_languageselector) && Module::isEnabled(ps_languageselector)}
            <div id="_mobile_language_selector"></div>
            {/if}
            <div id="_mobile_link_block"></div>
        </div>
        {if (Module::isInstalled(ps_searchbar) && Module::isEnabled(ps_searchbar)) || (Module::isInstalled(eagersearchbar) && Module::isEnabled(eagersearchbar))}
        <div class="wrapper-modules">
          <div id="_mobile_search_bar"></div>
        </div>
        {/if}
        <div class="js-top-menu mobile" id="_mobile_top_menu"></div>
      </div>
    </div>
  </div>
  {hook h='displayNavFullWidth'}
{/block}