{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}
{block name='header_banner'}
  <div class="header-banner">
    {hook h='displayBanner'}
  </div>
{/block}

{block name='header_nav'}
  <nav class="header-nav">
    <div class="container">
        <div class="row inner-wrapper">
          <div id="_desktop_logo" class="col-md-2 hidden-md-down">
              {if $page.page_name == 'index'}
                <h1>
                  <a href="{$urls.base_url}">
                    <img class="logo img-responsive" src="{$shop.logo}" alt="{$shop.name}">
                    <span>{$shop.name}</span>
                  </a>
                </h1>
              {else}
                  <a href="{$urls.base_url}">
                    <img class="logo img-responsive" src="{$shop.logo}" alt="{$shop.name}">
                  </a>
              {/if}
          </div>
          {hook h='displayNav1'}
          <div class="right-nav hidden-md-down">
              {hook h='displayNav2'}
            <div id="_desktop_menu-icon">
              <div class="js-menu-icon menu-icon" title="{l s='Menu' d='Shop.Theme.Actions'}">
                  <span class="sw-topper"></span>
                  <span class="sw-bottom"></span>
                  <span class="sw-footer"></span>
              </div>
            </div>
          </div>
          <div class="hidden-lg-up mobile">
            <div id="_mobile_menu-icon"></div>
            <div class="top-logo" id="_mobile_logo"></div>
            <div id="_mobile_contact_link"></div>
            <div id="_mobile_user_info">
            <a
                          class="account" 
                          href="{if $my_account_url != null}{$my_account_url}{else}/autentificare{/if}"
                          title="{l s='View my customer account' d='Shop.Theme.Customeraccount'}"
                          rel="nofollow"
                        >
                          <span class="material-symbols-outlined">
                            account_circle
                          </span>
                          {* <span>{$customerName}</span> *}
                        </a>
                      {else}
                        <a
                          href="{if $my_account_url != null}{$my_account_url}{else}/autentificare{/if}"
                          title="{l s='Log in to your customer account' d='Shop.Theme.Customeraccount'}"
                          rel="nofollow"
                        >
                          <i class="fa-solid fa-circle-user"></i>
                          {* <span>{l s='Sign in' d='Shop.Theme.Actions'}</span> *}
                          {* <span class="material-symbols-outlined">
                            account_circle
                          </span> *}
                        </a></div>
            <div id="_mobile_cart"></div>
          </div>
        </div>
    </div>
  </nav>
{/block}

{block name='header_top'}
  <div class="header-top">
    <div class="container">
       <div class="row inner-wrapper hidden-md-down">
        {hook h='displayTop'}
      </div>
      <div id="mobile_top_menu_wrapper" class="row hidden-lg-up">
        <div class="wrapper-nav">
            <div id="_mobile_currency_selector"></div>
            <div id="_mobile_language_selector"></div>
            <div id="_mobile_link_block"></div>
        </div>
        <div class="wrapper-modules">
          <div id="_mobile_search_bar"></div>
        </div>
        <div class="js-top-menu mobile" id="_mobile_top_menu"></div>
      </div>
    </div>
  </div>
  {hook h='displayNavFullWidth'}
{/block}